/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.MutationBlockedIOException;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.ParallelPhoenixContext;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixMonitoredStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.jdbc.PhoenixTestDriver;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.monitoring.HTableThreadPoolHistograms;
import org.apache.phoenix.monitoring.HTableThreadPoolMetricsManager;
import org.apache.phoenix.monitoring.HistogramDistribution;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ParallelPhoenixConnectionIT {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelPhoenixConnectionIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private static final Properties GLOBAL_PROPERTIES = new Properties();
    @Rule
    public TestName testName = new TestName();
    private Properties clientProperties;
    private HighAvailabilityGroup haGroup;
    private String tableName;
    private String haGroupName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.getHBaseCluster1().getConfiguration().setBoolean("phoenix.cluster.role.based.mutation.block.enabled", true);
        CLUSTERS.getHBaseCluster2().getConfiguration().setBoolean("phoenix.cluster.role.based.mutation.block.enabled", true);
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        DriverManager.registerDriver((Driver)((Object)new PhoenixTestDriver()));
        GLOBAL_PROPERTIES.setProperty("phoenix.connection.autoCommit", "true");
        GLOBAL_PROPERTIES.setProperty("phoenix.query.request.metrics.enabled", String.valueOf(true));
        GLOBAL_PROPERTIES.setProperty("phoenix.log.level", LogLevel.DEBUG.name());
        GLOBAL_PROPERTIES.setProperty("phoenix.cqsi.thread.pool.enabled", String.valueOf(true));
        GLOBAL_PROPERTIES.setProperty("phoenix.cqsi.thread.pool.keepalive.seconds", String.valueOf(13));
        GLOBAL_PROPERTIES.setProperty("phoenix.cqsi.thread.pool.core.size", String.valueOf(17));
        GLOBAL_PROPERTIES.setProperty("phoenix.cqsi.thread.pool.max.threads", String.valueOf(19));
        GLOBAL_PROPERTIES.setProperty("phoenix.cqsi.thread.pool.max.queue", String.valueOf(23));
        GLOBAL_PROPERTIES.setProperty("phoenix.cqsi.thread.pool.allow.core.thread.timeout", String.valueOf(true));
        GLOBAL_PROPERTIES.setProperty("hbase.client.retries.number", "0");
        GLOBAL_PROPERTIES.setProperty("phoenix.cqsi.thread.pool.metrics.enabled", String.valueOf(true));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        this.haGroupName = this.testName.getMethodName();
        this.clientProperties = new Properties(GLOBAL_PROPERTIES);
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroupName);
        CLUSTERS.initClusterRole(this.haGroupName, HighAvailabilityPolicy.PARALLEL);
        this.haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(CLUSTERS.getJdbcHAUrl(), this.clientProperties);
        LOG.info("Initialized haGroup {} with URL {}", (Object)this.haGroup, (Object)CLUSTERS.getJdbcHAUrl());
        this.tableName = this.testName.getMethodName().toUpperCase();
        CLUSTERS.createTableOnClusterPair(this.haGroup, this.tableName);
    }

    @Test
    public void testOperationUsingConnection() throws Exception {
        try (Connection conn = this.getParallelConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
    }

    @Test
    public void testUserPrincipal() throws Exception {
        try (Connection conn = this.getParallelConnection();){
            PhoenixConnection pConn2;
            PhoenixConnection pConn;
            ParallelPhoenixConnection pr = conn.unwrap(ParallelPhoenixConnection.class);
            if (CLUSTERS.getJdbcUrl1(this.haGroup).equals(((PhoenixConnection)pr.getFutureConnection1().get()).getURL())) {
                Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.haGroup), (Object)((PhoenixConnection)pr.getFutureConnection2().get()).getURL());
                pConn = (PhoenixConnection)pr.getFutureConnection1().get();
                pConn2 = (PhoenixConnection)pr.getFutureConnection2().get();
            } else {
                Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(this.haGroup), (Object)((PhoenixConnection)pr.getFutureConnection2().get()).getURL());
                Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.haGroup), (Object)((PhoenixConnection)pr.getFutureConnection1().get()).getURL());
                pConn = (PhoenixConnection)pr.getFutureConnection2().get();
                pConn2 = (PhoenixConnection)pr.getFutureConnection1().get();
            }
            ConnectionQueryServices cqsi = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
            Assert.assertEquals((Object)"USER_FOO", (Object)cqsi.getUserName());
            ConnectionQueryServices cqsiFromConn = pConn.getQueryServices();
            Assert.assertEquals((Object)"USER_FOO", (Object)cqsiFromConn.getUserName());
            Assert.assertSame((Object)cqsi, (Object)cqsiFromConn);
            cqsi = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl2(this.haGroup), this.clientProperties);
            Assert.assertEquals((Object)"USER_FOO", (Object)cqsi.getUserName());
            cqsiFromConn = pConn2.getQueryServices();
            Assert.assertEquals((Object)"USER_FOO", (Object)cqsiFromConn.getUserName());
            Assert.assertSame((Object)cqsi, (Object)cqsiFromConn);
        }
    }

    @Test
    public void testDifferentCQSIThreadPoolsForParallelConnection() throws Exception {
        try (Connection conn = this.getParallelConnection();){
            PhoenixConnection pConn2;
            PhoenixConnection pConn;
            ParallelPhoenixConnection pr = conn.unwrap(ParallelPhoenixConnection.class);
            if (CLUSTERS.getJdbcUrl1(this.haGroup).equals(((PhoenixConnection)pr.getFutureConnection1().get()).getURL())) {
                pConn = (PhoenixConnection)pr.getFutureConnection1().get();
                pConn2 = (PhoenixConnection)pr.getFutureConnection2().get();
            } else {
                pConn = (PhoenixConnection)pr.getFutureConnection2().get();
                pConn2 = (PhoenixConnection)pr.getFutureConnection1().get();
            }
            ConnectionQueryServices cqsi = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
            ConnectionQueryServices cqsiFromConn = pConn.getQueryServices();
            ThreadPoolExecutor threadPoolExecutor1 = BaseTest.extractThreadPoolExecutorFromCQSI(cqsi);
            Assert.assertSame((Object)threadPoolExecutor1, (Object)BaseTest.extractThreadPoolExecutorFromCQSI(cqsiFromConn));
            cqsi = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl2(this.haGroup), this.clientProperties);
            cqsiFromConn = pConn2.getQueryServices();
            Assert.assertSame((Object)cqsi, (Object)cqsiFromConn);
            ThreadPoolExecutor threadPoolExecutor2 = BaseTest.extractThreadPoolExecutorFromCQSI(cqsi);
            Assert.assertSame((Object)BaseTest.extractThreadPoolExecutorFromCQSI(cqsi), (Object)BaseTest.extractThreadPoolExecutorFromCQSI(cqsiFromConn));
            Assert.assertNotSame((Object)threadPoolExecutor1, (Object)threadPoolExecutor2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCqsiThreadPoolMetricsForParallelConnection() throws Exception {
        try (Connection conn = this.getParallelConnection();){
            ParallelPhoenixConnection pr = conn.unwrap(ParallelPhoenixConnection.class);
            PhoenixConnection pConn1 = (PhoenixConnection)pr.getFutureConnection1().get();
            Configuration config1 = pConn1.getQueryServices().getConfiguration();
            String zkQuorum1 = config1.get("hbase.zookeeper.quorum");
            String principal1 = config1.get("phoenix.query.services.name");
            PhoenixConnection pConn2 = (PhoenixConnection)pr.getFutureConnection2().get();
            Configuration config2 = pConn2.getQueryServices().getConfiguration();
            String zkQuorum2 = config2.get("hbase.zookeeper.quorum");
            String principal2 = config2.get("phoenix.query.services.name");
            CountDownLatch latch = new CountDownLatch(1);
            this.slowDownConnection(pr, pr.getFutureConnection1(), "futureConnection1", latch);
            try (Statement stmt = conn.createStatement();){
                HTableThreadPoolMetricsManager.getHistogramsForAllThreadPools();
                try (ResultSet rs = stmt.executeQuery(String.format("SELECT COUNT(*) FROM %s", this.tableName));){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)0L, (long)rs.getInt(1));
                    Assert.assertFalse((boolean)rs.next());
                }
                Map htableHistograms = HTableThreadPoolMetricsManager.getHistogramsForAllThreadPools();
                String conn1HistogramKey = this.getHistogramKey(config1);
                this.assertHTableThreadPoolHistograms((List)htableHistograms.get(conn1HistogramKey), conn1HistogramKey, false, zkQuorum1, principal1);
                String conn2HistogramKey = this.getHistogramKey(config2);
                this.assertHTableThreadPoolHistograms((List)htableHistograms.get(conn2HistogramKey), conn2HistogramKey, true, zkQuorum2, principal2);
                Assert.assertNotEquals((Object)conn1HistogramKey, (Object)conn2HistogramKey);
            }
            finally {
                latch.countDown();
            }
        }
    }

    private void slowDownConnection(ParallelPhoenixConnection pr, CompletableFuture<PhoenixConnection> pConn, String futureConnectionField, CountDownLatch latch) throws Exception {
        Assert.assertTrue((futureConnectionField.equals("futureConnection1") || futureConnectionField.equals("futureConnection2") ? 1 : 0) != 0);
        PhoenixConnection spy = (PhoenixConnection)Mockito.spy((Object)pConn.get());
        ((PhoenixConnection)Mockito.doAnswer(invocation -> {
            latch.await();
            return invocation.callRealMethod();
        }).when((Object)spy)).createStatement();
        Field futureField = ParallelPhoenixConnection.class.getDeclaredField(futureConnectionField);
        futureField.setAccessible(true);
        CompletableFuture<PhoenixConnection> spiedFuture = CompletableFuture.completedFuture(spy);
        futureField.set(pr, spiedFuture);
        if (futureConnectionField.equals("futureConnection1")) {
            Assert.assertSame((Object)spy, pr.getFutureConnection1().get());
        } else {
            Assert.assertSame((Object)spy, pr.getFutureConnection2().get());
        }
    }

    private String getHistogramKey(Configuration config) throws SQLException {
        String url = QueryUtil.getConnectionUrl((Properties)this.clientProperties, (Configuration)config, (String)"USER_FOO");
        return ConnectionInfo.createNoLogin((String)url, null, null).toUrl();
    }

    private void assertHTableThreadPoolHistograms(List<HistogramDistribution> histograms, String histogramKey, boolean isUsed, String zkQuorum, String principal) {
        Assert.assertNotNull(histograms);
        Assert.assertEquals((long)2L, (long)histograms.size());
        for (HistogramDistribution histogram : histograms) {
            if (isUsed) {
                Assert.assertTrue((histogram.getCount() > 0L ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((long)0L, (long)histogram.getCount());
            }
            Assert.assertEquals((Object)zkQuorum, (Object)histogram.getTags().get((Object)HTableThreadPoolHistograms.Tag.servers.name()));
            Assert.assertEquals((Object)principal, (Object)histogram.getTags().get((Object)HTableThreadPoolHistograms.Tag.cqsiName.name()));
        }
    }

    @Test
    public void testCluster1Unavailable() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster1(), () -> {
            CLUSTERS.logClustersStates();
            try (Connection conn = this.getParallelConnection();){
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            }
        });
    }

    @Test
    public void testCluster1OfflineRole() throws Exception {
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.OFFLINE, ClusterRoleRecord.ClusterRole.ACTIVE);
        try (Connection conn = this.getParallelConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBothClusterATSRole() throws Exception {
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY);
        try (Connection conn = this.getParallelConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            Assert.fail((String)"Expected MutationBlockedIOException to be thrown");
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)this.containsMutationBlockedException(e));
        }
        finally {
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        }
    }

    @Test
    public void testOneClusterATSRoleWithActive() throws Exception {
        this.testOneClusterATSRole(ClusterRoleRecord.ClusterRole.ACTIVE);
    }

    @Test
    public void testOneClusterATSRoleWithStandby() throws Exception {
        this.testOneClusterATSRole(ClusterRoleRecord.ClusterRole.STANDBY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOneClusterATSRole(ClusterRoleRecord.ClusterRole otherRole) throws Exception {
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, otherRole);
        try (Connection conn = this.getParallelConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
        catch (SQLException e) {
            Assert.fail((String)("Expected no exception to be thrown as one cluster is in ACTIVE_TO_STANDBY and other in " + otherRole));
        }
        finally {
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        }
    }

    private boolean containsMutationBlockedException(SQLException e) {
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof RetriesExhaustedWithDetailsException)) continue;
            RetriesExhaustedWithDetailsException re = (RetriesExhaustedWithDetailsException)cause;
            return re.getCause(0) instanceof MutationBlockedIOException;
        }
        return false;
    }

    @Test
    public void testPreparedStatementsBasic() throws Exception {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        Statement statement2;
        PreparedStatement preparedStatement;
        String upsertSQL = String.format("UPSERT INTO %s VALUES(?, ?)", this.tableName);
        try (Connection conn = this.getParallelConnection();){
            preparedStatement = conn.prepareStatement(upsertSQL);
            for (int i = 0; i < 100; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.setInt(2, i);
                preparedStatement.execute();
            }
            ParallelPhoenixConnectionIT.assertOperationTypeForStatement(preparedStatement, PhoenixStatement.Operation.UPSERT);
        }
        CLUSTERS.checkReplicationComplete();
        conn = CLUSTERS.getCluster1Connection(this.haGroup);
        var3_3 = null;
        try {
            statement2 = conn.createStatement();
            throwable2 = null;
            try {
                rs2 = statement2.executeQuery(String.format("SELECT COUNT(*) FROM %s", this.tableName));
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)100L, (long)rs2.getInt(1));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                if (statement2 != null) {
                    if (throwable2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (Throwable rs2) {
                            throwable2.addSuppressed(rs2);
                        }
                    } else {
                        statement2.close();
                    }
                }
            }
        }
        catch (Throwable statement2) {
            var3_3 = statement2;
            throw statement2;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable statement2) {
                        var3_3.addSuppressed(statement2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = CLUSTERS.getCluster2Connection(this.haGroup);
        var3_3 = null;
        try {
            statement2 = conn.createStatement();
            throwable2 = null;
            try {
                rs2 = statement2.executeQuery(String.format("SELECT COUNT(*) FROM %s", this.tableName));
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)100L, (long)rs2.getInt(1));
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs3) {
                throwable2 = rs3;
                throw rs3;
            }
            finally {
                if (statement2 != null) {
                    if (throwable2 != null) {
                        try {
                            statement2.close();
                        }
                        catch (Throwable rs3) {
                            throwable2.addSuppressed(rs3);
                        }
                    } else {
                        statement2.close();
                    }
                }
            }
        }
        catch (Throwable statement3) {
            var3_3 = statement3;
            throw statement3;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable statement3) {
                        var3_3.addSuppressed(statement3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.getParallelConnection();
        var3_3 = null;
        try {
            preparedStatement = conn.prepareStatement(String.format("SELECT v FROM %s WHERE id IN (1,3,7,19) ", this.tableName));
            throwable2 = null;
            try {
                rs2 = preparedStatement.executeQuery();
                throwable = null;
                try {
                    ParallelPhoenixConnectionIT.assertOperationTypeForStatement(preparedStatement, PhoenixStatement.Operation.QUERY);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)1L, (long)rs2.getInt(1));
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)3L, (long)rs2.getInt(1));
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)7L, (long)rs2.getInt(1));
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)19L, (long)rs2.getInt(1));
                    Assert.assertFalse((boolean)rs2.next());
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable9) {
                throwable2 = throwable9;
                throw throwable9;
            }
            finally {
                if (preparedStatement != null) {
                    if (throwable2 != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
        }
        catch (Throwable throwable11) {
            var3_3 = throwable11;
            throw throwable11;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable12) {
                        var3_3.addSuppressed(throwable12);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testClusterBasic() throws Exception {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        Statement statement3;
        try (Connection conn = this.getParallelConnection();){
            for (int i = 0; i < 100; ++i) {
                try (Statement statement2 = conn.createStatement();){
                    String upsertSQL = String.format("UPSERT INTO %s VALUES(%d, %d)", this.tableName, i, i);
                    statement2.executeUpdate(upsertSQL);
                    continue;
                }
            }
        }
        CLUSTERS.checkReplicationComplete();
        conn = CLUSTERS.getCluster1Connection(this.haGroup);
        var2_2 = null;
        try {
            statement3 = conn.createStatement();
            throwable2 = null;
            try {
                rs2 = statement3.executeQuery(String.format("SELECT COUNT(*) FROM %s", this.tableName));
                throwable = null;
                try {
                    ParallelPhoenixConnectionIT.assertOperationTypeForStatement(statement3, PhoenixStatement.Operation.QUERY);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)100L, (long)rs2.getInt(1));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                if (statement3 != null) {
                    if (throwable2 != null) {
                        try {
                            statement3.close();
                        }
                        catch (Throwable rs2) {
                            throwable2.addSuppressed(rs2);
                        }
                    } else {
                        statement3.close();
                    }
                }
            }
        }
        catch (Throwable statement3) {
            var2_2 = statement3;
            throw statement3;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable statement3) {
                        var2_2.addSuppressed(statement3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = CLUSTERS.getCluster2Connection(this.haGroup);
        var2_2 = null;
        try {
            statement3 = conn.createStatement();
            throwable2 = null;
            try {
                rs2 = statement3.executeQuery(String.format("SELECT COUNT(*) FROM %s", this.tableName));
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)100L, (long)rs2.getInt(1));
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs3) {
                throwable2 = rs3;
                throw rs3;
            }
            finally {
                if (statement3 != null) {
                    if (throwable2 != null) {
                        try {
                            statement3.close();
                        }
                        catch (Throwable rs3) {
                            throwable2.addSuppressed(rs3);
                        }
                    } else {
                        statement3.close();
                    }
                }
            }
        }
        catch (Throwable statement4) {
            var2_2 = statement4;
            throw statement4;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable statement4) {
                        var2_2.addSuppressed(statement4);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = this.getParallelConnection();
        var2_2 = null;
        try {
            statement3 = conn.createStatement();
            throwable2 = null;
            try {
                rs2 = statement3.executeQuery(String.format("SELECT v FROM %s WHERE id IN (1,3,7,19) ", this.tableName));
                throwable = null;
                try {
                    ParallelPhoenixConnectionIT.assertOperationTypeForStatement(statement3, PhoenixStatement.Operation.QUERY);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)1L, (long)rs2.getInt(1));
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)3L, (long)rs2.getInt(1));
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)7L, (long)rs2.getInt(1));
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)19L, (long)rs2.getInt(1));
                    Assert.assertFalse((boolean)rs2.next());
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable9) {
                throwable2 = throwable9;
                throw throwable9;
            }
            finally {
                if (statement3 != null) {
                    if (throwable2 != null) {
                        try {
                            statement3.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                    } else {
                        statement3.close();
                    }
                }
            }
        }
        catch (Throwable throwable11) {
            var2_2 = throwable11;
            throw throwable11;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable12) {
                        var2_2.addSuppressed(throwable12);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testClosedConnectionNotReusable() throws Exception {
        try (Connection conn = this.getParallelConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            Statement statement1 = conn.createStatement();
            ResultSet rs = statement1.executeQuery(String.format("SELECT v FROM %s ", this.tableName));
            conn.close();
            try {
                Statement statement2 = conn.createStatement();
                Assert.fail((String)"Should not reach this point");
            }
            catch (Exception e) {
                LOG.error("Exception expected: ", (Throwable)e);
            }
            try {
                rs.next();
                Assert.fail((String)"Should not reach this point");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConnectionErrorCount() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster1(), () -> {
            CLUSTERS.logClustersStates();
            GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_CREATED_COUNTER.getMetric().reset();
            GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_ERROR_COUNTER.getMetric().reset();
            try (Connection conn = this.getParallelConnection();){
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            }
            Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_CREATED_COUNTER.getMetric().getValue());
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_ERROR_COUNTER.getMetric().getValue());
            try {
                conn = this.getParallelConnection();
                var2_3 = null;
                try {
                    CompletableFuture pConn = null;
                    int downClientPort = CLUSTERS.getHBaseCluster1().getZkCluster().getClientPort();
                    pConn = ((ParallelPhoenixConnection)conn).getContext().getHaGroup().getRoleRecord().getUrl1().contains(String.valueOf(downClientPort)) ? ((ParallelPhoenixConnection)conn).futureConnection2 : ((ParallelPhoenixConnection)conn).futureConnection1;
                    try {
                        ((PhoenixConnection)pConn.get()).close();
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected Exception in future connection get/close", (Throwable)e);
                        throw e;
                    }
                    try (Statement stmt = conn.createStatement();){
                        stmt.executeQuery(String.format("SELECT v FROM %s WHERE id = %d", this.tableName, 0));
                    }
                    Assert.fail();
                }
                catch (Throwable throwable) {
                    var2_3 = throwable;
                    throw throwable;
                }
                finally {
                    if (conn != null) {
                        if (var2_3 != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable) {
                                var2_3.addSuppressed(throwable);
                            }
                        } else {
                            conn.close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertEquals((long)2L, (long)GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_CREATED_COUNTER.getMetric().getValue());
            Assert.assertEquals((long)1L, (long)GlobalClientMetrics.GLOBAL_HA_PARALLEL_CONNECTION_ERROR_COUNTER.getMetric().getValue());
        });
    }

    @Test
    public void testMetrics() throws Exception {
        Throwable throwable;
        Throwable throwable2;
        Statement stmt;
        CLUSTERS.logClustersStates();
        try (Connection conn = this.getParallelConnection();){
            PhoenixRuntime.resetMetrics((Connection)conn);
            stmt = conn.createStatement();
            throwable2 = null;
            try {
                stmt.executeUpdate(String.format("UPSERT INTO %s VALUES(%d, 1984)", this.tableName, 0));
                conn.commit();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            this.waitForCompletion(conn);
            Map metrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
            Assert.assertEquals((long)2L, (long)metrics.size());
            Map parallelMetrics = (Map)metrics.get(ParallelPhoenixContext.PARALLEL_PHOENIX_METRICS);
            Assert.assertEquals((long)0L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_ACTIVE_CLUSTER)));
            Assert.assertEquals((long)0L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_STANDBY_CLUSTER)));
            Assert.assertEquals((long)4L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_OPERATIONS_ACTIVE_CLUSTER)));
            Assert.assertEquals((long)4L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_OPERATIONS_STANDBY_CLUSTER)));
            Assert.assertEquals((long)4L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_ACTIVE_CLUSTER) + (Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_STANDBY_CLUSTER)));
            PhoenixRuntime.resetMetrics((Connection)conn);
            ((PhoenixConnection)((ParallelPhoenixConnection)conn).futureConnection1.get()).close();
            throwable = null;
            try (Statement stmt2 = conn.createStatement();){
                stmt2.executeUpdate(String.format("UPSERT INTO %s VALUES(%d, 1984)", this.tableName, 0));
                conn.commit();
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            this.waitForCompletion(conn);
            metrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
            Assert.assertEquals((long)2L, (long)metrics.size());
            parallelMetrics = (Map)metrics.get(ParallelPhoenixContext.PARALLEL_PHOENIX_METRICS);
            Assert.assertEquals((long)1L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_ACTIVE_CLUSTER)));
            Assert.assertEquals((long)0L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_STANDBY_CLUSTER)));
            Assert.assertEquals((long)1L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_OPERATIONS_ACTIVE_CLUSTER)));
            Assert.assertEquals((long)4L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_OPERATIONS_STANDBY_CLUSTER)));
            Assert.assertEquals((long)4L, (long)((Long)parallelMetrics.get(MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_STANDBY_CLUSTER)));
        }
        conn = this.getParallelConnection();
        var2_2 = null;
        try {
            stmt = conn.createStatement();
            throwable2 = null;
            try {
                throwable = null;
                try (ResultSet rs = stmt.executeQuery(String.format("SELECT * FROM  %s ", this.tableName));){
                    rs.next();
                    rs.getInt(1);
                    rs.getInt(2);
                    rs.next();
                    Map metrics = PhoenixRuntime.getRequestReadMetricInfo((ResultSet)rs);
                    Assert.assertEquals((long)2L, (long)metrics.size());
                    Map tableMetrics = (Map)metrics.get(ParallelPhoenixContext.PARALLEL_PHOENIX_METRICS);
                    Assert.assertEquals((long)0L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_ACTIVE_CLUSTER)));
                    Assert.assertEquals((long)0L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_STANDBY_CLUSTER)));
                    Assert.assertEquals((long)2L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_OPERATIONS_ACTIVE_CLUSTER)));
                    Assert.assertEquals((long)2L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_OPERATIONS_STANDBY_CLUSTER)));
                    Assert.assertEquals((long)3L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_ACTIVE_CLUSTER) + (Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_STANDBY_CLUSTER)));
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable9) {
            var2_2 = throwable9;
            throw throwable9;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable10) {
                        var2_2.addSuppressed(throwable10);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testNoMetrics() throws Exception {
        try (Connection conn = this.getParallelConnection();){
            Map metrics = PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)conn);
            Assert.assertEquals((long)1L, (long)metrics.size());
            Map tableMetrics = (Map)metrics.get(ParallelPhoenixContext.PARALLEL_PHOENIX_METRICS);
            this.waitForCompletion(conn);
            Assert.assertEquals((long)6L, (long)tableMetrics.size());
            Assert.assertEquals((long)0L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_ACTIVE_CLUSTER)));
            Assert.assertEquals((long)0L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_FAILED_OPERATIONS_STANDBY_CLUSTER)));
            Assert.assertEquals((long)0L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_OPERATIONS_ACTIVE_CLUSTER) + (Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_OPERATIONS_STANDBY_CLUSTER)));
            Assert.assertEquals((long)0L, (long)((Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_ACTIVE_CLUSTER) + (Long)tableMetrics.get(MetricType.HA_PARALLEL_COUNT_USED_OPERATIONS_STANDBY_CLUSTER)));
        }
    }

    @Test
    public void testGlobalClientExecutorServiceMetrics() throws Exception {
        try (Connection conn = this.getParallelConnection();){
            this.resetGlobalClientMetrics();
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate(String.format("UPSERT INTO %s VALUES(%d, 1984)", this.tableName, 0));
                conn.commit();
            }
            Assert.assertTrue((boolean)(conn instanceof ParallelPhoenixConnection));
            ParallelPhoenixContext context = ((ParallelPhoenixConnection)conn).getContext();
            GenericTestUtils.waitFor(() -> context.getChainOnConn1().isDone(), (long)100L, (long)5000L);
            GenericTestUtils.waitFor(() -> context.getChainOnConn2().isDone(), (long)100L, (long)5000L);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_EXECUTED_COUNTER.getMetric().getValue() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_QUEUE_WAIT_TIME.getMetric().getNumberOfSamples() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_QUEUE_WAIT_TIME.getMetric().getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_END_TO_END_TIME.getMetric().getNumberOfSamples() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_END_TO_END_TIME.getMetric().getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_EXECUTION_TIME.getMetric().getNumberOfSamples() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_EXECUTION_TIME.getMetric().getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL1_TASK_REJECTED_COUNTER.getMetric().getValue());
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_EXECUTED_COUNTER.getMetric().getValue() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_QUEUE_WAIT_TIME.getMetric().getNumberOfSamples() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_QUEUE_WAIT_TIME.getMetric().getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_END_TO_END_TIME.getMetric().getNumberOfSamples() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_END_TO_END_TIME.getMetric().getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_EXECUTION_TIME.getMetric().getNumberOfSamples() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_EXECUTION_TIME.getMetric().getValue() >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_HA_PARALLEL_POOL2_TASK_REJECTED_COUNTER.getMetric().getValue());
        }
    }

    private void resetGlobalClientMetrics() {
        for (GlobalMetric m : PhoenixRuntime.getGlobalPhoenixClientMetrics()) {
            m.reset();
        }
    }

    @Test
    public void testSeparateMetadata() throws Exception {
        String tableName = "TABLE_" + RandomStringUtils.randomAlphabetic((int)10);
        try (Connection conn = CLUSTERS.getCluster2Connection(this.haGroup);){
            String ddl = "CREATE TABLE " + tableName + " ( MYKEY VARCHAR NOT NULL, MYVALUE VARCHAR CONSTRAINT PK_DATA PRIMARY KEY (MYKEY))";
            try (Statement stmt = conn.createStatement();){
                stmt.execute(ddl);
            }
            stmt = conn.createStatement();
            var6_10 = null;
            try {
                stmt.execute("UPSERT INTO " + tableName + " VALUES('hi','bye')");
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var6_10 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            conn.commit();
        }
        conn = this.getParallelConnection();
        var3_3 = null;
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(String.format("SELECT * FROM %s", tableName));){
            Assert.assertTrue((boolean)rs.next());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testAllWrappedConnectionsClosedAfterRegistryChangeToMaster() throws Exception {
        short numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.getParallelConnection());
        }
        ConnectionQueryServicesImpl cqsi = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
        ConnectionInfo connInfo = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.haGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.clientProperties);
        ClusterRoleRecord.RegistryType newRegistry = ClusterRoleRecord.RegistryType.MASTER;
        CLUSTERS.transitClusterRoleRecordRegistry(this.haGroup, newRegistry);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            ParallelPhoenixConnection conn = (ParallelPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)((PhoenixConnection)conn.futureConnection1.get()).isClosed());
            Assert.assertTrue((boolean)((PhoenixConnection)conn.futureConnection2.get()).isClosed());
        }
        try {
            cqsi.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfo));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterRegistryChangeToRpc() throws Exception {
        short numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.getParallelConnection());
        }
        ConnectionQueryServicesImpl cqsi = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
        ConnectionInfo connInfo = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.haGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.clientProperties);
        ClusterRoleRecord.RegistryType newRegistry = ClusterRoleRecord.RegistryType.RPC;
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        CLUSTERS.transitClusterRoleRecordRegistry(this.haGroup, newRegistry);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            ParallelPhoenixConnection conn = (ParallelPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)((PhoenixConnection)conn.futureConnection1.get()).isClosed());
            Assert.assertTrue((boolean)((PhoenixConnection)conn.futureConnection2.get()).isClosed());
        }
        try {
            cqsi.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfo));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
    }

    private static void assertOperationTypeForStatement(Statement statement, PhoenixStatement.Operation expectedUpdateOpType) throws SQLException {
        PhoenixMonitoredStatement stmt = statement.unwrap(PhoenixMonitoredStatement.class);
        Assert.assertEquals((Object)expectedUpdateOpType, (Object)stmt.getUpdateOperation());
    }

    private Connection getParallelConnection() throws SQLException {
        return DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(), this.clientProperties);
    }

    void waitForCompletion(Connection conn) throws Exception {
        ParallelPhoenixContext context = ((ParallelPhoenixConnection)conn).getContext();
        Thread.sleep(200L);
        GenericTestUtils.waitFor(() -> context.getChainOnConn1().isDone(), (long)100L, (long)30000L);
        GenericTestUtils.waitFor(() -> context.getChainOnConn2().isDone(), (long)100L, (long)30000L);
        Thread.sleep(200L);
    }
}

