/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.LoggingConnectionLimiterIT;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.log.ConnectionLimiter;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class LoggingHAConnectionLimiterIT
extends LoggingConnectionLimiterIT {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingHAConnectionLimiterIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private static Map<String, String> GLOBAL_PROPERTIES;
    private static List<Connection> CONNECTIONS;
    private Properties clientProperties;
    private String jdbcHAUrl;
    private HighAvailabilityGroup haGroup;

    @BeforeClass
    public static final void doSetup() throws Exception {
        GLOBAL_PROPERTIES = new HashMap<String, String>(){
            {
                this.put("phoenix.connection.activity.logging.enabled", String.valueOf(true));
                this.put("phoenix.client.connection.max.allowed.connections", String.valueOf(20));
                this.put("phoenix.internal.connection.max.allowed.connections", String.valueOf(20));
                this.put("phoenix.ha.max.pool.size", String.valueOf(5));
                this.put("phoenix.ha.max.queue.size", String.valueOf(30));
            }
        };
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
        GLOBAL_PROPERTIES.put("phoenix.ha.group.name", HighAvailabilityPolicy.PARALLEL.name());
        CONNECTIONS = Lists.newArrayList((Object[])new Connection[]{LoggingHAConnectionLimiterIT.getConnection(CLUSTERS.getJdbcUrl(CLUSTERS.getZkUrl1())), LoggingHAConnectionLimiterIT.getConnection(CLUSTERS.getJdbcUrl(CLUSTERS.getZkUrl2()))});
        LOG.info(String.format("************* Num connections : %d", CONNECTIONS.size()));
        for (Connection conn : CONNECTIONS) {
            try (Statement statement = conn.createStatement();){
                statement.execute(CREATE_TABLE_SQL);
            }
            conn.commit();
        }
        try (Connection connection = LoggingHAConnectionLimiterIT.getConnection(CLUSTERS.getJdbcUrl(CLUSTERS.getZkUrl1()));){
            LoggingHAConnectionLimiterIT.loadData(connection, "org000000000000001", "groupId", 100, 20);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        for (Connection conn : CONNECTIONS) {
            conn.close();
        }
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        this.clientProperties = new Properties();
        this.clientProperties.putAll(GLOBAL_PROPERTIES);
        String haGroupName = this.testName.getMethodName();
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName);
        CLUSTERS.initClusterRole(haGroupName, HighAvailabilityPolicy.PARALLEL);
        this.jdbcHAUrl = String.format("jdbc:phoenix:[%s|%s]", CLUSTERS.getZkUrl1(), CLUSTERS.getZkUrl2());
        this.haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(this.jdbcHAUrl, this.clientProperties);
        LOG.info("Initialized haGroup {} with URL {}", (Object)this.haGroup.getGroupInfo().getName(), (Object)this.jdbcHAUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConnectionLimiter getConnectionLimiter() throws Exception {
        ConnectionQueryServices cqs = null;
        try (Connection testConnection = null;){
            testConnection = this.getConnection();
            ParallelPhoenixConnection phoenixConnection = testConnection.unwrap(ParallelPhoenixConnection.class);
            cqs = ((PhoenixConnection)phoenixConnection.getFutureConnection1().get()).getQueryServices();
            ConnectionLimiter connectionLimiter = cqs.getConnectionLimiter();
            return connectionLimiter;
        }
    }

    @Override
    protected Connection getConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.jdbcHAUrl, this.clientProperties);
        connection.setAutoCommit(true);
        return connection;
    }

    private static Connection getConnection(String url) throws SQLException {
        return DriverManager.getConnection(url, new Properties());
    }

    static {
        CONNECTIONS = null;
    }
}

