/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.log.ConnectionLimiter;
import org.apache.phoenix.log.LoggingConnectionLimiter;
import org.apache.phoenix.query.BaseTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={NeedsOwnMiniClusterTest.class})
public abstract class LoggingConnectionLimiterIT
extends BaseTest {
    private static final Instant NOW = Instant.now();
    private static final String tableName = LoggingConnectionLimiterIT.generateUniqueName();
    private static final String UPSERT_SQL = "UPSERT INTO " + tableName + "(ORGANIZATION_ID, CLIENT_TYPE, GROUP_ID, MY_KEY, MY_VALUE, SIZE, NEXT_CHUNK, POD, CREATED_DATE, EXPIRY_DATE) values (?,?,?,?,?,?,?,?,?,?)";
    private static final String GROUP_CONDITION = "ORGANIZATION_ID=? and CLIENT_TYPE=? and GROUP_ID=?";
    private static final String KEY_CONDITION = "ORGANIZATION_ID=? and CLIENT_TYPE=? and GROUP_ID=? and MY_KEY=?";
    private static final String SELECT_KEY_SQL = "SELECT EXPIRY_DATE, NEXT_CHUNK, MY_VALUE, CREATED_DATE FROM " + tableName + " WHERE " + "ORGANIZATION_ID=? and CLIENT_TYPE=? and GROUP_ID=? and MY_KEY=?";
    protected static final String CREATE_TABLE_SQL = String.format("CREATE TABLE IF NOT EXISTS %s (  \n  ORGANIZATION_ID CHAR(18) NOT NULL,  \n  CLIENT_TYPE VARCHAR NOT NULL,  \n  GROUP_ID VARCHAR NOT NULL,  \n  MY_KEY VARCHAR NOT NULL,  \n  MY_VALUE VARBINARY,  \n  SIZE INTEGER,\n  NEXT_CHUNK BOOLEAN,\n  POD VARCHAR,  \n  CREATED_DATE DATE,\n  EXPIRY_DATE DATE,\n  CONSTRAINT PK_DATA PRIMARY KEY   \n  (  \n    ORGANIZATION_ID,  \n    CLIENT_TYPE,  \n    GROUP_ID,  \n    MY_KEY  \n  )  \n) IMMUTABLE_ROWS=true, VERSIONS=1, DISABLE_TABLE_SOR=true, REPLICATION_SCOPE=1, TTL=864000", tableName);
    protected static final String ORG_ID = "org000000000000001";
    protected static final String GROUP_ID = "groupId";
    @Rule
    public TestName testName = new TestName();

    @Test
    public void testWhenAllConnectionsClosed() throws Exception {
        int loadFailures = this.runSampleActivity(ActivityType.LOAD, 10, 100, 10, 0);
        ConnectionLimiter limiter = this.getConnectionLimiter();
        Assert.assertTrue((boolean)(limiter instanceof LoggingConnectionLimiter));
        int count = ((LoggingConnectionLimiter)limiter).getConnectionCount();
        Assert.assertTrue((String)"Should not have any failures", (loadFailures == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Num connections not closed not as expected", (count == 0 ? 1 : 0) != 0);
        Map logs = ((LoggingConnectionLimiter)limiter).getActivityLog();
        for (Map.Entry logEntry : logs.entrySet()) {
            Assert.assertTrue((boolean)((String)logEntry.getValue()).contains("o=upserted"));
        }
    }

    @Test
    public void testActivityLogsOnUpsertsWhenNoFailures() throws Exception {
        int loadFailures = this.runSampleActivity(ActivityType.LOAD, 10, 100, 10, 10);
        ConnectionLimiter limiter = this.getConnectionLimiter();
        Assert.assertTrue((boolean)(limiter instanceof LoggingConnectionLimiter));
        int count = ((LoggingConnectionLimiter)limiter).getConnectionCount();
        Assert.assertTrue((String)"Should not have any failures", (loadFailures == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Num connections not closed not as expected", (count == 10 ? 1 : 0) != 0);
        Map logs = ((LoggingConnectionLimiter)limiter).getActivityLog();
        for (Map.Entry logEntry : logs.entrySet()) {
            Assert.assertTrue((boolean)((String)logEntry.getValue()).contains("o=upserted"));
        }
    }

    @Test
    public void testActivityLogsOnQueryWhenNoFailures() throws Exception {
        int queryFailures = this.runSampleActivity(ActivityType.QUERY, 10, 100, 10, 10);
        ConnectionLimiter limiter = this.getConnectionLimiter();
        Assert.assertTrue((boolean)(limiter instanceof LoggingConnectionLimiter));
        int count = ((LoggingConnectionLimiter)limiter).getConnectionCount();
        Assert.assertTrue((String)"Should not have any failures", (queryFailures == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Num connections not closed not as expected", (count == 10 ? 1 : 0) != 0);
        Map logs = ((LoggingConnectionLimiter)limiter).getActivityLog();
        for (Map.Entry logEntry : logs.entrySet()) {
            Assert.assertTrue((boolean)((String)logEntry.getValue()).contains("o=queried"));
        }
    }

    @Test
    public void testActivityLogsOnUpsertWhenFailures() throws Exception {
        int loadFailures = this.runSampleActivity(ActivityType.LOAD, 10, 100, 10, 20);
        ConnectionLimiter limiter = this.getConnectionLimiter();
        Assert.assertTrue((boolean)(limiter instanceof LoggingConnectionLimiter));
        int count = ((LoggingConnectionLimiter)limiter).getConnectionCount();
        Assert.assertTrue((String)"Should have some failures", (loadFailures > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)String.format("Num connections not closed not as expected [expected >= %d, actual = %d", 10, count), (count >= 10 ? 1 : 0) != 0);
        Map logs = ((LoggingConnectionLimiter)limiter).getActivityLog();
        for (Map.Entry logEntry : logs.entrySet()) {
            Assert.assertTrue((boolean)((String)logEntry.getValue()).contains("o=upserted"));
        }
    }

    @Test
    public void testActivityLogsOnQueryWhenFailures() throws Exception {
        int queryFailures = this.runSampleActivity(ActivityType.QUERY, 10, 100, 10, 20);
        ConnectionLimiter limiter = this.getConnectionLimiter();
        Assert.assertTrue((boolean)(limiter instanceof LoggingConnectionLimiter));
        int count = ((LoggingConnectionLimiter)limiter).getConnectionCount();
        Assert.assertTrue((String)"Should have some failures", (queryFailures > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)String.format("Num connections not closed not as expected [expected >= %d, actual = %d", 10, count), (count >= 10 ? 1 : 0) != 0);
        Map logs = ((LoggingConnectionLimiter)limiter).getActivityLog();
        for (Map.Entry logEntry : logs.entrySet()) {
            Assert.assertTrue((boolean)((String)logEntry.getValue()).contains("o=queried"));
        }
    }

    @Test
    public void testQueryExplainPlan() throws Exception {
        String query = "SELECT * FROM " + tableName;
        if (this.getConnection() instanceof PhoenixConnection) {
            try (PhoenixConnection pconn = this.getConnection().unwrap(PhoenixConnection.class);
                 Statement stmt = pconn.createStatement();){
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                }
                boolean queryPlanFound = false;
                String queryPlan = pconn.getActivityLogger().getExplainPlanInfo();
                if (queryPlan != null && queryPlan.contains("FULL SCAN") && queryPlan.contains("regions=") && queryPlan.contains("hostnames=")) {
                    queryPlanFound = true;
                    String regions = this.extractBetweenBraces(queryPlan, "regions={");
                    String hostnames = this.extractBetweenBraces(queryPlan, "hostnames={");
                    Assert.assertFalse((String)"Regions should not be empty", (boolean)regions.trim().isEmpty());
                    Assert.assertFalse((String)"Hostnames should not be empty", (boolean)hostnames.trim().isEmpty());
                }
                Assert.assertTrue((String)"Query plan should contain FULL SCAN, regions, and hostnames", (boolean)queryPlanFound);
            }
            pconn = this.getConnection().unwrap(PhoenixConnection.class);
            var3_3 = null;
            try {
                LoggingConnectionLimiterIT.loadData((Connection)pconn, "PhoenixTest", "1", 10, 2);
                String queryPlan = pconn.getActivityLogger().getExplainPlanInfo();
                Assert.assertTrue((String)"Query plan should be empty for non-query operations", (boolean)queryPlan.isEmpty());
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (pconn != null) {
                    if (var3_3 != null) {
                        try {
                            pconn.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        pconn.close();
                    }
                }
            }
        }
        Assert.assertTrue((boolean)(this.getConnection() instanceof ParallelPhoenixConnection));
    }

    private String extractBetweenBraces(String text, String marker) {
        int start = text.indexOf(marker) + marker.length();
        int end = text.indexOf("}", start);
        return text.substring(start, end);
    }

    protected abstract ConnectionLimiter getConnectionLimiter() throws Exception;

    protected int runSampleActivity(ActivityType activityType, int clientPool, int clientQueue, int numRows, int connNotClosed) throws Exception {
        int i;
        Random rnd = new Random();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(clientPool, clientPool, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(clientQueue));
        ArrayList clientCallList = new ArrayList();
        ArrayList<CompletionStage> mayHaveFailedList = new ArrayList<CompletionStage>();
        CountDownLatch latch = new CountDownLatch(clientQueue);
        HashSet<Integer> skipCloseForClients = new HashSet<Integer>();
        for (int i2 = 0; i2 < clientQueue && connNotClosed > 0; ++i2) {
            skipCloseForClients.add(rnd.nextInt(clientQueue));
            if (skipCloseForClients.size() == connNotClosed) break;
        }
        HashSet skippedCloseForClients = new HashSet();
        for (i = 0; i < clientQueue; ++i) {
            CompletableFuture mockCompletableFuture = new CompletableFuture();
            CompletionStage mayHaveException = mockCompletableFuture.whenCompleteAsync((r, e) -> {
                String resultInfo = (Object)((Object)activityType) + " activity started";
                int index = Integer.parseInt(r);
                try {
                    int rowsToWrite = numRows;
                    String orgId = StringUtils.rightPad((String)BaseTest.generateUniqueName(), (int)15).substring(0, 15);
                    String groupId = this.testName.getMethodName();
                    Connection connection = this.getConnection();
                    try {
                        connection.setAutoCommit(false);
                        switch (activityType) {
                            case LOAD: {
                                LoggingConnectionLimiterIT.loadData(connection, orgId, groupId, rowsToWrite, 20);
                                break;
                            }
                            case QUERY: {
                                LoggingConnectionLimiterIT.loadData(connection, orgId, groupId, rowsToWrite, 20);
                                this.queryData(connection, orgId, groupId);
                                break;
                            }
                        }
                        resultInfo = "activity completed";
                    }
                    finally {
                        if (!skipCloseForClients.contains(index)) {
                            connection.close();
                        }
                        if (skipCloseForClients.contains(index)) {
                            resultInfo = "skipped close";
                            skippedCloseForClients.add(Integer.valueOf(r));
                        }
                    }
                }
                catch (SQLException ex) {
                    resultInfo = "failed sqle";
                    throw new RuntimeException(ex);
                }
                catch (Exception ex) {
                    resultInfo = "failed general";
                    throw new RuntimeException(ex);
                }
                finally {
                    latch.countDown();
                }
            }, (Executor)executorService);
            mayHaveFailedList.add(mayHaveException);
            clientCallList.add(mockCompletableFuture);
        }
        for (i = 0; i < clientCallList.size(); ++i) {
            ((CompletableFuture)clientCallList.get(i)).complete(String.valueOf(i));
        }
        latch.await();
        executorService.shutdown();
        AtomicInteger failedCount = new AtomicInteger();
        mayHaveFailedList.forEach((Consumer<CompletionStage>)((Consumer<CompletableFuture>)cf -> cf.whenComplete((r, e) -> {
            if (e != null) {
                failedCount.incrementAndGet();
            }
        })));
        return failedCount.get();
    }

    protected static void loadData(Connection connection, String orgId, String groupId, int rows, int batchSize) throws SQLException {
        Integer counter = 0;
        for (int i = 0; i < rows; ++i) {
            try (PreparedStatement ps = connection.prepareStatement(UPSERT_SQL);){
                ps.setString(1, orgId);
                ps.setString(2, "CLIENT_TYPE");
                ps.setString(3, groupId);
                Integer n = counter;
                Integer n2 = counter = Integer.valueOf(counter + 1);
                ps.setString(4, String.valueOf(n));
                ps.setBytes(5, new byte[]{counter.byteValue()});
                ps.setInt(6, 1);
                ps.setBoolean(7, false);
                ps.setString(8, "pod");
                ps.setTimestamp(9, Timestamp.from(NOW));
                ps.setTimestamp(10, Timestamp.from(NOW.plusSeconds(3600L)));
                int result = ps.executeUpdate();
                if (result != 1) {
                    throw new RuntimeException("Phoenix error: upsert count is not one. It is " + result);
                }
            }
            if (connection.getAutoCommit() || counter % batchSize != 0) continue;
            connection.commit();
        }
        if (!connection.getAutoCommit()) {
            connection.commit();
        }
    }

    protected void queryData(Connection connection, String orgId, String groupId) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(SELECT_KEY_SQL);){
            statement.setString(1, orgId);
            statement.setString(2, "CLIENT_TYPE");
            statement.setString(3, groupId);
            statement.setString(4, "3");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertArrayEquals((byte[])new byte[]{Integer.valueOf(4).byteValue()}, (byte[])rs.getBytes(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    protected abstract Connection getConnection() throws SQLException;

    private static enum ActivityType {
        QUERY,
        LOAD;

    }
}

