/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class HighAvailabilityTestingUtilityIT {
    private static final Logger LOG = LoggerFactory.getLogger(HighAvailabilityTestingUtilityIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    @Rule
    public TestName testName = new TestName();
    private Properties clientProperties;
    private String jdbcHAUrl;
    private HighAvailabilityGroup haGroup;
    private String haGroupName;
    private final ClusterRoleRecord.RegistryType registryType;
    private String tableName;

    public HighAvailabilityTestingUtilityIT(ClusterRoleRecord.RegistryType registryType) {
        this.registryType = registryType;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        if (this.registryType == ClusterRoleRecord.RegistryType.RPC) {
            Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        }
        this.haGroupName = this.testName.getMethodName();
        this.clientProperties = HighAvailabilityTestingUtility.getHATestProperties();
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroupName);
        if (this.registryType == null) {
            CLUSTERS.initClusterRole(this.haGroupName, HighAvailabilityPolicy.FAILOVER);
        } else {
            CLUSTERS.initClusterRole(this.haGroupName, HighAvailabilityPolicy.FAILOVER, this.registryType);
        }
        this.tableName = RandomStringUtils.randomAlphabetic((int)10);
        this.jdbcHAUrl = CLUSTERS.getJdbcHAUrl();
        this.haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(this.jdbcHAUrl, this.clientProperties);
        CLUSTERS.createTableOnClusterPair(this.haGroup, this.tableName);
    }

    @Parameterized.Parameters(name="ClusterRoleRecord_registryType={0}")
    public static Collection<Object> data() {
        return Arrays.asList(ClusterRoleRecord.RegistryType.ZK, ClusterRoleRecord.RegistryType.MASTER, ClusterRoleRecord.RegistryType.RPC, null);
    }

    @Test
    public void testClusterUnavailableNormalConnection() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster2(), () -> {
            CLUSTERS.logClustersStates();
            try (Connection conn = CLUSTERS.getCluster1Connection(this.haGroup);){
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, null);
            }
        });
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneHBaseDown(CLUSTERS.getHBaseCluster1(), () -> {
            CLUSTERS.logClustersStates();
            try (Connection conn = CLUSTERS.getCluster2Connection(this.haGroup);){
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, null);
            }
        });
    }

    @Test
    public void testClusterReplication() throws Exception {
        try (Connection conn = CLUSTERS.getClusterConnection(0, this.haGroup);){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, null);
        }
        CLUSTERS.checkReplicationComplete();
        conn = CLUSTERS.getClusterConnection(1, this.haGroup);
        var2_2 = null;
        try (Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery(String.format("SELECT * FROM %s", this.tableName));){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testGetNewCQSShouldFail() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            try {
                Properties properties = HighAvailabilityTestingUtility.getHATestProperties();
                properties.setProperty("phoenix.ha.group.name", this.testName.getMethodName());
                ConnectionQueryServices cqs = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), properties);
                Assert.fail((String)("Should have failed since the target cluster is down, but got a CQS: " + cqs));
            }
            catch (Exception e) {
                LOG.info("Got expected exception since target cluster is down:", (Throwable)e);
            }
        });
    }
}

