/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.FailoverPhoenixConnection;
import org.apache.phoenix.jdbc.HAURLInfo;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.ParallelPhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class HighAvailabilityGroupTestIT {
    private static final Logger LOG = LoggerFactory.getLogger(HighAvailabilityGroupTestIT.class);
    private static final String ZK1 = "zk1-1\\:2181,zk1-2\\:2181::/hbase";
    private static final String ZK2 = "zk2-1\\:2181,zk2-2\\:2181::/hbase";
    private static final String DUMMY_URL = "jdbc:phoenix:dummyhost";
    private static final PhoenixEmbeddedDriver DRIVER = (PhoenixEmbeddedDriver)Mockito.mock(PhoenixEmbeddedDriver.class);
    private final Properties clientProperties = new Properties();
    private final ClusterRoleRecord record = (ClusterRoleRecord)Mockito.mock(ClusterRoleRecord.class);
    private HighAvailabilityGroup haGroup;
    private HAURLInfo haURLInfo;
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final Timeout globalTimeout = new Timeout(300L, TimeUnit.SECONDS);

    @BeforeClass
    public static void setupBeforeClass() throws SQLException {
        PhoenixConnection connection = (PhoenixConnection)Mockito.mock(PhoenixConnection.class);
        Mockito.when((Object)connection.getURL()).thenReturn((Object)ZK1);
        ConnectionQueryServices cqs = (ConnectionQueryServices)Mockito.mock(ConnectionQueryServicesImpl.class);
        Mockito.when((Object)cqs.connect(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.any(Properties.class))).thenReturn((Object)connection);
        Mockito.when((Object)DRIVER.acceptsURL(ArgumentMatchers.startsWith((String)"jdbc:phoenix"))).thenReturn((Object)true);
        Mockito.when((Object)DRIVER.getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.any(Properties.class))).thenReturn((Object)cqs);
        DriverManager.registerDriver((Driver)DRIVER);
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @Before
    public void init() {
        String haGroupName = this.testName.getMethodName();
        Mockito.when((Object)this.record.getPolicy()).thenReturn((Object)HighAvailabilityPolicy.FAILOVER);
        Mockito.when((Object)this.record.getHaGroupName()).thenReturn((Object)haGroupName);
        Mockito.when((Object)this.record.getRegistryType()).thenReturn((Object)ClusterRoleRecord.RegistryType.ZK);
        Mockito.when((Object)this.record.getActiveUrl()).thenReturn(Optional.of(ZK1));
        Mockito.when((Object)this.record.getUrl1()).thenReturn((Object)ZK1);
        Mockito.when((Object)this.record.getUrl2()).thenReturn((Object)ZK2);
        Mockito.when((Object)this.record.getRole((String)ArgumentMatchers.eq((Object)ZK1))).thenReturn((Object)ClusterRoleRecord.ClusterRole.ACTIVE);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName);
        HighAvailabilityGroup.HAGroupInfo haGroupInfo = new HighAvailabilityGroup.HAGroupInfo(haGroupName, ZK1, ZK2);
        this.haGroup = (HighAvailabilityGroup)Mockito.spy((Object)new HighAvailabilityGroup(haGroupInfo, this.clientProperties, this.record, HighAvailabilityGroup.State.READY));
        this.haURLInfo = (HAURLInfo)Mockito.spy((Object)new HAURLInfo(haGroupName));
    }

    @Test
    public void testConnect() throws SQLException {
        Connection conn = this.haGroup.connect(this.clientProperties, this.haURLInfo);
        Assert.assertTrue((boolean)(conn instanceof FailoverPhoenixConnection));
        FailoverPhoenixConnection failoverConnection = conn.unwrap(FailoverPhoenixConnection.class);
        Assert.assertNotNull((Object)failoverConnection);
        ((HighAvailabilityGroup)Mockito.verify((Object)this.haGroup, (VerificationMode)Mockito.times((int)1))).connectActive((Properties)ArgumentMatchers.any(Properties.class), (HAURLInfo)ArgumentMatchers.any(HAURLInfo.class));
        ((HighAvailabilityGroup)Mockito.verify((Object)this.haGroup, (VerificationMode)Mockito.times((int)1))).connectToOneCluster(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)this.clientProperties), (HAURLInfo)ArgumentMatchers.any(HAURLInfo.class));
        ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.atLeastOnce())).getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)this.clientProperties));
        Mockito.when((Object)this.record.getPolicy()).thenReturn((Object)HighAvailabilityPolicy.PARALLEL);
        Connection conn2 = this.haGroup.connect(this.clientProperties, this.haURLInfo);
        Assert.assertTrue((boolean)(conn2 instanceof ParallelPhoenixConnection));
    }

    @Test
    public void testConnectShouldFailWhenNotReady() throws SQLException {
        HighAvailabilityGroup.HAGroupInfo info = this.haGroup.getGroupInfo();
        this.haGroup = (HighAvailabilityGroup)Mockito.spy((Object)new HighAvailabilityGroup(info, this.clientProperties, this.record, HighAvailabilityGroup.State.UNINITIALIZED));
        try {
            this.haGroup.connect(this.clientProperties, this.haURLInfo);
            Assert.fail((String)"Should have failed since HA group is not READY!");
        }
        catch (SQLException e) {
            LOG.info("Got expected exception", (Throwable)e);
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION.getErrorCode(), (long)e.getErrorCode());
            ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.never())).getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)this.clientProperties));
        }
    }

    @Test
    public void testConnectToOneCluster() throws SQLException {
        String jdbcString = String.format("jdbc:phoenix:%s", ZK1);
        this.haGroup.connectToOneCluster(jdbcString, this.clientProperties, this.haURLInfo);
        ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.times((int)1))).getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)this.clientProperties));
        this.haGroup.connectToOneCluster(ZK1, this.clientProperties, this.haURLInfo);
        ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.times((int)2))).getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)this.clientProperties));
    }

    @Test
    public void testConnectToOneClusterShouldFailIfNotConnectable() throws SQLException {
        Mockito.when((Object)this.record.getRole((String)ArgumentMatchers.eq((Object)ZK1))).thenReturn((Object)ClusterRoleRecord.ClusterRole.UNKNOWN);
        String jdbcString = String.format("jdbc:phoenix:%s", ZK1);
        try {
            this.haGroup.connectToOneCluster(jdbcString, this.clientProperties, this.haURLInfo);
            Assert.fail((String)"Should have failed because cluster is in UNKNOWN role");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.HA_CLUSTER_CAN_NOT_CONNECT.getErrorCode(), (long)e.getErrorCode());
        }
        ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.never())).getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)this.clientProperties));
        Mockito.when((Object)this.record.getRole((String)ArgumentMatchers.eq((Object)ZK1))).thenReturn((Object)ClusterRoleRecord.ClusterRole.OFFLINE);
        try {
            this.haGroup.connectToOneCluster(jdbcString, this.clientProperties, this.haURLInfo);
            Assert.fail((String)"Should have failed because cluster is in OFFLINE role");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.HA_CLUSTER_CAN_NOT_CONNECT.getErrorCode(), (long)e.getErrorCode());
        }
        ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.never())).getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)this.clientProperties));
    }

    @Test
    public void testConnectToOneClusterShouldFailWithNonHAJdbcString() throws SQLException {
        String jdbcString = DUMMY_URL;
        Mockito.when((Object)this.record.getRole((String)ArgumentMatchers.eq((Object)"dummyhost\\:2181::/hbase"))).thenReturn((Object)ClusterRoleRecord.ClusterRole.UNKNOWN);
        try {
            this.haGroup.connectToOneCluster(DUMMY_URL, this.clientProperties, this.haURLInfo);
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.HA_CLUSTER_CAN_NOT_CONNECT.getErrorCode(), (long)e.getErrorCode());
        }
        ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.never())).getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)this.clientProperties));
    }

    @Test
    public void testConnectToOneClusterShouldNotFailWithDifferentHostOrderJdbcString() throws SQLException {
        String hosts = "zk1-2,zk1-1:2181:/hbase";
        String jdbcString = String.format("jdbc:phoenix+zk:%s", "zk1-2,zk1-1:2181:/hbase");
        this.haGroup.connectToOneCluster(jdbcString, this.clientProperties, this.haURLInfo);
        ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.times((int)1))).getConnectionQueryServices((String)ArgumentMatchers.eq((Object)String.format("jdbc:phoenix+zk:%s", ZK1)), (Properties)ArgumentMatchers.eq((Object)this.clientProperties));
    }

    @Test
    public void testGetShouldFailWithoutHAGroupName() throws SQLException {
        String jdbcString = String.format("jdbc:phoenix:[%s|%s]", ZK1, ZK2);
        Properties properties = new Properties();
        try {
            HighAvailabilityGroup.get((String)jdbcString, (Properties)properties);
            Assert.fail((String)"Should have fail because the HA group name is not set");
        }
        catch (SQLException e) {
            LOG.info("Got expected exception when HA group name is empty", (Throwable)e);
            Assert.assertEquals((long)SQLExceptionCode.HA_INVALID_PROPERTIES.getErrorCode(), (long)e.getErrorCode());
        }
        ((PhoenixEmbeddedDriver)Mockito.verify((Object)DRIVER, (VerificationMode)Mockito.never())).getConnectionQueryServices(ArgumentMatchers.anyString(), (Properties)ArgumentMatchers.eq((Object)properties));
    }

    @Test
    public void testIsConnectionActive() throws SQLException {
        Assert.assertFalse((boolean)this.haGroup.isActive(null));
        PhoenixConnection connection = this.haGroup.connectToOneCluster(ZK1, this.clientProperties, this.haURLInfo);
        Assert.assertTrue((boolean)this.haGroup.isActive(connection));
    }

    @Test
    public void testNegativeCacheWhenMissingClusterRoleRecords() throws Exception {
        String haGroupName2 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        HighAvailabilityGroup.HAGroupInfo haGroupInfo2 = new HighAvailabilityGroup.HAGroupInfo(haGroupName2, ZK1, ZK2);
        HighAvailabilityGroup haGroup2 = (HighAvailabilityGroup)Mockito.spy((Object)new HighAvailabilityGroup(haGroupInfo2, this.clientProperties, null, HighAvailabilityGroup.State.READY));
        ((HighAvailabilityGroup)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Mocked Exception when init HA group 2")}).when((Object)haGroup2)).init();
        HighAvailabilityGroup.GROUPS.put(haGroupInfo2, haGroup2);
        String jdbcString = String.format("jdbc:phoenix:[%s|%s]", ZK1, ZK2);
        try {
            HighAvailabilityGroup.get((String)jdbcString, (Properties)this.clientProperties);
            Assert.fail((String)"Should have fail because the HA group fails to init and ZK is not connectable");
        }
        catch (SQLException sQLException) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected Exception" + e.toString()));
        }
        CuratorFramework curator = (CuratorFramework)Mockito.mock(CuratorFramework.class);
        Mockito.when((Object)curator.blockUntilConnected(ArgumentMatchers.anyInt(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenReturn((Object)true);
        HighAvailabilityGroup.CURATOR_CACHE.put((Object)ZK2, (Object)curator);
        HighAvailabilityGroup.CURATOR_CACHE.put((Object)ZK1, (Object)curator);
        ExistsBuilder eb = (ExistsBuilder)Mockito.mock(ExistsBuilder.class);
        Mockito.when((Object)eb.forPath(ArgumentMatchers.anyString())).thenReturn(null);
        Mockito.when((Object)curator.checkExists()).thenReturn((Object)eb);
        for (int i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)HighAvailabilityGroup.get((String)jdbcString, (Properties)this.clientProperties).isPresent());
        }
        ((HighAvailabilityGroup)Mockito.verify((Object)haGroup2, (VerificationMode)Mockito.times((int)1))).init();
    }
}

