/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HAGroupStoreManager;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.PhoenixHAAdmin;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class HAGroupStoreManagerIT
extends BaseTest {
    private final PhoenixHAAdmin haAdmin = new PhoenixHAAdmin(config);
    private static final Long ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS = 1000L;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.cluster.role.based.mutation.block.enabled", "true");
        HAGroupStoreManagerIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void before() throws Exception {
        List crrs = this.haAdmin.listAllClusterRoleRecordsOnZookeeper();
        for (ClusterRoleRecord crr : crrs) {
            this.haAdmin.getCurator().delete().forPath(PhoenixHAAdmin.toPath((String)crr.getHaGroupName()));
        }
    }

    @Test
    public void testHAGroupStoreManagerWithSingleCRR() throws Exception {
        HAGroupStoreManager haGroupStoreManager = HAGroupStoreManager.getInstance((Configuration)config);
        ClusterRoleRecord crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        ClusterRoleRecord crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        Assert.assertFalse((boolean)haGroupStoreManager.isMutationBlocked());
        crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreManager.isMutationBlocked());
    }
}

