/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.HAGroupStoreClient;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.PhoenixHAAdmin;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class HAGroupStoreClientIT
extends BaseTest {
    private final PhoenixHAAdmin haAdmin = new PhoenixHAAdmin(config);
    private static final Long ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS = 5000L;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        HAGroupStoreClientIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Before
    public void before() throws Exception {
        List crrs = this.haAdmin.listAllClusterRoleRecordsOnZookeeper();
        for (ClusterRoleRecord crr : crrs) {
            this.haAdmin.getCurator().delete().forPath(PhoenixHAAdmin.toPath((String)crr.getHaGroupName()));
        }
    }

    @Test
    public void testHAGroupStoreClientWithSingleCRR() throws Exception {
        HAGroupStoreClient haGroupStoreClient = HAGroupStoreClient.getInstance((Configuration)config);
        ClusterRoleRecord crr = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty());
        crr = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).isEmpty());
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).size() == 1);
        crr = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 3L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty());
        crr = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 4L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).isEmpty());
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).size() == 1);
        crr = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, 5L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty());
    }

    @Test
    public void testHAGroupStoreClientWithMultipleCRRs() throws Exception {
        HAGroupStoreClient haGroupStoreClient = HAGroupStoreClient.getInstance((Configuration)config);
        ClusterRoleRecord crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        ClusterRoleRecord crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 2);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty());
        crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).size() == 1);
        crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 3L);
        crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 3L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 2);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty());
        crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 4L);
        crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 4L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).size() == 1);
        crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, 5L);
        crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, 5L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 2);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty());
    }

    @Test
    public void testMultiThreadedAccessToHACache() throws Exception {
        HAGroupStoreClient haGroupStoreClient = HAGroupStoreClient.getInstance((Configuration)config);
        ClusterRoleRecord crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        ClusterRoleRecord crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        int threadCount = 10;
        CountDownLatch latch = new CountDownLatch(threadCount);
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            executor.submit(() -> {
                try {
                    assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 2);
                    assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty());
                    latch.countDown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        assert (latch.await(10L, TimeUnit.SECONDS));
        crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        CountDownLatch latch2 = new CountDownLatch(threadCount);
        executor = Executors.newFixedThreadPool(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            executor.submit(() -> {
                try {
                    assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
                    assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).size() == 1);
                    latch2.countDown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        assert (latch2.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testHAGroupStoreClientWithRootPathDeletion() throws Exception {
        HAGroupStoreClient haGroupStoreClient = HAGroupStoreClient.getInstance((Configuration)config);
        ClusterRoleRecord crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        ClusterRoleRecord crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).size() == 1);
        this.haAdmin.getCurator().delete().deletingChildrenIfNeeded().forPath("/");
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).isEmpty());
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).isEmpty());
        crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 2L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).size() == 1);
    }

    @Test
    public void testThrowsExceptionWithZKDisconnectionAndThenConnection() throws Exception {
        HAGroupStoreClient haGroupStoreClient = HAGroupStoreClient.getInstance((Configuration)config);
        ClusterRoleRecord crr1 = new ClusterRoleRecord("failover", HighAvailabilityPolicy.FAILOVER, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        ClusterRoleRecord crr2 = new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 2);
        utility.shutdownMiniZKCluster();
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        Assert.assertThrows(IOException.class, () -> haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE));
        utility.startMiniZKCluster(1, new int[]{Integer.parseInt(HAGroupStoreClientIT.getZKClientPort(config))});
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 2);
    }

    @Test
    public void testHAGroupStoreClientWithDifferentZKURLFormats() throws Exception {
        HAGroupStoreClient haGroupStoreClient = HAGroupStoreClient.getInstance((Configuration)config);
        String zkClientPort = HAGroupStoreClientIT.getZKClientPort(config);
        String format1 = "127.0.0.1\\:" + zkClientPort + "::/hbase";
        String format2 = "127.0.0.1:" + zkClientPort + "::/hbase";
        String format3 = "127.0.0.1\\:" + zkClientPort + ":/hbase";
        ClusterRoleRecord crr1 = new ClusterRoleRecord("parallel1", HighAvailabilityPolicy.PARALLEL, format1, ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr1);
        ClusterRoleRecord crr2 = new ClusterRoleRecord("parallel2", HighAvailabilityPolicy.PARALLEL, format2, ClusterRoleRecord.ClusterRole.STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr2);
        ClusterRoleRecord crr3 = new ClusterRoleRecord("parallel3", HighAvailabilityPolicy.PARALLEL, format3, ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, 1L);
        this.haAdmin.createOrUpdateDataOnZookeeper(crr3);
        Thread.sleep(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY).size() == 1);
        assert (haGroupStoreClient.getCRRsByClusterRole(ClusterRoleRecord.ClusterRole.STANDBY).size() == 1);
    }

    @Test
    public void testHAGroupStoreClientWithMultiThreadedUpdates() throws Exception {
        int i;
        int threadCount = 5;
        ArrayList crrEventVersions = new ArrayList();
        CountDownLatch eventsLatch = new CountDownLatch(threadCount);
        PathChildrenCacheListener pathChildrenCacheListener = (client, event) -> {
            if (event.getData() != null && event.getData().getData() != null && ClusterRoleRecord.fromJson((byte[])event.getData().getData()).isPresent()) {
                ClusterRoleRecord crr = (ClusterRoleRecord)ClusterRoleRecord.fromJson((byte[])event.getData().getData()).get();
                crrEventVersions.add((int)crr.getVersion());
                eventsLatch.countDown();
            }
        };
        new HAGroupStoreClient(config, pathChildrenCacheListener);
        CountDownLatch updateLatch = new CountDownLatch(threadCount);
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        ArrayList<Integer> updateList = new ArrayList<Integer>();
        ConcurrentLinkedQueue<ClusterRoleRecord> updateQueue = new ConcurrentLinkedQueue<ClusterRoleRecord>();
        for (i = 0; i < threadCount; ++i) {
            updateQueue.add(this.createCRR(i + 1));
            updateList.add(i + 1);
        }
        for (i = 0; i < threadCount; ++i) {
            executor.submit(() -> {
                try {
                    Class<HAGroupStoreClientIT> clazz = HAGroupStoreClientIT.class;
                    synchronized (HAGroupStoreClientIT.class) {
                        this.haAdmin.createOrUpdateDataOnZookeeper((ClusterRoleRecord)Objects.requireNonNull(updateQueue.poll()));
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        updateLatch.countDown();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        assert (eventsLatch.await(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS * (long)threadCount, TimeUnit.MILLISECONDS));
        assert (updateLatch.await(ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS * (long)threadCount, TimeUnit.MILLISECONDS));
        assert (updateList.equals(crrEventVersions));
    }

    private ClusterRoleRecord createCRR(Integer version) {
        return new ClusterRoleRecord("parallel", HighAvailabilityPolicy.PARALLEL, this.haAdmin.getZkUrl(), ClusterRoleRecord.ClusterRole.ACTIVE, "random-zk-url", ClusterRoleRecord.ClusterRole.STANDBY, (long)version.intValue());
    }
}

