/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.FailoverSQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.FailoverPhoenixConnection;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.util.PhoenixRuntime;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class FailoverPhoenixConnectionIT {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverPhoenixConnectionIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    @Rule
    public final TestName testName = new TestName();
    private Properties clientProperties;
    private HighAvailabilityGroup haGroup;
    private String tableName;
    private String haGroupName;
    private final ClusterRoleRecord.RegistryType registryType = ClusterRoleRecord.RegistryType.ZK;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        this.haGroupName = this.testName.getMethodName();
        this.clientProperties = HighAvailabilityTestingUtility.getHATestProperties();
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroupName);
        this.clientProperties.setProperty("phoenix.cqsi.thread.pool.enabled", String.valueOf(true));
        this.clientProperties.setProperty("phoenix.cqsi.thread.pool.keepalive.seconds", String.valueOf(13));
        this.clientProperties.setProperty("phoenix.cqsi.thread.pool.core.size", String.valueOf(17));
        this.clientProperties.setProperty("phoenix.cqsi.thread.pool.max.threads", String.valueOf(19));
        this.clientProperties.setProperty("phoenix.cqsi.thread.pool.max.queue", String.valueOf(23));
        this.clientProperties.setProperty("phoenix.cqsi.thread.pool.allow.core.thread.timeout", String.valueOf(true));
        CLUSTERS.initClusterRole(this.haGroupName, HighAvailabilityPolicy.FAILOVER);
        this.haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(CLUSTERS.getJdbcHAUrl(), this.clientProperties);
        LOG.info("Initialized haGroup {} with URL {}", (Object)this.haGroup, (Object)CLUSTERS.getJdbcHAUrl());
        this.tableName = this.testName.getMethodName().toUpperCase();
        CLUSTERS.createTableOnClusterPair(this.haGroup, this.tableName);
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.haGroup.close();
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.haGroup.getProperties()).close();
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl2(this.haGroup), this.haGroup.getProperties()).close();
        }
        catch (Exception e) {
            LOG.error("Fail to tear down the HA group and the CQS. Will ignore", (Throwable)e);
        }
    }

    @Test
    public void testCQSIThreadPoolCreation() throws Exception {
        try (Connection conn = this.createFailoverConnection();){
            FailoverPhoenixConnection failoverConn = conn.unwrap(FailoverPhoenixConnection.class);
            ConnectionQueryServices cqsi = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
            ConnectionQueryServices cqsiFromConn = failoverConn.getWrappedConnection().getQueryServices();
            Assert.assertSame((Object)BaseTest.extractThreadPoolExecutorFromCQSI(cqsi), (Object)BaseTest.extractThreadPoolExecutorFromCQSI(cqsiFromConn));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test(timeout=300000L)
    public void testOperationUsingConnection() throws Exception {
        try (Connection conn = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
    }

    @Test(timeout=300000L)
    public void testCloseConnectionOnceMore() throws Exception {
        Connection conn = this.createFailoverConnection();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        conn.close();
        conn.close();
    }

    @Test(timeout=300000L)
    public void testConnectionCreationFailsIfNoActiveCluster() throws Exception {
        try (Connection conn = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.STANDBY);
        try {
            this.createFailoverConnection();
            Assert.fail((String)"Should have failed because neither cluster is ACTIVE");
        }
        catch (SQLException e) {
            LOG.info("Got expected exception when creating new connection", (Throwable)e);
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test(timeout=300000L)
    public void testConnectionOneOfflineOneActive() throws Exception {
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.OFFLINE, ClusterRoleRecord.ClusterRole.ACTIVE);
        try (Connection conn = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
    }

    @Test(timeout=300000L)
    public void testConnectionCreationFailsIfBothClustersOffline() throws Exception {
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.OFFLINE, ClusterRoleRecord.ClusterRole.OFFLINE);
        try {
            this.createFailoverConnection();
            Assert.fail((String)"Should have failed because both clusters are OFFLINE");
        }
        catch (SQLException e) {
            LOG.info("Got expected exception when creating new connection", (Throwable)e);
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_ESTABLISH_CONNECTION.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test(timeout=300000L)
    public void testWrappedConnectionClosedAfterStandby() throws Exception {
        Connection conn = this.createFailoverConnection();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        PhoenixConnection pc = ((FailoverPhoenixConnection)conn).getWrappedConnection();
        Assert.assertNotNull((Object)pc);
        Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(this.haGroup), (Object)pc.getURL());
        Assert.assertTrue((boolean)pc.isClosed());
        FailoverPhoenixConnectionIT.doTestActionShouldFailBecauseOfFailover(conn::createStatement);
    }

    @Test(timeout=300000L)
    public void testStatementClosedAfterStandby() throws Exception {
        Connection conn = this.createFailoverConnection();
        Statement stmt = conn.createStatement();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithStatement(conn, stmt, this.tableName);
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        Assert.assertFalse((boolean)conn.isClosed());
        Assert.assertTrue((boolean)stmt.isClosed());
        FailoverPhoenixConnectionIT.doTestActionShouldFailBecauseOfFailover(() -> stmt.executeQuery("SELECT * FROM " + this.tableName));
    }

    @Test(timeout=300000L)
    public void testNonHAConnectionNotClosedAfterFailover() throws Exception {
        String firstUrl = String.format("jdbc:phoenix+zk:%s", CLUSTERS.getZkUrl1());
        Connection phoenixConn = DriverManager.getConnection(firstUrl, new Properties());
        Connection failoverConn = this.createFailoverConnection();
        PhoenixConnection wrappedConn = ((FailoverPhoenixConnection)failoverConn).getWrappedConnection();
        Assert.assertFalse((boolean)phoenixConn.isClosed());
        Assert.assertFalse((boolean)failoverConn.isClosed());
        Assert.assertFalse((boolean)wrappedConn.isClosed());
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        Assert.assertFalse((boolean)phoenixConn.isClosed());
        Assert.assertFalse((boolean)failoverConn.isClosed());
        Assert.assertTrue((boolean)wrappedConn.isClosed());
    }

    @Test(timeout=300000L)
    public void testOtherHAGroupConnectionUnchanged() throws Exception {
        Connection conn = this.createFailoverConnection();
        PhoenixConnection wrappedConn = ((FailoverPhoenixConnection)conn).getWrappedConnection();
        String haGroupName2 = this.haGroup.getGroupInfo().getName() + "2";
        this.initClusterRoleRecord(haGroupName2);
        Properties clientProperties2 = new Properties(this.clientProperties);
        clientProperties2.setProperty("phoenix.ha.group.name", haGroupName2);
        Connection conn2 = DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(), clientProperties2);
        PhoenixConnection wrappedConn2 = ((FailoverPhoenixConnection)conn2).getWrappedConnection();
        Assert.assertFalse((boolean)wrappedConn.isClosed());
        Assert.assertFalse((boolean)wrappedConn2.isClosed());
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        Assert.assertTrue((boolean)wrappedConn.isClosed());
        Assert.assertFalse((boolean)wrappedConn2.isClosed());
    }

    @Test(timeout=300000L)
    public void testFailoverCanFinishWhenOneConnectionGotStuckClosing() throws Exception {
        Connection conn = this.createFailoverConnection();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(this.haGroup), (Object)conn.unwrap(FailoverPhoenixConnection.class).getWrappedConnection().getURL());
        PhoenixConnection wrapped = conn.unwrap(FailoverPhoenixConnection.class).getWrappedConnection();
        Connection spy = (Connection)Mockito.spy((Object)wrapped);
        CountDownLatch latch = new CountDownLatch(1);
        ((Connection)Mockito.doAnswer(invocation -> {
            latch.await();
            invocation.callRealMethod();
            return null;
        }).when((Object)spy)).close();
        ConnectionQueryServices cqs = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
        cqs.removeConnection(wrapped.unwrap(PhoenixConnection.class));
        cqs.addConnection(spy.unwrap(PhoenixConnection.class));
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        ((Connection)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).close();
        Assert.assertFalse((boolean)spy.isClosed());
        Assert.assertFalse((boolean)conn.isClosed());
        try (Connection conn2 = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn2, this.tableName, this.haGroupName);
            Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.haGroup), (Object)conn2.unwrap(FailoverPhoenixConnection.class).getWrappedConnection().getURL());
        }
        latch.countDown();
        conn.close();
        GenericTestUtils.waitFor(() -> {
            try {
                ((ConnectionQueryServicesImpl)cqs).checkClosed();
                return false;
            }
            catch (IllegalStateException e) {
                LOG.info("CQS got closed as we get expected exception.", (Throwable)e);
                return true;
            }
        }, (long)100L, (long)10000L);
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterStandby() throws Exception {
        short i;
        short numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.createFailoverConnection());
        }
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        for (i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterStandbyAsync() throws Exception {
        int numberOfThreads = 10;
        CountDownLatch latchToTransitRole = new CountDownLatch(numberOfThreads / 2);
        CountDownLatch latchToCreateMoreConnections = new CountDownLatch(1);
        ExecutorService executor = Executors.newFixedThreadPool(numberOfThreads);
        ArrayList<Future<Connection>> connections = new ArrayList<Future<Connection>>(numberOfThreads);
        for (int i = 0; i < numberOfThreads; i = (int)((short)(i + 1))) {
            Future<Connection> future = executor.submit(() -> {
                if (latchToTransitRole.getCount() <= 0L) {
                    latchToCreateMoreConnections.await();
                }
                Connection conn = this.createFailoverConnection();
                latchToTransitRole.countDown();
                return conn;
            });
            connections.add(future);
        }
        latchToTransitRole.await();
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.STANDBY);
        latchToCreateMoreConnections.countDown();
        GenericTestUtils.waitFor(() -> {
            for (Future future : connections) {
                if (!future.isDone()) {
                    return false;
                }
                try {
                    Connection conn = (Connection)future.get(100L, TimeUnit.MILLISECONDS);
                    FailoverPhoenixConnection failoverConn = (FailoverPhoenixConnection)conn;
                    if (failoverConn.getWrappedConnection().isClosed()) continue;
                    return false;
                }
                catch (Exception e) {
                    LOG.info("Got exception when getting client connection; ignored", (Throwable)e);
                }
            }
            return true;
        }, (long)100L, (long)60000L);
    }

    @Test(timeout=300000L)
    public void testNewPhoenixConnectionAfterFailover() throws Exception {
        try (Connection conn = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        conn = this.createFailoverConnection();
        var2_2 = null;
        try {
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test(timeout=300000L)
    public void testFailoverTwice() throws Exception {
        try (Connection conn = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(this.haGroup), (Object)conn.unwrap(FailoverPhoenixConnection.class).getWrappedConnection().getURL());
        }
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        conn = this.createFailoverConnection();
        var2_2 = null;
        try {
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.haGroup), (Object)conn.unwrap(FailoverPhoenixConnection.class).getWrappedConnection().getURL());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        conn = this.createFailoverConnection();
        var2_2 = null;
        try {
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(this.haGroup), (Object)conn.unwrap(FailoverPhoenixConnection.class).getWrappedConnection().getURL());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test(timeout=300000L)
    public void testFailoverConnectionExplicitly() throws Exception {
        Connection conn = this.createFailoverConnection();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        FailoverPhoenixConnectionIT.doTestActionShouldFailBecauseOfFailover(conn::createStatement);
        FailoverPhoenixConnection.failover((Connection)conn, (long)30000L);
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        FailoverPhoenixConnection.failover((Connection)conn, (long)30000L);
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
    }

    @Test(timeout=300000L)
    public void testFailoverConnectionExplicitlyTimeout() throws Exception {
        Connection conn = this.createFailoverConnection();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.STANDBY);
        try {
            FailoverPhoenixConnection.failover((Connection)conn, (long)10000L);
            Assert.fail((String)"Should have failed since two clusters are both in STANDBY role");
        }
        catch (FailoverSQLException e) {
            LOG.info("Got expected exception when failover explicitly", (Throwable)e);
        }
    }

    @Test(timeout=300000L)
    public void testTenantSpecificPhoenixConnection() throws Exception {
        this.tableName = this.tableName + "Tenant";
        CLUSTERS.createTenantSpecificTable(this.haGroup, this.tableName);
        this.clientProperties.setProperty("TenantId", "mytenant");
        Connection tenantConn = this.createFailoverConnection();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(tenantConn, this.tableName, this.haGroupName);
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        FailoverPhoenixConnectionIT.doTestActionShouldFailBecauseOfFailover(tenantConn::createStatement);
        try (Connection newTenantConn = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(newTenantConn, this.tableName, this.haGroupName);
        }
    }

    @Test(timeout=300000L)
    public void testStatementWithActiveFailoverPolicy() throws Exception {
        this.clientProperties.setProperty("phoenix.ha.failover.policy", "active");
        Connection conn = this.createFailoverConnection();
        Statement stmt1 = conn.createStatement();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithStatement(conn, stmt1, this.tableName);
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        Assert.assertFalse((boolean)conn.isClosed());
        Assert.assertTrue((boolean)stmt1.isClosed());
        Statement stmt2 = conn.createStatement();
        HighAvailabilityTestingUtility.doTestBasicOperationsWithStatement(conn, stmt2, this.tableName);
    }

    @Test(timeout=300000L)
    public void testFailoverMetrics() throws Exception {
        Connection conn = this.createFailoverConnection();
        PhoenixRuntime.resetMetrics((Connection)conn);
        Assert.assertTrue((boolean)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).isEmpty());
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        this.doVerifyMetrics(conn, 1L);
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        this.doVerifyMetrics(conn, 1L);
        FailoverPhoenixConnection.failover((Connection)conn, (long)30000L);
        this.doVerifyMetrics(conn, 1L);
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        this.doVerifyMetrics(conn, 2L);
        PhoenixRuntime.resetMetrics((Connection)conn);
        Assert.assertTrue((boolean)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).isEmpty());
        HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        this.doVerifyMetrics(conn, 1L);
        conn.close();
        Assert.assertTrue((boolean)PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn).isEmpty());
    }

    @Test(timeout=300000L)
    public void testAllConnectionsOfHAIsAffected() throws Exception {
        Connection conn = this.createFailoverConnection();
        PhoenixConnection wrappedConn = ((FailoverPhoenixConnection)conn).getWrappedConnection();
        String principal = RandomStringUtils.randomAlphabetic((int)5);
        Connection conn2 = DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(principal), this.clientProperties);
        PhoenixConnection wrappedConn2 = ((FailoverPhoenixConnection)conn2).getWrappedConnection();
        String haGroupName2 = this.haGroup.getGroupInfo().getName() + "2";
        this.initClusterRoleRecord(haGroupName2);
        Properties clientProperties2 = new Properties(this.clientProperties);
        clientProperties2.setProperty("phoenix.ha.group.name", haGroupName2);
        Connection conn3 = DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(), clientProperties2);
        PhoenixConnection wrappedConn3 = ((FailoverPhoenixConnection)conn3).getWrappedConnection();
        Connection conn4 = DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(principal), clientProperties2);
        PhoenixConnection wrappedConn4 = ((FailoverPhoenixConnection)conn4).getWrappedConnection();
        Assert.assertFalse((boolean)wrappedConn.isClosed());
        Assert.assertFalse((boolean)wrappedConn2.isClosed());
        Assert.assertFalse((boolean)wrappedConn3.isClosed());
        Assert.assertFalse((boolean)wrappedConn4.isClosed());
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        Assert.assertTrue((boolean)wrappedConn.isClosed());
        Assert.assertTrue((boolean)wrappedConn2.isClosed());
        Assert.assertFalse((boolean)wrappedConn3.isClosed());
        Assert.assertFalse((boolean)wrappedConn4.isClosed());
    }

    @Test(timeout=300000L)
    public void testUserPrincipal() throws Exception {
        Connection conn = this.createFailoverConnection();
        FailoverPhoenixConnection fconn = (FailoverPhoenixConnection)conn;
        ConnectionQueryServices cqsi = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
        String haGroupName2 = this.testName.getMethodName() + RandomStringUtils.randomAlphabetic((int)3);
        this.initClusterRoleRecord(haGroupName2);
        this.clientProperties.setProperty("phoenix.ha.group.name", haGroupName2);
        HighAvailabilityGroup haGroup2 = HighAvailabilityTestingUtility.getHighAvailibilityGroup(CLUSTERS.getJdbcHAUrl(), this.clientProperties);
        Connection conn2 = DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(), this.clientProperties);
        FailoverPhoenixConnection fconn2 = (FailoverPhoenixConnection)conn2;
        ConnectionQueryServices cqsi2 = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(haGroup2), this.clientProperties);
        Connection conn3 = DriverManager.getConnection(CLUSTERS.getJdbcHAUrlWithoutPrincipal(), this.clientProperties);
        FailoverPhoenixConnection fconn3 = (FailoverPhoenixConnection)conn3;
        ConnectionQueryServices cqsi3 = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrlWithoutPrincipal(haGroup2, CLUSTERS.getURL(1, haGroup2.getRoleRecord().getRegistryType())), this.clientProperties);
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroupName);
        String principal4 = RandomStringUtils.randomAlphabetic((int)5);
        Connection conn4 = DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(principal4), this.clientProperties);
        FailoverPhoenixConnection fconn4 = (FailoverPhoenixConnection)conn4;
        ConnectionQueryServices cqsi4 = PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup, principal4), this.clientProperties);
        Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(this.haGroup), (Object)fconn.getWrappedConnection().getURL());
        Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(haGroup2), (Object)fconn2.getWrappedConnection().getURL());
        Assert.assertEquals((Object)CLUSTERS.getJdbcUrlWithoutPrincipal(haGroup2, CLUSTERS.getURL(1, haGroup2.getRoleRecord().getRegistryType())), (Object)fconn3.getWrappedConnection().getURL());
        Assert.assertEquals((Object)CLUSTERS.getJdbcUrl1(this.haGroup, principal4), (Object)fconn4.getWrappedConnection().getURL());
        Assert.assertEquals((Object)"USER_FOO", (Object)cqsi.getUserName());
        Assert.assertSame((Object)cqsi, (Object)fconn.getWrappedConnection().getQueryServices());
        Assert.assertEquals((Object)"USER_FOO", (Object)cqsi2.getUserName());
        Assert.assertSame((Object)cqsi2, (Object)fconn2.getWrappedConnection().getQueryServices());
        Assert.assertNull((Object)cqsi3.getUserName());
        Assert.assertSame((Object)cqsi3, (Object)fconn3.getWrappedConnection().getQueryServices());
        Assert.assertEquals((Object)principal4, (Object)cqsi4.getUserName());
        Assert.assertSame((Object)cqsi4, (Object)fconn4.getWrappedConnection().getQueryServices());
    }

    @Test(timeout=300000L)
    public void testHAGroupMappingsWithDifferentPrincipalsOnDifferentThreads() throws Exception {
        int numThreads = RandomUtils.nextInt((int)3, (int)5);
        ArrayList<Thread> connectionThreads = new ArrayList<Thread>(numThreads + 4);
        for (int i = 0; i < numThreads; ++i) {
            connectionThreads.add(new Thread(() -> {
                try {
                    this.createConnectionWithRandomPrincipal(false);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }));
        }
        connectionThreads.add(new Thread(() -> {
            try {
                this.createConnectionWithRandomPrincipal(true);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }));
        String principal = RandomStringUtils.randomAlphabetic((int)3);
        int numConnectionsWithSamePrincipal = 3;
        for (int i = 0; i < numConnectionsWithSamePrincipal; ++i) {
            connectionThreads.add(new Thread(() -> {
                try {
                    DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(principal), this.clientProperties);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }));
        }
        for (Thread connectionThread : connectionThreads) {
            connectionThread.start();
        }
        for (Thread connectionThread : connectionThreads) {
            connectionThread.join();
        }
        Assert.assertEquals((long)(numThreads + 2), (long)((Set)HighAvailabilityGroup.URLS.get(this.haGroup.getGroupInfo())).size());
    }

    private void doVerifyMetrics(Connection conn, long expectedUpsert) throws SQLException {
        Map mutation = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)conn);
        Assert.assertFalse((boolean)mutation.isEmpty());
        Assert.assertTrue((boolean)mutation.containsKey(this.tableName));
        Long upsertMetric = (Long)((Map)mutation.get(this.tableName)).get(MetricType.UPSERT_MUTATION_SQL_COUNTER);
        Assert.assertEquals((long)expectedUpsert, (long)upsertMetric);
        Assert.assertTrue((boolean)PhoenixRuntime.getReadMetricInfoForMutationsSinceLastReset((Connection)conn).isEmpty());
    }

    private Connection createFailoverConnection() throws SQLException {
        return DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(), this.clientProperties);
    }

    private static void doTestActionShouldFailBecauseOfFailover(Action action) throws Exception {
        try {
            action.execute();
            Assert.fail((String)"Should have failed because the connection is closed");
        }
        catch (FailoverSQLException fe) {
            LOG.info("Got expected failover exception after connection is closed.", (Throwable)fe);
        }
        catch (SQLException e) {
            LOG.info("Will fail the test if its cause is not FailoverSQLException", (Throwable)e);
            Assert.assertTrue((boolean)(e.getCause() instanceof FailoverSQLException));
            LOG.info("Got expected failover exception after connection is closed.", (Throwable)e);
        }
    }

    private void createConnectionWithRandomPrincipal(boolean isPrincipalNull) throws SQLException {
        String principal = RandomStringUtils.randomAlphabetic((int)5);
        if (isPrincipalNull) {
            DriverManager.getConnection(CLUSTERS.getJdbcHAUrlWithoutPrincipal(), this.clientProperties);
            return;
        }
        DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(principal), this.clientProperties);
    }

    private void initClusterRoleRecord(String haGroupName) throws Exception {
        CLUSTERS.initClusterRole(haGroupName, HighAvailabilityPolicy.FAILOVER);
    }

    @FunctionalInterface
    private static interface Action {
        public void execute() throws Exception;
    }
}

