/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.FailoverPhoenixConnection;
import org.apache.phoenix.jdbc.FailoverPhoenixConnectionIT;
import org.apache.phoenix.jdbc.HighAvailabilityGroup;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.query.ConnectionQueryServicesImpl;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class FailoverPhoenixConnection2IT {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverPhoenixConnectionIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    private static final long ZK_CURATOR_EVENT_PROPAGATION_TIMEOUT_MS = 1000L;
    @Rule
    public final TestName testName = new TestName();
    private Properties clientProperties;
    private HighAvailabilityGroup haGroup;
    private String tableName;
    private String haGroupName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
        DriverManager.registerDriver((Driver)PhoenixDriver.INSTANCE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        DriverManager.deregisterDriver((Driver)PhoenixDriver.INSTANCE);
        CLUSTERS.close();
    }

    @Before
    public void setup() throws Exception {
        this.haGroupName = this.testName.getMethodName();
        this.clientProperties = HighAvailabilityTestingUtility.getHATestProperties();
        this.clientProperties.setProperty("phoenix.ha.group.name", this.haGroupName);
        CLUSTERS.initClusterRole(this.haGroupName, HighAvailabilityPolicy.FAILOVER);
        this.haGroup = HighAvailabilityTestingUtility.getHighAvailibilityGroup(CLUSTERS.getJdbcHAUrl(), this.clientProperties);
        LOG.info("Initialized haGroup {} with URL {}", (Object)this.haGroup, (Object)CLUSTERS.getJdbcHAUrl());
        this.tableName = this.testName.getMethodName().toUpperCase();
        CLUSTERS.createTableOnClusterPair(this.haGroup, this.tableName);
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.haGroup.close();
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.haGroup.getProperties()).close();
            PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl2(this.haGroup), this.haGroup.getProperties()).close();
        }
        catch (Exception e) {
            LOG.error("Fail to tear down the HA group and the CQS. Will ignore", (Throwable)e);
        }
    }

    @Test(timeout=300000L)
    public void testFailoverCanFinishWhenOneZKDown() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.OFFLINE);
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
            try (Connection conn = this.createFailoverConnection();){
                FailoverPhoenixConnection failoverConn = (FailoverPhoenixConnection)conn;
                Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.haGroup), (Object)failoverConn.getWrappedConnection().getURL());
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            }
        });
    }

    @Test(timeout=300000L)
    public void testFailoverCanFinishWhenOneZKDownWithCQS() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            try {
                this.createFailoverConnection();
                Assert.fail((String)("Should have failed since ACTIVE ZK '" + CLUSTERS.getZkUrl1() + "' is down"));
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE ZK cluster is down", (Throwable)e);
            }
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
            try (Connection conn = this.createFailoverConnection();){
                FailoverPhoenixConnection failoverConn = (FailoverPhoenixConnection)conn;
                Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.haGroup), (Object)failoverConn.getWrappedConnection().getURL());
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            }
        });
    }

    @Test(timeout=300000L)
    public void testConnectionWhenActiveZKRestarts() throws Exception {
        try (Connection conn = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            Throwable throwable;
            Connection conn;
            try {
                conn = this.createFailoverConnection();
                throwable = null;
                try {
                    HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (conn != null) {
                        if (throwable != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            conn.close();
                        }
                    }
                }
                Assert.fail((String)"Should have failed since ACTIVE ZK cluster was shutdown");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE ZK cluster is down", (Throwable)e);
            }
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
            conn = this.createFailoverConnection();
            throwable = null;
            try {
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        });
        LOG.info("Testing failover connection when both clusters are up and running");
        conn = this.createFailoverConnection();
        var2_2 = null;
        try {
            FailoverPhoenixConnection failoverConn = conn.unwrap(FailoverPhoenixConnection.class);
            Assert.assertEquals((Object)CLUSTERS.getJdbcUrl2(this.haGroup), (Object)failoverConn.getWrappedConnection().getURL());
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        LOG.info("Testing failover back to cluster1 when bot clusters are up and running");
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        conn = this.createFailoverConnection();
        var2_2 = null;
        try {
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test(timeout=300000L)
    public void testConnectionWhenStandbyZKRestarts() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster2(), () -> {
            try (Connection conn = this.createFailoverConnection();){
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            }
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
            try {
                this.createFailoverConnection();
                Assert.fail((String)"Should have failed since ACTIVE ZK cluster was shutdown");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE ZK cluster {} was shutdown", (Object)CLUSTERS.getZkUrl2(), (Object)e);
            }
        });
        try (Connection conn = this.createFailoverConnection();){
            HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
        }
    }

    @Test(timeout=300000L)
    public void testConnectionWhenTwoZKRestarts() throws Exception {
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster2(), () -> {
                try {
                    this.createFailoverConnection();
                    Assert.fail((String)"Should have failed since ACTIVE ZK cluster was shutdown");
                }
                catch (SQLException e) {
                    LOG.info("Got expected exception when both clusters are down", (Throwable)e);
                }
            });
            try {
                this.createFailoverConnection();
                Assert.fail((String)"Should have failed since ACTIVE ZK cluster was shutdown");
            }
            catch (SQLException e) {
                LOG.info("Got expected exception when ACTIVE ZK cluster {} was shutdown", (Object)CLUSTERS.getZkUrl2(), (Object)e);
            }
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
            try (Connection conn = this.createFailoverConnection();){
                HighAvailabilityTestingUtility.doTestBasicOperationsWithConnection(conn, this.tableName, this.haGroupName);
            }
        });
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterStandby() throws Exception {
        short i;
        short numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.createFailoverConnection());
        }
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        for (i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterStandbyAndZKDownAsync() throws Exception {
        int numberOfThreads = 10;
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList<Future<Connection>> connections = new ArrayList<Future<Connection>>(10);
        connections.add(executor.submit(this::createFailoverConnection));
        HighAvailabilityTestingUtility.HBaseTestingUtilityPair.doTestWhenOneZKDown(CLUSTERS.getHBaseCluster1(), () -> {
            LOG.info("Since cluster1 is down, now failing over to cluster2");
            for (int i = 1; i < 10; i = (int)((short)(i + 1))) {
                connections.add(executor.submit(this::createFailoverConnection));
            }
            CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.STANDBY, ClusterRoleRecord.ClusterRole.ACTIVE);
        });
        GenericTestUtils.waitFor(() -> {
            for (Future future : connections) {
                if (!future.isDone()) {
                    return false;
                }
                try {
                    Connection c = (Connection)future.get(100L, TimeUnit.MILLISECONDS);
                    PhoenixConnection pc = ((FailoverPhoenixConnection)c).getWrappedConnection();
                    if (pc.isClosed() || pc.getURL().equals(CLUSTERS.getZkUrl2())) continue;
                    Assert.fail((String)"Found one connection to cluster1 but it is not closed");
                }
                catch (Exception e) {
                    LOG.info("Got exception when getting client connection; ignored", (Throwable)e);
                }
            }
            return true;
        }, (long)100L, (long)120000L);
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterRegistryChangeToMaster() throws Exception {
        short numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.createFailoverConnection());
        }
        ConnectionQueryServicesImpl cqsi = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
        ConnectionInfo connInfo = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.haGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.clientProperties);
        ClusterRoleRecord.RegistryType newRegistry = ClusterRoleRecord.RegistryType.MASTER;
        CLUSTERS.transitClusterRoleRecordRegistry(this.haGroup, newRegistry);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
        }
        try {
            cqsi.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfo));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterRegistryChangeToRpc() throws Exception {
        short numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.createFailoverConnection());
        }
        ConnectionQueryServicesImpl cqsi = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
        ConnectionInfo connInfo = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.haGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.clientProperties);
        ClusterRoleRecord.RegistryType newRegistry = ClusterRoleRecord.RegistryType.RPC;
        Assume.assumeTrue((VersionInfo.compareVersion((String)VersionInfo.getVersion(), (String)"2.5.0") >= 0 ? 1 : 0) != 0);
        CLUSTERS.transitClusterRoleRecordRegistry(this.haGroup, newRegistry);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
        }
        try {
            cqsi.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfo));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedAfterActiveURLChange() throws Exception {
        short numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.createFailoverConnection());
        }
        ConnectionQueryServicesImpl cqsi = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl1(this.haGroup), this.clientProperties);
        ConnectionInfo connInfo = ConnectionInfo.create((String)CLUSTERS.getJdbcUrl1(this.haGroup), (ReadOnlyProps)PhoenixDriver.INSTANCE.getQueryServices().getProps(), (Properties)this.clientProperties);
        CLUSTERS.restartCluster1();
        CLUSTERS.refreshClusterRoleRecordAfterClusterRestart(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
            conn.close();
        }
        try {
            cqsi.checkClosed();
            Assert.fail((String)"Should have thrown an exception as cqsi should be closed");
        }
        catch (IllegalStateException e) {
            Assert.assertFalse((boolean)PhoenixDriver.INSTANCE.checkIfCQSIIsInCache(connInfo));
        }
        catch (Exception e) {
            Assert.fail((String)"Should have thrown on IllegalStateException as cqsi should be closed");
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsNotClosedAfterStandbyURLChange() throws Exception {
        short numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (short i = 0; i < numberOfConnections; i = (short)((short)(i + 1))) {
            connectionList.add(this.createFailoverConnection());
        }
        ConnectionQueryServicesImpl cqsi = (ConnectionQueryServicesImpl)PhoenixDriver.INSTANCE.getConnectionQueryServices(CLUSTERS.getJdbcUrl2(this.haGroup), this.clientProperties);
        CLUSTERS.restartCluster2();
        CLUSTERS.refreshClusterRoleRecordAfterClusterRestart(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE, ClusterRoleRecord.ClusterRole.STANDBY);
        for (short i = 0; i < numberOfConnections; i = (short)(i + 1)) {
            LOG.info("Asserting connection number {}", (Object)i);
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertFalse((boolean)conn.getWrappedConnection().isClosed());
            conn.close();
        }
        try {
            cqsi.checkClosed();
        }
        catch (Exception e) {
            Assert.fail((String)"Should not through any excepetion as cqsi is not closed");
        }
    }

    @Test(timeout=300000L)
    public void testAllWrappedConnectionsClosedWhenRoleChangeFromActiveToATS() throws Exception {
        int i;
        int numberOfConnections = 10;
        ArrayList<Connection> connectionList = new ArrayList<Connection>(numberOfConnections);
        for (i = 0; i < numberOfConnections; i = (int)((short)(i + 1))) {
            connectionList.add(this.createFailoverConnection());
        }
        CLUSTERS.transitClusterRole(this.haGroup, ClusterRoleRecord.ClusterRole.ACTIVE_TO_STANDBY, ClusterRoleRecord.ClusterRole.STANDBY);
        for (i = 0; i < numberOfConnections; i = (int)((short)(i + 1))) {
            FailoverPhoenixConnection conn = (FailoverPhoenixConnection)connectionList.get(i);
            Assert.assertFalse((boolean)conn.isClosed());
            Assert.assertTrue((boolean)conn.getWrappedConnection().isClosed());
        }
    }

    private Connection createFailoverConnection() throws SQLException {
        return DriverManager.getConnection(CLUSTERS.getJdbcHAUrl(), this.clientProperties);
    }
}

