/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.ClusterRoleRecord;
import org.apache.phoenix.jdbc.ClusterRoleRecordGeneratorTool;
import org.apache.phoenix.jdbc.HighAvailabilityPolicy;
import org.apache.phoenix.jdbc.HighAvailabilityTestingUtility;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ClusterRoleRecordGeneratorToolIT {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterRoleRecordGeneratorToolIT.class);
    private static final HighAvailabilityTestingUtility.HBaseTestingUtilityPair CLUSTERS = new HighAvailabilityTestingUtility.HBaseTestingUtilityPair();
    @Rule
    public final TestName testName = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CLUSTERS.start();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        CLUSTERS.close();
    }

    @Test
    public void testRun() throws Exception {
        ClusterRoleRecordGeneratorTool generator = new ClusterRoleRecordGeneratorTool();
        Configuration conf = new Configuration(CLUSTERS.getHBaseCluster1().getConfiguration());
        String haGroupNames = String.format("%s,%s,%s", this.testName.getMethodName(), this.testName.getMethodName() + 1, this.testName.getMethodName() + 2);
        conf.set("phoenix.ha.role.generator.groups", haGroupNames);
        File file = File.createTempFile("phoenix.ha.cluster.role.records", ".json");
        file.deleteOnExit();
        conf.set("phoenix.ha.role.generator.file", file.getAbsolutePath());
        generator.setConf(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new ClusterRoleRecordGeneratorTool(), (String[])new String[0]);
        Assert.assertEquals((long)0L, (long)ret);
        String recordJson = FileUtils.readFileToString((File)file);
        LOG.info("The created file content is: \n{}", (Object)recordJson);
        for (String haGroupName : haGroupNames.split(",")) {
            Assert.assertTrue((boolean)recordJson.contains(haGroupName));
        }
    }

    @Test
    public void testListAllRecordsByGenerator1() throws Exception {
        ClusterRoleRecordGeneratorTool generator1 = new ClusterRoleRecordGeneratorTool();
        Configuration conf1 = new Configuration(CLUSTERS.getHBaseCluster1().getConfiguration());
        conf1.set("phoenix.ha.role.generator.groups", this.testName.getMethodName());
        conf1.set(String.format("phoenix.ha.role.generator.policy.%s", this.testName.getMethodName()), HighAvailabilityPolicy.FAILOVER.name());
        generator1.setConf(conf1);
        List records = generator1.listAllRecordsByZk();
        Assert.assertNotNull((Object)records);
        LOG.info("Generated following records from cluster1: {}", (Object)records);
        Assert.assertEquals((long)1L, (long)records.size());
        for (ClusterRoleRecord record : records) {
            Assert.assertEquals((Object)HighAvailabilityPolicy.FAILOVER, (Object)record.getPolicy());
            Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.ACTIVE, (Object)record.getRole(CLUSTERS.getZkUrl1()));
            Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.STANDBY, (Object)record.getRole(CLUSTERS.getZkUrl2()));
        }
    }

    @Test
    public void testListAllRecordsByGenerator2() throws Exception {
        ClusterRoleRecordGeneratorTool generator2 = new ClusterRoleRecordGeneratorTool();
        Configuration conf2 = new Configuration(CLUSTERS.getHBaseCluster2().getConfiguration());
        String haGroupNames = String.format("%s,%s,%s", this.testName.getMethodName(), this.testName.getMethodName() + 1, this.testName.getMethodName() + 2);
        conf2.set("phoenix.ha.role.generator.groups", haGroupNames);
        generator2.setConf(conf2);
        List records = generator2.listAllRecordsByZk();
        Assert.assertNotNull((Object)records);
        LOG.info("Generated following records from cluster2: {}", (Object)records);
        Assert.assertEquals((long)3L, (long)records.size());
        for (ClusterRoleRecord record : records) {
            Assert.assertEquals((Object)HighAvailabilityPolicy.PARALLEL, (Object)record.getPolicy());
            Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.ACTIVE, (Object)record.getRole(CLUSTERS.getZkUrl2()));
            Assert.assertEquals((Object)ClusterRoleRecord.ClusterRole.STANDBY, (Object)record.getRole(CLUSTERS.getZkUrl1()));
        }
    }
}

