/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;

public class TestingMapReduceParallelScanGrouper
extends MapReduceParallelScanGrouper {
    private static final AtomicInteger numCallsToGetRegionBoundaries = new AtomicInteger(0);
    private static final TestingMapReduceParallelScanGrouper INSTANCE = new TestingMapReduceParallelScanGrouper();

    public static TestingMapReduceParallelScanGrouper getInstance() {
        return INSTANCE;
    }

    public List<HRegionLocation> getRegionBoundaries(StatementContext context, byte[] tableName) throws SQLException {
        List regionLocations = super.getRegionBoundaries(context, tableName);
        numCallsToGetRegionBoundaries.incrementAndGet();
        return regionLocations;
    }

    public List<HRegionLocation> getRegionBoundaries(StatementContext context, byte[] tableName, byte[] startRegionBoundaryKey, byte[] stopRegionBoundaryKey) throws SQLException {
        List regionLocations = super.getRegionBoundaries(context, tableName, startRegionBoundaryKey, stopRegionBoundaryKey);
        numCallsToGetRegionBoundaries.incrementAndGet();
        return regionLocations;
    }

    public static int getNumCallsToGetRegionBoundaries() {
        return numCallsToGetRegionBoundaries.get();
    }

    public static void clearNumCallsToGetRegionBoundaries() {
        numCallsToGetRegionBoundaries.set(0);
    }
}

