/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.iterate.MaterializedResultIterator;
import org.apache.phoenix.iterate.MergeSortRowKeyResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.AssertResults;
import org.junit.Test;

public class MergeSortResultIteratorTest {
    private static final byte[] A = Bytes.toBytes((String)"a");
    private static final byte[] B = Bytes.toBytes((String)"b");

    @Test
    public void testMergeSort() throws Throwable {
        Tuple[] results1 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        Tuple[] results2 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        Tuple[] results3 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        final ArrayList<PeekingResultIterator> results = new ArrayList<PeekingResultIterator>(Arrays.asList(new MaterializedResultIterator(Arrays.asList(results1)), new MaterializedResultIterator(Arrays.asList(results2)), new MaterializedResultIterator(Arrays.asList(results3))));
        Tuple[] expectedResults = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        ResultIterators iterators = new ResultIterators(){

            public List<PeekingResultIterator> getIterators() throws SQLException {
                return results;
            }

            public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
            }

            public int size() {
                return results.size();
            }

            public void explain(List<String> planSteps) {
            }

            public List<KeyRange> getSplits() {
                return Collections.emptyList();
            }

            public List<List<Scan>> getScans() {
                return Collections.emptyList();
            }

            public void close() throws SQLException {
            }
        };
        ResultIterators reverseIterators = new ResultIterators(){

            public List<PeekingResultIterator> getIterators() throws SQLException {
                return results;
            }

            public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
            }

            public int size() {
                return results.size();
            }

            public void explain(List<String> planSteps) {
            }

            public List<KeyRange> getSplits() {
                return Collections.emptyList();
            }

            public List<List<Scan>> getScans() {
                return Collections.emptyList();
            }

            public void close() throws SQLException {
            }
        };
        MergeSortRowKeyResultIterator scanner = new MergeSortRowKeyResultIterator(iterators);
        AssertResults.assertResults((ResultIterator)scanner, expectedResults);
    }

    @Test
    public void testReverseMergeSort() throws Throwable {
        Tuple[] results1 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        Tuple[] results2 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        Tuple[] results3 = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        final ArrayList<PeekingResultIterator> results = new ArrayList<PeekingResultIterator>(Arrays.asList(new MaterializedResultIterator(Arrays.asList(results1)), new MaterializedResultIterator(Arrays.asList(results2)), new MaterializedResultIterator(Arrays.asList(results3))));
        Tuple[] expectedResults = new Tuple[]{new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(B, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1))), new SingleKeyValueTuple((Cell)new KeyValue(A, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Bytes.toBytes((int)1)))};
        ResultIterators iterators = new ResultIterators(){

            public List<PeekingResultIterator> getIterators() throws SQLException {
                return results;
            }

            public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
            }

            public int size() {
                return results.size();
            }

            public void explain(List<String> planSteps) {
            }

            public List<KeyRange> getSplits() {
                return Collections.emptyList();
            }

            public List<List<Scan>> getScans() {
                return Collections.emptyList();
            }

            public void close() throws SQLException {
            }
        };
        MergeSortRowKeyResultIterator scanner = new MergeSortRowKeyResultIterator(iterators, 0, true);
        AssertResults.assertResults((ResultIterator)scanner, expectedResults);
    }
}

