/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.iterate.TableResultIteratorFactory;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;

public class DelayedTableResultIteratorFactory
implements TableResultIteratorFactory {
    private final long delay;

    public DelayedTableResultIteratorFactory(long delay) {
        this.delay = delay;
    }

    public TableResultIterator newIterator(MutationState mutationState, TableRef tableRef, Scan scan, ScanMetricsHolder scanMetricsHolder, long renewLeaseThreshold, QueryPlan plan, ParallelScanGrouper scanGrouper, Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches, long maxQueryEndTime) throws SQLException {
        return new DelayedTableResultIterator(mutationState, tableRef, scan, scanMetricsHolder, renewLeaseThreshold, plan, scanGrouper, caches, maxQueryEndTime);
    }

    private class DelayedTableResultIterator
    extends TableResultIterator {
        public DelayedTableResultIterator(MutationState mutationState, TableRef tableRef, Scan scan, ScanMetricsHolder scanMetricsHolder, long renewLeaseThreshold, QueryPlan plan, ParallelScanGrouper scanGrouper, Map<ImmutableBytesPtr, ServerCacheClient.ServerCache> caches, long maxQueryEndTime) throws SQLException {
            super(mutationState, scan, scanMetricsHolder, renewLeaseThreshold, plan, scanGrouper, caches, maxQueryEndTime);
        }

        public synchronized void initScanner() throws SQLException {
            super.initScanner();
        }

        public Tuple next() throws SQLException {
            this.delay();
            return super.next();
        }

        private void delay() throws SQLException {
            try {
                new CountDownLatch(1).await(DelayedTableResultIteratorFactory.this.delay, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INTERRUPTED_EXCEPTION).setRootCause((Throwable)e).build().buildException();
            }
        }
    }
}

