/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.GlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRepository;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Bytes;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class VerifySingleIndexRowTest
extends BaseConnectionlessQueryTest {
    private static final String UNEXPECTED_COLUMN = "0:UNEXPECTED_COLUMN";
    public static final String FIRST_ID = "FIRST_ID";
    public static final String SECOND_ID = "SECOND_ID";
    public static final String FIRST_VALUE = "FIRST_VALUE";
    public static final String SECOND_VALUE = "SECOND_VALUE";
    public static final String CREATE_TABLE_DDL = "CREATE TABLE IF NOT EXISTS %s (FIRST_ID BIGINT NOT NULL, SECOND_ID BIGINT NOT NULL, FIRST_VALUE VARCHAR(20), SECOND_VALUE INTEGER CONSTRAINT PK PRIMARY KEY(FIRST_ID, SECOND_ID)) COLUMN_ENCODED_BYTES=0";
    public static final String CREATE_INDEX_DDL = "CREATE INDEX %s ON %s (SECOND_VALUE) INCLUDE (FIRST_VALUE)";
    public static final String COMPLETE_ROW_UPSERT = "UPSERT INTO %s VALUES (?,?,?,?)";
    public static final String PARTIAL_ROW_UPSERT = "UPSERT INTO %s (%s, %s, %s) VALUES (?,?,?)";
    public static final String DELETE_ROW_DML = "DELETE FROM %s WHERE %s = ?  AND %s = ?";
    public static final String INCLUDED_COLUMN = "0:FIRST_VALUE";
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    @Mock
    Result indexRow;
    @Mock
    IndexRebuildRegionScanner rebuildScanner;
    List<Mutation> actualMutationList;
    String schema;
    String table;
    String dataTableFullName;
    String index;
    String indexTableFullName;
    PTable pIndexTable;
    PTable pDataTable;
    Put put = null;
    Delete delete = null;
    PhoenixConnection pconn;
    IndexToolVerificationResult.PhaseResult actualPR;
    public Map<byte[], List<Mutation>> indexKeyToMutationMap = null;
    Set<byte[]> mostRecentIndexRowKeys;
    private IndexMaintainer indexMaintainer;

    @Before
    public void setup() throws SQLException, IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.createDBObject();
        this.createMutationsWithUpserts();
        this.initializeRebuildScannerAttributes();
        this.initializeGlobalMockitoSetup();
    }

    @After
    public void reset() {
        EnvironmentEdgeManager.reset();
    }

    public void createDBObject() throws SQLException {
        try (Connection conn = DriverManager.getConnection(VerifySingleIndexRowTest.getUrl(), new Properties());){
            this.schema = VerifySingleIndexRowTest.generateUniqueName();
            this.table = VerifySingleIndexRowTest.generateUniqueName();
            this.index = VerifySingleIndexRowTest.generateUniqueName();
            this.dataTableFullName = SchemaUtil.getQualifiedTableName((String)this.schema, (String)this.table);
            this.indexTableFullName = SchemaUtil.getQualifiedTableName((String)this.schema, (String)this.index);
            conn.createStatement().execute(String.format(CREATE_TABLE_DDL, this.dataTableFullName));
            conn.createStatement().execute(String.format(CREATE_INDEX_DDL, this.index, this.dataTableFullName));
            conn.commit();
            this.pconn = conn.unwrap(PhoenixConnection.class);
            this.pIndexTable = this.pconn.getTable(new PTableKey(this.pconn.getTenantId(), this.indexTableFullName));
            this.pDataTable = this.pconn.getTable(new PTableKey(this.pconn.getTenantId(), this.dataTableFullName));
        }
    }

    private void createMutationsWithUpserts() throws SQLException, IOException {
        this.deleteRow(2, 3);
        this.upsertPartialRow(2, 3, "abc");
        this.upsertCompleteRow(2, 3, "hik", 8);
        this.upsertPartialRow(2, 3, 10);
        this.upsertPartialRow(2, 3, 4);
        this.deleteRow(2, 3);
        this.upsertPartialRow(2, 3, "def");
        this.upsertCompleteRow(2, 3, null, 20);
        this.upsertPartialRow(2, 3, "wert");
    }

    private void deleteRow(int key1, int key2) throws SQLException, IOException {
        try (Connection conn = DriverManager.getConnection(VerifySingleIndexRowTest.getUrl(), new Properties());){
            PreparedStatement ps = conn.prepareStatement(String.format(DELETE_ROW_DML, this.dataTableFullName, FIRST_ID, SECOND_ID));
            ps.setInt(1, key1);
            ps.setInt(2, key2);
            ps.execute();
            this.convertUpsertToMutations(conn);
        }
    }

    private void upsertPartialRow(int key1, int key2, String val1) throws SQLException, IOException {
        try (Connection conn = DriverManager.getConnection(VerifySingleIndexRowTest.getUrl(), new Properties());){
            PreparedStatement ps = conn.prepareStatement(String.format(PARTIAL_ROW_UPSERT, this.dataTableFullName, FIRST_ID, SECOND_ID, FIRST_VALUE));
            ps.setInt(1, key1);
            ps.setInt(2, key2);
            ps.setString(3, val1);
            ps.execute();
            this.convertUpsertToMutations(conn);
        }
    }

    private void upsertPartialRow(int key1, int key2, int value1) throws SQLException, IOException {
        try (Connection conn = DriverManager.getConnection(VerifySingleIndexRowTest.getUrl(), new Properties());){
            PreparedStatement ps = conn.prepareStatement(String.format(PARTIAL_ROW_UPSERT, this.dataTableFullName, FIRST_ID, SECOND_ID, SECOND_VALUE));
            ps.setInt(1, key1);
            ps.setInt(2, key2);
            ps.setInt(3, value1);
            ps.execute();
            this.convertUpsertToMutations(conn);
        }
    }

    private void upsertCompleteRow(int key1, int key2, String val1, int val2) throws SQLException, IOException {
        try (Connection conn = DriverManager.getConnection(VerifySingleIndexRowTest.getUrl(), new Properties());){
            PreparedStatement ps = conn.prepareStatement(String.format(COMPLETE_ROW_UPSERT, this.dataTableFullName));
            ps.setInt(1, key1);
            ps.setInt(2, key2);
            ps.setString(3, val1);
            ps.setInt(4, val2);
            ps.execute();
            this.convertUpsertToMutations(conn);
        }
    }

    private void convertUpsertToMutations(Connection conn) throws SQLException, IOException {
        Iterator dataTableNameAndMutationKeyValuesIter = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        Pair elem = (Pair)dataTableNameAndMutationKeyValuesIter.next();
        byte[] key = CellUtil.cloneRow((Cell)((Cell)((List)elem.getSecond()).get(0)));
        long mutationTS = EnvironmentEdgeManager.currentTimeMillis();
        for (Cell kv : (List)elem.getSecond()) {
            Cell cell = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(CellUtil.cloneRow((Cell)kv)).setFamily(CellUtil.cloneFamily((Cell)kv)).setQualifier(CellUtil.cloneQualifier((Cell)kv)).setTimestamp(mutationTS).setType(kv.getType()).setValue(CellUtil.cloneValue((Cell)kv)).build();
            if (cell.getType().equals((Object)Cell.Type.Put)) {
                if (this.put == null) {
                    this.put = new Put(key);
                }
                this.put.add(cell);
                continue;
            }
            if (this.delete == null) {
                this.delete = new Delete(key);
            }
            this.delete.add(cell);
        }
    }

    private void initializeRebuildScannerAttributes() throws SQLException {
        Mockito.when((Object)this.rebuildScanner.setIndexMaintainer((IndexMaintainer)ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)this.rebuildScanner.setMaxLookBackInMills(ArgumentMatchers.anyLong())).thenCallRealMethod();
        this.indexMaintainer = this.pIndexTable.getIndexMaintainer(this.pDataTable, this.pconn);
        this.rebuildScanner.setIndexMaintainer(this.indexMaintainer);
        this.rebuildScanner.setMaxLookBackInMills(Long.MAX_VALUE);
    }

    private void initializeGlobalMockitoSetup() throws IOException {
        Mockito.when((Object)this.indexMaintainer.getIndexRowKey(this.put, null)).thenCallRealMethod();
        Mockito.when((Object)this.rebuildScanner.prepareIndexMutations(this.put, this.delete, this.indexKeyToMutationMap, this.mostRecentIndexRowKeys)).thenCallRealMethod();
        Mockito.when((Object)this.rebuildScanner.verifySingleIndexRow((byte[])ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (IndexToolVerificationResult.PhaseResult)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenCallRealMethod();
        ((IndexRebuildRegionScanner)Mockito.doNothing().when((Object)this.rebuildScanner)).logToIndexToolOutputTable((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyString(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IndexVerificationOutputRepository.IndexVerificationErrorType)Mockito.any());
        ((IndexRebuildRegionScanner)Mockito.doNothing().when((Object)this.rebuildScanner)).logToIndexToolOutputTable((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyString(), ArgumentMatchers.anyBoolean(), (IndexVerificationOutputRepository.IndexVerificationErrorType)Mockito.any());
        this.indexKeyToMutationMap = Maps.newTreeMap((Comparator)org.apache.hadoop.hbase.util.Bytes.BYTES_COMPARATOR);
        this.rebuildScanner.prepareIndexMutations(this.put, this.delete, this.indexKeyToMutationMap, this.mostRecentIndexRowKeys);
    }

    private byte[] getValidRowKey() {
        return this.indexKeyToMutationMap.entrySet().iterator().next().getKey();
    }

    @Test
    public void testVerifySingleIndexRow_validIndexRowCount_nonZero() throws IOException {
        IndexToolVerificationResult.PhaseResult expectedPR = this.getValidPhaseResult();
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.VALID_EXACT_MATCH);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((Object)this.actualPR, (Object)expectedPR);
        }
    }

    @Test
    public void testVerifySingleIndexRow_validIndexRowCount_moreActual() throws IOException {
        IndexToolVerificationResult.PhaseResult expectedPR = this.getValidPhaseResult();
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.VALID_MORE_MUTATIONS);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((Object)this.actualPR, (Object)expectedPR);
        }
    }

    @Test
    public void testVerifySingleIndexRow_allMix() throws IOException {
        IndexToolVerificationResult.PhaseResult expectedPR = this.getValidPhaseResult();
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.VALID_MIX_MUTATIONS);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((Object)this.actualPR, (Object)expectedPR);
        }
    }

    @Test
    public void testVerifySingleIndexRow_allUnverified() throws IOException {
        IndexToolVerificationResult.PhaseResult expectedPR = this.getValidPhaseResult();
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.VALID_NEW_UNVERIFIED_MUTATIONS);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((Object)this.actualPR, (Object)expectedPR);
        }
    }

    @Test
    public void testVerifySingleIndexRow_invalidIndexRowCount_cellValue() throws IOException {
        IndexToolVerificationResult.PhaseResult expectedPR = this.getInvalidPhaseResult();
        expectedPR.setIndexHasExtraCellsCount(1L);
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.INVALID_CELL_VALUE);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((Object)this.actualPR, (Object)expectedPR);
        }
    }

    @Test
    public void testVerifySingleIndexRow_invalidIndexRowCount_emptyCell() throws IOException {
        IndexToolVerificationResult.PhaseResult expectedPR = this.getInvalidPhaseResult();
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.INVALID_EMPTY_CELL);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((Object)this.actualPR, (Object)expectedPR);
        }
    }

    @Test
    public void testVerifySingleIndexRow_invalidIndexRowCount_diffColumn() throws IOException {
        IndexToolVerificationResult.PhaseResult expectedPR = this.getInvalidPhaseResult();
        expectedPR.setIndexHasExtraCellsCount(1L);
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.INVALID_COLUMN);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((Object)this.actualPR, (Object)expectedPR);
        }
    }

    @Test
    public void testVerifySingleIndexRow_invalidIndexRowCount_extraCell() throws IOException {
        IndexToolVerificationResult.PhaseResult expectedPR = this.getInvalidPhaseResult();
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.INVALID_EXTRA_CELL);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((Object)this.actualPR, (Object)expectedPR);
        }
    }

    @Test
    public void testVerifySingleIndexRow_expectedMutations_null() throws IOException {
        Mockito.when((Object)this.indexRow.getRow()).thenReturn((Object)org.apache.hadoop.hbase.util.Bytes.toBytes((int)1));
        this.exceptionRule.expect(DoNotRetryIOException.class);
        this.exceptionRule.expectMessage("No expected mutation");
        this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
    }

    @Test
    public void testVerifySingleIndexRow_validIndexRowCount_extraCell() throws IOException {
        for (Map.Entry<byte[], List<Mutation>> entry : this.indexKeyToMutationMap.entrySet()) {
            this.initializeLocalMockitoSetup(entry, TestType.VALID_EXTRA_CELL);
            this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), this.actualMutationList, this.indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, this.actualPR, true);
            Assert.assertEquals((long)1L, (long)this.actualPR.getIndexHasExtraCellsCount());
        }
    }

    @Test
    public void testVerifySingleIndexRow_compactionOnIndexTable_atLeastOneExpectedMutationWithinMaxLookBack() throws Exception {
        String dataRowKey = "k1";
        byte[] indexRowKey1Bytes = VerifySingleIndexRowTest.generateIndexRowKey(dataRowKey, "val1");
        ManualEnvironmentEdge injectEdge = new ManualEnvironmentEdge();
        injectEdge.setValue(1L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)injectEdge);
        ArrayList<Put> expectedMutations = new ArrayList<Put>();
        ArrayList<Put> actualMutations = new ArrayList<Put>();
        long maxLookbackInMills = 10000L;
        this.rebuildScanner.setMaxLookBackInMills(maxLookbackInMills);
        Put put = new Put(indexRowKey1Bytes);
        Cell cell = this.getNewCell(indexRowKey1Bytes, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, EnvironmentEdgeManager.currentTimeMillis(), Cell.Type.Put, QueryConstants.VERIFIED_BYTES);
        put.add(cell);
        expectedMutations.add(put);
        injectEdge.incrementValue(maxLookbackInMills);
        put = new Put(indexRowKey1Bytes);
        cell = this.getNewCell(indexRowKey1Bytes, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, EnvironmentEdgeManager.currentTimeMillis(), Cell.Type.Put, QueryConstants.VERIFIED_BYTES);
        put.add(cell);
        expectedMutations.add(put);
        actualMutations.add(put);
        Result actualMutationsScanResult = Result.create(Arrays.asList(cell));
        TreeMap indexKeyToMutationMap = Maps.newTreeMap((Comparator)org.apache.hadoop.hbase.util.Bytes.BYTES_COMPARATOR);
        indexKeyToMutationMap.put(indexRowKey1Bytes, expectedMutations);
        Mockito.when((Object)this.rebuildScanner.prepareActualIndexMutations((Result)ArgumentMatchers.any(Result.class))).thenReturn(actualMutations);
        Mockito.when((Object)this.indexRow.getRow()).thenReturn((Object)indexRowKey1Bytes);
        injectEdge.incrementValue(1L);
        IndexToolVerificationResult.PhaseResult actualPR = new IndexToolVerificationResult.PhaseResult();
        Collections.sort((List)indexKeyToMutationMap.get(this.indexRow.getRow()), GlobalIndexRegionScanner.MUTATION_TS_DESC_COMPARATOR);
        Assert.assertTrue((boolean)this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), actualMutations, (List)indexKeyToMutationMap.get(this.indexRow.getRow()), this.mostRecentIndexRowKeys, Collections.EMPTY_LIST, actualPR, false));
        IndexToolVerificationResult.PhaseResult expectedPR = new IndexToolVerificationResult.PhaseResult(1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        Assert.assertTrue((boolean)actualPR.equals((Object)expectedPR));
    }

    @Test
    public void testVerifySingleIndexRow_compactionOnIndexTable_noExpectedMutationWithinMaxLookBack() throws Exception {
        String dataRowKey = "k1";
        byte[] indexRowKey1Bytes = VerifySingleIndexRowTest.generateIndexRowKey(dataRowKey, "val1");
        ArrayList<Put> expectedMutations = new ArrayList<Put>();
        ArrayList<Put> actualMutations = new ArrayList<Put>();
        long maxLookbackInMills = 10000L;
        this.rebuildScanner.setMaxLookBackInMills(maxLookbackInMills);
        ManualEnvironmentEdge injectEdge = new ManualEnvironmentEdge();
        injectEdge.setValue(1L);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)injectEdge);
        Put put = new Put(indexRowKey1Bytes);
        Cell cell = this.getNewCell(indexRowKey1Bytes, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, EnvironmentEdgeManager.currentTimeMillis(), Cell.Type.Put, QueryConstants.VERIFIED_BYTES);
        put.add(cell);
        expectedMutations.add(put);
        injectEdge.incrementValue(maxLookbackInMills);
        put = new Put(indexRowKey1Bytes);
        cell = this.getNewCell(indexRowKey1Bytes, QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, EnvironmentEdgeManager.currentTimeMillis(), Cell.Type.Put, QueryConstants.UNVERIFIED_BYTES);
        put.add(cell);
        actualMutations.add(put);
        Result actualMutationsScanResult = Result.create(Arrays.asList(cell));
        TreeMap indexKeyToMutationMap = Maps.newTreeMap((Comparator)org.apache.hadoop.hbase.util.Bytes.BYTES_COMPARATOR);
        indexKeyToMutationMap.put(indexRowKey1Bytes, expectedMutations);
        this.mostRecentIndexRowKeys = new TreeSet<byte[]>(org.apache.hadoop.hbase.util.Bytes.BYTES_COMPARATOR);
        Mockito.when((Object)this.rebuildScanner.prepareActualIndexMutations((Result)ArgumentMatchers.any(Result.class))).thenReturn(actualMutations);
        Mockito.when((Object)this.indexRow.getRow()).thenReturn((Object)indexRowKey1Bytes);
        injectEdge.incrementValue(1L);
        IndexToolVerificationResult.PhaseResult actualPR = new IndexToolVerificationResult.PhaseResult();
        Assert.assertFalse((boolean)this.rebuildScanner.verifySingleIndexRow(this.indexRow.getRow(), actualMutations, expectedMutations, this.mostRecentIndexRowKeys, new ArrayList(), actualPR, true));
        IndexToolVerificationResult.PhaseResult expectedPR = new IndexToolVerificationResult.PhaseResult(0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L);
        Assert.assertTrue((boolean)actualPR.equals((Object)expectedPR));
    }

    private static byte[] generateIndexRowKey(String dataRowKey, String dataVal) {
        ArrayList<Byte> idxKey = new ArrayList<Byte>();
        if (dataVal != null && !dataVal.isEmpty()) {
            idxKey.addAll(Bytes.asList((byte[])org.apache.hadoop.hbase.util.Bytes.toBytes((String)dataVal)));
        }
        idxKey.add((byte)0);
        idxKey.addAll(Bytes.asList((byte[])org.apache.hadoop.hbase.util.Bytes.toBytes((String)dataRowKey)));
        return Bytes.toArray(idxKey);
    }

    private IndexToolVerificationResult.PhaseResult getValidPhaseResult() {
        return new IndexToolVerificationResult.PhaseResult(1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    private IndexToolVerificationResult.PhaseResult getInvalidPhaseResult() {
        return new IndexToolVerificationResult.PhaseResult(0L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    private void initializeLocalMockitoSetup(Map.Entry<byte[], List<Mutation>> entry, TestType testType) throws IOException {
        this.actualPR = new IndexToolVerificationResult.PhaseResult();
        byte[] indexKey = entry.getKey();
        Mockito.when((Object)this.indexRow.getRow()).thenReturn((Object)indexKey);
        this.actualMutationList = this.buildActualIndexMutationsList(testType);
        Mockito.when((Object)this.rebuildScanner.prepareActualIndexMutations(this.indexRow)).thenReturn(this.actualMutationList);
    }

    private List<Mutation> buildActualIndexMutationsList(TestType testType) {
        ArrayList<Mutation> actualMutations = new ArrayList<Mutation>();
        actualMutations.addAll((Collection)this.indexKeyToMutationMap.get(this.indexRow.getRow()));
        if (testType.equals((Object)TestType.EXPIRED)) {
            return actualMutations;
        }
        if (testType.toString().startsWith("VALID")) {
            return this.getValidActualMutations(testType, actualMutations);
        }
        if (testType.toString().startsWith("INVALID")) {
            return this.getInvalidActualMutations(testType, actualMutations);
        }
        return null;
    }

    private List<Mutation> getValidActualMutations(TestType testType, List<Mutation> actualMutations) {
        ArrayList<Mutation> newActualMutations = new ArrayList<Mutation>();
        if (testType.equals((Object)TestType.VALID_EXACT_MATCH)) {
            return actualMutations;
        }
        if (testType.equals((Object)TestType.VALID_MIX_MUTATIONS)) {
            newActualMutations.add(this.getUnverifiedPutMutation(actualMutations.get(0), null));
            newActualMutations.add(this.getDeleteMutation(actualMutations.get(0), new Long(1L)));
            newActualMutations.add(this.getUnverifiedPutMutation(actualMutations.get(0), null));
        }
        if (testType.equals((Object)TestType.VALID_NEW_UNVERIFIED_MUTATIONS)) {
            newActualMutations.add(this.getUnverifiedPutMutation(actualMutations.get(0), null));
            newActualMutations.add(this.getUnverifiedPutMutation(actualMutations.get(0), null));
            newActualMutations.add(this.getUnverifiedPutMutation(actualMutations.get(0), null));
            newActualMutations.add(this.getUnverifiedPutMutation(actualMutations.get(0), new Long(1L)));
        }
        newActualMutations.addAll(actualMutations);
        if (testType.equals((Object)TestType.VALID_MORE_MUTATIONS)) {
            newActualMutations.add(this.getUnverifiedPutMutation(actualMutations.get(0), null));
            newActualMutations.add(this.getDeleteMutation(actualMutations.get(0), null));
            newActualMutations.add(this.getDeleteMutation(actualMutations.get(0), new Long(1L)));
            newActualMutations.add(this.getUnverifiedPutMutation(actualMutations.get(0), new Long(1L)));
        }
        if (testType.equals((Object)TestType.VALID_EXTRA_CELL)) {
            for (Mutation m : newActualMutations) {
                if (!(m instanceof Put)) continue;
                List origList = (List)m.getFamilyCellMap().firstEntry().getValue();
                Cell newCell = this.getNewCell(m.getRow(), CellUtil.cloneFamily((Cell)((Cell)origList.get(0))), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"EXTRACOL"), m.getTimestamp(), Cell.Type.Put, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"asdfg"));
                byte[] fam = CellUtil.cloneFamily((Cell)((Cell)origList.get(0)));
                ((List)m.getFamilyCellMap().get(fam)).add(newCell);
                break;
            }
        }
        return newActualMutations;
    }

    private List<Mutation> getInvalidActualMutations(TestType testType, List<Mutation> actualMutations) {
        ArrayList<Mutation> newActualMutations = new ArrayList<Mutation>();
        newActualMutations.addAll(actualMutations);
        for (Mutation m : actualMutations) {
            newActualMutations.remove(m);
            NavigableMap familyCellMap = m.getFamilyCellMap();
            List cellList = (List)familyCellMap.firstEntry().getValue();
            ArrayList<Cell> newCellList = new ArrayList<Cell>();
            byte[] fam = CellUtil.cloneFamily((Cell)((Cell)cellList.get(0)));
            for (Cell c : cellList) {
                this.infiltrateCell(c, newCellList, testType);
            }
            familyCellMap.put(fam, newCellList);
            Object newM = m instanceof Put ? new Put(m.getRow(), m.getTimestamp(), familyCellMap) : new Delete(m.getRow(), m.getTimestamp(), familyCellMap);
            newActualMutations.add((Mutation)newM);
        }
        return newActualMutations;
    }

    private void infiltrateCell(Cell c, List<Cell> newCellList, TestType e) {
        switch (e) {
            case INVALID_COLUMN: {
                Cell newCell = this.getNewCell(CellUtil.cloneRow((Cell)c), CellUtil.cloneFamily((Cell)c), org.apache.hadoop.hbase.util.Bytes.toBytes((String)UNEXPECTED_COLUMN), c.getTimestamp(), Cell.Type.Put, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"zxcv"));
                newCellList.add(newCell);
                newCellList.add(c);
                break;
            }
            case INVALID_CELL_VALUE: {
                if (CellUtil.matchingQualifier((Cell)c, (byte[])QueryConstants.EMPTY_COLUMN_BYTES)) {
                    Cell newCell = this.getCellWithPut(c);
                    Cell emptyCell = this.getVerifiedEmptyCell(c);
                    newCellList.add(newCell);
                    newCellList.add(emptyCell);
                    break;
                }
                newCellList.add(c);
                break;
            }
            case INVALID_EMPTY_CELL: {
                if (CellUtil.matchingQualifier((Cell)c, (byte[])QueryConstants.EMPTY_COLUMN_BYTES)) {
                    Cell newCell = this.getNewCell(CellUtil.cloneRow((Cell)c), CellUtil.cloneFamily((Cell)c), CellUtil.cloneQualifier((Cell)c), c.getTimestamp(), Cell.Type.Delete, QueryConstants.VERIFIED_BYTES);
                    newCellList.add(newCell);
                    break;
                }
                newCellList.add(c);
                break;
            }
            case INVALID_EXTRA_CELL: {
                Cell newCell = this.getCellWithPut(c);
                Cell emptyCell = this.getVerifiedEmptyCell(c);
                newCellList.add(newCell);
                newCellList.add(emptyCell);
                newCellList.add(c);
            }
        }
    }

    private Cell getVerifiedEmptyCell(Cell c) {
        return this.getNewCell(CellUtil.cloneRow((Cell)c), CellUtil.cloneFamily((Cell)c), this.indexMaintainer.getEmptyKeyValueQualifier(), c.getTimestamp(), Cell.Type.Put, QueryConstants.VERIFIED_BYTES);
    }

    private Cell getCellWithPut(Cell c) {
        return this.getNewCell(CellUtil.cloneRow((Cell)c), CellUtil.cloneFamily((Cell)c), org.apache.hadoop.hbase.util.Bytes.toBytes((String)INCLUDED_COLUMN), c.getTimestamp(), Cell.Type.Put, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"zxcv"));
    }

    private Mutation getDeleteMutation(Mutation orig, Long ts) {
        Delete m = new Delete(orig.getRow());
        List origList = (List)orig.getFamilyCellMap().firstEntry().getValue();
        ts = ts == null ? EnvironmentEdgeManager.currentTimeMillis() : ts;
        Cell c = this.getNewPutCell(orig, origList, ts, Cell.Type.DeleteFamilyVersion);
        Cell empty = this.getEmptyCell(orig, origList, ts, Cell.Type.Put, true);
        byte[] fam = CellUtil.cloneFamily((Cell)((Cell)origList.get(0)));
        ArrayList famCells = Lists.newArrayList();
        m.getFamilyCellMap().put(fam, famCells);
        famCells.add(c);
        famCells.add(empty);
        return m;
    }

    private Mutation getUnverifiedPutMutation(Mutation orig, Long ts) {
        Put m = new Put(orig.getRow());
        if (orig.getAttributesMap() != null) {
            for (Map.Entry entry : orig.getAttributesMap().entrySet()) {
                m.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
            }
        }
        List origList = (List)orig.getFamilyCellMap().firstEntry().getValue();
        ts = ts == null ? EnvironmentEdgeManager.currentTimeMillis() : ts;
        Cell c = this.getNewPutCell(orig, origList, ts, Cell.Type.Put);
        Cell empty = this.getEmptyCell(orig, origList, ts, Cell.Type.Put, false);
        byte[] fam = CellUtil.cloneFamily((Cell)((Cell)origList.get(0)));
        ArrayList famCells = Lists.newArrayList();
        m.getFamilyCellMap().put(fam, famCells);
        famCells.add(c);
        famCells.add(empty);
        return m;
    }

    private Cell getEmptyCell(Mutation orig, List<Cell> origList, Long ts, Cell.Type type, boolean verified) {
        return this.getNewCell(orig.getRow(), CellUtil.cloneFamily((Cell)origList.get(0)), this.indexMaintainer.getEmptyKeyValueQualifier(), ts, type, verified ? QueryConstants.VERIFIED_BYTES : QueryConstants.UNVERIFIED_BYTES);
    }

    private Cell getNewPutCell(Mutation orig, List<Cell> origList, Long ts, Cell.Type type) {
        return this.getNewCell(orig.getRow(), CellUtil.cloneFamily((Cell)origList.get(0)), org.apache.hadoop.hbase.util.Bytes.toBytes((String)INCLUDED_COLUMN), ts, type, org.apache.hadoop.hbase.util.Bytes.toBytes((String)"asdfg"));
    }

    private Cell getNewCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, Cell.Type type, byte[] value) {
        return CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(row).setFamily(family).setQualifier(qualifier).setTimestamp(timestamp).setType(type).setValue(value).build();
    }

    public static class UnitTestClock
    extends EnvironmentEdge {
        long initialTime;
        long delta;

        public UnitTestClock(long delta) {
            this.initialTime = System.currentTimeMillis() + delta;
            this.delta = delta;
        }

        public long currentTime() {
            return System.currentTimeMillis() + this.delta;
        }
    }

    private static enum TestType {
        VALID_EXACT_MATCH,
        VALID_MIX_MUTATIONS,
        VALID_NEW_UNVERIFIED_MUTATIONS,
        VALID_MORE_MUTATIONS,
        VALID_EXTRA_CELL,
        EXPIRED,
        INVALID_EXTRA_CELL,
        INVALID_EMPTY_CELL,
        INVALID_CELL_VALUE,
        INVALID_COLUMN;

    }
}

