/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Test;

public class IndexRebuildRegionScannerTest {
    private static final Random RAND = new Random(7L);

    @Test
    public void testGetPerTaskIndexKeyToMutationMaps() {
        int i;
        TreeMap indexKeyToMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        int MAP_SIZE = 65536;
        int REPEAT = 32;
        int MAX_SPLIT_SIZE = 32;
        for (i = 0; i < 65536; ++i) {
            byte[] indexKey = Bytes.toBytes((long)(RAND.nextLong() % 720896L));
            indexKeyToMutationMap.put(indexKey, null);
        }
        for (i = 1; i <= 32; ++i) {
            byte[][] endKeys = new byte[i][8];
            for (int j = 0; j < i - 1; ++j) {
                endKeys[j] = Bytes.toBytes((long)(RAND.nextLong() % 327680L));
            }
            endKeys[i - 1] = null;
            List mapList = IndexRebuildRegionScanner.getPerTaskIndexMutationMaps((TreeMap)indexKeyToMutationMap, (byte[][])endKeys, (int)32);
            int regionIndex = 0;
            int regionCount = i;
            for (Map map : mapList) {
                Assert.assertTrue((map.size() <= 32 ? 1 : 0) != 0);
                NavigableMap treeMap = (NavigableMap)map;
                byte[] firstKey = (byte[])treeMap.firstKey();
                while (regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(firstKey, endKeys[regionIndex]) > 0) {
                    ++regionIndex;
                }
                if (regionIndex == regionCount - 1) continue;
                Assert.assertTrue((Bytes.BYTES_COMPARATOR.compare(treeMap.lastKey(), endKeys[regionIndex]) <= 0 ? 1 : 0) != 0);
            }
            Assert.assertTrue((mapList.size() >= indexKeyToMutationMap.size() / 32 ? 1 : 0) != 0);
            Assert.assertTrue((mapList.size() <= indexKeyToMutationMap.size() / 32 + i ? 1 : 0) != 0);
        }
    }
}

