/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.end2end.index.IndexTestUtil;
import org.apache.phoenix.hbase.index.AbstractValueGetter;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class IndexMaintainerTest
extends BaseConnectionlessQueryTest {
    private static final String DEFAULT_SCHEMA_NAME = "";
    private static final String DEFAULT_TABLE_NAME = "rkTest";

    private void testIndexRowKeyBuilding(String dataColumns, String pk, String indexColumns, Object[] values) throws Exception {
        this.testIndexRowKeyBuilding(DEFAULT_SCHEMA_NAME, DEFAULT_TABLE_NAME, dataColumns, pk, indexColumns, values, DEFAULT_SCHEMA_NAME, DEFAULT_SCHEMA_NAME, DEFAULT_SCHEMA_NAME);
    }

    private void testIndexRowKeyBuilding(String dataColumns, String pk, String indexColumns, Object[] values, String includeColumns) throws Exception {
        this.testIndexRowKeyBuilding(DEFAULT_SCHEMA_NAME, DEFAULT_TABLE_NAME, dataColumns, pk, indexColumns, values, includeColumns, DEFAULT_SCHEMA_NAME, DEFAULT_SCHEMA_NAME);
    }

    private void testIndexRowKeyBuilding(String dataColumns, String pk, String indexColumns, Object[] values, String includeColumns, String dataProps, String indexProps) throws Exception {
        this.testIndexRowKeyBuilding(DEFAULT_SCHEMA_NAME, DEFAULT_TABLE_NAME, dataColumns, pk, indexColumns, values, DEFAULT_SCHEMA_NAME, dataProps, indexProps);
    }

    private static ValueGetter newValueGetter(final byte[] row, final Map<ColumnReference, byte[]> valueMap) {
        return new AbstractValueGetter(){

            public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) {
                return new ImmutableBytesPtr((byte[])valueMap.get(ref));
            }

            public byte[] getRowKey() {
                return row;
            }
        };
    }

    private void testIndexRowKeyBuilding(String schemaName, String tableName, String dataColumns, String pk, String indexColumns, Object[] values, String includeColumns, String dataProps, String indexProps) throws Exception {
        KeyValueBuilder builder = GenericKeyValueBuilder.INSTANCE;
        this.testIndexRowKeyBuilding(schemaName, tableName, dataColumns, pk, indexColumns, values, includeColumns, dataProps, indexProps, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIndexRowKeyBuilding(String schemaName, String tableName, String dataColumns, String pk, String indexColumns, Object[] values, String includeColumns, String dataProps, String indexProps, KeyValueBuilder builder) throws Exception {
        Connection conn = DriverManager.getConnection(IndexMaintainerTest.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SchemaUtil.normalizeIdentifier((String)schemaName), (String)SchemaUtil.normalizeIdentifier((String)tableName));
        String fullIndexName = SchemaUtil.getTableName((String)SchemaUtil.normalizeIdentifier((String)schemaName), (String)SchemaUtil.normalizeIdentifier((String)"idx"));
        conn.createStatement().execute("CREATE TABLE " + fullTableName + "(" + dataColumns + " CONSTRAINT pk PRIMARY KEY (" + pk + "))  " + (dataProps.isEmpty() ? DEFAULT_SCHEMA_NAME : dataProps));
        try {
            conn.createStatement().execute("CREATE INDEX idx ON " + fullTableName + "(" + indexColumns + ") " + (includeColumns.isEmpty() ? DEFAULT_SCHEMA_NAME : "INCLUDE (" + includeColumns + ") ") + (indexProps.isEmpty() ? DEFAULT_SCHEMA_NAME : indexProps));
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable table = pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName));
            PTable index = pconn.getTable(new PTableKey(pconn.getTenantId(), fullIndexName));
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            table.getIndexMaintainers(ptr, pconn);
            List c1 = IndexMaintainer.deserialize((ImmutableBytesWritable)ptr, (KeyValueBuilder)builder, (boolean)true);
            Assert.assertEquals((long)1L, (long)c1.size());
            IndexMaintainer im1 = (IndexMaintainer)c1.get(0);
            StringBuilder buf = new StringBuilder("UPSERT INTO " + fullTableName + " VALUES(");
            for (int i = 0; i < values.length; ++i) {
                buf.append("?,");
            }
            buf.setCharAt(buf.length() - 1, ')');
            PreparedStatement stmt = conn.prepareStatement(buf.toString());
            for (int i = 0; i < values.length; ++i) {
                stmt.setObject(i + 1, values[i]);
            }
            stmt.execute();
            Iterator iterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
            List dataKeyValues = (List)((Pair)iterator.next()).getSecond();
            HashMap valueMap = Maps.newHashMapWithExpectedSize((int)dataKeyValues.size());
            ImmutableBytesWritable rowKeyPtr = new ImmutableBytesWritable(((Cell)dataKeyValues.get(0)).getRowArray(), ((Cell)dataKeyValues.get(0)).getRowOffset(), (int)((Cell)dataKeyValues.get(0)).getRowLength());
            byte[] row = rowKeyPtr.copyBytes();
            Put dataMutation = new Put(row);
            for (Cell kv : dataKeyValues) {
                valueMap.put(new ColumnReference(kv.getFamilyArray(), kv.getFamilyOffset(), (int)kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength()), CellUtil.cloneValue((Cell)kv));
                dataMutation.add(kv);
            }
            ValueGetter valueGetter = IndexMaintainerTest.newValueGetter(row, valueMap);
            List<Mutation> indexMutations = IndexTestUtil.generateIndexData(index, table, (Mutation)dataMutation, ptr, builder);
            Assert.assertEquals((long)1L, (long)indexMutations.size());
            Assert.assertTrue((boolean)(indexMutations.get(0) instanceof Put));
            Mutation indexMutation = indexMutations.get(0);
            ImmutableBytesWritable indexKeyPtr = new ImmutableBytesWritable(indexMutation.getRow());
            ptr.set(rowKeyPtr.get(), rowKeyPtr.getOffset(), rowKeyPtr.getLength());
            byte[] mutablelndexRowKey = im1.buildRowKey(valueGetter, ptr, null, null, Long.MAX_VALUE);
            byte[] immutableIndexRowKey = indexKeyPtr.copyBytes();
            Assert.assertArrayEquals((byte[])immutableIndexRowKey, (byte[])mutablelndexRowKey);
            for (ColumnReference ref : im1.getCoveredColumns()) {
                valueMap.get(ref);
            }
            byte[] dataRowKey = im1.buildDataRowKey(indexKeyPtr, (byte[][])null);
            Assert.assertArrayEquals((byte[])dataRowKey, (byte[])CellUtil.cloneRow((Cell)((Cell)dataKeyValues.get(0))));
        }
        finally {
            try {
                conn.rollback();
                conn.createStatement().execute("DROP TABLE " + fullTableName);
            }
            finally {
                conn.close();
            }
        }
    }

    @Test
    public void testRowKeyVarOnlyIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 DECIMAL", "k1,k2", "k2, k1", new Object[]{"a", 1.1});
    }

    @Test
    public void testVarFixedndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER NOT NULL, v VARCHAR", "k1,k2", "k2, k1", new Object[]{"a", 1.1});
    }

    @Test
    public void testCompositeRowKeyVarFixedIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER NOT NULL, v VARCHAR", "k1,k2", "k2, k1", new Object[]{"a", 1});
    }

    @Test
    public void testCompositeRowKeyVarFixedAtEndIndex() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER NOT NULL, k3 VARCHAR, v VARCHAR", "k1,k2,k3", "k1, k3, k2", new Object[]{"a", i, "b"});
        }
    }

    @Test
    public void testSingleKeyValueIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER, v VARCHAR", "k1", "v", new Object[]{"a", 1, "b"});
    }

    @Test
    public void testMultiKeyValueIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, v2 CHAR(2), v3 BIGINT", "k1, k2", "v2, k2, v1", new Object[]{"a", 1, 2.2, "bb"});
    }

    @Test
    public void testMultiKeyValueCoveredIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, v2 CHAR(2), v3 BIGINT, v4 CHAR(10)", "k1, k2", "v2, k2, v1", new Object[]{"a", 1, 2.2, "bb"}, "v3, v4");
    }

    @Test
    public void testSingleKeyValueDescIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER, v VARCHAR", "k1", "v DESC", new Object[]{"a", 1, "b"});
    }

    @Test
    public void testCompositeRowKeyVarFixedDescIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER NOT NULL, v VARCHAR", "k1,k2", "k2 DESC, k1", new Object[]{"a", 1});
    }

    @Test
    public void testCompositeRowKeyTimeIndex() throws Exception {
        long timeInMillis = System.currentTimeMillis();
        long timeInNanos = System.nanoTime();
        Timestamp ts = new Timestamp(timeInMillis);
        ts.setNanos((int)(timeInNanos % 1000000000L));
        this.testIndexRowKeyBuilding("ts1 DATE NOT NULL, ts2 TIME NOT NULL, ts3 TIMESTAMP NOT NULL", "ts1,ts2,ts3", "ts2, ts1", new Object[]{new Date(timeInMillis), new Time(timeInMillis), ts});
    }

    @Test
    public void testCompositeRowKeyBytesIndex() throws Exception {
        long timeInMillis = System.currentTimeMillis();
        long timeInNanos = System.nanoTime();
        Timestamp ts = new Timestamp(timeInMillis);
        ts.setNanos((int)(timeInNanos % 1000000000L));
        this.testIndexRowKeyBuilding("b1 BINARY(3) NOT NULL, v VARCHAR", "b1,v", "v, b1", new Object[]{new byte[]{41, 42, 43}, "foo"});
    }

    @Test
    public void testCompositeDescRowKeyVarFixedDescIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER NOT NULL, v VARCHAR", "k1, k2 DESC", "k2 DESC, k1", new Object[]{"a", 1});
    }

    @Test
    public void testCompositeDescRowKeyVarDescIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 DECIMAL NOT NULL, v VARCHAR", "k1, k2 DESC", "k2 DESC, k1", new Object[]{"a", 1.1, "b"});
    }

    @Test
    public void testCompositeDescRowKeyVarAscIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 DECIMAL NOT NULL, v VARCHAR", "k1, k2 DESC", "k2, k1", new Object[]{"a", 1.1, "b"});
    }

    @Test
    public void testCompositeDescRowKeyVarFixedDescSaltedIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER NOT NULL, v VARCHAR", "k1, k2 DESC", "k2 DESC, k1", new Object[]{"a", 1}, DEFAULT_SCHEMA_NAME, DEFAULT_SCHEMA_NAME, "SALT_BUCKETS=4");
    }

    @Test
    public void testCompositeDescRowKeyVarFixedDescSaltedIndexSaltedTable() throws Exception {
        this.testIndexRowKeyBuilding("k1 VARCHAR, k2 INTEGER NOT NULL, v VARCHAR", "k1, k2 DESC", "k2 DESC, k1", new Object[]{"a", 1}, DEFAULT_SCHEMA_NAME, "SALT_BUCKETS=3", "SALT_BUCKETS=3");
    }

    @Test
    public void testMultiKeyValueCoveredSaltedIndex() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, v2 CHAR(2), v3 BIGINT, v4 CHAR(10)", "k1, k2", "v2 DESC, k2 DESC, v1", new Object[]{"a", 1, 2.2, "bb"}, "v3, v4", DEFAULT_SCHEMA_NAME, "SALT_BUCKETS=4");
    }

    @Test
    public void tesIndexWithBigInt() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 BIGINT, v2 CHAR(2), v3 BIGINT, v4 CHAR(10)", "k1, k2", "v1 DESC, k2 DESC", new Object[]{"a", 1, 2.2, "bb"});
    }

    @Test
    public void tesIndexWithAscBoolean() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 BOOLEAN, v2 CHAR(2), v3 BIGINT, v4 CHAR(10)", "k1, k2", "v1, k2 DESC", new Object[]{"a", 1, true, "bb"});
    }

    @Test
    public void tesIndexWithAscNullBoolean() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 BOOLEAN, v2 CHAR(2), v3 BIGINT, v4 CHAR(10)", "k1, k2", "v1, k2 DESC", new Object[]{"a", 1, null, "bb"});
    }

    @Test
    public void tesIndexWithAscFalseBoolean() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 BOOLEAN, v2 CHAR(2), v3 BIGINT, v4 CHAR(10)", "k1, k2", "v1, k2 DESC", new Object[]{"a", 1, false, "bb"});
    }

    @Test
    public void tesIndexWithDescBoolean() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 BOOLEAN, v2 CHAR(2), v3 BIGINT, v4 CHAR(10)", "k1, k2", "v1 DESC, k2 DESC", new Object[]{"a", 1, true, "bb"});
    }

    @Test
    public void tesIndexWithDescFalseBoolean() throws Exception {
        this.testIndexRowKeyBuilding("k1 CHAR(1) NOT NULL, k2 INTEGER NOT NULL, v1 BOOLEAN, v2 CHAR(2), v3 BIGINT, v4 CHAR(10)", "k1, k2", "v1 DESC, k2 DESC", new Object[]{"a", 1, false, "bb"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tesIndexedExpressionSerialization() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexMaintainerTest.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS FHA (ORGANIZATION_ID CHAR(15) NOT NULL, PARENT_ID CHAR(15) NOT NULL, CREATED_DATE DATE NOT NULL, ENTITY_HISTORY_ID CHAR(15) NOT NULL, FIELD_HISTORY_ARCHIVE_ID CHAR(15), CREATED_BY_ID VARCHAR, FIELD VARCHAR, DATA_TYPE VARCHAR, OLDVAL_STRING VARCHAR, NEWVAL_STRING VARCHAR, OLDVAL_FIRST_NAME VARCHAR, NEWVAL_FIRST_NAME VARCHAR, OLDVAL_LAST_NAME VARCHAR, NEWVAL_LAST_NAME VARCHAR, OLDVAL_NUMBER DECIMAL, NEWVAL_NUMBER DECIMAL, OLDVAL_DATE DATE,  NEWVAL_DATE DATE, ARCHIVE_PARENT_TYPE VARCHAR, ARCHIVE_FIELD_NAME VARCHAR, ARCHIVE_TIMESTAMP DATE, ARCHIVE_PARENT_NAME VARCHAR, DIVISION INTEGER, CONNECTION_ID VARCHAR CONSTRAINT PK PRIMARY KEY (ORGANIZATION_ID, PARENT_ID, CREATED_DATE DESC, ENTITY_HISTORY_ID )) VERSIONS=1,MULTI_TENANT=true");
            conn.createStatement().execute("CREATE INDEX IDX ON FHA (FIELD_HISTORY_ARCHIVE_ID, UPPER(OLDVAL_STRING) || UPPER(NEWVAL_STRING), NEWVAL_DATE - NEWVAL_DATE)");
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable table = pconn.getTable(new PTableKey(pconn.getTenantId(), "FHA"));
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            table.getIndexMaintainers(ptr, pconn);
            List indexMaintainerList = IndexMaintainer.deserialize((ImmutableBytesWritable)ptr, (KeyValueBuilder)GenericKeyValueBuilder.INSTANCE, (boolean)true);
            Assert.assertEquals((long)1L, (long)indexMaintainerList.size());
            IndexMaintainer indexMaintainer = (IndexMaintainer)indexMaintainerList.get(0);
            Set indexedColumns = indexMaintainer.getIndexedColumns();
            Assert.assertEquals((String)"Unexpected Number of indexed columns ", (long)indexedColumns.size(), (long)4L);
        }
    }

    @Test
    public void testDeleteColumnMutation() throws Exception {
        String tableName = "T_" + IndexMaintainerTest.generateUniqueName();
        String indexName1 = "I_" + IndexMaintainerTest.generateUniqueName();
        String indexName2 = "I_" + IndexMaintainerTest.generateUniqueName();
        String ddl = String.format("create table %s (id varchar primary key, col1 varchar, col2 varchar, col3 bigint)", tableName);
        String index1 = String.format("create index %s on %s (col2) include (col1) ", indexName1, tableName);
        String index2 = String.format("create index %s on %s (col2) include (col1) COLUMN_ENCODED_BYTES=2, IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS", indexName2, tableName);
        try (Connection conn = DriverManager.getConnection(IndexMaintainerTest.getUrl());){
            conn.createStatement().execute(ddl);
            conn.createStatement().execute(index1);
            conn.createStatement().execute(index2);
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable table = pconn.getTable(tableName);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            table.getIndexMaintainers(ptr, pconn);
            List ims = IndexMaintainer.deserialize((ImmutableBytesWritable)ptr, (KeyValueBuilder)GenericKeyValueBuilder.INSTANCE, (boolean)true);
            Assert.assertEquals((long)2L, (long)ims.size());
            String dml = String.format("upsert into %s values ('a', 'ab', 'abc', 2)", tableName);
            IndexMaintainerTest.assertDeleteColumnMutation(tableName, dml, false, pconn, ims);
            pconn.getMutationState().rollback();
            dml = String.format("upsert into %s (id, col2) values  ('a', 'ab')", tableName);
            IndexMaintainerTest.assertDeleteColumnMutation(tableName, dml, true, pconn, ims);
            pconn.getMutationState().rollback();
        }
    }

    private static void assertDeleteColumnMutation(String tableName, String dml, boolean isPartialUpdate, PhoenixConnection pconn, List<IndexMaintainer> ims) throws Exception {
        pconn.createStatement().execute(dml);
        Iterator iterator = pconn.getMutationState().toMutations();
        while (iterator.hasNext()) {
            Pair mutationPair = (Pair)iterator.next();
            List batchMutations = (List)mutationPair.getSecond();
            Assert.assertEquals((long)1L, (long)batchMutations.size());
            Assert.assertTrue((boolean)(batchMutations.get(0) instanceof Put));
            Put dataRow = (Put)batchMutations.get(0);
            IndexUtil.SimpleValueGetter nextDataRowVG = new IndexUtil.SimpleValueGetter(dataRow);
            long ts = EnvironmentEdgeManager.currentTimeMillis();
            ImmutableBytesPtr rowKey = new ImmutableBytesPtr(dataRow.getRow());
            for (IndexMaintainer im : ims) {
                Put indexPut = im.buildUpdateMutation(GenericKeyValueBuilder.INSTANCE, (ValueGetter)nextDataRowVG, (ImmutableBytesWritable)rowKey, ts, null, null, false, null);
                if (indexPut == null) {
                    byte[] indexRowKey = im.buildRowKey((ValueGetter)nextDataRowVG, (ImmutableBytesWritable)rowKey, null, null, ts, null);
                    indexPut = new Put(indexRowKey);
                }
                indexPut.addColumn(im.getEmptyKeyValueFamily().copyBytesIfNecessary(), im.getEmptyKeyValueQualifier(), ts, QueryConstants.UNVERIFIED_BYTES);
                Delete deleteCol = im.buildDeleteColumnMutation(indexPut, ts);
                if (im.getIndexStorageScheme() == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                    Assert.assertNull((Object)deleteCol);
                    continue;
                }
                if (isPartialUpdate) {
                    Assert.assertNotNull((Object)deleteCol);
                    continue;
                }
                Assert.assertNull((Object)deleteCol);
            }
        }
    }
}

