/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write.recovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.recovery.PerRegionIndexWriteCache;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestPerRegionIndexWriteCache {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName tableName = TableName.valueOf((String)"t1");
    private static final byte[] row = Bytes.toBytes((String)"row");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qual = Bytes.toBytes((String)"qual");
    private static final byte[] val = Bytes.toBytes((String)"val");
    private static MiniDFSCluster miniDfs = null;
    Put p = new Put(row);
    Put p2 = new Put(Bytes.toBytes((String)"other row"));
    HRegion r1;
    HRegion r2;
    WAL wal;
    @Rule
    public TestName testName;

    public TestPerRegionIndexWriteCache() {
        this.p.addColumn(family, qual, val);
        this.p2.addColumn(family, qual, val);
        this.testName = new TestName();
    }

    @BeforeClass
    public static synchronized void startDfs() throws Exception {
        miniDfs = TEST_UTIL.startMiniDFSCluster(1);
    }

    @AfterClass
    public static synchronized void stopDfs() throws Exception {
        if (miniDfs != null) {
            miniDfs.shutdown();
            miniDfs = null;
        }
    }

    @Before
    public void setUp() throws Exception {
        Path hbaseRootDir = new Path(this.getClass().getSimpleName() + "_" + this.testName.getMethodName());
        TEST_UTIL.getConfiguration().set("hbase.rootdir", hbaseRootDir.toString());
        DistributedFileSystem newFS = miniDfs.getFileSystem();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(null).setEndKey(null).setSplit(false).build();
        Path basedir = CommonFSUtils.getTableDir((Path)hbaseRootDir, (TableName)tableName);
        Random rn = new Random();
        tableName = TableName.valueOf((String)("TestPerRegion" + rn.nextInt()));
        WALFactory walFactory = new WALFactory(TEST_UTIL.getConfiguration(), this.getClass().getSimpleName());
        this.wal = walFactory.getWAL(RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"logs")).build());
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).addColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"a")).build()).build();
        this.r1 = new HRegion(basedir, this.wal, (FileSystem)newFS, TEST_UTIL.getConfiguration(), hri, htd, null){

            public int hashCode() {
                return 1;
            }

            public String toString() {
                return "testRegion1";
            }
        };
        this.r2 = new HRegion(basedir, this.wal, (FileSystem)newFS, TEST_UTIL.getConfiguration(), hri, htd, null){

            public int hashCode() {
                return 2;
            }

            public String toString() {
                return "testRegion1";
            }
        };
    }

    @After
    public void cleanUp() throws Exception {
        try {
            this.r1.close();
            this.r2.close();
            this.wal.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileSystem newFS = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        newFS.delete(TEST_UTIL.getDataTestDir(), true);
    }

    @Test
    public void testAddRemoveSingleRegion() {
        PerRegionIndexWriteCache cache = new PerRegionIndexWriteCache();
        HTableInterfaceReference t1 = new HTableInterfaceReference(new ImmutableBytesPtr(Bytes.toBytes((String)"t1")));
        ArrayList<Put> mutations = new ArrayList<Put>();
        mutations.add(this.p);
        cache.addEdits((Region)this.r1, t1, mutations);
        Multimap edits = cache.getEdits((Region)this.r1);
        Set entries = edits.asMap().entrySet();
        Assert.assertEquals((String)"Got more than one table in the the edit map!", (long)1L, (long)entries.size());
        for (Map.Entry entry : entries) {
            List stored = (List)entry.getValue();
            Assert.assertEquals((String)"Got an unexpected amount of mutations in the entry", (long)1L, (long)stored.size());
            Assert.assertEquals((String)"Got an unexpected mutation in the entry", (Object)this.p, stored.get(0));
        }
        Assert.assertNull((String)"Got an entry for a region we removed", (Object)cache.getEdits((Region)this.r1));
    }

    @Test
    public void testMultipleAddsForSingleRegion() {
        PerRegionIndexWriteCache cache = new PerRegionIndexWriteCache();
        HTableInterfaceReference t1 = new HTableInterfaceReference(new ImmutableBytesPtr(Bytes.toBytes((String)"t1")));
        ArrayList mutations = Lists.newArrayList((Object[])new Mutation[]{this.p});
        cache.addEdits((Region)this.r1, t1, (Collection)mutations);
        mutations = Lists.newArrayList((Object[])new Mutation[]{this.p2});
        cache.addEdits((Region)this.r1, t1, (Collection)mutations);
        Multimap edits = cache.getEdits((Region)this.r1);
        Set entries = edits.asMap().entrySet();
        Assert.assertEquals((String)"Got more than one table in the the edit map!", (long)1L, (long)entries.size());
        for (Map.Entry entry : entries) {
            List stored = (List)entry.getValue();
            Assert.assertEquals((String)"Got an unexpected amount of mutations in the entry", (long)2L, (long)stored.size());
            Assert.assertEquals((String)"Got an unexpected mutation in the entry", (Object)this.p, stored.get(0));
            Assert.assertEquals((String)"Got an unexpected mutation in the entry", (Object)this.p2, stored.get(1));
        }
    }

    @Test
    public void testMultipleRegions() {
        List stored;
        PerRegionIndexWriteCache cache = new PerRegionIndexWriteCache();
        HTableInterfaceReference t1 = new HTableInterfaceReference(new ImmutableBytesPtr(Bytes.toBytes((String)"t1")));
        ArrayList mutations = Lists.newArrayList((Object[])new Mutation[]{this.p});
        ArrayList m2 = Lists.newArrayList((Object[])new Mutation[]{this.p2});
        cache.addEdits((Region)this.r1, t1, (Collection)mutations);
        cache.addEdits((Region)this.r2, t1, (Collection)m2);
        Multimap edits = cache.getEdits((Region)this.r1);
        Set entries = edits.asMap().entrySet();
        Assert.assertEquals((String)"Got more than one table in the the edit map!", (long)1L, (long)entries.size());
        for (Map.Entry entry : entries) {
            stored = (List)entry.getValue();
            Assert.assertEquals((String)"Got an unexpected amount of mutations in the entry for region1", (long)1L, (long)stored.size());
            Assert.assertEquals((String)"Got an unexpected mutation in the entry for region2", (Object)this.p, stored.get(0));
        }
        edits = cache.getEdits((Region)this.r2);
        entries = edits.asMap().entrySet();
        Assert.assertEquals((String)"Got more than one table in the the edit map!", (long)1L, (long)entries.size());
        for (Map.Entry entry : entries) {
            stored = (List)entry.getValue();
            Assert.assertEquals((String)"Got an unexpected amount of mutations in the entry for region2", (long)1L, (long)stored.size());
            Assert.assertEquals((String)"Got an unexpected mutation in the entry for region2", (Object)this.p2, stored.get(0));
        }
        Assert.assertNull((String)"Got an entry for a region we removed", (Object)cache.getEdits((Region)this.r1));
    }
}

