/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.hbase.index.write.TrackingParallelWriterIndexCommitter;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTrackingParallelWriterIndexCommitter
extends TrackingParallelWriterIndexCommitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestTrackingParallelWriterIndexCommitter.class);
    private HTableFactory testFactory;

    void setup(HTableFactory factory, ExecutorService pool, Stoppable stop, RegionCoprocessorEnvironment env) {
        LOGGER.info("Setting up TestCoprocessorHConnectionTableFactory ");
        this.testFactory = new TestCoprocessorHConnectionTableFactory(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION_WITH_CUSTOM_THREADS);
        super.setup(this.testFactory, pool, stop, env);
    }

    public void stop(String why) {
        LOGGER.info("Stopping TestTrackingParallelWriterIndexCommitter " + why);
        this.testFactory.shutdown();
        super.stop(why);
    }

    public static class TestCoprocessorHConnectionTableFactory
    extends IndexWriterUtils.CoprocessorHConnectionTableFactory {
        @GuardedBy(value="TestCoprocessorHConnectionTableFactory.this")
        private RegionCoprocessorEnvironment env;
        private ServerUtil.ConnectionType connectionType;

        TestCoprocessorHConnectionTableFactory(RegionCoprocessorEnvironment env, ServerUtil.ConnectionType connectionType) {
            super(env, connectionType);
            this.env = env;
            this.connectionType = connectionType;
        }

        public Connection getConnection() throws IOException {
            return TestConnectionFactory.getConnection(this.connectionType, this.env);
        }

        public synchronized void shutdown() {
            TestConnectionFactory.shutdown();
        }
    }

    public static class TestConnectionFactory
    extends ServerUtil.ConnectionFactory {
        private static Map<ServerUtil.ConnectionType, Connection> connections = new ConcurrentHashMap<ServerUtil.ConnectionType, Connection>();

        public static Connection getConnection(final ServerUtil.ConnectionType connectionType, final RegionCoprocessorEnvironment env) {
            String key = String.format("%s-%s", env.getServerName(), connectionType.name().toLowerCase());
            LOGGER.info("Connecting to {}", (Object)key);
            return connections.computeIfAbsent(connectionType, new Function<ServerUtil.ConnectionType, Connection>(){

                @Override
                public Connection apply(ServerUtil.ConnectionType t) {
                    try {
                        return env.createConnection(ServerUtil.ConnectionFactory.getTypeSpecificConfiguration((ServerUtil.ConnectionType)connectionType, (Configuration)env.getConfiguration()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void shutdown() {
            Class<ServerUtil.ConnectionFactory> clazz = ServerUtil.ConnectionFactory.class;
            synchronized (ServerUtil.ConnectionFactory.class) {
                for (Connection connection : connections.values()) {
                    try {
                        LOGGER.info("Closing connection to {}", (Object)connection.getClusterId());
                        connection.close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Unable to close coprocessor connection", (Throwable)e);
                    }
                }
                connections.clear();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static int getConnectionsCount() {
            return connections.size();
        }
    }
}

