/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.parallel;

import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.hbase.index.IndexTableName;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestThreadPoolBuilder {
    @Rule
    public IndexTableName name = new IndexTableName();

    @Test
    public void testCoreThreadTimeoutNonZero() {
        Configuration conf = new Configuration(false);
        String key = this.name.getTableNameString() + "-key";
        ThreadPoolBuilder builder = new ThreadPoolBuilder(this.name.getTableNameString(), conf);
        Assert.assertTrue((String)"core threads not set, but failed return", (builder.getKeepAliveTime() > 0L ? 1 : 0) != 0);
        builder.setCoreTimeout(key, -1L);
        Assert.assertTrue((String)"core threads not set, but failed return", (builder.getKeepAliveTime() > 0L ? 1 : 0) != 0);
        builder.setCoreTimeout(key, 1234L);
        Assert.assertEquals((String)"core threads not set, but failed return", (long)1234L, (long)builder.getKeepAliveTime());
        builder.setCoreTimeout(key);
        Assert.assertTrue((String)"core threads not set, but failed return", (builder.getKeepAliveTime() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMaxThreadsNonZero() {
        Configuration conf = new Configuration(false);
        String key = this.name.getTableNameString() + "-key";
        ThreadPoolBuilder builder = new ThreadPoolBuilder(this.name.getTableNameString(), conf);
        Assert.assertTrue((String)"core threads not set, but failed return", (builder.getMaxThreads() > 0 ? 1 : 0) != 0);
        builder.setMaxThread(key, -1);
        Assert.assertTrue((String)"core threads not set, but failed return", (builder.getMaxThreads() > 0 ? 1 : 0) != 0);
        builder.setMaxThread(key, 1234);
        Assert.assertEquals((String)"core threads not set, but failed return", (long)1234L, (long)builder.getMaxThreads());
    }
}

