/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.parallel;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.WaitForCompletionTaskRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskRunner {
    @Test
    public void testWaitForCompletionTaskRunner() throws Exception {
        WaitForCompletionTaskRunner tr = new WaitForCompletionTaskRunner(Executors.newFixedThreadPool(4));
        TaskBatch tasks = new TaskBatch(4);
        for (int i = 0; i < 4; ++i) {
            tasks.add((Task)new EvenNumberFailingTask(i));
        }
        Pair resultAndFutures = tr.submitUninterruptible(tasks);
        List results = (List)resultAndFutures.getFirst();
        List futures = (List)resultAndFutures.getSecond();
        for (int j = 0; j < 4; ++j) {
            if (j % 2 == 0) {
                Assert.assertNull(results.get(j));
                try {
                    ((Future)futures.get(j)).get();
                    Assert.fail((String)"Should have received ExecutionException");
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof ExecutionException));
                    Assert.assertTrue((boolean)e.getCause().getMessage().equals("Even number task"));
                }
                continue;
            }
            Assert.assertTrue((boolean)((Boolean)results.get(j)));
        }
    }

    private static class EvenNumberFailingTask
    extends Task<Boolean> {
        private int num;

        public EvenNumberFailingTask(int i) {
            this.num = i;
        }

        public Boolean call() throws Exception {
            if (this.num % 2 == 0) {
                throw new IOException("Even number task");
            }
            return Boolean.TRUE;
        }
    }
}

