/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.update.IndexUpdateManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestIndexUpdateManager {
    private static final byte[] row = Bytes.toBytes((String)"row");
    private static final String TABLE_NAME = "table";
    private static final byte[] table = Bytes.toBytes((String)"table");
    private IndexMetaData mockIndexMetaData;

    @Before
    public void setup() {
        this.mockIndexMetaData = (IndexMetaData)Mockito.mock(IndexMetaData.class);
        Mockito.when((Object)this.mockIndexMetaData.getReplayWrite()).thenReturn(null);
    }

    @Test
    public void testMutationComparator() throws Exception {
        IndexUpdateManager manager = new IndexUpdateManager(this.mockIndexMetaData);
        Comparator comparator = manager.COMPARATOR;
        Put p = new Put(row, 10L);
        Put p1 = new Put(Bytes.toBytes((String)"ro"), 10L);
        Assert.assertTrue((String)"lexigraphically later sorting first, should be earlier first.", (comparator.compare(p, p1) > 0 ? 1 : 0) != 0);
        p1 = new Put(Bytes.toBytes((String)"row1"), 10L);
        Assert.assertTrue((String)"lexigraphically later sorting first, should be earlier first.", (comparator.compare(p1, p) > 0 ? 1 : 0) != 0);
        p1 = new Put(row, 11L);
        Assert.assertTrue((String)"Smaller timestamp sorting first, should be larger first.", (comparator.compare(p, p1) > 0 ? 1 : 0) != 0);
        Delete d = new Delete(row, 11L);
        Assert.assertTrue((String)"Smaller timestamp sorting first, should be larger first.", (comparator.compare(p, d) > 0 ? 1 : 0) != 0);
        d = new Delete(row, 10L);
        Assert.assertTrue((String)"Delete doesn't sort before put, for the same row and ts", (comparator.compare(p, d) > 0 ? 1 : 0) != 0);
        d = new Delete(Bytes.toBytes((String)"row1"), 10L);
        Assert.assertTrue((String)"Delete doesn't sort before put, for the same row and ts", (comparator.compare(p, d) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCancelingUpdates() throws Exception {
        IndexUpdateManager manager = new IndexUpdateManager(this.mockIndexMetaData);
        long ts1 = 10L;
        long ts2 = 11L;
        Delete d = new Delete(row, ts1);
        Put p = new Put(row, ts2);
        manager.addIndexUpdate(table, (Mutation)d);
        manager.addIndexUpdate(table, (Mutation)p);
        ArrayList<Mutation> pending = new ArrayList<Mutation>();
        pending.add((Mutation)p);
        pending.add((Mutation)d);
        this.validate(manager, pending);
        Delete d2 = new Delete(row, ts2);
        manager.addIndexUpdate(table, (Mutation)d2);
        pending.add((Mutation)d);
        this.validate(manager, pending);
        Delete d3 = new Delete(row, ts2);
        manager.addIndexUpdate(table, (Mutation)d3);
        pending.add((Mutation)d);
        this.validate(manager, pending);
        manager = new IndexUpdateManager(this.mockIndexMetaData);
        manager.addIndexUpdate(table, (Mutation)d2);
        manager.addIndexUpdate(table, (Mutation)p);
        this.validate(manager, Collections.emptyList());
        manager = new IndexUpdateManager(this.mockIndexMetaData);
        manager.addIndexUpdate(table, (Mutation)p);
        byte[] row1 = Bytes.toBytes((String)"row1");
        Put p1 = new Put(row1, ts1);
        manager.addIndexUpdate(table, (Mutation)p1);
        Delete d4 = new Delete(row1, ts1);
        manager.addIndexUpdate(table, (Mutation)d4);
        pending.clear();
        pending.add((Mutation)p);
        this.validate(manager, pending);
    }

    private void validate(IndexUpdateManager manager, List<Mutation> pending) {
        for (Pair entry : manager.toMap()) {
            Assert.assertEquals((String)"Table name didn't match for stored entry!", (Object)table, (Object)entry.getSecond());
            Mutation m = pending.remove(0);
            Assert.assertTrue((String)("Didn't get the expected mutation! Expected: " + m + ", but got: " + entry.getFirst()), (m == entry.getFirst() ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("Missing pending updates: " + pending), (boolean)pending.isEmpty());
    }
}

