/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.data;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.data.DelegateComparator;
import org.apache.phoenix.hbase.index.covered.data.IndexMemStore;
import org.apache.phoenix.hbase.index.scanner.ReseekableScanner;
import org.junit.Assert;
import org.junit.Test;

public class TestIndexMemStore {
    private static final byte[] row = Bytes.toBytes((String)"row");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qual = Bytes.toBytes((String)"qual");
    private static final byte[] val = Bytes.toBytes((String)"val");
    private static final byte[] val2 = Bytes.toBytes((String)"val2");

    @Test
    public void testCorrectOverwritting() throws Exception {
        IndexMemStore store = new IndexMemStore((CellComparator)new DelegateComparator((CellComparator)new CellComparatorImpl()){

            public int compare(Cell leftCell, Cell rightCell) {
                return super.compare(leftCell, rightCell, true);
            }
        });
        long ts = 10L;
        KeyValue kv = new KeyValue(row, family, qual, ts, KeyValue.Type.Put, val);
        kv.setSequenceId(2L);
        KeyValue kv2 = new KeyValue(row, family, qual, ts, KeyValue.Type.Put, val2);
        kv2.setSequenceId(0L);
        store.add((Cell)kv, true);
        store.add((Cell)kv2, false);
        ReseekableScanner scanner = store.getScanner();
        KeyValue first = KeyValueUtil.createFirstOnRow((byte[])row);
        scanner.seek((Cell)first);
        Assert.assertTrue((String)"Overwrote kv when specifically not!", (kv == scanner.next() ? 1 : 0) != 0);
        scanner.close();
        store.add((Cell)kv2, true);
        scanner = store.getScanner();
        scanner.seek((Cell)first);
        Assert.assertTrue((String)"Didn't overwrite kv when specifically requested!", (kv2 == scanner.next() ? 1 : 0) != 0);
        scanner.close();
    }

    @Test
    public void testExpectedOrdering() throws Exception {
        IndexMemStore store = new IndexMemStore();
        KeyValue kv = new KeyValue(row, family, qual, 12L, KeyValue.Type.Put, val);
        store.add((Cell)kv, true);
        KeyValue kv2 = new KeyValue(row, family, qual, 10L, KeyValue.Type.Put, val2);
        store.add((Cell)kv2, true);
        KeyValue df = new KeyValue(row, family, null, 11L, KeyValue.Type.DeleteFamily, null);
        store.add((Cell)df, true);
        KeyValue dc = new KeyValue(row, family, qual, 11L, KeyValue.Type.DeleteColumn, null);
        store.add((Cell)dc, true);
        KeyValue d = new KeyValue(row, family, qual, 12L, KeyValue.Type.Delete, null);
        store.add((Cell)d, true);
        ReseekableScanner scanner = store.getScanner();
        KeyValue first = KeyValueUtil.createFirstOnRow((byte[])row);
        Assert.assertTrue((String)"Didn't have any data in the scanner", (boolean)scanner.seek((Cell)first));
        Assert.assertTrue((String)"Didn't get delete family first (no qualifier == sort first)", (df == scanner.next() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Didn't get point delete before corresponding put", (d == scanner.next() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Didn't get larger ts Put", (kv == scanner.next() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Didn't get delete column before corresponding put(delete sorts first)", (dc == scanner.next() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Didn't get smaller ts Put", (kv2 == scanner.next() ? 1 : 0) != 0);
        Assert.assertNull((String)"Have more data in the scanner", (Object)scanner.next());
    }
}

