/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.ColumnGroup;
import org.apache.phoenix.hbase.index.covered.CoveredColumn;
import org.apache.phoenix.hbase.index.covered.CoveredColumnIndexCodec;
import org.apache.phoenix.hbase.index.covered.IndexCodec;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.LocalTableState;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCoveredColumnIndexCodec {
    private static final byte[] PK = new byte[]{97};
    private static final String FAMILY_STRING = "family";
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] QUAL = Bytes.toBytes((String)"qual");
    private static final CoveredColumn COLUMN_REF = new CoveredColumn("family", QUAL);
    private static final byte[] EMPTY_INDEX_KEY = CoveredColumnIndexCodec.composeRowKey(PK, 0, Arrays.asList(TestCoveredColumnIndexCodec.toColumnEntry(new byte[0])));
    private static final byte[] BLANK_INDEX_KEY = CoveredColumnIndexCodec.composeRowKey(PK, 0, Collections.emptyList());

    private static CoveredColumnIndexCodec.ColumnEntry toColumnEntry(byte[] bytes) {
        return new CoveredColumnIndexCodec.ColumnEntry(bytes, COLUMN_REF);
    }

    @Test
    public void toFromIndexKey() throws Exception {
        byte[] indexKey = BLANK_INDEX_KEY;
        List<byte[]> stored = CoveredColumnIndexCodec.getValues(indexKey);
        Assert.assertEquals((String)"Found some stored values in an index row key that wasn't created with values!", (long)0L, (long)stored.size());
        indexKey = EMPTY_INDEX_KEY;
        stored = CoveredColumnIndexCodec.getValues(indexKey);
        Assert.assertEquals((String)"Found some stored values in an index row key that wasn't created with values!", (long)1L, (long)stored.size());
        Assert.assertEquals((String)("Found a non-zero length value: " + Bytes.toString((byte[])stored.get(0))), (long)0L, (long)stored.get(0).length);
        byte[] v1 = new byte[]{97};
        byte[] v2 = new byte[]{98};
        byte[] v3 = Bytes.toBytes((String)"v3");
        int len = v1.length + v2.length + v3.length;
        indexKey = CoveredColumnIndexCodec.composeRowKey(PK, len, Arrays.asList(TestCoveredColumnIndexCodec.toColumnEntry(v1), TestCoveredColumnIndexCodec.toColumnEntry(v2), TestCoveredColumnIndexCodec.toColumnEntry(v3)));
        stored = CoveredColumnIndexCodec.getValues(indexKey);
        Assert.assertEquals((String)"Didn't find expected number of values in index key!", (long)3L, (long)stored.size());
        Assert.assertTrue((String)"First index keys don't match!", (boolean)Bytes.equals((byte[])v1, (byte[])stored.get(0)));
        Assert.assertTrue((String)"Second index keys don't match!", (boolean)Bytes.equals((byte[])v2, (byte[])stored.get(1)));
        Assert.assertTrue((String)"Third index keys don't match!", (boolean)Bytes.equals((byte[])v3, (byte[])stored.get(2)));
    }

    @Test
    public void testCheckRowKeyForAllNulls() {
        byte[] pk = new byte[]{97, 98, 122};
        byte[] result = EMPTY_INDEX_KEY;
        Assert.assertTrue((String)"Didn't correctly read single element as being null in row key", (boolean)CoveredColumnIndexCodec.checkRowKeyForAllNulls(result));
        result = CoveredColumnIndexCodec.composeRowKey(pk, 0, Lists.newArrayList((Object[])new CoveredColumnIndexCodec.ColumnEntry[]{TestCoveredColumnIndexCodec.toColumnEntry(new byte[0]), TestCoveredColumnIndexCodec.toColumnEntry(new byte[0])}));
        Assert.assertTrue((String)"Didn't correctly read two elements as being null in row key", (boolean)CoveredColumnIndexCodec.checkRowKeyForAllNulls(result));
        result = CoveredColumnIndexCodec.composeRowKey(pk, 2, Arrays.asList(TestCoveredColumnIndexCodec.toColumnEntry(new byte[]{1, 2})));
        Assert.assertFalse((String)"Found a null key, when it wasn't!", (boolean)CoveredColumnIndexCodec.checkRowKeyForAllNulls(result));
        result = CoveredColumnIndexCodec.composeRowKey(pk, 2, Arrays.asList(TestCoveredColumnIndexCodec.toColumnEntry(new byte[]{1, 2}), TestCoveredColumnIndexCodec.toColumnEntry(new byte[0])));
        Assert.assertFalse((String)"Found a null key, when it wasn't!", (boolean)CoveredColumnIndexCodec.checkRowKeyForAllNulls(result));
    }

    @Test
    public void testGeneratedIndexUpdates() throws Exception {
        ColumnGroup group = new ColumnGroup("test-column-group");
        group.add(COLUMN_REF);
        Result emptyState = Result.create(Collections.emptyList());
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Configuration conf = new Configuration(false);
        Mockito.when((Object)env.getConfiguration()).thenReturn((Object)conf);
        SimpleTableState table = new SimpleTableState(emptyState);
        CoveredColumnIndexCodec codec = CoveredColumnIndexCodec.getCodecForTesting(Arrays.asList(group));
        Put p = new Put(PK);
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        byte[] v1 = Bytes.toBytes((String)"v1");
        KeyValue kv = new KeyValue(PK, FAMILY, QUAL, 1L, v1);
        kvs.add((Cell)kv);
        p.add((Cell)kv);
        byte[] v2 = Bytes.toBytes((String)"v2");
        kv = new KeyValue(PK, Bytes.toBytes((String)"family2"), QUAL, 1L, v2);
        kvs.add((Cell)kv);
        p.add((Cell)kv);
        LocalTableState state = new LocalTableState((LocalHBaseState)table, (Mutation)p);
        Iterable<IndexUpdate> updates = codec.getIndexDeletes((TableState)state, IndexMetaData.NULL_INDEX_META_DATA, null, null);
        Assert.assertFalse((String)"Found index updates without any existing kvs in table!", (boolean)updates.iterator().next().isValid());
        state.setCurrentTimestamp(1L);
        state.addPendingUpdates(kvs);
        updates = codec.getIndexUpserts((TableState)state, IndexMetaData.NULL_INDEX_META_DATA, null, null, false);
        Assert.assertTrue((String)"Didn't find index updates for pending primary table update!", (boolean)updates.iterator().hasNext());
        for (IndexUpdate update : updates) {
            Assert.assertTrue((String)"Update marked as invalid, but should be a pending index write!", (boolean)update.isValid());
            Put m = (Put)update.getUpdate();
            byte[] expected = CoveredColumnIndexCodec.composeRowKey(PK, v1.length, Arrays.asList(TestCoveredColumnIndexCodec.toColumnEntry(v1)));
            Assert.assertArrayEquals((String)"Didn't get expected index value", (byte[])expected, (byte[])m.getRow());
        }
        Delete d = new Delete(PK, 2L);
        d.addFamily(FAMILY, 2L);
        table = new SimpleTableState(Result.create(kvs));
        state = new LocalTableState((LocalHBaseState)table, (Mutation)d);
        state.setCurrentTimestamp(2L);
        updates = codec.getIndexDeletes((TableState)state, IndexMetaData.NULL_INDEX_META_DATA, null, null);
        for (IndexUpdate update : updates) {
            Assert.assertTrue((String)"Didn't have any index cleanup, even though there is current state", (boolean)update.isValid());
            Delete m = (Delete)update.getUpdate();
            byte[] expected = CoveredColumnIndexCodec.composeRowKey(PK, v1.length, Arrays.asList(TestCoveredColumnIndexCodec.toColumnEntry(v1)));
            Assert.assertArrayEquals((String)"Didn't get expected index value", (byte[])expected, (byte[])m.getRow());
        }
        this.ensureNoUpdatesWhenCoveredByDelete(env, (IndexCodec)codec, kvs, d);
        d = new Delete(PK, 2L);
        d.addColumns(FAMILY, QUAL, 2L);
        this.ensureNoUpdatesWhenCoveredByDelete(env, (IndexCodec)codec, kvs, d);
        d = new Delete(PK, 1L);
        d.addColumn(FAMILY, QUAL, 1L);
        this.ensureNoUpdatesWhenCoveredByDelete(env, (IndexCodec)codec, kvs, d);
    }

    private void ensureNoUpdatesWhenCoveredByDelete(RegionCoprocessorEnvironment env, IndexCodec codec, List<Cell> currentState, Delete d) throws IOException {
        SimpleTableState table = new SimpleTableState(Result.create(currentState));
        LocalTableState state = new LocalTableState((LocalHBaseState)table, (Mutation)d);
        state.setCurrentTimestamp(d.getTimestamp());
        state.addPendingUpdates((List)d.getFamilyCellMap().get(FAMILY));
        Iterable updates = codec.getIndexUpserts((TableState)state, IndexMetaData.NULL_INDEX_META_DATA, null, null, false);
        for (IndexUpdate update : updates) {
            Assert.assertFalse((String)"Had some index updates, though it should have been covered by the delete", (boolean)update.isValid());
        }
    }

    private static class SimpleTableState
    implements LocalHBaseState {
        private Result r;

        public SimpleTableState(Result r) {
            this.r = r;
        }

        public List<Cell> getCurrentRowState(Mutation m, Collection<? extends ColumnReference> toCover, boolean preMutationStateOnly) throws IOException {
            return this.r.listCells();
        }
    }
}

