/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessorclient.BaseScannerRegionObserverConstants;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.LocalTableState;
import org.apache.phoenix.hbase.index.covered.data.CachedLocalTable;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.scanner.Scanner;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.util.ScanUtil;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LocalTableStateTest {
    private static final byte[] row = Bytes.toBytes((String)"row");
    private static final byte[] fam = Bytes.toBytes((String)"fam");
    private static final byte[] qual = Bytes.toBytes((String)"qual");
    private static final byte[] val = Bytes.toBytes((String)"val");
    private static final long ts = 10L;
    private static final IndexMetaData indexMetaData = new IndexMetaData(){

        public BaseScannerRegionObserverConstants.ReplayWrite getReplayWrite() {
            return null;
        }

        public boolean requiresPriorRowState(Mutation m) {
            return true;
        }

        public int getClientVersion() {
            return ScanUtil.UNKNOWN_CLIENT_VERSION;
        }
    };

    @Test
    public void testCorrectOrderingWithLazyLoadingColumns() throws Exception {
        Put m = new Put(row);
        m.addColumn(fam, qual, 10L, val);
        Configuration conf = new Configuration(false);
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Mockito.when((Object)env.getConfiguration()).thenReturn((Object)conf);
        Region region = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)env.getRegion()).thenReturn((Object)region);
        byte[] stored = Bytes.toBytes((String)"stored-value");
        KeyValue kv = new KeyValue(row, fam, qual, 10L, KeyValue.Type.Put, stored);
        kv.setSequenceId(0L);
        HashMap<ImmutableBytesPtr, List<KeyValue>> rowKeyPtrToCells = new HashMap<ImmutableBytesPtr, List<KeyValue>>();
        rowKeyPtrToCells.put(new ImmutableBytesPtr(row), Collections.singletonList(kv));
        CachedLocalTable cachedLocalTable = CachedLocalTable.build(rowKeyPtrToCells);
        LocalTableState table = new LocalTableState((LocalHBaseState)cachedLocalTable, (Mutation)m);
        table.addPendingUpdates(m.get(fam, qual));
        ColumnReference col = new ColumnReference(fam, qual);
        table.setCurrentTimestamp(10L);
        Pair p = table.getIndexedColumnsTableState(Arrays.asList(col), false, false, indexMetaData);
        Scanner s = (Scanner)p.getFirst();
        Assert.assertEquals((String)"Didn't get the pending mutation's value first", m.get(fam, qual).get(0), (Object)s.next());
    }

    @Test
    public void testNoScannerForImmutableRows() throws Exception {
        IndexMetaData indexMetaData = new IndexMetaData(){

            public BaseScannerRegionObserverConstants.ReplayWrite getReplayWrite() {
                return null;
            }

            public boolean requiresPriorRowState(Mutation m) {
                return false;
            }

            public int getClientVersion() {
                return ScanUtil.UNKNOWN_CLIENT_VERSION;
            }
        };
        Put m = new Put(row);
        m.addColumn(fam, qual, 10L, val);
        Configuration conf = new Configuration(false);
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Mockito.when((Object)env.getConfiguration()).thenReturn((Object)conf);
        Region region = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)env.getRegion()).thenReturn((Object)region);
        CachedLocalTable cachedLocalTable = CachedLocalTable.build(null);
        LocalTableState table = new LocalTableState((LocalHBaseState)cachedLocalTable, (Mutation)m);
        table.addPendingUpdates(m.get(fam, qual));
        ColumnReference col = new ColumnReference(fam, qual);
        table.setCurrentTimestamp(10L);
        Pair p = table.getIndexedColumnsTableState(Arrays.asList(col), false, false, indexMetaData);
        Scanner s = (Scanner)p.getFirst();
        Assert.assertEquals((String)"Didn't get the pending mutation's value first", m.get(fam, qual).get(0), (Object)s.next());
    }

    @Test
    public void testCorrectRollback() throws Exception {
        Put m = new Put(row);
        m.addColumn(fam, qual, 10L, val);
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Region region = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)env.getRegion()).thenReturn((Object)region);
        byte[] stored = Bytes.toBytes((String)"stored-value");
        KeyValue storedKv = new KeyValue(row, fam, qual, 10L, KeyValue.Type.Put, stored);
        storedKv.setSequenceId(2L);
        HashMap<ImmutableBytesPtr, List<KeyValue>> rowKeyPtrToCells = new HashMap<ImmutableBytesPtr, List<KeyValue>>();
        rowKeyPtrToCells.put(new ImmutableBytesPtr(row), Collections.singletonList(storedKv));
        CachedLocalTable cachedLocalTable = CachedLocalTable.build(rowKeyPtrToCells);
        LocalTableState table = new LocalTableState((LocalHBaseState)cachedLocalTable, (Mutation)m);
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)((Cell)m.get(fam, qual).get(0)));
        kv.setSequenceId(0L);
        table.addPendingUpdates(new Cell[]{kv});
        ColumnReference col = new ColumnReference(fam, qual);
        table.setCurrentTimestamp(10L);
        Pair p = table.getIndexedColumnsTableState(Arrays.asList(col), false, false, indexMetaData);
        Scanner s = (Scanner)p.getFirst();
        Assert.assertEquals((String)"Didn't get the pending mutation's value first", (Object)kv, (Object)s.next());
        table.rollback(Arrays.asList(kv));
        p = table.getIndexedColumnsTableState(Arrays.asList(col), false, false, indexMetaData);
        s = (Scanner)p.getFirst();
        Assert.assertEquals((String)"Didn't correctly rollback the row - still found it!", null, (Object)s.next());
    }

    @Test
    public void testOnlyLoadsRequestedColumns() throws Exception {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)Mockito.mock(RegionCoprocessorEnvironment.class);
        Region region = (Region)Mockito.mock(Region.class);
        Mockito.when((Object)env.getRegion()).thenReturn((Object)region);
        KeyValue storedKv = new KeyValue(row, fam, qual, 10L, KeyValue.Type.Put, Bytes.toBytes((String)"stored-value"));
        storedKv.setSequenceId(2L);
        Put pendingUpdate = new Put(row);
        pendingUpdate.addColumn(fam, qual, 10L, val);
        HashMap<ImmutableBytesPtr, List<KeyValue>> rowKeyPtrToCells = new HashMap<ImmutableBytesPtr, List<KeyValue>>();
        rowKeyPtrToCells.put(new ImmutableBytesPtr(row), Collections.singletonList(storedKv));
        CachedLocalTable cachedLocalTable = CachedLocalTable.build(rowKeyPtrToCells);
        LocalTableState table = new LocalTableState((LocalHBaseState)cachedLocalTable, (Mutation)pendingUpdate);
        ColumnReference col = new ColumnReference(fam, qual);
        table.setCurrentTimestamp(10L);
        Pair p = table.getIndexedColumnsTableState(Arrays.asList(col), false, false, indexMetaData);
        Scanner s = (Scanner)p.getFirst();
        Assert.assertEquals((String)"Didn't get the stored keyvalue!", (Object)storedKv, (Object)s.next());
        p = table.getIndexedColumnsTableState(Arrays.asList(col), false, false, indexMetaData);
        s = (Scanner)p.getFirst();
        Assert.assertEquals((String)"Lost already loaded update!", (Object)storedKv, (Object)s.next());
    }

    public static final class ScannerCreatedException
    extends RuntimeException {
        ScannerCreatedException(String msg) {
            super(msg);
        }
    }
}

