/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;

public class CoveredColumn
extends ColumnReference {
    public static final String SEPARATOR = ":";
    String familyString;
    private final int hashCode;

    public CoveredColumn(byte[] family, byte[] qualifier) {
        this(Bytes.toString((byte[])family), qualifier);
    }

    public CoveredColumn(String family, byte[] qualifier) {
        super(Bytes.toBytes((String)family), qualifier == null ? ColumnReference.ALL_QUALIFIERS : qualifier);
        this.familyString = family;
        this.hashCode = CoveredColumn.calcHashCode(family, qualifier);
    }

    public static CoveredColumn parse(String spec) {
        int sep = spec.indexOf(SEPARATOR);
        if (sep < 0) {
            throw new IllegalArgumentException(spec + " is not a valid specifier!");
        }
        String family = spec.substring(0, sep);
        String qual = spec.substring(sep + 1);
        byte[] column = qual.length() == 0 ? null : Bytes.toBytes((String)qual);
        return new CoveredColumn(family, column);
    }

    public String serialize() {
        return CoveredColumn.serialize(this.familyString, this.getQualifier());
    }

    public static String serialize(String first, byte[] second) {
        String nextValue = first + SEPARATOR;
        if (second != null) {
            nextValue = nextValue + Bytes.toString((byte[])second);
        }
        return nextValue;
    }

    public boolean matchesFamily(String family2) {
        return this.familyString.equals(family2);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static int calcHashCode(String familyString, byte[] qualifier) {
        int prime = 31;
        int result = 1;
        result = 31 * result + familyString.hashCode();
        if (qualifier != null) {
            result = 31 * result + Bytes.hashCode((byte[])qualifier);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CoveredColumn other = (CoveredColumn)((Object)obj);
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (!this.familyString.equals(other.familyString)) {
            return false;
        }
        return Bytes.equals((byte[])this.getQualifier(), (byte[])other.getQualifier());
    }

    public String toString() {
        String qualString = this.getQualifier() == null ? "null" : Bytes.toString((byte[])this.getQualifier());
        return "CoveredColumn:[" + this.familyString + SEPARATOR + qualString + "]";
    }
}

