/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.hbase.index.IndexTestingUtils;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.covered.ColumnGroup;
import org.apache.phoenix.hbase.index.covered.CoveredColumn;
import org.apache.phoenix.hbase.index.covered.CoveredColumnIndexSpecifierBuilder;
import org.apache.phoenix.query.BaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class FailForUnsupportedHBaseVersionsIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailForUnsupportedHBaseVersionsIT.class);

    @Test
    public void testDoesNotSupportCompressedWAL() {
        Configuration conf = HBaseConfiguration.create();
        IndexTestingUtils.setupConfig(conf);
        String version = VersionInfo.getVersion();
        conf.setBoolean("hbase.regionserver.wal.enablecompression", false);
        String supported = Indexer.validateVersion((String)version, (Configuration)conf);
        Assert.assertNull((String)("WAL Compression wasn't enabled, but version " + version + " of HBase wasn't supported! All versions should support writing without a compressed WAL. Message: " + supported), (Object)supported);
        conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        version = "0.94.4";
        supported = Indexer.validateVersion((String)version, (Configuration)conf);
        Assert.assertNotNull((String)"WAL Compression was enabled, but incorrectly marked version as supported", (Object)supported);
        version = "0.94.9";
        supported = Indexer.validateVersion((String)version, (Configuration)conf);
        Assert.assertNull((String)("WAL Compression wasn't enabled, but version " + version + " of HBase wasn't supported! Message: " + supported), (Object)supported);
        version = "0.94.9-SNAPSHOT";
        supported = Indexer.validateVersion((String)version, (Configuration)conf);
        Assert.assertNull((String)("WAL Compression wasn't enabled, but version " + version + " of HBase wasn't supported! Message: " + supported), (Object)supported);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testDoesNotStartRegionServerForUnsupportedCompressionAndVersion() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        BaseTest.setUpConfigForMiniCluster(conf);
        IndexTestingUtils.setupConfig(conf);
        conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        String version = VersionInfo.getVersion();
        boolean supported = false;
        if (Indexer.validateVersion((String)version, (Configuration)conf) == null) {
            supported = true;
        }
        HBaseTestingUtility util = new HBaseTestingUtility(conf);
        util.startMiniCluster();
        try {
            TableDescriptorBuilder descBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)"testDoesNotStartRegionServerForUnsupportedCompressionAndVersion"));
            byte[] family = Bytes.toBytes((String)"f");
            descBuilder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
            TableDescriptor desc = descBuilder.build();
            String indexTableName = "INDEX_TABLE";
            ColumnGroup fam1 = new ColumnGroup(indexTableName);
            fam1.add(new CoveredColumn(family, CoveredColumn.ALL_QUALIFIERS));
            CoveredColumnIndexSpecifierBuilder builder = new CoveredColumnIndexSpecifierBuilder();
            builder.addIndexGroup(fam1);
            builder.build(desc);
            HRegionServer server = util.getMiniHBaseCluster().getRegionServer(0);
            Admin admin = util.getAdmin();
            if (supported) {
                admin.createTable(desc);
                Assert.assertFalse((String)("Hosting regeion server failed, even the HBase version (" + version + ") supports WAL Compression."), (boolean)server.isAborted());
            } else {
                admin.createTableAsync(desc, (byte[][])null);
                while (!server.isAborted()) {
                    LOGGER.debug("Waiting on regionserver to abort..");
                }
            }
        }
        finally {
            ServerMetadataCacheTestImpl.resetCache();
            util.shutdownMiniCluster();
        }
    }
}

