/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SkipScanFilterTest
extends TestCase {
    private final SkipScanFilter skipper;
    private final List<List<KeyRange>> cnf;
    private final List<Expectation> expectations;
    private static final Function<KeyRange[], List<KeyRange>> ARRAY_TO_LIST = new Function<KeyRange[], List<KeyRange>>(){

        public List<KeyRange> apply(KeyRange[] input) {
            return Lists.newArrayList((Object[])input);
        }
    };

    public SkipScanFilterTest(List<List<KeyRange>> cnf, int[] widths, int[] slotSpans, List<Expectation> expectations) {
        this.expectations = expectations;
        this.cnf = cnf;
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(widths.length);
        for (final int width : widths) {
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return width <= 0;
                }

                public PDataType getDataType() {
                    return width <= 0 ? PVarchar.INSTANCE : PChar.INSTANCE;
                }

                public Integer getMaxLength() {
                    return width <= 0 ? null : Integer.valueOf(width);
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, width <= 0, SortOrder.getDefault());
        }
        this.skipper = slotSpans == null ? new SkipScanFilter(cnf, builder.build(), false) : new SkipScanFilter(cnf, slotSpans, builder.build(), false);
    }

    @Test
    public void test() throws IOException {
        for (Expectation expectation : this.expectations) {
            expectation.examine(this.skipper);
        }
    }

    @Parameterized.Parameters(name="{0} {1} {3}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC), PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"e"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC), PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"f"), true, Bytes.toBytes((String)"f"), true, SortOrder.ASC)}, {PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE}, {PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}}, new int[4], null, new Include(ByteUtil.concat((byte[])Bytes.toBytes((String)"a"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"b"), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"1")})), new SeekNext(ByteUtil.concat((byte[])Bytes.toBytes((String)"e.f"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"b"), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"1")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"f"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"b"), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"1")})), new Include(ByteUtil.concat((byte[])Bytes.toBytes((String)"f"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"b"), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"1")}))));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2018-02-10"), true, Bytes.toBytes((String)"2019-02-19"), true, SortOrder.ASC)}, {PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"channel"), true, Bytes.toBytes((String)"channel"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {KeyRange.EVERYTHING_RANGE}, {KeyRange.EVERYTHING_RANGE}, {PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A004"), true, Bytes.toBytes((String)"A004"), true, SortOrder.ASC)}}, new int[]{0, 0, 1, 0, 0, 0, 0, 0}, null, new SeekNext(ByteUtil.concat((byte[])Bytes.toBytes((String)"2018-02-14"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"channel"), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"2")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"2018-02-14"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"channel"), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"2"), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"A004")})), new Include(ByteUtil.concat((byte[])Bytes.toBytes((String)"2018-02-15"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"channel"), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"2"), QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"A004")}))));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"20160116121006"), true, Bytes.toBytes((String)"20160116181006"), true, SortOrder.ASC)}, {PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2404787"), true, Bytes.toBytes((String)"2404787"), true, SortOrder.ASC)}}, new int[4], null, new SeekNext(ByteUtil.concat((byte[])Bytes.toBytes((String)"20160116141006"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"servlet")}), ByteUtil.concat((byte[])Bytes.toBytes((String)"20160116141006"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"2404787")})), new Include(ByteUtil.concat((byte[])Bytes.toBytes((String)"20160116151006"), (byte[][])new byte[][]{QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"2404787"), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes((String)"jdbc"), QueryConstants.SEPARATOR_BYTE_ARRAY}))));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"dzy"), false, Bytes.toBytes((String)"xyz"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AA"), true, Bytes.toBytes((String)"AB"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AA"), true, Bytes.toBytes((String)"AB"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AA"), true, Bytes.toBytes((String)"AB"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AA"), true, Bytes.toBytes((String)"AB"), false, SortOrder.ASC)}}, new int[]{3, 2, 2, 2, 2}, null, new SeekNext("defAAABABAB", "dzzAAAAAAAA"), new Finished("xyyABABABAB")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"j"), false, Bytes.toBytes((String)"k"), true, SortOrder.ASC)}}, new int[]{0}, null, new SeekNext(Bytes.toBytes((String)"a"), ByteUtil.nextKey((byte[])new byte[]{106, 0})), new Include("ja"), new Include("jz"), new Include("k"), new Finished("ka")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"aaa"), true, Bytes.toBytes((String)"aaa"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"aac"), true, Bytes.toBytes((String)"aad"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC)}}, new int[]{3}, null, new SeekNext("aab", "aac"), new SeekNext("abb", "abc"), new Include("abc"), new Include("abe"), new Include("def"), new Finished("deg")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"aaa"), true, Bytes.toBytes((String)"aaa"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), false, Bytes.toBytes((String)"def"), true, SortOrder.ASC)}}, new int[]{3}, null, new SeekNext("aba", "abd"), new Include("abe"), new Include("def"), new Finished("deg")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"aaa"), true, Bytes.toBytes((String)"aaa"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), false, Bytes.toBytes((String)"def"), false, SortOrder.ASC)}}, new int[]{3}, null, new SeekNext("aba", "abd"), new Finished("def")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"dzy"), false, Bytes.toBytes((String)"xyz"), false, SortOrder.ASC)}}, new int[]{3}, null, new Include("def"), new SeekNext("deg", "dzz"), new Include("eee"), new Finished("xyz")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"aaa"), true, Bytes.toBytes((String)"aaa"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), true, Bytes.toBytes((String)"abc"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"def"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AB"), true, Bytes.toBytes((String)"AX"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"EA"), false, Bytes.toBytes((String)"EZ"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"PO"), true, Bytes.toBytes((String)"PP"), false, SortOrder.ASC)}}, new int[]{3, 2}, null, new Include("abcAB"), new SeekNext("abcAY", "abcEB"), new Include("abcEF"), new SeekNext("abcPP", "defAB"), new SeekNext("defEZ", "defPO"), new Include("defPO"), new Finished("defPP")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AB"), true, Bytes.toBytes((String)"AX"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"EA"), false, Bytes.toBytes((String)"EZ"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"PO"), true, Bytes.toBytes((String)"PP"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), true, Bytes.toBytes((String)"abc"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"def"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC)}}, new int[]{2, 3}, null, new Include("ABabc"), new SeekNext("ABdeg", "ACabc"), new Include("AMabc"), new SeekNext("AYabc", "EBabc"), new Include("EFabc"), new SeekNext("EZdef", "POabc"), new SeekNext("POabd", "POdef"), new Include("POdef"), new Finished("PPabc")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"PO"), true, Bytes.toBytes((String)"PP"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"def"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC)}}, new int[]{2, 3}, null, new Include("POdef"), new Finished("POdeg")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"PO"), true, Bytes.toBytes((String)"PO"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"def"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC)}}, new int[]{2, 3}, null, new Include("POdef")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AAA"), true, Bytes.toBytes((String)"AAA"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"dzy"), false, Bytes.toBytes((String)"xyz"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AB"), true, Bytes.toBytes((String)"AX"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"EA"), false, Bytes.toBytes((String)"EZ"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"PO"), true, Bytes.toBytes((String)"PP"), false, SortOrder.ASC)}}, new int[]{3, 2}, null, new SeekNext("aaaAA", "abcAB"), new SeekNext("abcZZ", "abdAB"), new SeekNext("abdZZ", "abeAB"), new SeekNext(new byte[]{100, 101, 97, -1, -1}, new byte[]{100, 101, 98, 65, 66}), new Include("defAB"), new Include("defAC"), new Include("defAW"), new Include("defAX"), new Include("defEB"), new Include("defPO"), new SeekNext("degAB", "dzzAB"), new Include("dzzAX"), new Include("dzzEY"), new SeekNext("dzzEZ", "dzzPO"), new Include("eeeAB"), new Include("eeeAC"), new SeekNext("eeeEA", "eeeEB"), new Include("eeeEF"), new SeekNext("eeeEZ", "eeePO"), new Finished("xyzAA")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"aaa"), true, Bytes.toBytes((String)"aaa"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"dzz"), true, Bytes.toBytes((String)"xyz"), false, SortOrder.ASC)}}, new int[]{3}, null, new SeekNext("abb", "abc"), new Include("abc"), new Include("abe"), new Finished("xyz")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"abc"), true, Bytes.toBytes((String)"def"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"dzy"), false, Bytes.toBytes((String)"xyz"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"AB"), true, Bytes.toBytes((String)"AX"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"EA"), false, Bytes.toBytes((String)"EZ"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"PO"), true, Bytes.toBytes((String)"PP"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"100"), true, Bytes.toBytes((String)"250"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"700"), false, Bytes.toBytes((String)"901"), false, SortOrder.ASC)}}, new int[]{3, 2, 3}, null, new SeekNext("abcEB700", "abcEB701"), new Include("abcEB701"), new SeekNext("dzzAB250", "dzzAB701"), new Finished("zzzAA000")));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)1), true, PInteger.INSTANCE.toBytes((Object)4), true, SortOrder.ASC)}, {KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)5)), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)7))}, {PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)9), true, PInteger.INSTANCE.toBytes((Object)10), true, SortOrder.ASC)}}, new int[]{4, 4, 4}, null, new SeekNext(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)11)}), ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)9)})), new Finished(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)4), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)11)}))));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)1)), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)3)), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)4))}, {KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)5)), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)7))}, {PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)9), true, PInteger.INSTANCE.toBytes((Object)10), true, SortOrder.ASC)}}, new int[]{4, 4, 4}, null, new SeekNext(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)11)}), ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)4), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)9)})), new Finished(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)4), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)11)}))));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)2)}), (boolean)true, (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)}), (boolean)true)}, {KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)5), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)6)}), (boolean)true, (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)7), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)8)}), (boolean)true)}}, new int[]{4, 4, 4, 4}, new int[]{1, 1}, new Include(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)6), PInteger.INSTANCE.toBytes((Object)7)})), new SeekNext(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)9)}), ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4), PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)6)})), new Finished(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4), PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)9)}))));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)2)}), (boolean)true, (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)}), (boolean)true)}, {KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)5)), KeyRange.getKeyRange((byte[])PInteger.INSTANCE.toBytes((Object)7))}, {PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)9), true, PInteger.INSTANCE.toBytes((Object)10), true, SortOrder.ASC)}}, new int[]{4, 4, 4, 4}, new int[]{1, 0, 0}, new Include(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)9)})), new SeekNext(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)11)}), ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4), PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)9)})), new Finished(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4), PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)11)}))));
        testCases.addAll(SkipScanFilterTest.foreach(new KeyRange[][]{{KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)2)}), (boolean)true, (byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4)}), (boolean)true)}, {KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)5), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)6)})), KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)7), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)8)}))}, {PInteger.INSTANCE.getKeyRange(PInteger.INSTANCE.toBytes((Object)9), true, PInteger.INSTANCE.toBytes((Object)10), true, SortOrder.ASC)}}, new int[]{4, 4, 4, 4, 4}, new int[]{1, 1, 0}, new Include(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)1), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)6), PInteger.INSTANCE.toBytes((Object)9)})), new SeekNext(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)8), PInteger.INSTANCE.toBytes((Object)11)}), ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)2), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4), PInteger.INSTANCE.toBytes((Object)5), PInteger.INSTANCE.toBytes((Object)6), PInteger.INSTANCE.toBytes((Object)9)})), new Finished(ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)3), (byte[][])new byte[][]{PInteger.INSTANCE.toBytes((Object)4), PInteger.INSTANCE.toBytes((Object)7), PInteger.INSTANCE.toBytes((Object)8), PInteger.INSTANCE.toBytes((Object)11)}))));
        return testCases;
    }

    private static Collection<?> foreach(KeyRange[][] ranges, int[] widths, int[] slotSpans, Expectation ... expectations) {
        List cnf = Lists.transform((List)Lists.newArrayList((Object[])ranges), ARRAY_TO_LIST);
        ArrayList ret = Lists.newArrayList();
        ret.add(new Object[]{cnf, widths, slotSpans, Arrays.asList(expectations)});
        return ret;
    }

    private static final class Finished
    implements Expectation {
        private final byte[] rowkey;

        public Finished(String rowkey) {
            this.rowkey = Bytes.toBytes((String)rowkey);
        }

        public Finished(byte[] rowkey) {
            this.rowkey = rowkey;
        }

        @Override
        public void examine(SkipScanFilter skipper) throws IOException {
            KeyValue kv = KeyValueUtil.createFirstOnRow((byte[])this.rowkey);
            skipper.reset();
            TestCase.assertEquals((Object)Filter.ReturnCode.NEXT_ROW, (Object)skipper.filterCell((Cell)kv));
            skipper.reset();
            TestCase.assertTrue((boolean)skipper.filterAllRemaining());
        }

        public String toString() {
            return "rowkey=" + Bytes.toStringBinary((byte[])this.rowkey) + ", expected finished";
        }
    }

    private static final class Include
    implements Expectation {
        private final byte[] rowkey;

        public Include(String rowkey) {
            this.rowkey = Bytes.toBytes((String)rowkey);
        }

        public Include(byte[] rowkey) {
            this.rowkey = rowkey;
        }

        @Override
        public void examine(SkipScanFilter skipper) throws IOException {
            KeyValue kv = KeyValueUtil.createFirstOnRow((byte[])this.rowkey);
            skipper.reset();
            TestCase.assertFalse((boolean)skipper.filterAllRemaining());
            TestCase.assertFalse((boolean)skipper.filterRowKey((Cell)kv));
            TestCase.assertEquals((String)kv.toString(), (Object)Filter.ReturnCode.INCLUDE_AND_NEXT_COL, (Object)skipper.filterCell((Cell)kv));
        }

        public String toString() {
            return "rowkey=" + Bytes.toStringBinary((byte[])this.rowkey) + ", expected include";
        }
    }

    private static final class SeekNext
    implements Expectation {
        private final byte[] rowkey;
        private final byte[] hint;

        public SeekNext(String rowkey, String hint) {
            this.rowkey = Bytes.toBytes((String)rowkey);
            this.hint = Bytes.toBytes((String)hint);
        }

        public SeekNext(byte[] rowkey, byte[] hint) {
            this.rowkey = rowkey;
            this.hint = hint;
        }

        @Override
        public void examine(SkipScanFilter skipper) throws IOException {
            KeyValue kv = KeyValueUtil.createFirstOnRow((byte[])this.rowkey);
            skipper.reset();
            TestCase.assertFalse((boolean)skipper.filterAllRemaining());
            TestCase.assertFalse((boolean)skipper.filterRowKey((Cell)kv));
            TestCase.assertEquals((Object)Filter.ReturnCode.SEEK_NEXT_USING_HINT, (Object)skipper.filterCell((Cell)kv));
            TestCase.assertEquals((Object)KeyValueUtil.createFirstOnRow((byte[])this.hint), (Object)skipper.getNextCellHint((Cell)kv));
        }

        public String toString() {
            return "rowkey=" + Bytes.toStringBinary((byte[])this.rowkey) + ", expected seek next using hint: " + Bytes.toStringBinary((byte[])this.hint);
        }
    }

    static interface Expectation {
        public void examine(SkipScanFilter var1) throws IOException;
    }
}

