/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SkipScanFilterIntersectTest {
    private final SkipScanFilter filter;
    private final byte[] lowerInclusiveKey;
    private final byte[] upperExclusiveKey;
    private final List<List<KeyRange>> expectedNewSlots;
    private static final Function<KeyRange[], List<KeyRange>> ARRAY_TO_LIST = new Function<KeyRange[], List<KeyRange>>(){

        public List<KeyRange> apply(KeyRange[] input) {
            return Lists.newArrayList((Object[])input);
        }
    };

    public SkipScanFilterIntersectTest(List<List<KeyRange>> slots, RowKeySchema schema, byte[] lowerInclusiveKey, byte[] upperExclusiveKey, List<List<KeyRange>> expectedNewSlots) {
        this.filter = new SkipScanFilter(slots, schema, false);
        this.lowerInclusiveKey = lowerInclusiveKey;
        this.upperExclusiveKey = upperExclusiveKey;
        this.expectedNewSlots = expectedNewSlots;
    }

    @Test
    public void test() {
        SkipScanFilter intersectedFilter = this.filter.intersect(this.lowerInclusiveKey, this.upperExclusiveKey);
        if (this.expectedNewSlots == null && intersectedFilter == null) {
            return;
        }
        Assert.assertNotNull((String)"Intersected filter should not be null", (Object)intersectedFilter);
        List newSlots = intersectedFilter.getSlots();
        this.assertSameSlots(this.expectedNewSlots, newSlots);
    }

    private void assertSameSlots(List<List<KeyRange>> expectedSlots, List<List<KeyRange>> slots) {
        Assert.assertEquals((long)expectedSlots.size(), (long)slots.size());
        for (int i = 0; i < expectedSlots.size(); ++i) {
            List<KeyRange> expectedSlot = expectedSlots.get(i);
            List<KeyRange> slot = slots.get(i);
            Assert.assertEquals((String)("index: " + i), (long)expectedSlot.size(), (long)slot.size());
            for (int j = 0; j < expectedSlot.size(); ++j) {
                KeyRange expectedRange = expectedSlot.get(j);
                KeyRange range = slot.get(j);
                Assert.assertArrayEquals((byte[])expectedRange.getLowerRange(), (byte[])range.getLowerRange());
                Assert.assertArrayEquals((byte[])expectedRange.getUpperRange(), (byte[])range.getUpperRange());
                Assert.assertEquals((Object)expectedRange.isLowerInclusive(), (Object)range.isLowerInclusive());
                Assert.assertEquals((Object)expectedRange.isUpperInclusive(), (Object)range.isUpperInclusive());
            }
        }
    }

    @Parameterized.Parameters(name="{0} {4}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"j"), true, Bytes.toBytes((String)"m"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"j3A"), Bytes.toBytes((String)"k4C"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"j"), true, Bytes.toBytes((String)"m"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"j"), true, Bytes.toBytes((String)"m"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"j3A"), Bytes.toBytes((String)"j4C"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"j"), true, Bytes.toBytes((String)"m"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"d"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"j"), true, Bytes.toBytes((String)"m"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"C"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"m"), true, Bytes.toBytes((String)"u"), false, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"z"), true, Bytes.toBytes((String)"z"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"M"), true, Bytes.toBytes((String)"M"), true, SortOrder.ASC)}}, new int[]{1, 1, 1, 1, 1}, Bytes.toBytes((String)"bkCpM"), Bytes.toBytes((String)"bkCtD"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"j"), true, Bytes.toBytes((String)"m"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"C"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"m"), true, Bytes.toBytes((String)"u"), false, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"D"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"M"), true, Bytes.toBytes((String)"M"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"3"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"b1B"), Bytes.toBytes((String)"b1C"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"b1Z"), Bytes.toBytes((String)"b3Z"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"a"), true, Bytes.toBytes((String)"a"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"2"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"A"), true, Bytes.toBytes((String)"A"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"G"), true, Bytes.toBytes((String)"G"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a1I"), Bytes.toBytes((String)"a2A"), null));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"3"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0A"), Bytes.toBytes((String)"b1B"), null));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"3"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0A"), Bytes.toBytes((String)"b1C"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"3"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0A"), Bytes.toBytes((String)"b1D"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"3"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0A"), Bytes.toBytes((String)"b1D"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"3"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"b1B"), Bytes.toBytes((String)"b1D"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"d"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"3"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0A"), Bytes.toBytes((String)"b1F"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"D"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0Z"), Bytes.toBytes((String)"b3Z"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0Z"), Bytes.toBytes((String)"b9Z"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0Z"), Bytes.toBytes((String)"c3Z"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, 1}, Bytes.toBytes((String)"a0A"), Bytes.toBytes((String)"f4F"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, -1}, Bytes.toBytes((String)"d3AA"), Bytes.toBytes((String)"d4FF"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, -1}, Bytes.toBytes((String)"d0AA"), Bytes.toBytes((String)"d4FF"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}));
        testCases.addAll(SkipScanFilterIntersectTest.foreach(new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}, new int[]{1, 1, -1}, Bytes.toBytes((String)"a0AA"), Bytes.toBytes((String)"f4FF"), new KeyRange[][]{{PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"b"), true, Bytes.toBytes((String)"b"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"1"), true, Bytes.toBytes((String)"1"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"2"), true, Bytes.toBytes((String)"4"), true, SortOrder.ASC)}, {PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"B"), true, Bytes.toBytes((String)"B"), true, SortOrder.ASC), PChar.INSTANCE.getKeyRange(Bytes.toBytes((String)"C"), true, Bytes.toBytes((String)"E"), true, SortOrder.ASC)}}));
        return testCases;
    }

    private static Collection<?> foreach(KeyRange[][] ranges, int[] widths, byte[] lowerInclusive, byte[] upperExclusive, KeyRange[][] expectedRanges) {
        List slots = Lists.transform((List)Lists.newArrayList((Object[])ranges), ARRAY_TO_LIST);
        List expectedSlots = expectedRanges == null ? null : Lists.transform((List)Lists.newArrayList((Object[])expectedRanges), ARRAY_TO_LIST);
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(10);
        for (final int width : widths) {
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return width <= 0;
                }

                public PDataType getDataType() {
                    return width <= 0 ? PVarchar.INSTANCE : PChar.INSTANCE;
                }

                public Integer getMaxLength() {
                    return width <= 0 ? null : Integer.valueOf(width);
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, width <= 0, SortOrder.getDefault());
        }
        ArrayList ret = Lists.newArrayList();
        ret.add(new Object[]{slots, builder.build(), lowerInclusive, upperExclusive, expectedSlots});
        return ret;
    }
}

