/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.filter.DistinctPrefixFilter;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;

public class DistinctPrefixFilterTest
extends TestCase {
    private DistinctPrefixFilter createFilter(int[] widths, int prefixLength) {
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(widths.length);
        for (final int width : widths) {
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return width <= 0;
                }

                public PDataType<?> getDataType() {
                    return width <= 0 ? PVarchar.INSTANCE : PChar.INSTANCE;
                }

                public Integer getMaxLength() {
                    return width <= 0 ? null : Integer.valueOf(width);
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, width <= 0, SortOrder.getDefault());
        }
        return new DistinctPrefixFilter(builder.build(), prefixLength);
    }

    private void assertInclude(String next, Filter f) throws IOException {
        this.assertInclude(Bytes.toBytes((String)next), f);
    }

    private void assertInclude(byte[] next, Filter f) throws IOException {
        KeyValue c = new KeyValue(next, ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY, 0L, ByteUtil.EMPTY_BYTE_ARRAY);
        DistinctPrefixFilterTest.assertTrue((f.filterCell((Cell)c) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        DistinctPrefixFilterTest.assertFalse((boolean)f.filterAllRemaining());
    }

    private void assertSeekAndHint(String next, Filter f, String rowHint) throws IOException {
        this.assertSeekAndHint(next, f, rowHint, false);
    }

    private void assertSeekAndHint(String next, Filter f, String rowHint, boolean filterAll) throws IOException {
        this.assertSeekAndHint(Bytes.toBytes((String)next), f, Bytes.toBytes((String)rowHint), filterAll);
    }

    private void assertSeekAndHint(byte[] next, Filter f, byte[] rowHint, boolean filterAll) throws IOException {
        KeyValue c = new KeyValue(next, ByteUtil.EMPTY_BYTE_ARRAY, ByteUtil.EMPTY_BYTE_ARRAY, 0L, ByteUtil.EMPTY_BYTE_ARRAY);
        DistinctPrefixFilterTest.assertTrue((f.filterCell((Cell)c) == Filter.ReturnCode.SEEK_NEXT_USING_HINT ? 1 : 0) != 0);
        Cell h = f.getNextCellHint((Cell)c);
        byte[] hintBytes = rowHint;
        DistinctPrefixFilterTest.assertTrue((boolean)Bytes.equals((byte[])hintBytes, (int)0, (int)hintBytes.length, (byte[])h.getRowArray(), (int)h.getRowOffset(), (int)h.getRowLength()));
        DistinctPrefixFilterTest.assertEquals((boolean)filterAll, (boolean)f.filterAllRemaining());
    }

    public void testSingleFixedWidth() throws Exception {
        DistinctPrefixFilter f = this.createFilter(new int[]{3}, 1);
        this.assertInclude("000", (Filter)f);
        this.assertInclude("001", (Filter)f);
        this.assertSeekAndHint("001", (Filter)f, "002");
        this.assertInclude("003", (Filter)f);
        this.assertInclude("004", (Filter)f);
        this.assertInclude("005", (Filter)f);
        this.assertSeekAndHint("005", (Filter)f, "006");
        f = this.createFilter(new int[]{3}, 1);
        f.setReversed(true);
        this.assertInclude("005", (Filter)f);
        this.assertInclude("004", (Filter)f);
        this.assertSeekAndHint(new byte[]{48, 48, 52}, (Filter)f, new byte[]{48, 48, 52}, false);
        this.assertInclude("003", (Filter)f);
        this.assertInclude("002", (Filter)f);
        this.assertInclude("001", (Filter)f);
        this.assertSeekAndHint(new byte[]{48, 48, 49}, (Filter)f, new byte[]{48, 48, 49}, false);
    }

    public void testMultiFixedWidth() throws Exception {
        DistinctPrefixFilter f = this.createFilter(new int[]{5, 4}, 1);
        this.assertInclude("00000aaaa", (Filter)f);
        this.assertInclude("00001aaaa", (Filter)f);
        this.assertSeekAndHint("00001aaaa", (Filter)f, "00002");
        this.assertInclude("00003aaaa", (Filter)f);
        this.assertInclude("00004aaaa", (Filter)f);
        this.assertInclude("00005aaaa", (Filter)f);
        this.assertSeekAndHint("00005aaaa", (Filter)f, "00006");
        f = this.createFilter(new int[]{5, 4}, 2);
        this.assertInclude("00000aaaa", (Filter)f);
        this.assertInclude("00001aaaa", (Filter)f);
        this.assertSeekAndHint("00001aaaa", (Filter)f, "00001aaab");
        this.assertInclude("00003aaaa", (Filter)f);
        this.assertInclude("00004aaaa", (Filter)f);
        this.assertInclude("00005aaaa", (Filter)f);
        this.assertSeekAndHint("00005aaaa", (Filter)f, "00005aaab");
        f = this.createFilter(new int[]{3, 2}, 1);
        f.setReversed(true);
        this.assertInclude("005aa", (Filter)f);
        this.assertInclude("004aa", (Filter)f);
        this.assertSeekAndHint(new byte[]{48, 48, 52, 97, 97}, (Filter)f, new byte[]{48, 48, 52}, false);
        this.assertInclude("003aa", (Filter)f);
        this.assertInclude("002aa", (Filter)f);
        this.assertInclude("001aa", (Filter)f);
        this.assertSeekAndHint(new byte[]{48, 48, 49, 97, 97}, (Filter)f, new byte[]{48, 48, 49}, false);
        f = this.createFilter(new int[]{3, 2}, 2);
        f.setReversed(true);
        this.assertInclude("005bb", (Filter)f);
        this.assertInclude("004bb", (Filter)f);
        this.assertInclude("003bb", (Filter)f);
        this.assertSeekAndHint(new byte[]{48, 48, 51, 98, 98}, (Filter)f, new byte[]{48, 48, 51, 98, 98}, false);
        this.assertInclude("003ba", (Filter)f);
        this.assertInclude("002bb", (Filter)f);
        this.assertInclude("001bb", (Filter)f);
        this.assertSeekAndHint(new byte[]{48, 48, 49, 98, 98}, (Filter)f, new byte[]{48, 48, 49, 98, 98}, false);
    }

    public void testSingleVariableWidth() throws Exception {
        DistinctPrefixFilter f = this.createFilter(new int[]{-5}, 1);
        this.assertInclude("00000", (Filter)f);
        this.assertInclude("00001", (Filter)f);
        this.assertSeekAndHint("00001", (Filter)f, "00001\u0001");
        this.assertInclude("00003", (Filter)f);
        this.assertInclude("00004", (Filter)f);
        this.assertInclude("00005", (Filter)f);
        this.assertSeekAndHint("00005", (Filter)f, "00005\u0001");
    }

    public void testVariableWithNull() throws Exception {
        DistinctPrefixFilter f = this.createFilter(new int[]{-2, -2}, 1);
        this.assertInclude("\u0000aa", (Filter)f);
        this.assertSeekAndHint("\u0000aa", (Filter)f, "\u0001");
        this.assertSeekAndHint("\u0000aa", (Filter)f, "\u0001");
        f = this.createFilter(new int[]{-2, -2}, 2);
        this.assertInclude("\u0000\u0000", (Filter)f);
        this.assertSeekAndHint("\u0000\u0000", (Filter)f, "\u0000\u0000\u0001");
        this.assertSeekAndHint("\u0000\u0000", (Filter)f, "\u0000\u0000\u0001");
    }

    public void testMultiVariableWidth() throws Exception {
        DistinctPrefixFilter f = this.createFilter(new int[]{-5, -4}, 1);
        this.assertInclude("00000\u0000aaaa", (Filter)f);
        this.assertInclude("00001\u0000aaaa", (Filter)f);
        this.assertSeekAndHint("00001\u0000aaaa", (Filter)f, "00001\u0001");
        this.assertInclude("00003\u0000aaaa", (Filter)f);
        this.assertInclude("00004\u0000aaaa", (Filter)f);
        this.assertInclude("00005\u0000aaaa", (Filter)f);
        this.assertSeekAndHint("00005\u0000aaaa", (Filter)f, "00005\u0001");
        f = this.createFilter(new int[]{-5, -4}, 2);
        this.assertInclude("00000\u0000aaaa", (Filter)f);
        this.assertInclude("00001\u0000aaaa", (Filter)f);
        this.assertSeekAndHint("00001\u0000aaaa", (Filter)f, "00001\u0000aaaa\u0001");
        this.assertInclude("00003\u0000aaaa", (Filter)f);
        this.assertInclude("00004\u0000aaaa", (Filter)f);
        this.assertInclude("00005\u0000aaaa", (Filter)f);
        this.assertSeekAndHint("00005\u0000aaaa", (Filter)f, "00005\u0000aaaa\u0001");
        f = this.createFilter(new int[]{-3, -2}, 1);
        f.setReversed(true);
        this.assertInclude("005\u0000aa", (Filter)f);
        this.assertInclude("004\u0000aa", (Filter)f);
        this.assertSeekAndHint(new byte[]{48, 48, 52, 0, 97, 97}, (Filter)f, new byte[]{48, 48, 52}, false);
        f = this.createFilter(new int[]{-3, -2}, 2);
        f.setReversed(true);
        this.assertInclude("005\u0000bb", (Filter)f);
        this.assertInclude("004\u0000bb", (Filter)f);
        this.assertSeekAndHint(new byte[]{48, 48, 52, 0, 98, 98}, (Filter)f, new byte[]{48, 48, 52, 0, 98, 98}, false);
    }

    public void testFixedAfterVariable() throws Exception {
        DistinctPrefixFilter f = this.createFilter(new int[]{-5, 4}, 1);
        this.assertInclude("00000\u0000aaaa", (Filter)f);
        this.assertInclude("00001\u0000aaaa", (Filter)f);
        this.assertSeekAndHint("00001\u0000aaaa", (Filter)f, "00001\u0001");
        this.assertInclude("00003\u0000aaaa", (Filter)f);
        this.assertInclude("00004\u0000aaaa", (Filter)f);
        this.assertInclude("00005\u0000aaaa", (Filter)f);
        this.assertSeekAndHint("00005\u0000aaaa", (Filter)f, "00005\u0001");
        f = this.createFilter(new int[]{-5, 4}, 2);
        this.assertInclude("00000\u0000aaaa", (Filter)f);
        this.assertInclude("00001\u0000aaaa", (Filter)f);
        this.assertSeekAndHint("00001\u0000aaaa", (Filter)f, "00001\u0000aaab");
        this.assertInclude("00003\u0000aaaa", (Filter)f);
        this.assertInclude("00004\u0000aaaa", (Filter)f);
        this.assertInclude("00005\u0000aaaa", (Filter)f);
        this.assertSeekAndHint("00005\u0000aaaa", (Filter)f, "00005\u0000aaab");
    }

    public void testVariableAfterFixed() throws Exception {
        DistinctPrefixFilter f = this.createFilter(new int[]{5, -4}, 1);
        this.assertInclude("00000aaaa", (Filter)f);
        this.assertInclude("00001aaaa", (Filter)f);
        this.assertSeekAndHint("00001aaaa", (Filter)f, "00002");
        this.assertInclude("00003aaaa", (Filter)f);
        this.assertInclude("00004aaaa", (Filter)f);
        this.assertInclude("00005aaaa", (Filter)f);
        this.assertSeekAndHint("00005aaaa", (Filter)f, "00006");
        f = this.createFilter(new int[]{5, -4}, 2);
        this.assertInclude("00000aaaa", (Filter)f);
        this.assertInclude("00001aaaa", (Filter)f);
        this.assertSeekAndHint("00001aaaa", (Filter)f, "00001aaaa\u0001");
        this.assertInclude("00003aaaa", (Filter)f);
        this.assertInclude("00004aaaa", (Filter)f);
        this.assertInclude("00005aaaa", (Filter)f);
        this.assertSeekAndHint("00005aaaa", (Filter)f, "00005aaaa\u0001");
    }

    public void testNoNextKey() throws Exception {
        DistinctPrefixFilter f = this.createFilter(new int[]{2, 2}, 1);
        this.assertInclude("00cc", (Filter)f);
        this.assertInclude(new byte[]{-1, -1, 20, 20}, (Filter)f);
        this.assertSeekAndHint(new byte[]{-1, -1, 20, 20}, (Filter)f, new byte[]{-1, -1}, true);
        this.assertSeekAndHint(new byte[]{-1, -1, 20, 20}, (Filter)f, new byte[]{-1, -1}, true);
        f = this.createFilter(new int[]{2, 2}, 1);
        f.setReversed(true);
        this.assertInclude(new byte[]{0, 0, 1, 1}, (Filter)f);
        this.assertSeekAndHint(new byte[]{0, 0, 1, 1}, (Filter)f, new byte[]{0, 0}, false);
        this.assertSeekAndHint(new byte[]{0, 0, 1, 1}, (Filter)f, new byte[]{0, 0}, false);
    }
}

