/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.rewrite;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.rewrite.RowValueConstructorExpressionRewriter;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RowValueConstructorExpressionRewriterTest {
    @Test
    public void testRewriteAllChildrenAsc() throws SQLException {
        Expression ascChild = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)ascChild.getSortOrder()).thenReturn((Object)SortOrder.ASC);
        Mockito.when((Object)ascChild.getDataType()).thenReturn((Object)PFloat.INSTANCE);
        Mockito.when((Object)ascChild.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        Mockito.when((Object)ascChild.requiresFinalEvaluation()).thenReturn((Object)true);
        Expression descChild = (Expression)Mockito.mock(Expression.class);
        Mockito.when((Object)descChild.getSortOrder()).thenReturn((Object)SortOrder.DESC);
        Mockito.when((Object)descChild.getDataType()).thenReturn((Object)PFloat.INSTANCE);
        Mockito.when((Object)descChild.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        Mockito.when((Object)descChild.requiresFinalEvaluation()).thenReturn((Object)true);
        ImmutableList children = ImmutableList.of((Object)ascChild, (Object)descChild);
        RowValueConstructorExpression expression = new RowValueConstructorExpression((List)children, false);
        RowValueConstructorExpressionRewriter rewriter = RowValueConstructorExpressionRewriter.getSingleton();
        RowValueConstructorExpression result = rewriter.rewriteAllChildrenAsc(expression);
        Assert.assertEquals((long)2L, (long)result.getChildren().size());
        Expression child1 = (Expression)result.getChildren().get(0);
        Expression child2 = (Expression)result.getChildren().get(1);
        Assert.assertEquals((Object)SortOrder.ASC, (Object)child1.getSortOrder());
        Assert.assertEquals((Object)SortOrder.ASC, (Object)child2.getSortOrder());
        Assert.assertEquals((Object)ascChild, (Object)child1);
        Assert.assertTrue((boolean)(child2 instanceof CoerceExpression));
        Assert.assertEquals((Object)descChild, (Object)((CoerceExpression)child2).getChild());
    }
}

