/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.LowerFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class LowerFunctionTest {
    private static ImmutableMap<String, String> turkishLowerToUpperCaseMap = ImmutableMap.of((Object)"\u0130", (Object)"i", (Object)"I", (Object)"\u0131");
    private static ImmutableMap<String, String> anyLocaleLowerToUpperCaseMap = ImmutableMap.of((Object)"\u0399\u03a7\u0398\u03a5\u03a3", (Object)"\u03b9\u03c7\u03b8\u03c5\u03c2", (Object)"FrEnCh Fries", (Object)"french fries");

    @Test
    public void testTurkishUpperCase() throws Exception {
        this.testLowerToUpperCaseMap((Map<String, String>)turkishLowerToUpperCaseMap, "tr");
    }

    @Test
    public void testUniversalUpperCaseNoLocale() throws Exception {
        this.testLowerToUpperCaseMap((Map<String, String>)anyLocaleLowerToUpperCaseMap, null);
    }

    @Test
    public void testUniversalUpperCaseTurkish() throws Exception {
        this.testLowerToUpperCaseMap((Map<String, String>)anyLocaleLowerToUpperCaseMap, "tr");
    }

    private void testLowerToUpperCaseMap(Map<String, String> lowerToUpperMap, String locale) throws Exception {
        for (Map.Entry<String, String> lowerUpperPair : lowerToUpperMap.entrySet()) {
            String upperCaseResultAsc = LowerFunctionTest.callFunction(lowerUpperPair.getKey(), locale, SortOrder.ASC);
            String upperCaseResultDesc = LowerFunctionTest.callFunction(lowerUpperPair.getKey(), locale, SortOrder.DESC);
            Assert.assertEquals((String)("Result of calling LowerFunction[ASC] on [" + lowerUpperPair.getKey() + "][" + locale + "] not as expected."), (Object)lowerUpperPair.getValue(), (Object)upperCaseResultAsc);
            Assert.assertEquals((String)("Result of calling LowerFunction[DESC] on [" + lowerUpperPair.getKey() + "][" + locale + "] not as expected."), (Object)lowerUpperPair.getValue(), (Object)upperCaseResultDesc);
        }
    }

    private static String callFunction(String inputStr, String localeIsoCode, SortOrder sortOrder) throws Exception {
        ImmutableBytesWritable ptr;
        LiteralExpression inputStrLiteral = LiteralExpression.newConstant((Object)inputStr, (PDataType)PVarchar.INSTANCE, (SortOrder)sortOrder);
        LiteralExpression localeIsoCodeLiteral = LiteralExpression.newConstant((Object)localeIsoCode, (PDataType)PVarchar.INSTANCE, (SortOrder)sortOrder);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{inputStrLiteral, localeIsoCodeLiteral});
        LowerFunction lowerFunction = new LowerFunction((List)expressions);
        boolean ret = lowerFunction.evaluate(null, ptr = new ImmutableBytesWritable());
        String result = ret ? (String)lowerFunction.getDataType().toObject(ptr, lowerFunction.getSortOrder()) : null;
        return result;
    }
}

