/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CollationKeyFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.primitives.UnsignedBytes;
import org.junit.Assert;
import org.junit.Test;

public class CollationKeyFunctionTest {
    private static String[] chineseChars = new String[]{"\u963f", "\u55c4", "\u963e", "\u554a", "\u4ec8", "\u3d9a", "\u9f51"};
    private static Comparator<byte[]> collationKeyComparator = UnsignedBytes.lexicographicalComparator();
    private static Comparator<ByteArrayAndInteger> collationKeyAndIndexComparator = new Comparator<ByteArrayAndInteger>(){

        @Override
        public int compare(ByteArrayAndInteger o1, ByteArrayAndInteger o2) {
            int compareResult = collationKeyComparator.compare(o1.byteArray, o2.byteArray);
            if (compareResult == 0) {
                compareResult = o1.integer.compareTo(o2.integer);
            }
            return compareResult;
        }
    };

    @Test
    public void testZhSort() throws Exception {
        this.testSortOrderNoEquals(chineseChars, "zh", Boolean.FALSE, null, null, new Integer[]{4, 3, 1, 5, 2, 0, 6});
    }

    @Test
    public void testZhTwSort() throws Exception {
        this.testSortOrderNoEquals(chineseChars, "zh_TW", Boolean.FALSE, null, null, new Integer[]{4, 3, 1, 5, 2, 0, 6});
    }

    @Test
    public void testZhTwStrokeSort() throws Exception {
        this.testSortOrderNoEquals(chineseChars, "zh_TW_STROKE", Boolean.FALSE, null, null, new Integer[]{4, 2, 0, 3, 1, 6, 5});
    }

    @Test
    public void testZhStrokeSort() throws Exception {
        this.testSortOrderNoEquals(chineseChars, "zh__STROKE", Boolean.FALSE, null, null, new Integer[]{4, 2, 0, 3, 1, 6, 5});
    }

    @Test
    public void testZhPinyinSort() throws Exception {
        this.testSortOrderNoEquals(chineseChars, "zh__PINYIN", Boolean.FALSE, null, null, new Integer[]{0, 1, 3, 4, 6, 2, 5});
    }

    @Test
    public void testUpperCaseCollationKeyBytes() throws Exception {
        this.testCollationKeysEqual(new String[]{"abcdef", "ABCDEF", "aBcDeF"}, "en", Boolean.TRUE, null, null);
    }

    @Test
    public void testNullCollationKey() throws Exception {
        List<ByteArrayAndInteger> collationKeys = this.calculateCollationKeys(new String[]{null}, "en", null, null, null);
        Assert.assertNull((Object)collationKeys.get((int)0).byteArray);
    }

    @Test
    public void testEqualCollationKeysForPrimaryStrength() throws Exception {
        this.testCollationKeysEqual(new String[]{"a", "A", "\u00e4"}, "en", Boolean.FALSE, 0, null);
        this.testSortOrderNoEquals(new String[]{"b", "a"}, "en", Boolean.FALSE, 0, null, new Integer[]{1, 0});
    }

    @Test
    public void testCollationKeyBytesForSecondaryStrength() throws Exception {
        this.testCollationKeysEqual(new String[]{"a", "A"}, "en", Boolean.FALSE, 1, null);
        this.testSortOrderNoEquals(new String[]{"b", "a", "\u00e4"}, "en", Boolean.FALSE, 1, null, new Integer[]{1, 2, 0});
    }

    @Test
    public void testCollationKeyBytesForTertiaryStrength() throws Exception {
        this.testSortOrderNoEquals(new String[]{"b", "a", "\u00e4", "A"}, "en", Boolean.FALSE, 2, null, new Integer[]{1, 3, 2, 0});
    }

    @Test
    public void testCollationKeyBytesForFullDecomposition() throws Exception {
        this.testCollationKeysEqual(new String[]{"a", "A"}, "en", Boolean.FALSE, null, 2);
    }

    private void testSortOrderNoEquals(String[] inputStrings, String locale, Boolean uppercaseCollator, Integer strength, Integer decomposition, Integer[] expectedOrder) throws Exception {
        List<ByteArrayAndInteger> sortedCollationKeysAndIndexes = this.calculateCollationKeys(inputStrings, locale, uppercaseCollator, strength, decomposition);
        Collections.sort(sortedCollationKeysAndIndexes, collationKeyAndIndexComparator);
        this.testCollationKeysNotEqual(inputStrings, sortedCollationKeysAndIndexes);
        Object[] sortedIndexes = new Integer[sortedCollationKeysAndIndexes.size()];
        for (int i = 0; i < sortedIndexes.length; ++i) {
            sortedIndexes[i] = sortedCollationKeysAndIndexes.get((int)i).integer;
        }
        Assert.assertArrayEquals((Object[])expectedOrder, (Object[])sortedIndexes);
    }

    private List<ByteArrayAndInteger> calculateCollationKeys(String[] inputStrings, String locale, Boolean upperCaseCollator, Integer strength, Integer decomposition) throws Exception {
        ArrayList collationKeysAndIndexes = Lists.newArrayList();
        for (int i = 0; i < inputStrings.length; ++i) {
            byte[] thisCollationKeyBytes = CollationKeyFunctionTest.callFunction(inputStrings[i], locale, upperCaseCollator, strength, decomposition, SortOrder.ASC);
            collationKeysAndIndexes.add(new ByteArrayAndInteger(thisCollationKeyBytes, i));
        }
        return collationKeysAndIndexes;
    }

    private void testCollationKeysEqual(String[] inputStrings, String locale, Boolean upperCaseCollator, Integer strength, Integer decomposition) throws Exception {
        List<ByteArrayAndInteger> collationKeysAndIndexes = this.calculateCollationKeys(inputStrings, locale, upperCaseCollator, strength, decomposition);
        int i = 0;
        for (int j = 1; i < inputStrings.length && j < inputStrings.length; ++i, ++j) {
            boolean isPairEqual;
            byte[] iByteArray = ByteArrayAndInteger.findFirstIntegerMatch(collationKeysAndIndexes, (Integer)Integer.valueOf((int)i)).byteArray;
            byte[] jByteArray = ByteArrayAndInteger.findFirstIntegerMatch(collationKeysAndIndexes, (Integer)Integer.valueOf((int)j)).byteArray;
            boolean bl = isPairEqual = collationKeyComparator.compare(iByteArray, jByteArray) == 0;
            if (isPairEqual) continue;
            Assert.fail((String)String.format("Collation keys for inputStrings [%s] and [%s] ([%s], [%s]) were not equal", inputStrings[i], inputStrings[j], Hex.encodeHexString((byte[])iByteArray), Hex.encodeHexString((byte[])jByteArray)));
        }
    }

    private void testCollationKeysNotEqual(String[] inputStrings, List<ByteArrayAndInteger> collationKeysAndIndexes) throws Exception {
        for (int i = 0; i < inputStrings.length; ++i) {
            for (int j = i + 1; j < inputStrings.length; ++j) {
                boolean isPairEqual;
                byte[] iByteArray = ByteArrayAndInteger.findFirstIntegerMatch(collationKeysAndIndexes, (Integer)Integer.valueOf((int)i)).byteArray;
                byte[] jByteArray = ByteArrayAndInteger.findFirstIntegerMatch(collationKeysAndIndexes, (Integer)Integer.valueOf((int)j)).byteArray;
                boolean bl = isPairEqual = collationKeyComparator.compare(iByteArray, jByteArray) == 0;
                if (!isPairEqual) continue;
                Assert.fail((String)String.format("Collation keys for inputStrings [%s] and [%s] ([%s], [%s]) were equal", inputStrings[i], inputStrings[j], Hex.encodeHexString((byte[])iByteArray), Hex.encodeHexString((byte[])jByteArray)));
            }
        }
    }

    private static byte[] callFunction(String inputStr, String localeIsoCode, Boolean upperCaseCollator, Integer strength, Integer decomposition, SortOrder sortOrder) throws Exception {
        LiteralExpression inputStrLiteral = LiteralExpression.newConstant((Object)inputStr, (PDataType)PVarchar.INSTANCE, (SortOrder)sortOrder);
        LiteralExpression localeIsoCodeLiteral = LiteralExpression.newConstant((Object)localeIsoCode, (PDataType)PVarchar.INSTANCE, (SortOrder)sortOrder);
        LiteralExpression upperCaseBooleanLiteral = LiteralExpression.newConstant((Object)upperCaseCollator, (PDataType)PBoolean.INSTANCE, (SortOrder)sortOrder);
        LiteralExpression strengthLiteral = LiteralExpression.newConstant((Object)strength, (PDataType)PInteger.INSTANCE, (SortOrder)sortOrder);
        LiteralExpression decompositionLiteral = LiteralExpression.newConstant((Object)decomposition, (PDataType)PInteger.INSTANCE, (SortOrder)sortOrder);
        return CollationKeyFunctionTest.callFunction(inputStrLiteral, localeIsoCodeLiteral, upperCaseBooleanLiteral, strengthLiteral, decompositionLiteral);
    }

    private static byte[] callFunction(LiteralExpression inputStrLiteral, LiteralExpression localeIsoCodeLiteral, LiteralExpression upperCaseBooleanLiteral, LiteralExpression strengthLiteral, LiteralExpression decompositionLiteral) throws Exception {
        ImmutableBytesWritable ptr;
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{inputStrLiteral, localeIsoCodeLiteral, upperCaseBooleanLiteral, strengthLiteral, decompositionLiteral});
        CollationKeyFunction collationKeyFunction = new CollationKeyFunction((List)expressions);
        boolean ret = collationKeyFunction.evaluate(null, ptr = new ImmutableBytesWritable());
        byte[] result = ret ? (byte[])collationKeyFunction.getDataType().toObject(ptr, collationKeyFunction.getSortOrder()) : null;
        return result;
    }

    private static class ByteArrayAndInteger {
        byte[] byteArray;
        Integer integer;

        private ByteArrayAndInteger(byte[] byteArray, Integer integer) {
            this.byteArray = byteArray;
            this.integer = integer;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }

        public static ByteArrayAndInteger findFirstIntegerMatch(List<ByteArrayAndInteger> list, Integer matchingInteger) {
            for (ByteArrayAndInteger entry : list) {
                if (!entry.integer.equals(matchingInteger)) continue;
                return entry;
            }
            return null;
        }
    }
}

