/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.function.AggregateFunction;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.function.UDFExpression;
import org.junit.Assert;
import org.junit.Test;

public class BuiltinFunctionConstructorTest {
    @Test
    public void testChildrenListConstructors() throws Exception {
        ExpressionType[] types = ExpressionType.values();
        for (int i = 0; i < types.length; ++i) {
            try {
                Class expressionClass = types[i].getExpressionClass();
                if (Modifier.isAbstract(expressionClass.getModifiers()) || !ScalarFunction.class.isAssignableFrom(expressionClass) || expressionClass == UDFExpression.class) continue;
                Method cloneMethod = expressionClass.getMethod("clone", List.class);
                Assert.assertNotNull((Object)cloneMethod);
                if (cloneMethod.getDeclaringClass() != ScalarFunction.class) continue;
                Constructor cons = expressionClass.getDeclaredConstructor(List.class);
                Assert.assertTrue((String)("Constructor for " + expressionClass + " is not public"), (boolean)Modifier.isPublic(cons.getModifiers()));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to find required List<Expression> constructor " + types[i].getExpressionClass().getName(), e);
            }
        }
    }

    @Test
    public void testNoArgumentConstructors() {
        ExpressionType[] types = ExpressionType.values();
        for (int i = 0; i < types.length; ++i) {
            try {
                if (AggregateFunction.class.isAssignableFrom(types[i].getExpressionClass()) || ExpressionType.EXPRESSION_TYPES_NOT_SUPPORTED_AT_SERVER.contains(types[i].getExpressionClass())) continue;
                Constructor cons = types[i].getExpressionClass().getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                cons.newInstance(new Object[0]);
                continue;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

