/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.StringToArrayFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class StringToArrayFunctionTest {
    private static void testExpression(LiteralExpression array, LiteralExpression delimiter, LiteralExpression nullString, PhoenixArray expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{array});
        expressions.add(delimiter);
        expressions.add(nullString);
        StringToArrayFunction stringToArrayFunction = new StringToArrayFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        stringToArrayFunction.evaluate(null, ptr);
        PhoenixArray result = (PhoenixArray)stringToArrayFunction.getDataType().toObject(ptr, stringToArrayFunction.getSortOrder(), stringToArrayFunction.getMaxLength(), stringToArrayFunction.getScale());
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private static void test(String string, String delimiter, String nullString, PhoenixArray expected, SortOrder stringSortOrder, SortOrder delimiterSortOrder, SortOrder nullStringSortOrder, PDataType stringType, PDataType delimiterType, PDataType nullStringType) throws SQLException {
        LiteralExpression arrayLiteral = LiteralExpression.newConstant((Object)string, (PDataType)stringType, null, null, (SortOrder)stringSortOrder, (Determinism)Determinism.ALWAYS);
        LiteralExpression delimiterLiteral = LiteralExpression.newConstant((Object)delimiter, (PDataType)delimiterType, null, null, (SortOrder)delimiterSortOrder, (Determinism)Determinism.ALWAYS);
        LiteralExpression nullStringLiteral = LiteralExpression.newConstant((Object)nullString, (PDataType)nullStringType, null, null, (SortOrder)nullStringSortOrder, (Determinism)Determinism.ALWAYS);
        StringToArrayFunctionTest.testExpression(arrayLiteral, delimiterLiteral, nullStringLiteral, expected);
    }

    @Test
    public void testStringToArrayFunction1() throws SQLException {
        String string = "1,2,3,4,5";
        Object[] o1 = new Object[]{"1", "2", "3", "4", "5"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = ",";
        String nullString = "*";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction2() throws SQLException {
        String string = "1,2,3,4,5";
        Object[] o1 = new Object[]{"1", "2", "3", "4", "5"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = ",";
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction3() throws SQLException {
        String string = "1234";
        Object[] o1 = new Object[]{"1", "2", "3", "4"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = null;
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction4() throws SQLException {
        String string = "1";
        Object[] o1 = new Object[]{"1"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = ",";
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction5() throws SQLException {
        String string = "hello, hello, hello";
        Object[] o1 = new Object[]{"hello", "hello", "hello"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = ", ";
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction6() throws SQLException {
        String string = "1.2...2.3...5.6";
        Object[] o1 = new Object[]{"1.2", "2.3", "5.6"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = "...";
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction7() throws SQLException {
        String string = "a\\b\\c\\d\\e\\f";
        Object[] o1 = new Object[]{"a", "b", "c", "d", "e", "f"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = "\\";
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction8() throws SQLException {
        String string = "a-b-c-d-e-f-";
        Object[] o1 = new Object[]{"a", "b", "c", "d", "e", "f"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = "-";
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction9() throws SQLException {
        String string = "a b c d e f";
        Object[] o1 = new Object[]{"a", "b", "c", "d", "e", "f"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = " ";
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction10() throws SQLException {
        String string = "axbxcxdxexf";
        Object[] o1 = new Object[]{"a", "b", "c", "d", "e", "f"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = "x";
        String nullString = "";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction11() throws SQLException {
        String string = "axbxcxdxexfx*";
        Object[] o1 = new Object[]{"a", "b", "c", "d", "e", "f", null};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = "x";
        String nullString = "*";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction12() throws SQLException {
        String string = "* a b c d e f";
        Object[] o1 = new Object[]{null, "a", "b", "c", "d", "e", "f"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = " ";
        String nullString = "*";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction13() throws SQLException {
        String string = "a * b * c d e f";
        Object[] o1 = new Object[]{"a", null, "b", null, "c", "d", "e", "f"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = " ";
        String nullString = "*";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction14() throws SQLException {
        String string = "null a null";
        Object[] o1 = new Object[]{null, "a", null};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = " ";
        String nullString = "null";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction16() throws SQLException {
        String string = "null a null";
        Object[] o1 = new Object[]{null, "a", null};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = " ";
        String nullString = "null";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction17() throws SQLException {
        String string = "null a null";
        Object[] o1 = new Object[]{null, "a", null};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = " ";
        String nullString = "null";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PChar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PChar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction18() throws SQLException {
        String string = "null,a,null";
        Object[] o1 = new Object[]{null, "a", null};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = ",";
        String nullString = "null";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction19() throws SQLException {
        String string = "null,a,null";
        Object[] o1 = new Object[]{null, "a", null};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = ",";
        String nullString = "null";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction20() throws SQLException {
        String string = "abc";
        Object[] o1 = new Object[]{"a", "b", "c"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = null;
        String nullString = "null";
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE, (PDataType)PChar.INSTANCE);
    }

    @Test
    public void testStringToArrayFunction21() throws SQLException {
        String string = "(?!^)";
        Object[] o1 = new Object[]{"(", "?", "!", "^", ")"};
        PhoenixArray expected = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        String delimiter = null;
        String nullString = null;
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
        StringToArrayFunctionTest.test(string, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE, (PDataType)PVarchar.INSTANCE);
    }
}

