/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.SignFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PNumericType;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedFloat;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class SignFunctionTest {
    private static void testExpression(LiteralExpression literal, Integer expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{literal});
        SignFunction signFunction = new SignFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        signFunction.evaluate(null, ptr);
        Integer result = (Integer)signFunction.getDataType().toObject(ptr, signFunction.getSortOrder());
        Assert.assertTrue((result.compareTo(expected) == 0 ? 1 : 0) != 0);
    }

    private static void test(Number value, PNumericType dataType, int expected) throws SQLException {
        LiteralExpression literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.ASC);
        SignFunctionTest.testExpression(literal, expected);
        literal = LiteralExpression.newConstant((Object)value, (PDataType)dataType, (SortOrder)SortOrder.DESC);
        SignFunctionTest.testExpression(literal, expected);
    }

    private static void testBatch(Number[] value, PNumericType dataType, int[] expected) throws SQLException {
        Assert.assertEquals((long)value.length, (long)expected.length);
        for (int i = 0; i < value.length; ++i) {
            SignFunctionTest.test(value[i], dataType, expected[i]);
        }
    }

    @Test
    public void testSignFunction() throws Exception {
        SignFunctionTest.testBatch(new BigDecimal[]{BigDecimal.valueOf(1.0), BigDecimal.valueOf(0.0), BigDecimal.valueOf(-1.0), BigDecimal.valueOf(123.1234), BigDecimal.valueOf(-123.1234)}, (PNumericType)PDecimal.INSTANCE, new int[]{1, 0, -1, 1, -1});
        SignFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(-3.4028235E38f), Float.valueOf(-1.4E-45f), Float.valueOf(123.1234f), Float.valueOf(-123.1234f)}, (PNumericType)PFloat.INSTANCE, new int[]{1, 0, -1, 1, 1, -1, -1, 1, -1});
        SignFunctionTest.testBatch(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(123.1234f)}, (PNumericType)PUnsignedFloat.INSTANCE, new int[]{1, 0, 1, 1, 1});
        SignFunctionTest.testBatch(new Double[]{1.0, 0.0, -1.0, Double.MAX_VALUE, Double.MIN_VALUE, -1.7976931348623157E308, -4.9E-324, 123.1234, -123.1234}, (PNumericType)PDouble.INSTANCE, new int[]{1, 0, -1, 1, 1, -1, -1, 1, -1});
        SignFunctionTest.testBatch(new Double[]{1.0, 0.0, Double.MAX_VALUE, Double.MIN_VALUE, 123.1234}, (PNumericType)PUnsignedDouble.INSTANCE, new int[]{1, 0, 1, 1, 1});
        SignFunctionTest.testBatch(new Long[]{1L, 0L, -1L, Long.MAX_VALUE, Long.MIN_VALUE, 123L, -123L}, (PNumericType)PLong.INSTANCE, new int[]{1, 0, -1, 1, -1, 1, -1});
        SignFunctionTest.testBatch(new Long[]{1L, 0L, Long.MAX_VALUE, 123L}, (PNumericType)PLong.INSTANCE, new int[]{1, 0, 1, 1});
        SignFunctionTest.testBatch(new Integer[]{1, 0, -1, Integer.MAX_VALUE, Integer.MIN_VALUE, 123, -123}, (PNumericType)PInteger.INSTANCE, new int[]{1, 0, -1, 1, -1, 1, -1});
        SignFunctionTest.testBatch(new Integer[]{1, 0, Integer.MAX_VALUE, 123}, (PNumericType)PUnsignedInt.INSTANCE, new int[]{1, 0, 1, 1});
        SignFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)-1, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE, (short)123, (short)-123}, (PNumericType)PSmallint.INSTANCE, new int[]{1, 0, -1, 1, -1, 1, -1});
        SignFunctionTest.testBatch(new Short[]{(short)1, (short)0, (short)Short.MAX_VALUE, (short)123}, (PNumericType)PSmallint.INSTANCE, new int[]{1, 0, 1, 1});
        SignFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)-1, (byte)127, (byte)-128, (byte)123, (byte)-123}, (PNumericType)PTinyint.INSTANCE, new int[]{1, 0, -1, 1, -1, 1, -1});
        SignFunctionTest.testBatch(new Byte[]{(byte)1, (byte)0, (byte)127, (byte)123}, (PNumericType)PTinyint.INSTANCE, new int[]{1, 0, 1, 1});
    }
}

