/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CeilDateExpression;
import org.apache.phoenix.expression.function.CeilDecimalExpression;
import org.apache.phoenix.expression.function.CeilMonthExpression;
import org.apache.phoenix.expression.function.CeilWeekExpression;
import org.apache.phoenix.expression.function.CeilYearExpression;
import org.apache.phoenix.expression.function.FloorDateExpression;
import org.apache.phoenix.expression.function.FloorDecimalExpression;
import org.apache.phoenix.expression.function.FloorMonthExpression;
import org.apache.phoenix.expression.function.FloorWeekExpression;
import org.apache.phoenix.expression.function.FloorYearExpression;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.expression.function.RoundDecimalExpression;
import org.apache.phoenix.expression.function.RoundMonthExpression;
import org.apache.phoenix.expression.function.RoundWeekExpression;
import org.apache.phoenix.expression.function.RoundYearExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.GJChronology;
import org.junit.Assert;
import org.junit.Test;

public class RoundFloorCeilExpressionsTest
extends BaseConnectionlessQueryTest {
    private static long HALF_SEC = 500L;
    private static long SEC = 2L * HALF_SEC;
    private static long HALF_MIN = 30000L;
    private static long MIN = 2L * HALF_MIN;
    private static long HALF_HOUR = 1800000L;
    private static long HOUR = 2L * HALF_HOUR;
    private static long HALF_DAY = 43200000L;
    private static long DAY = 2L * HALF_DAY;
    private static long HALF_WEEK = 302400000L;
    private static long WEEK = 2L * HALF_WEEK;
    private static long HALF_YEAR = 15768000000L;
    private static long YEAR = 2L * HALF_YEAR;
    private static final LiteralExpression DUMMY_DECIMAL = LiteralExpression.newConstant((Object)new BigDecimal("2.5"));
    private static final List<BigDecimal> DECIMALS = Collections.unmodifiableList(Arrays.asList(BigDecimal.valueOf(0x7FFFFFFFFFFFFFF3L, 9), BigDecimal.valueOf(Long.MIN_VALUE, 8), new BigDecimal("-200300"), new BigDecimal("-8.44"), new BigDecimal("-2.00"), new BigDecimal("-0.6"), new BigDecimal("-0.00032"), BigDecimal.ZERO, BigDecimal.ONE, new BigDecimal("0.00000984"), new BigDecimal("0.74"), new BigDecimal("2.00"), new BigDecimal("7.09"), new BigDecimal("84900800"), BigDecimal.valueOf(Long.MAX_VALUE, 8), BigDecimal.valueOf(0x7FFFFFFFFFFFFFF2L, 7)));
    private static final List<Integer> SCALES = Collections.unmodifiableList(Arrays.asList(0, 1, 2, 3, 8));

    @Test
    public void testRoundDecimalExpression() throws Exception {
        LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)1.23898, (PDataType)PDecimal.INSTANCE);
        Expression roundDecimalExpression = RoundDecimalExpression.create((Expression)decimalLiteral, (int)3);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        roundDecimalExpression.evaluate(null, ptr);
        Object result = roundDecimalExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof BigDecimal));
        BigDecimal resultDecimal = (BigDecimal)result;
        Assert.assertEquals((Object)BigDecimal.valueOf(1.239), (Object)resultDecimal);
    }

    @Test
    public void testRoundNegativePrecisionDecimalExpression() throws Exception {
        LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)444.44, (PDataType)PDecimal.INSTANCE);
        Expression roundDecimalExpression = RoundDecimalExpression.create((Expression)decimalLiteral, (int)-2);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        roundDecimalExpression.evaluate(null, ptr);
        Object result = roundDecimalExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof BigDecimal));
        BigDecimal resultDecimal = (BigDecimal)result;
        Assert.assertEquals((long)0L, (long)BigDecimal.valueOf(400L).compareTo(resultDecimal));
    }

    @Test
    public void testRoundDecimalExpressionNoop() throws Exception {
        LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)5, (PDataType)PInteger.INSTANCE);
        Expression roundDecimalExpression = RoundDecimalExpression.create((Expression)decimalLiteral, (int)3);
        Assert.assertEquals((Object)roundDecimalExpression, (Object)decimalLiteral);
    }

    @Test
    public void testFloorDecimalExpression() throws Exception {
        LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)1.23898, (PDataType)PDecimal.INSTANCE);
        Expression floorDecimalExpression = FloorDecimalExpression.create((Expression)decimalLiteral, (int)3);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        floorDecimalExpression.evaluate(null, ptr);
        Object result = floorDecimalExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof BigDecimal));
        BigDecimal resultDecimal = (BigDecimal)result;
        Assert.assertEquals((Object)BigDecimal.valueOf(1.238), (Object)resultDecimal);
    }

    @Test
    public void testFloorDecimalExpressionNoop() throws Exception {
        LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)5, (PDataType)PInteger.INSTANCE);
        Expression floorDecimalExpression = FloorDecimalExpression.create((Expression)decimalLiteral, (int)3);
        Assert.assertEquals((Object)floorDecimalExpression, (Object)decimalLiteral);
    }

    @Test
    public void testCeilDecimalExpression() throws Exception {
        LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)1.23898, (PDataType)PDecimal.INSTANCE);
        Expression ceilDecimalExpression = CeilDecimalExpression.create((Expression)decimalLiteral, (int)3);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ceilDecimalExpression.evaluate(null, ptr);
        Object result = ceilDecimalExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof BigDecimal));
        BigDecimal resultDecimal = (BigDecimal)result;
        Assert.assertEquals((Object)BigDecimal.valueOf(1.239), (Object)resultDecimal);
    }

    @Test
    public void testCeilDecimalExpressionNoop() throws Exception {
        LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)5, (PDataType)PInteger.INSTANCE);
        Expression ceilDecimalExpression = CeilDecimalExpression.create((Expression)decimalLiteral, (int)3);
        Assert.assertEquals((Object)ceilDecimalExpression, (Object)decimalLiteral);
    }

    @Test
    public void testRoundDecimalExpressionScaleParamValidation() throws Exception {
        LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)1.23898, (PDataType)PDecimal.INSTANCE);
        LiteralExpression scale = LiteralExpression.newConstant((Object)"3", (PDataType)PVarchar.INSTANCE);
        ArrayList<LiteralExpression> childExpressions = new ArrayList<LiteralExpression>(2);
        childExpressions.add(decimalLiteral);
        childExpressions.add(scale);
        try {
            RoundDecimalExpression.create(childExpressions);
            Assert.fail((String)"Evaluation should have failed because only an INTEGER is allowed for second param in a RoundDecimalExpression");
        }
        catch (IllegalDataException illegalDataException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundDecimalExpressionKeyRangeSimple() throws Exception {
        KeyPart baseKeyPart = RoundFloorCeilExpressionsTest.getDecimalKeyPart();
        ScalarFunction roundDecimalExpression = (ScalarFunction)RoundDecimalExpression.create((Expression)DUMMY_DECIMAL, (int)3);
        byte[] upperBound = PDecimal.INSTANCE.toBytes((Object)new BigDecimal("1.2385"));
        byte[] lowerBound = PDecimal.INSTANCE.toBytes((Object)new BigDecimal("1.2375"));
        KeyRange expectedKeyRange = KeyRange.getKeyRange((byte[])lowerBound, (byte[])upperBound);
        KeyPart keyPart = roundDecimalExpression.newKeyPart(baseKeyPart);
        Assert.assertEquals((Object)expectedKeyRange, (Object)keyPart.getKeyRange(CompareOperator.EQUAL, (Expression)LiteralExpression.newConstant((Object)new BigDecimal("1.238"), (PDataType)PDecimal.INSTANCE)));
    }

    @Test
    public void testFloorDecimalExpressionKeyRangeSimple() throws Exception {
        KeyPart baseKeyPart = RoundFloorCeilExpressionsTest.getDecimalKeyPart();
        ScalarFunction floorDecimalExpression = (ScalarFunction)FloorDecimalExpression.create((Expression)DUMMY_DECIMAL, (int)3);
        byte[] upperBound = PDecimal.INSTANCE.toBytes((Object)new BigDecimal("1.239"));
        byte[] lowerBound = PDecimal.INSTANCE.toBytes((Object)new BigDecimal("1.238"));
        KeyRange expectedKeyRange = KeyRange.getKeyRange((byte[])lowerBound, (boolean)true, (byte[])upperBound, (boolean)false);
        KeyPart keyPart = floorDecimalExpression.newKeyPart(baseKeyPart);
        Assert.assertEquals((Object)expectedKeyRange, (Object)keyPart.getKeyRange(CompareOperator.EQUAL, (Expression)LiteralExpression.newConstant((Object)new BigDecimal("1.238"), (PDataType)PDecimal.INSTANCE)));
    }

    @Test
    public void testCeilDecimalExpressionKeyRangeSimple() throws Exception {
        KeyPart baseKeyPart = RoundFloorCeilExpressionsTest.getDecimalKeyPart();
        ScalarFunction ceilDecimalExpression = (ScalarFunction)CeilDecimalExpression.create((Expression)DUMMY_DECIMAL, (int)3);
        byte[] upperBound = PDecimal.INSTANCE.toBytes((Object)new BigDecimal("1.238"));
        byte[] lowerBound = PDecimal.INSTANCE.toBytes((Object)new BigDecimal("1.237"));
        KeyRange expectedKeyRange = KeyRange.getKeyRange((byte[])lowerBound, (boolean)false, (byte[])upperBound, (boolean)true);
        KeyPart keyPart = ceilDecimalExpression.newKeyPart(baseKeyPart);
        Assert.assertEquals((Object)expectedKeyRange, (Object)keyPart.getKeyRange(CompareOperator.EQUAL, (Expression)LiteralExpression.newConstant((Object)new BigDecimal("1.238"), (PDataType)PDecimal.INSTANCE)));
    }

    @Test
    public void testRoundDecimalExpressionKeyRangeCoverage() throws Exception {
        KeyPart baseKeyPart = RoundFloorCeilExpressionsTest.getDecimalKeyPart();
        for (int scale : SCALES) {
            ScalarFunction roundDecimalExpression = (ScalarFunction)RoundDecimalExpression.create((Expression)DUMMY_DECIMAL, (int)scale);
            KeyPart keyPart = roundDecimalExpression.newKeyPart(baseKeyPart);
            this.verifyKeyPart(RoundingType.ROUND, scale, keyPart);
        }
    }

    private static KeyPart getDecimalKeyPart() throws SQLException {
        String tableName = RoundFloorCeilExpressionsTest.generateUniqueName();
        try (PhoenixConnection pconn = DriverManager.getConnection(RoundFloorCeilExpressionsTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);){
            KeyPart baseKeyPart;
            pconn.createStatement().execute("CREATE TABLE " + tableName + " (k DECIMAL PRIMARY KEY)");
            final PTable table = pconn.getMetaDataCache().getTableRef(new PTableKey(null, tableName)).getTable();
            KeyPart keyPart = baseKeyPart = new KeyPart(){

                public KeyRange getKeyRange(CompareOperator op, Expression rhs) {
                    return KeyRange.EVERYTHING_RANGE;
                }

                public Set<Expression> getExtractNodes() {
                    return Collections.emptySet();
                }

                public PColumn getColumn() {
                    return (PColumn)table.getPKColumns().get(0);
                }

                public PTable getTable() {
                    return table;
                }
            };
            return keyPart;
        }
    }

    @Test
    public void testFloorDecimalExpressionKeyRangeCoverage() throws Exception {
        KeyPart baseKeyPart = RoundFloorCeilExpressionsTest.getDecimalKeyPart();
        for (int scale : SCALES) {
            ScalarFunction floorDecimalExpression = (ScalarFunction)FloorDecimalExpression.create((Expression)DUMMY_DECIMAL, (int)scale);
            KeyPart keyPart = floorDecimalExpression.newKeyPart(baseKeyPart);
            this.verifyKeyPart(RoundingType.FLOOR, scale, keyPart);
        }
    }

    @Test
    public void testCeilDecimalExpressionKeyRangeCoverage() throws Exception {
        KeyPart baseKeyPart = RoundFloorCeilExpressionsTest.getDecimalKeyPart();
        for (int scale : SCALES) {
            ScalarFunction ceilDecimalExpression = (ScalarFunction)CeilDecimalExpression.create((Expression)DUMMY_DECIMAL, (int)scale);
            KeyPart keyPart = ceilDecimalExpression.newKeyPart(baseKeyPart);
            this.verifyKeyPart(RoundingType.CEIL, scale, keyPart);
        }
    }

    private static String getMessage(RoundingType exprType, int scale, Relation relation, BigDecimal rhs, KeyRange range) {
        String where = exprType.name + "(?, " + scale + ") " + relation.symbol + " " + rhs;
        return "'where " + where + "' (produced range: " + RoundFloorCeilExpressionsTest.formatDecimalKeyRange(range) + " )";
    }

    private static String formatDecimalKeyRange(KeyRange range) {
        return (range.isLowerInclusive() ? "[" : "(") + (range.lowerUnbound() ? "*" : PDecimal.INSTANCE.toObject(range.getLowerRange())) + ", " + (range.upperUnbound() ? "*" : PDecimal.INSTANCE.toObject(range.getUpperRange())) + (range.isUpperInclusive() ? "]" : ")");
    }

    private void verifyKeyPart(RoundingType exprType, int scale, KeyPart keyPart) throws SQLException {
        for (BigDecimal rhsDecimal : DECIMALS) {
            LiteralExpression rhsExpression = LiteralExpression.newConstant((Object)rhsDecimal, (PDataType)PDecimal.INSTANCE);
            for (Relation relation : Relation.values()) {
                KeyRange keyRange = keyPart.getKeyRange(relation.compareOp, (Expression)rhsExpression);
                this.verifyKeyRange(exprType, scale, relation, rhsDecimal, keyRange);
            }
        }
    }

    private void verifyKeyRange(RoundingType exprType, int scale, Relation relation, BigDecimal rhs, KeyRange range) throws SQLException {
        String dump = RoundFloorCeilExpressionsTest.getMessage(exprType, scale, relation, rhs, range);
        ImmutableBytesPtr rhsPtr = new ImmutableBytesPtr();
        LiteralExpression.newConstant((Object)rhs, (PDataType)PDecimal.INSTANCE).evaluate(null, (ImmutableBytesWritable)rhsPtr);
        ImmutableBytesPtr lhsPtr = new ImmutableBytesPtr();
        if (range == KeyRange.EMPTY_RANGE) {
            Assert.assertTrue((String)("should only get empty key range for unmatchable rhs precision (" + dump + ")"), (rhs.scale() > scale ? 1 : 0) != 0);
            Assert.assertEquals((String)("should only get empty key range for equals checks (" + dump + ")"), (Object)((Object)Relation.EQUAL), (Object)((Object)relation));
            return;
        }
        if (relation != Relation.GREATER && relation != Relation.GREATER_OR_EQUAL) {
            byte[] lowestHighExcluded;
            byte[] highestHighIncluded;
            if (range.isUpperInclusive()) {
                highestHighIncluded = range.getUpperRange();
                lowestHighExcluded = RoundFloorCeilExpressionsTest.nextDecimalKey(range.getUpperRange());
            } else {
                highestHighIncluded = RoundFloorCeilExpressionsTest.prevDecimalKey(range.getUpperRange());
                lowestHighExcluded = range.getUpperRange();
            }
            exprType.getExpression(highestHighIncluded, scale).evaluate(null, (ImmutableBytesWritable)lhsPtr);
            Assert.assertTrue((String)("incorrectly excluding " + PDecimal.INSTANCE.toObject(highestHighIncluded) + " in upper bound for " + dump), (boolean)relation.compare(lhsPtr, rhsPtr));
            exprType.getExpression(lowestHighExcluded, scale).evaluate(null, (ImmutableBytesWritable)lhsPtr);
            Assert.assertFalse((String)("incorrectly including " + PDecimal.INSTANCE.toObject(lowestHighExcluded) + " in upper bound for " + dump), (boolean)relation.compare(lhsPtr, rhsPtr));
        } else {
            Assert.assertTrue((String)("should not have a upper bound for " + dump), (boolean)range.upperUnbound());
        }
        if (relation != Relation.LESS && relation != Relation.LESS_OR_EQUAL) {
            byte[] highestLowExcluded;
            byte[] lowestLowIncluded;
            if (range.isLowerInclusive()) {
                lowestLowIncluded = range.getLowerRange();
                highestLowExcluded = RoundFloorCeilExpressionsTest.prevDecimalKey(range.getLowerRange());
            } else {
                lowestLowIncluded = RoundFloorCeilExpressionsTest.nextDecimalKey(range.getLowerRange());
                highestLowExcluded = range.getLowerRange();
            }
            exprType.getExpression(lowestLowIncluded, scale).evaluate(null, (ImmutableBytesWritable)lhsPtr);
            Assert.assertTrue((String)("incorrectly excluding " + PDecimal.INSTANCE.toObject(lowestLowIncluded) + " in lower bound for " + dump), (boolean)relation.compare(lhsPtr, rhsPtr));
            exprType.getExpression(highestLowExcluded, scale).evaluate(null, (ImmutableBytesWritable)lhsPtr);
            Assert.assertFalse((String)("incorrectly including " + PDecimal.INSTANCE.toObject(highestLowExcluded) + " in lower bound for " + dump), (boolean)relation.compare(lhsPtr, rhsPtr));
        } else {
            Assert.assertTrue((String)("should not have a lower bound for " + dump), (boolean)range.lowerUnbound());
        }
    }

    private static byte[] prevDecimalKey(byte[] key) {
        BigDecimal decimal = (BigDecimal)PDecimal.INSTANCE.toObject(key);
        BigDecimal prev = decimal.subtract(RoundFloorCeilExpressionsTest.getSmallestUnit(decimal));
        return PDecimal.INSTANCE.toBytes((Object)prev);
    }

    private static byte[] nextDecimalKey(byte[] key) {
        BigDecimal decimal = (BigDecimal)PDecimal.INSTANCE.toObject(key);
        BigDecimal next = decimal.add(RoundFloorCeilExpressionsTest.getSmallestUnit(decimal));
        return PDecimal.INSTANCE.toBytes((Object)next);
    }

    private static BigDecimal getSmallestUnit(BigDecimal decimal) {
        if (decimal.precision() > 38) {
            throw new IllegalArgumentException("rounding errors mean that we cannot reliably test " + decimal);
        }
        int minScale = decimal.scale() + (38 - decimal.precision());
        return BigDecimal.valueOf(1L, minScale);
    }

    @Test
    public void testRoundDateExpression() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2012-01-01 14:25:28"), (PDataType)PDate.INSTANCE);
        Expression roundDateExpression = RoundDateExpression.create((Expression)dateLiteral, (TimeUnit)TimeUnit.DAY);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        roundDateExpression.evaluate(null, ptr);
        Object result = roundDateExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof Date));
        Date resultDate = (Date)result;
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2012-01-02 00:00:00"), (Object)resultDate);
    }

    @Test
    public void testRoundDateExpressionWithMultiplier() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2012-01-01 14:25:28"), (PDataType)PDate.INSTANCE);
        Expression roundDateExpression = RoundDateExpression.create((Expression)dateLiteral, (TimeUnit)TimeUnit.MINUTE, (int)10);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        roundDateExpression.evaluate(null, ptr);
        Object result = roundDateExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof Date));
        Date resultDate = (Date)result;
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2012-01-01 14:30:00"), (Object)resultDate);
    }

    @Test
    public void testFloorDateExpression() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2012-01-01 14:25:28"), (PDataType)PDate.INSTANCE);
        Expression floorDateExpression = FloorDateExpression.create((Expression)dateLiteral, (TimeUnit)TimeUnit.DAY);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        floorDateExpression.evaluate(null, ptr);
        Object result = floorDateExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof Date));
        Date resultDate = (Date)result;
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2012-01-01 00:00:00"), (Object)resultDate);
    }

    @Test
    public void testFloorDateExpressionWithMultiplier() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2012-01-01 14:25:28"), (PDataType)PDate.INSTANCE);
        Expression floorDateExpression = FloorDateExpression.create((Expression)dateLiteral, (TimeUnit)TimeUnit.SECOND, (int)10);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        floorDateExpression.evaluate(null, ptr);
        Object result = floorDateExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof Date));
        Date resultDate = (Date)result;
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2012-01-01 14:25:20"), (Object)resultDate);
    }

    @Test
    public void testCeilDateExpression() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2012-01-01 14:25:28"), (PDataType)PDate.INSTANCE);
        Expression ceilDateExpression = CeilDateExpression.create((Expression)dateLiteral, (TimeUnit)TimeUnit.DAY);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ceilDateExpression.evaluate(null, ptr);
        Object result = ceilDateExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof Date));
        Date resultDate = (Date)result;
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2012-01-02 00:00:00"), (Object)resultDate);
    }

    @Test
    public void testCeilDateExpressionWithMultiplier() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2012-01-01 14:25:28"), (PDataType)PDate.INSTANCE);
        Expression ceilDateExpression = CeilDateExpression.create((Expression)dateLiteral, (TimeUnit)TimeUnit.SECOND, (int)10);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ceilDateExpression.evaluate(null, ptr);
        Object result = ceilDateExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof Date));
        Date resultDate = (Date)result;
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2012-01-01 14:25:30"), (Object)resultDate);
    }

    @Test
    public void testRoundDateExpressionValidation_1() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2012-01-01 14:25:28"), (PDataType)PDate.INSTANCE);
        ArrayList<LiteralExpression> childExpressions = new ArrayList<LiteralExpression>(1);
        childExpressions.add(dateLiteral);
        try {
            RoundDateExpression.create(childExpressions);
            Assert.fail((String)"Instantiating a RoundDateExpression with only one argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundDateExpressionValidation_2() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2012-01-01 14:25:28"), (PDataType)PDate.INSTANCE);
        LiteralExpression timeUnitLiteral = LiteralExpression.newConstant((Object)"millis", (PDataType)PVarchar.INSTANCE);
        ArrayList<LiteralExpression> childExpressions = new ArrayList<LiteralExpression>(1);
        childExpressions.add(dateLiteral);
        childExpressions.add(timeUnitLiteral);
        try {
            RoundDateExpression.create(childExpressions);
            Assert.fail((String)"Only a valid time unit represented by TimeUnit enum is allowed and millis is invalid.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFloorDateExpressionForWeek() throws Exception {
        LiteralExpression dateLiteral = LiteralExpression.newConstant((Object)DateUtil.parseDate((String)"2016-01-07 08:17:28"), (PDataType)PDate.INSTANCE);
        Expression floorDateExpression = FloorDateExpression.create((Expression)dateLiteral, (TimeUnit)TimeUnit.WEEK);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        floorDateExpression.evaluate(null, ptr);
        Object result = floorDateExpression.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(result instanceof Date));
        Date resultDate = (Date)result;
        Assert.assertEquals((Object)DateUtil.parseDate((String)"2016-01-04 00:00:00"), (Object)resultDate);
    }

    private RoundDateExpression getRoundMsExpression(String s, TimeUnit u, int m) throws SQLException {
        return (RoundDateExpression)RoundDateExpression.create((Expression)LiteralExpression.newConstant((Object)s), (TimeUnit)u, (int)m);
    }

    @Test
    public void testRoundingGMT() throws SQLException {
        RoundDateExpression oddWholeSecondExp = this.getRoundMsExpression("2022-11-11 11:11:11", TimeUnit.SECOND, 1);
        Timestamp oddWholeSecond = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:11").getTime());
        long lowerBoundaryOddWholeSecond = oddWholeSecond.getTime() - HALF_SEC;
        long upperBoundaryOddWholeSecond = oddWholeSecond.getTime() + HALF_SEC - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeSecond, (long)oddWholeSecondExp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecond, (long)oddWholeSecondExp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(lowerBoundaryOddWholeSecond)));
        Assert.assertNotEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(lowerBoundaryOddWholeSecond - 1L)));
        Assert.assertEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(upperBoundaryOddWholeSecond)));
        Assert.assertNotEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(upperBoundaryOddWholeSecond + 1L)));
        RoundDateExpression oddWholeSecondRound10Exp = this.getRoundMsExpression("2022-11-11 11:11:10", TimeUnit.SECOND, 10);
        Timestamp oddWholeSecondRound10 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:10").getTime());
        long lowerBoundaryOddWholeSecondRound10 = oddWholeSecondRound10.getTime() - 5L * SEC;
        long upperBoundaryOddWholeSecondRound10 = oddWholeSecondRound10.getTime() + 5L * SEC - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeSecondRound10, (long)oddWholeSecondRound10Exp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecondRound10, (long)oddWholeSecondRound10Exp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecondRound10, (Object)new Timestamp(oddWholeSecondRound10Exp.roundTime(lowerBoundaryOddWholeSecondRound10)));
        Assert.assertNotEquals((Object)oddWholeSecondRound10, (Object)new Timestamp(oddWholeSecondRound10Exp.roundTime(lowerBoundaryOddWholeSecondRound10 - 1L)));
        Assert.assertEquals((Object)oddWholeSecondRound10, (Object)new Timestamp(oddWholeSecondRound10Exp.roundTime(upperBoundaryOddWholeSecondRound10)));
        Assert.assertNotEquals((Object)oddWholeSecondRound10, (Object)new Timestamp(oddWholeSecondRound10Exp.roundTime(upperBoundaryOddWholeSecondRound10 + 1L)));
        RoundDateExpression oddWholeSecondRound15Exp = this.getRoundMsExpression("2022-11-11 11:11:15", TimeUnit.SECOND, 15);
        Timestamp oddWholeSecondRound15 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:15").getTime());
        long lowerBoundaryOddWholeSecondRound15 = oddWholeSecondRound15.getTime() - 15L * HALF_SEC;
        long upperBoundaryOddWholeSecondRound15 = oddWholeSecondRound15.getTime() + 15L * HALF_SEC - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeSecondRound15, (long)oddWholeSecondRound15Exp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecondRound15, (long)oddWholeSecondRound15Exp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecondRound15, (Object)new Timestamp(oddWholeSecondRound15Exp.roundTime(lowerBoundaryOddWholeSecondRound15)));
        Assert.assertNotEquals((Object)oddWholeSecondRound15, (Object)new Timestamp(oddWholeSecondRound15Exp.roundTime(lowerBoundaryOddWholeSecondRound15 - 1L)));
        Assert.assertEquals((Object)oddWholeSecondRound15, (Object)new Timestamp(oddWholeSecondRound15Exp.roundTime(upperBoundaryOddWholeSecondRound15)));
        Assert.assertNotEquals((Object)oddWholeSecondRound15, (Object)new Timestamp(oddWholeSecondRound15Exp.roundTime(upperBoundaryOddWholeSecondRound15 + 1L)));
        RoundDateExpression evenWholeSecondExp = this.getRoundMsExpression("2022-11-11 11:11:12", TimeUnit.SECOND, 1);
        Timestamp evenWholeSecond = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:12").getTime());
        long lowerBoundaryEvenWholeSecond = evenWholeSecond.getTime() - HALF_SEC;
        long upperBoundaryEvenWholeSecond = evenWholeSecond.getTime() + HALF_SEC - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeSecond, (long)evenWholeSecondExp.rangeLower(evenWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeSecond, (long)evenWholeSecondExp.rangeUpper(evenWholeSecond.getTime()));
        Assert.assertEquals((Object)evenWholeSecond, (Object)new Timestamp(evenWholeSecondExp.roundTime(lowerBoundaryEvenWholeSecond)));
        Assert.assertNotEquals((Object)evenWholeSecond, (Object)new Timestamp(evenWholeSecondExp.roundTime(lowerBoundaryEvenWholeSecond - 1L)));
        Assert.assertEquals((Object)evenWholeSecond, (Object)new Timestamp(evenWholeSecondExp.roundTime(upperBoundaryEvenWholeSecond)));
        Assert.assertNotEquals((Object)evenWholeSecond, (Object)new Timestamp(evenWholeSecondExp.roundTime(upperBoundaryEvenWholeSecond + 1L)));
        RoundDateExpression oddWholeMinuteExp = this.getRoundMsExpression("2022-11-11 11:11:0", TimeUnit.MINUTE, 1);
        Timestamp oddWholeMinute = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:0").getTime());
        long lowerBoundaryOddWholeMinute = oddWholeMinute.getTime() - HALF_MIN;
        long upperBoundaryOddWholeMinute = oddWholeMinute.getTime() + HALF_MIN - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeMinute, (long)oddWholeMinuteExp.rangeLower(oddWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeMinute, (long)oddWholeMinuteExp.rangeUpper(oddWholeMinute.getTime()));
        Assert.assertEquals((Object)oddWholeMinute, (Object)new Timestamp(oddWholeMinuteExp.roundTime(lowerBoundaryOddWholeMinute)));
        Assert.assertNotEquals((Object)oddWholeMinute, (Object)new Timestamp(oddWholeMinuteExp.roundTime(lowerBoundaryOddWholeMinute - 1L)));
        Assert.assertEquals((Object)oddWholeMinute, (Object)new Timestamp(oddWholeMinuteExp.roundTime(upperBoundaryOddWholeMinute)));
        Assert.assertNotEquals((Object)oddWholeMinute, (Object)new Timestamp(oddWholeMinuteExp.roundTime(upperBoundaryOddWholeMinute + 1L)));
        RoundDateExpression oddWholeMinuteRound20Exp = this.getRoundMsExpression("2022-11-11 11:20:0", TimeUnit.MINUTE, 20);
        Timestamp oddWholeMinuteRound20 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:20:0").getTime());
        long lowerBoundaryOddWholeMinute20 = oddWholeMinuteRound20.getTime() - 10L * MIN;
        long upperBoundaryOddWholeMinute20 = oddWholeMinuteRound20.getTime() + 10L * MIN - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeMinute20, (long)oddWholeMinuteRound20Exp.rangeLower(oddWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeMinute20, (long)oddWholeMinuteRound20Exp.rangeUpper(oddWholeMinute.getTime()));
        Assert.assertEquals((Object)oddWholeMinuteRound20, (Object)new Timestamp(oddWholeMinuteRound20Exp.roundTime(lowerBoundaryOddWholeMinute20)));
        Assert.assertNotEquals((Object)oddWholeMinuteRound20, (Object)new Timestamp(oddWholeMinuteRound20Exp.roundTime(lowerBoundaryOddWholeMinute20 - 1L)));
        Assert.assertEquals((Object)oddWholeMinuteRound20, (Object)new Timestamp(oddWholeMinuteRound20Exp.roundTime(upperBoundaryOddWholeMinute20)));
        Assert.assertNotEquals((Object)oddWholeMinuteRound20, (Object)new Timestamp(oddWholeMinuteRound20Exp.roundTime(upperBoundaryOddWholeMinute20 + 1L)));
        RoundDateExpression oddWholeMinuteRound17Exp = this.getRoundMsExpression("2022-11-11 11:12:0", TimeUnit.MINUTE, 17);
        Timestamp oddWholeMinuteRound17 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:12:00").getTime());
        long lowerBoundaryOddWholeMinute17 = oddWholeMinuteRound17.getTime() - 17L * HALF_MIN;
        long upperBoundaryOddWholeMinute17 = oddWholeMinuteRound17.getTime() + 17L * HALF_MIN - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeMinute17, (long)oddWholeMinuteRound17Exp.rangeLower(oddWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeMinute17, (long)oddWholeMinuteRound17Exp.rangeUpper(oddWholeMinute.getTime()));
        Assert.assertEquals((Object)oddWholeMinuteRound17, (Object)new Timestamp(oddWholeMinuteRound17Exp.roundTime(lowerBoundaryOddWholeMinute17)));
        Assert.assertNotEquals((Object)oddWholeMinuteRound17, (Object)new Timestamp(oddWholeMinuteRound17Exp.roundTime(lowerBoundaryOddWholeMinute17 - 1L)));
        Assert.assertEquals((Object)oddWholeMinuteRound17, (Object)new Timestamp(oddWholeMinuteRound17Exp.roundTime(upperBoundaryOddWholeMinute17)));
        Assert.assertNotEquals((Object)oddWholeMinuteRound17, (Object)new Timestamp(oddWholeMinuteRound17Exp.roundTime(upperBoundaryOddWholeMinute17 + 1L)));
        RoundDateExpression evenWholeMinuteExp = this.getRoundMsExpression("2022-11-11 11:12:0", TimeUnit.MINUTE, 1);
        Timestamp evenWholeMinute = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:12:0").getTime());
        long lowerBoundaryEvenWholeMinute = evenWholeMinute.getTime() - HALF_MIN;
        long upperBoundaryEvenWholeMinute = evenWholeMinute.getTime() + HALF_MIN - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeMinute, (long)evenWholeMinuteExp.rangeLower(evenWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeMinute, (long)evenWholeMinuteExp.rangeUpper(evenWholeMinute.getTime()));
        Assert.assertEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(lowerBoundaryEvenWholeMinute)));
        Assert.assertNotEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(lowerBoundaryEvenWholeMinute - 1L)));
        Assert.assertEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(upperBoundaryEvenWholeMinute)));
        Assert.assertNotEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(upperBoundaryEvenWholeMinute + 1L)));
        RoundDateExpression oddWholeHourExp = this.getRoundMsExpression("2022-11-11 11:0:0", TimeUnit.HOUR, 1);
        Timestamp oddWholeHour = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:0:0").getTime());
        long lowerBoundaryOddWholeHour = oddWholeHour.getTime() - HALF_HOUR;
        long upperBoundaryOddWholeHour = oddWholeHour.getTime() + HALF_HOUR - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeHour, (long)oddWholeHourExp.rangeLower(oddWholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeHour, (long)oddWholeHourExp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(lowerBoundaryOddWholeHour)));
        Assert.assertNotEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(lowerBoundaryOddWholeHour - 1L)));
        Assert.assertEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(upperBoundaryOddWholeHour)));
        Assert.assertNotEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(upperBoundaryOddWholeHour + 1L)));
        RoundDateExpression oddWholeHour10Exp = this.getRoundMsExpression("2022-11-11 12:0:0", TimeUnit.HOUR, 10);
        Timestamp oddWholeHour10 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 12:0:0").getTime());
        long lowerBoundaryOddWholeHour10 = oddWholeHour10.getTime() - HALF_HOUR * 10L;
        long upperBoundaryOddWholeHour10 = oddWholeHour10.getTime() + HALF_HOUR * 10L - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeHour10, (long)oddWholeHour10Exp.rangeLower(oddWholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeHour10, (long)oddWholeHour10Exp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(lowerBoundaryOddWholeHour10)));
        Assert.assertNotEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(lowerBoundaryOddWholeHour10 - 1L)));
        Assert.assertEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(upperBoundaryOddWholeHour10)));
        Assert.assertNotEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(upperBoundaryOddWholeHour10 + 1L)));
        RoundDateExpression oddWholeHour11Exp = this.getRoundMsExpression("2022-11-11 07:0:0", TimeUnit.HOUR, 11);
        Timestamp oddWholeHour11 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 07:0:0").getTime());
        long lowerBoundaryOddWholeHour11 = oddWholeHour11.getTime() - HALF_HOUR * 11L;
        long upperBoundaryOddWholeHour11 = oddWholeHour11.getTime() + HALF_HOUR * 11L - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeHour11, (long)oddWholeHour11Exp.rangeLower(oddWholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeHour11, (long)oddWholeHour11Exp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(lowerBoundaryOddWholeHour11)));
        Assert.assertNotEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(lowerBoundaryOddWholeHour11 - 1L)));
        Assert.assertEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(upperBoundaryOddWholeHour11)));
        Assert.assertNotEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(upperBoundaryOddWholeHour11 + 1L)));
        RoundDateExpression evenwholeHourExp = this.getRoundMsExpression("2022-11-11 12:0:0", TimeUnit.HOUR, 1);
        Timestamp evenwholeHour = new Timestamp(DateUtil.parseDate((String)"2022-11-11 12:0:0").getTime());
        long lowerBoundaryEvenWholeHour = evenwholeHour.getTime() - HALF_HOUR;
        long upperBoundaryEvenWholeHour = evenwholeHour.getTime() + HALF_HOUR - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeHour, (long)evenwholeHourExp.rangeLower(evenwholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeHour, (long)evenwholeHourExp.rangeUpper(evenwholeHour.getTime()));
        Assert.assertEquals((Object)evenwholeHour, (Object)new Timestamp(evenwholeHourExp.roundTime(lowerBoundaryEvenWholeHour)));
        Assert.assertNotEquals((Object)evenwholeHour, (Object)new Timestamp(evenwholeHourExp.roundTime(lowerBoundaryEvenWholeHour - 1L)));
        Assert.assertEquals((Object)evenwholeHour, (Object)new Timestamp(evenwholeHourExp.roundTime(upperBoundaryEvenWholeHour)));
        Assert.assertNotEquals((Object)evenwholeHour, (Object)new Timestamp(evenwholeHourExp.roundTime(upperBoundaryEvenWholeHour + 1L)));
        RoundDateExpression oddWholeDayExp = this.getRoundMsExpression("2022-11-11 0:0:0", TimeUnit.DAY, 1);
        Timestamp oddWholeDay = new Timestamp(DateUtil.parseDate((String)"2022-11-11 0:0:0").getTime());
        long lowerBoundaryOddWholeDay = oddWholeDay.getTime() - HALF_DAY;
        long upperBoundaryOddWholeDay = oddWholeDay.getTime() + HALF_DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeDay, (long)oddWholeDayExp.rangeLower(oddWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeDay, (long)oddWholeDayExp.rangeUpper(oddWholeDay.getTime()));
        Assert.assertEquals((Object)oddWholeDay, (Object)new Timestamp(oddWholeDayExp.roundTime(lowerBoundaryOddWholeDay)));
        Assert.assertNotEquals((Object)oddWholeDay, (Object)new Timestamp(oddWholeDayExp.roundTime(lowerBoundaryOddWholeDay - 1L)));
        Assert.assertEquals((Object)oddWholeDay, (Object)new Timestamp(oddWholeDayExp.roundTime(upperBoundaryOddWholeDay)));
        Assert.assertNotEquals((Object)oddWholeDay, (Object)new Timestamp(oddWholeDayExp.roundTime(upperBoundaryOddWholeDay + 1L)));
        RoundDateExpression oddWholeDay10Exp = this.getRoundMsExpression("2022-11-14 0:0:0", TimeUnit.DAY, 10);
        Timestamp oddWholeDay10 = new Timestamp(DateUtil.parseDate((String)"2022-11-14 0:0:0").getTime());
        long lowerBoundaryOddWholeDay10 = oddWholeDay10.getTime() - 10L * HALF_DAY;
        long upperBoundaryOddWholeDay10 = oddWholeDay10.getTime() + 10L * HALF_DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeDay10, (long)oddWholeDay10Exp.rangeLower(oddWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeDay10, (long)oddWholeDay10Exp.rangeUpper(oddWholeDay.getTime()));
        Assert.assertEquals((Object)oddWholeDay10, (Object)new Timestamp(oddWholeDay10Exp.roundTime(lowerBoundaryOddWholeDay10)));
        Assert.assertNotEquals((Object)oddWholeDay10, (Object)new Timestamp(oddWholeDay10Exp.roundTime(lowerBoundaryOddWholeDay10 - 1L)));
        Assert.assertEquals((Object)oddWholeDay10, (Object)new Timestamp(oddWholeDay10Exp.roundTime(upperBoundaryOddWholeDay10)));
        Assert.assertNotEquals((Object)oddWholeDay10, (Object)new Timestamp(oddWholeDay10Exp.roundTime(upperBoundaryOddWholeDay10 + 1L)));
        RoundDateExpression oddWholeDay3Exp = this.getRoundMsExpression("2022-11-12 0:0:0", TimeUnit.DAY, 3);
        Timestamp oddWholeDay3 = new Timestamp(DateUtil.parseDate((String)"2022-11-12 0:0:0").getTime());
        long lowerBoundaryOddWholeDay3 = oddWholeDay3.getTime() - 3L * HALF_DAY;
        long upperBoundaryOddWholeDay3 = oddWholeDay3.getTime() + 3L * HALF_DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeDay3, (long)oddWholeDay3Exp.rangeLower(oddWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeDay3, (long)oddWholeDay3Exp.rangeUpper(oddWholeDay.getTime()));
        Assert.assertEquals((Object)oddWholeDay3, (Object)new Timestamp(oddWholeDay3Exp.roundTime(lowerBoundaryOddWholeDay3)));
        Assert.assertNotEquals((Object)oddWholeDay3, (Object)new Timestamp(oddWholeDay3Exp.roundTime(lowerBoundaryOddWholeDay3 - 1L)));
        Assert.assertEquals((Object)oddWholeDay3, (Object)new Timestamp(oddWholeDay3Exp.roundTime(upperBoundaryOddWholeDay3)));
        Assert.assertNotEquals((Object)oddWholeDay3, (Object)new Timestamp(oddWholeDay3Exp.roundTime(upperBoundaryOddWholeDay3 + 1L)));
        RoundDateExpression evenWholeDayExp = this.getRoundMsExpression("2022-11-12 0:0:0", TimeUnit.DAY, 1);
        Timestamp evenWholeDay = new Timestamp(DateUtil.parseDate((String)"2022-11-12 0:0:0").getTime());
        long lowerBoundaryEvenWholeDay = evenWholeDay.getTime() - HALF_DAY;
        long upperBoundaryEvenWholeDay = evenWholeDay.getTime() + HALF_DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeDay, (long)evenWholeDayExp.rangeLower(evenWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeDay, (long)evenWholeDayExp.rangeUpper(evenWholeDay.getTime()));
        Assert.assertEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(lowerBoundaryEvenWholeDay)));
        Assert.assertNotEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(lowerBoundaryEvenWholeDay - 1L)));
        Assert.assertEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(upperBoundaryEvenWholeDay)));
        Assert.assertNotEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(upperBoundaryEvenWholeDay + 1L)));
        RoundWeekExpression roundWeekExpression = new RoundWeekExpression();
        Timestamp wholeWeekOdd = new Timestamp(DateUtil.parseDate((String)"2022-10-10 0:0:0").getTime());
        long lowerBoundaryWholeWeekOdd = wholeWeekOdd.getTime() - (HALF_WEEK - 1L);
        long upperBoundaryWholeWeekOdd = wholeWeekOdd.getTime() + HALF_WEEK - 1L;
        Assert.assertEquals((long)lowerBoundaryWholeWeekOdd, (long)roundWeekExpression.rangeLower(wholeWeekOdd.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeWeekOdd, (long)roundWeekExpression.rangeUpper(wholeWeekOdd.getTime()));
        Assert.assertEquals((Object)wholeWeekOdd, (Object)new Timestamp(roundWeekExpression.roundDateTime(new DateTime(lowerBoundaryWholeWeekOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeWeekOdd, (Object)new Timestamp(roundWeekExpression.roundDateTime(new DateTime(lowerBoundaryWholeWeekOdd - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeWeekOdd, (Object)new Timestamp(roundWeekExpression.roundDateTime(new DateTime(upperBoundaryWholeWeekOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeWeekOdd, (Object)new Timestamp(roundWeekExpression.roundDateTime(new DateTime(upperBoundaryWholeWeekOdd + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeWeekEven = new Timestamp(DateUtil.parseDate((String)"2022-10-17 0:0:0").getTime());
        long lowerBoundaryWholeWeekEven = wholeWeekEven.getTime() - HALF_WEEK;
        long upperBoundaryWholeWeekEven = wholeWeekEven.getTime() + HALF_WEEK;
        Assert.assertEquals((long)lowerBoundaryWholeWeekEven, (long)roundWeekExpression.rangeLower(wholeWeekEven.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeWeekEven, (long)roundWeekExpression.rangeUpper(wholeWeekEven.getTime()));
        Assert.assertEquals((Object)wholeWeekEven, (Object)new Timestamp(roundWeekExpression.roundDateTime(new DateTime(lowerBoundaryWholeWeekEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeWeekEven, (Object)new Timestamp(roundWeekExpression.roundDateTime(new DateTime(lowerBoundaryWholeWeekEven - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeWeekEven, (Object)new Timestamp(roundWeekExpression.roundDateTime(new DateTime(upperBoundaryWholeWeekEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeWeekEven, (Object)new Timestamp(roundWeekExpression.roundDateTime(new DateTime(upperBoundaryWholeWeekEven + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        RoundMonthExpression roundMonthExpression = new RoundMonthExpression();
        Timestamp wholeMonthEven = new Timestamp(DateUtil.parseDate((String)"2022-06-1 0:0:0").getTime());
        long lowerBoundaryWholeMonthEven = wholeMonthEven.getTime() - 31L * HALF_DAY;
        long upperBoundaryWholeMonthEven = wholeMonthEven.getTime() + 30L * HALF_DAY;
        Assert.assertEquals((long)lowerBoundaryWholeMonthEven, (long)roundMonthExpression.rangeLower(wholeMonthEven.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeMonthEven, (long)roundMonthExpression.rangeUpper(wholeMonthEven.getTime()));
        Assert.assertEquals((Object)wholeMonthEven, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthEven, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthEven - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeMonthEven, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthEven, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthEven + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeMonthOdd = new Timestamp(DateUtil.parseDate((String)"2022-07-1 0:0:0").getTime());
        long lowerBoundaryWholeMonthOdd = wholeMonthOdd.getTime() - 30L * HALF_DAY + 1L;
        long upperBoundaryWholeMonthOdd = wholeMonthOdd.getTime() + 31L * HALF_DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryWholeMonthOdd, (long)roundMonthExpression.rangeLower(wholeMonthOdd.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeMonthOdd, (long)roundMonthExpression.rangeUpper(wholeMonthOdd.getTime()));
        Assert.assertEquals((Object)wholeMonthOdd, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthOdd, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthOdd - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeMonthOdd, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthOdd, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthOdd + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeMonthLeap = new Timestamp(DateUtil.parseDate((String)"2024-02-1 0:0:0").getTime());
        long lowerBoundaryWholeMonthLeap = wholeMonthLeap.getTime() - 31L * HALF_DAY;
        long upperBoundaryWholeMonthLeap = wholeMonthLeap.getTime() + 29L * HALF_DAY;
        Assert.assertEquals((long)lowerBoundaryWholeMonthLeap, (long)roundMonthExpression.rangeLower(wholeMonthLeap.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeMonthLeap, (long)roundMonthExpression.rangeUpper(wholeMonthLeap.getTime()));
        Assert.assertEquals((Object)wholeMonthLeap, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthLeap, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthLeap, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthLeap - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeMonthLeap, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthLeap, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthLeap, (Object)new Timestamp(roundMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthLeap + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        RoundYearExpression roundYearExpression = new RoundYearExpression();
        Timestamp wholeYearEven = new Timestamp(DateUtil.parseDate((String)"2022-1-1 0:0:0").getTime());
        long lowerBoundaryWholeYearEven = wholeYearEven.getTime() - HALF_YEAR;
        long upperBoundaryWholeYearEven = wholeYearEven.getTime() + HALF_YEAR;
        Assert.assertEquals((long)lowerBoundaryWholeYearEven, (long)roundYearExpression.rangeLower(wholeYearEven.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeYearEven, (long)roundYearExpression.rangeUpper(wholeYearEven.getTime()));
        Assert.assertEquals((Object)wholeYearEven, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearEven, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearEven - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeYearEven, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearEven, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearEven + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeYearOdd = new Timestamp(DateUtil.parseDate((String)"2023-1-1 0:0:0").getTime());
        long lowerBoundaryWholeYearOdd = wholeYearOdd.getTime() - HALF_YEAR + 1L;
        long upperBoundaryWholeYearOdd = wholeYearOdd.getTime() + HALF_YEAR - 1L;
        Assert.assertEquals((long)lowerBoundaryWholeYearOdd, (long)roundYearExpression.rangeLower(wholeYearOdd.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeYearOdd, (long)roundYearExpression.rangeUpper(wholeYearOdd.getTime()));
        Assert.assertEquals((Object)wholeYearOdd, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearOdd, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearOdd - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeYearOdd, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearOdd, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearOdd + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeYearLeapEven = new Timestamp(DateUtil.parseDate((String)"2024-1-1 0:0:0").getTime());
        long lowerBoundaryWholeYearLeapEven = wholeYearLeapEven.getTime() - HALF_YEAR;
        long upperBoundaryWholeYearLeapEven = wholeYearLeapEven.getTime() + HALF_YEAR + HALF_DAY;
        Assert.assertEquals((long)lowerBoundaryWholeYearLeapEven, (long)roundYearExpression.rangeLower(wholeYearLeapEven.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeYearLeapEven, (long)roundYearExpression.rangeUpper(wholeYearLeapEven.getTime()));
        Assert.assertEquals((Object)wholeYearLeapEven, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearLeapEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearLeapEven, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearLeapEven - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeYearLeapEven, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearLeapEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearLeapEven, (Object)new Timestamp(roundYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearLeapEven + 1L, (Chronology)GJChronology.getInstanceUTC()))));
    }

    private FloorDateExpression getFloorMsExpression(String s, TimeUnit u, int m) throws SQLException {
        return (FloorDateExpression)FloorDateExpression.create((Expression)LiteralExpression.newConstant((Object)s), (TimeUnit)u, (int)m);
    }

    @Test
    public void testFloorGMT() throws SQLException {
        FloorDateExpression oddWholeSecondExp = this.getFloorMsExpression("2022-11-11 11:11:11", TimeUnit.SECOND, 1);
        Timestamp oddWholeSecond = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:11").getTime());
        long lowerBoundaryOddWholeSecond = oddWholeSecond.getTime();
        long upperBoundaryOddWholeSecond = oddWholeSecond.getTime() + SEC - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeSecond, (long)oddWholeSecondExp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecond, (long)oddWholeSecondExp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(lowerBoundaryOddWholeSecond)));
        Assert.assertNotEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(lowerBoundaryOddWholeSecond - 1L)));
        Assert.assertEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(upperBoundaryOddWholeSecond)));
        Assert.assertNotEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(upperBoundaryOddWholeSecond + 1L)));
        FloorDateExpression oddWholeSecondFloor10Exp = this.getFloorMsExpression("2022-11-11 11:11:10", TimeUnit.SECOND, 10);
        Timestamp oddWholeSecondFloor10 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:10").getTime());
        long lowerBoundaryOddWholeSecondFloor10 = oddWholeSecondFloor10.getTime();
        long upperBoundaryOddWholeSecondFloor10 = oddWholeSecondFloor10.getTime() + 10L * SEC - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeSecondFloor10, (long)oddWholeSecondFloor10Exp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecondFloor10, (long)oddWholeSecondFloor10Exp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecondFloor10, (Object)new Timestamp(oddWholeSecondFloor10Exp.roundTime(lowerBoundaryOddWholeSecondFloor10)));
        Assert.assertNotEquals((Object)oddWholeSecondFloor10, (Object)new Timestamp(oddWholeSecondFloor10Exp.roundTime(lowerBoundaryOddWholeSecondFloor10 - 1L)));
        Assert.assertEquals((Object)oddWholeSecondFloor10, (Object)new Timestamp(oddWholeSecondFloor10Exp.roundTime(upperBoundaryOddWholeSecondFloor10)));
        Assert.assertNotEquals((Object)oddWholeSecondFloor10, (Object)new Timestamp(oddWholeSecondFloor10Exp.roundTime(upperBoundaryOddWholeSecondFloor10 + 1L)));
        FloorDateExpression oddWholeSecondFloor15Exp = this.getFloorMsExpression("2022-11-11 11:11:0", TimeUnit.SECOND, 15);
        Timestamp oddWholeSecondFloor15 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:0").getTime());
        long lowerBoundaryOddWholeSecondFloor15 = oddWholeSecondFloor15.getTime();
        long upperBoundaryOddWholeSecondFloor15 = oddWholeSecondFloor15.getTime() + 15L * SEC - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeSecondFloor15, (long)oddWholeSecondFloor15Exp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecondFloor15, (long)oddWholeSecondFloor15Exp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecondFloor15, (Object)new Timestamp(oddWholeSecondFloor15Exp.roundTime(lowerBoundaryOddWholeSecondFloor15)));
        Assert.assertNotEquals((Object)oddWholeSecondFloor15, (Object)new Timestamp(oddWholeSecondFloor15Exp.roundTime(lowerBoundaryOddWholeSecondFloor15 - 1L)));
        Assert.assertEquals((Object)oddWholeSecondFloor15, (Object)new Timestamp(oddWholeSecondFloor15Exp.roundTime(upperBoundaryOddWholeSecondFloor15)));
        Assert.assertNotEquals((Object)oddWholeSecondFloor15, (Object)new Timestamp(oddWholeSecondFloor15Exp.roundTime(upperBoundaryOddWholeSecondFloor15 + 1L)));
        FloorDateExpression evenWholeMinuteExp = this.getFloorMsExpression("2022-11-11 11:12:0", TimeUnit.MINUTE, 1);
        Timestamp evenWholeMinute = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:12:0").getTime());
        long lowerBoundaryEvenWholeMinute = evenWholeMinute.getTime();
        long upperBoundaryEvenWholeMinute = evenWholeMinute.getTime() + MIN - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeMinute, (long)evenWholeMinuteExp.rangeLower(evenWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeMinute, (long)evenWholeMinuteExp.rangeUpper(evenWholeMinute.getTime()));
        Assert.assertEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(lowerBoundaryEvenWholeMinute)));
        Assert.assertNotEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(lowerBoundaryEvenWholeMinute - 1L)));
        Assert.assertEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(upperBoundaryEvenWholeMinute)));
        Assert.assertNotEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(upperBoundaryEvenWholeMinute + 1L)));
        FloorDateExpression evenWholeMinuteFloor20Exp = this.getFloorMsExpression("2022-11-11 11:00:0", TimeUnit.MINUTE, 20);
        Timestamp evenWholeMinuteFloor20 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:00:0").getTime());
        long lowerBoundaryEvenWholeMinuteFloor20 = evenWholeMinuteFloor20.getTime();
        long upperBoundaryEvenWholeMinuteFloor20 = evenWholeMinuteFloor20.getTime() + 20L * MIN - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeMinuteFloor20, (long)evenWholeMinuteFloor20Exp.rangeLower(evenWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeMinuteFloor20, (long)evenWholeMinuteFloor20Exp.rangeUpper(evenWholeMinute.getTime()));
        Assert.assertEquals((Object)evenWholeMinuteFloor20, (Object)new Timestamp(evenWholeMinuteFloor20Exp.roundTime(lowerBoundaryEvenWholeMinuteFloor20)));
        Assert.assertNotEquals((Object)evenWholeMinuteFloor20, (Object)new Timestamp(evenWholeMinuteFloor20Exp.roundTime(lowerBoundaryEvenWholeMinuteFloor20 - 1L)));
        Assert.assertEquals((Object)evenWholeMinuteFloor20, (Object)new Timestamp(evenWholeMinuteFloor20Exp.roundTime(upperBoundaryEvenWholeMinuteFloor20)));
        Assert.assertNotEquals((Object)evenWholeMinuteFloor20, (Object)new Timestamp(evenWholeMinuteFloor20Exp.roundTime(upperBoundaryEvenWholeMinuteFloor20 + 1L)));
        FloorDateExpression evenWholeMinuteFloor17Exp = this.getFloorMsExpression("2022-11-11 11:12:00", TimeUnit.MINUTE, 17);
        Timestamp evenWholeMinuteFloor17 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:12:00").getTime());
        long lowerBoundaryEvenWholeMinute17 = evenWholeMinuteFloor17.getTime();
        long upperBoundaryEvenWholeMinute17 = evenWholeMinuteFloor17.getTime() + 17L * MIN - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeMinute17, (long)evenWholeMinuteFloor17Exp.rangeLower(evenWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeMinute17, (long)evenWholeMinuteFloor17Exp.rangeUpper(evenWholeMinute.getTime()));
        Assert.assertEquals((Object)evenWholeMinuteFloor17, (Object)new Timestamp(evenWholeMinuteFloor17Exp.roundTime(lowerBoundaryEvenWholeMinute17)));
        Assert.assertNotEquals((Object)evenWholeMinuteFloor17, (Object)new Timestamp(evenWholeMinuteFloor17Exp.roundTime(lowerBoundaryEvenWholeMinute17 - 1L)));
        Assert.assertEquals((Object)evenWholeMinuteFloor17, (Object)new Timestamp(evenWholeMinuteFloor17Exp.roundTime(upperBoundaryEvenWholeMinute17)));
        Assert.assertNotEquals((Object)evenWholeMinuteFloor17, (Object)new Timestamp(evenWholeMinuteFloor17Exp.roundTime(upperBoundaryEvenWholeMinute17 + 1L)));
        FloorDateExpression oddWholeHourExp = this.getFloorMsExpression("2022-11-11 11:0:0", TimeUnit.HOUR, 1);
        Timestamp oddWholeHour = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:0:0").getTime());
        long lowerBoundaryOddWholeHour = oddWholeHour.getTime();
        long upperBoundaryOddWholeHour = oddWholeHour.getTime() + HOUR - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeHour, (long)oddWholeHourExp.rangeLower(oddWholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeHour, (long)oddWholeHourExp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(lowerBoundaryOddWholeHour)));
        Assert.assertNotEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(lowerBoundaryOddWholeHour - 1L)));
        Assert.assertEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(upperBoundaryOddWholeHour)));
        Assert.assertNotEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(upperBoundaryOddWholeHour + 1L)));
        FloorDateExpression oddWholeHour10Exp = this.getFloorMsExpression("2022-11-11 02:0:0", TimeUnit.HOUR, 10);
        Timestamp oddWholeHour10 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 02:0:0").getTime());
        long lowerBoundaryOddWholeHour10 = oddWholeHour10.getTime();
        long upperBoundaryOddWholeHour10 = oddWholeHour10.getTime() + HOUR * 10L - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeHour10, (long)oddWholeHour10Exp.rangeLower(oddWholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeHour10, (long)oddWholeHour10Exp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(lowerBoundaryOddWholeHour10)));
        Assert.assertNotEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(lowerBoundaryOddWholeHour10 - 1L)));
        Assert.assertEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(upperBoundaryOddWholeHour10)));
        Assert.assertNotEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(upperBoundaryOddWholeHour10 + 1L)));
        FloorDateExpression oddWholeHour11Exp = this.getFloorMsExpression("2022-11-11 07:0:0", TimeUnit.HOUR, 11);
        Timestamp oddWholeHour11 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 07:0:0").getTime());
        long lowerBoundaryOddWholeHour11 = oddWholeHour11.getTime();
        long upperBoundaryOddWholeHour11 = oddWholeHour11.getTime() + HOUR * 11L - 1L;
        Assert.assertEquals((long)lowerBoundaryOddWholeHour11, (long)oddWholeHour11Exp.rangeLower(oddWholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeHour11, (long)oddWholeHour11Exp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(lowerBoundaryOddWholeHour11)));
        Assert.assertNotEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(lowerBoundaryOddWholeHour11 - 1L)));
        Assert.assertEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(upperBoundaryOddWholeHour11)));
        Assert.assertNotEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(upperBoundaryOddWholeHour11 + 1L)));
        FloorDateExpression evenWholeDayExp = this.getFloorMsExpression("2022-11-12 0:0:0", TimeUnit.DAY, 1);
        Timestamp evenWholeDay = new Timestamp(DateUtil.parseDate((String)"2022-11-12 0:0:0").getTime());
        long lowerBoundaryEvenWholeDay = evenWholeDay.getTime();
        long upperBoundaryEvenWholeDay = evenWholeDay.getTime() + DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeDay, (long)evenWholeDayExp.rangeLower(evenWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeDay, (long)evenWholeDayExp.rangeUpper(evenWholeDay.getTime()));
        Assert.assertEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(lowerBoundaryEvenWholeDay)));
        Assert.assertNotEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(lowerBoundaryEvenWholeDay - 1L)));
        Assert.assertEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(upperBoundaryEvenWholeDay)));
        Assert.assertNotEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(upperBoundaryEvenWholeDay + 1L)));
        FloorDateExpression evenWholeDay2Exp = this.getFloorMsExpression("2022-11-12 0:0:0", TimeUnit.DAY, 2);
        Timestamp evenWholeDay2 = new Timestamp(DateUtil.parseDate((String)"2022-11-12 0:0:0").getTime());
        long lowerBoundaryEvenWholeDay2 = evenWholeDay2.getTime();
        long upperBoundaryEvenWholeDay2 = evenWholeDay2.getTime() + 2L * DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeDay2, (long)evenWholeDay2Exp.rangeLower(evenWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeDay2, (long)evenWholeDay2Exp.rangeUpper(evenWholeDay.getTime()));
        Assert.assertEquals((Object)evenWholeDay2, (Object)new Timestamp(evenWholeDay2Exp.roundTime(lowerBoundaryEvenWholeDay2)));
        Assert.assertNotEquals((Object)evenWholeDay2, (Object)new Timestamp(evenWholeDay2Exp.roundTime(lowerBoundaryEvenWholeDay2 - 1L)));
        Assert.assertEquals((Object)evenWholeDay2, (Object)new Timestamp(evenWholeDay2Exp.roundTime(upperBoundaryEvenWholeDay2)));
        Assert.assertNotEquals((Object)evenWholeDay2, (Object)new Timestamp(evenWholeDay2Exp.roundTime(upperBoundaryEvenWholeDay2 + 1L)));
        FloorDateExpression evenWholeDay3Exp = this.getFloorMsExpression("2022-11-12 0:0:0", TimeUnit.DAY, 3);
        Timestamp evenWholeDay3 = new Timestamp(DateUtil.parseDate((String)"2022-11-12 0:0:0").getTime());
        long lowerBoundaryEvenWholeDay3 = evenWholeDay3.getTime();
        long upperBoundaryEvenWholeDay3 = evenWholeDay3.getTime() + 3L * DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryEvenWholeDay3, (long)evenWholeDay3Exp.rangeLower(evenWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeDay3, (long)evenWholeDay3Exp.rangeUpper(evenWholeDay.getTime()));
        Assert.assertEquals((Object)evenWholeDay3, (Object)new Timestamp(evenWholeDay3Exp.roundTime(lowerBoundaryEvenWholeDay3)));
        Assert.assertNotEquals((Object)evenWholeDay3, (Object)new Timestamp(evenWholeDay3Exp.roundTime(lowerBoundaryEvenWholeDay3 - 1L)));
        Assert.assertEquals((Object)evenWholeDay3, (Object)new Timestamp(evenWholeDay3Exp.roundTime(upperBoundaryEvenWholeDay3)));
        Assert.assertNotEquals((Object)evenWholeDay3, (Object)new Timestamp(evenWholeDay3Exp.roundTime(upperBoundaryEvenWholeDay3 + 1L)));
        FloorWeekExpression floorWeekExpression = new FloorWeekExpression();
        Timestamp wholeWeekOdd = new Timestamp(DateUtil.parseDate((String)"2022-10-10 0:0:0").getTime());
        long lowerBoundaryWholeWeekOdd = wholeWeekOdd.getTime();
        long upperBoundaryWholeWeekOdd = wholeWeekOdd.getTime() + WEEK - 1L;
        Assert.assertEquals((long)lowerBoundaryWholeWeekOdd, (long)floorWeekExpression.rangeLower(wholeWeekOdd.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeWeekOdd, (long)floorWeekExpression.rangeUpper(wholeWeekOdd.getTime()));
        Assert.assertEquals((Object)wholeWeekOdd, (Object)new Timestamp(floorWeekExpression.roundDateTime(new DateTime(lowerBoundaryWholeWeekOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeWeekOdd, (Object)new Timestamp(floorWeekExpression.roundDateTime(new DateTime(lowerBoundaryWholeWeekOdd - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeWeekOdd, (Object)new Timestamp(floorWeekExpression.roundDateTime(new DateTime(upperBoundaryWholeWeekOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeWeekOdd, (Object)new Timestamp(floorWeekExpression.roundDateTime(new DateTime(upperBoundaryWholeWeekOdd + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        FloorMonthExpression floorMonthExpression = new FloorMonthExpression();
        Timestamp wholeMonthOdd = new Timestamp(DateUtil.parseDate((String)"2022-07-1 0:0:0").getTime());
        long lowerBoundaryWholeMonthOdd = wholeMonthOdd.getTime();
        long upperBoundaryWholeMonthOdd = wholeMonthOdd.getTime() + 31L * DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryWholeMonthOdd, (long)floorMonthExpression.rangeLower(wholeMonthOdd.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeMonthOdd, (long)floorMonthExpression.rangeUpper(wholeMonthOdd.getTime()));
        Assert.assertEquals((Object)wholeMonthOdd, (Object)new Timestamp(floorMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthOdd, (Object)new Timestamp(floorMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthOdd - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeMonthOdd, (Object)new Timestamp(floorMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthOdd, (Object)new Timestamp(floorMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthOdd + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeMonthLeap = new Timestamp(DateUtil.parseDate((String)"2024-02-1 0:0:0").getTime());
        long lowerBoundaryWholeMonthLeap = wholeMonthLeap.getTime();
        long upperBoundaryWholeMonthLeap = wholeMonthLeap.getTime() + 29L * DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryWholeMonthLeap, (long)floorMonthExpression.rangeLower(wholeMonthLeap.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeMonthLeap, (long)floorMonthExpression.rangeUpper(wholeMonthLeap.getTime()));
        Assert.assertEquals((Object)wholeMonthLeap, (Object)new Timestamp(floorMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthLeap, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthLeap, (Object)new Timestamp(floorMonthExpression.roundDateTime(new DateTime(lowerBoundaryWholeMonthLeap - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeMonthLeap, (Object)new Timestamp(floorMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthLeap, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthLeap, (Object)new Timestamp(floorMonthExpression.roundDateTime(new DateTime(upperBoundaryWholeMonthLeap + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        FloorYearExpression floorYearExpression = new FloorYearExpression();
        Timestamp wholeYearEven = new Timestamp(DateUtil.parseDate((String)"2022-1-1 0:0:0").getTime());
        long lowerBoundaryWholeYearEven = wholeYearEven.getTime();
        long upperBoundaryWholeYearEven = wholeYearEven.getTime() + YEAR - 1L;
        Assert.assertEquals((long)lowerBoundaryWholeYearEven, (long)floorYearExpression.rangeLower(wholeYearEven.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeYearEven, (long)floorYearExpression.rangeUpper(wholeYearEven.getTime()));
        Assert.assertEquals((Object)wholeYearEven, (Object)new Timestamp(floorYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearEven, (Object)new Timestamp(floorYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearEven - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeYearEven, (Object)new Timestamp(floorYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearEven, (Object)new Timestamp(floorYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearEven + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeYearLeapEven = new Timestamp(DateUtil.parseDate((String)"2024-1-1 0:0:0").getTime());
        long lowerBoundaryWholeYearLeapEven = wholeYearLeapEven.getTime();
        long upperBoundaryWholeYearLeapEven = wholeYearLeapEven.getTime() + YEAR + DAY - 1L;
        Assert.assertEquals((long)lowerBoundaryWholeYearLeapEven, (long)floorYearExpression.rangeLower(wholeYearLeapEven.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeYearLeapEven, (long)floorYearExpression.rangeUpper(wholeYearLeapEven.getTime()));
        Assert.assertEquals((Object)wholeYearLeapEven, (Object)new Timestamp(floorYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearLeapEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearLeapEven, (Object)new Timestamp(floorYearExpression.roundDateTime(new DateTime(lowerBoundaryWholeYearLeapEven - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeYearLeapEven, (Object)new Timestamp(floorYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearLeapEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearLeapEven, (Object)new Timestamp(floorYearExpression.roundDateTime(new DateTime(upperBoundaryWholeYearLeapEven + 1L, (Chronology)GJChronology.getInstanceUTC()))));
    }

    private CeilDateExpression getCeilMsExpression(String s, TimeUnit u, int m) throws SQLException {
        return (CeilDateExpression)CeilDateExpression.create((Expression)LiteralExpression.newConstant((Object)s), (TimeUnit)u, (int)m);
    }

    @Test
    public void testCeilGMT() throws SQLException {
        CeilDateExpression oddWholeSecondExp = this.getCeilMsExpression("2022-11-11 11:11:11", TimeUnit.SECOND, 1);
        Timestamp oddWholeSecond = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:11").getTime());
        long lowerBoundaryOddWholeSecond = oddWholeSecond.getTime() - SEC + 1L;
        long upperBoundaryOddWholeSecond = oddWholeSecond.getTime();
        Assert.assertEquals((long)lowerBoundaryOddWholeSecond, (long)oddWholeSecondExp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecond, (long)oddWholeSecondExp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(lowerBoundaryOddWholeSecond)));
        Assert.assertNotEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(lowerBoundaryOddWholeSecond - 1L)));
        Assert.assertEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(upperBoundaryOddWholeSecond)));
        Assert.assertNotEquals((Object)oddWholeSecond, (Object)new Timestamp(oddWholeSecondExp.roundTime(upperBoundaryOddWholeSecond + 1L)));
        CeilDateExpression oddWholeSecondCeil10Exp = this.getCeilMsExpression("2022-11-11 11:11:20", TimeUnit.SECOND, 10);
        Timestamp oddWholeSecondCeil10 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:20").getTime());
        long lowerBoundaryOddWholeSecondCeil10 = oddWholeSecondCeil10.getTime() - 10L * SEC + 1L;
        long upperBoundaryOddWholeSecondCeil10 = oddWholeSecondCeil10.getTime();
        Assert.assertEquals((long)lowerBoundaryOddWholeSecondCeil10, (long)oddWholeSecondCeil10Exp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecondCeil10, (long)oddWholeSecondCeil10Exp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecondCeil10, (Object)new Timestamp(oddWholeSecondCeil10Exp.roundTime(lowerBoundaryOddWholeSecondCeil10)));
        Assert.assertNotEquals((Object)oddWholeSecondCeil10, (Object)new Timestamp(oddWholeSecondCeil10Exp.roundTime(lowerBoundaryOddWholeSecondCeil10 - 1L)));
        Assert.assertEquals((Object)oddWholeSecondCeil10, (Object)new Timestamp(oddWholeSecondCeil10Exp.roundTime(upperBoundaryOddWholeSecondCeil10)));
        Assert.assertNotEquals((Object)oddWholeSecondCeil10, (Object)new Timestamp(oddWholeSecondCeil10Exp.roundTime(upperBoundaryOddWholeSecondCeil10 + 1L)));
        CeilDateExpression oddWholeSecondCeil15Exp = this.getCeilMsExpression("2022-11-11 11:11:15", TimeUnit.SECOND, 15);
        Timestamp oddWholeSecondCeil15 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:11:15").getTime());
        long lowerBoundaryOddWholeSecondFloor15 = oddWholeSecondCeil15.getTime() - 15L * SEC + 1L;
        long upperBoundaryOddWholeSecondFloor15 = oddWholeSecondCeil15.getTime();
        Assert.assertEquals((long)lowerBoundaryOddWholeSecondFloor15, (long)oddWholeSecondCeil15Exp.rangeLower(oddWholeSecond.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeSecondFloor15, (long)oddWholeSecondCeil15Exp.rangeUpper(oddWholeSecond.getTime()));
        Assert.assertEquals((Object)oddWholeSecondCeil15, (Object)new Timestamp(oddWholeSecondCeil15Exp.roundTime(lowerBoundaryOddWholeSecondFloor15)));
        Assert.assertNotEquals((Object)oddWholeSecondCeil15, (Object)new Timestamp(oddWholeSecondCeil15Exp.roundTime(lowerBoundaryOddWholeSecondFloor15 - 1L)));
        Assert.assertEquals((Object)oddWholeSecondCeil15, (Object)new Timestamp(oddWholeSecondCeil15Exp.roundTime(upperBoundaryOddWholeSecondFloor15)));
        Assert.assertNotEquals((Object)oddWholeSecondCeil15, (Object)new Timestamp(oddWholeSecondCeil15Exp.roundTime(upperBoundaryOddWholeSecondFloor15 + 1L)));
        CeilDateExpression evenWholeMinuteExp = this.getCeilMsExpression("2022-11-11 11:12:0", TimeUnit.MINUTE, 1);
        Timestamp evenWholeMinute = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:12:0").getTime());
        long lowerBoundaryEvenWholeMinute = evenWholeMinute.getTime() - MIN + 1L;
        long upperBoundaryEvenWholeMinute = evenWholeMinute.getTime();
        Assert.assertEquals((long)lowerBoundaryEvenWholeMinute, (long)evenWholeMinuteExp.rangeLower(evenWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeMinute, (long)evenWholeMinuteExp.rangeUpper(evenWholeMinute.getTime()));
        Assert.assertEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(lowerBoundaryEvenWholeMinute)));
        Assert.assertNotEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(lowerBoundaryEvenWholeMinute - 1L)));
        Assert.assertEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(upperBoundaryEvenWholeMinute)));
        Assert.assertNotEquals((Object)evenWholeMinute, (Object)new Timestamp(evenWholeMinuteExp.roundTime(upperBoundaryEvenWholeMinute + 1L)));
        CeilDateExpression evenWholeMinuteCeil20Exp = this.getCeilMsExpression("2022-11-11 11:20:0", TimeUnit.MINUTE, 20);
        Timestamp evenWholeMinuteCeil20 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:20:0").getTime());
        long lowerBoundaryEvenWholeMinuteCeil20 = evenWholeMinuteCeil20.getTime() - 20L * MIN + 1L;
        long upperBoundaryEvenWholeMinuteCeil20 = evenWholeMinuteCeil20.getTime();
        Assert.assertEquals((long)lowerBoundaryEvenWholeMinuteCeil20, (long)evenWholeMinuteCeil20Exp.rangeLower(evenWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeMinuteCeil20, (long)evenWholeMinuteCeil20Exp.rangeUpper(evenWholeMinute.getTime()));
        Assert.assertEquals((Object)evenWholeMinuteCeil20, (Object)new Timestamp(evenWholeMinuteCeil20Exp.roundTime(lowerBoundaryEvenWholeMinuteCeil20)));
        Assert.assertNotEquals((Object)evenWholeMinuteCeil20, (Object)new Timestamp(evenWholeMinuteCeil20Exp.roundTime(lowerBoundaryEvenWholeMinuteCeil20 - 1L)));
        Assert.assertEquals((Object)evenWholeMinuteCeil20, (Object)new Timestamp(evenWholeMinuteCeil20Exp.roundTime(upperBoundaryEvenWholeMinuteCeil20)));
        Assert.assertNotEquals((Object)evenWholeMinuteCeil20, (Object)new Timestamp(evenWholeMinuteCeil20Exp.roundTime(upperBoundaryEvenWholeMinuteCeil20 + 1L)));
        CeilDateExpression evenWholeMinuteCeil17Exp = this.getCeilMsExpression("2022-11-11 11:12:00", TimeUnit.MINUTE, 17);
        Timestamp evenWholeMinuteCeil17 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:12:00").getTime());
        long lowerBoundaryEvenWholeMinute17 = evenWholeMinuteCeil17.getTime() - 17L * MIN + 1L;
        long upperBoundaryEvenWholeMinute17 = evenWholeMinuteCeil17.getTime();
        Assert.assertEquals((long)lowerBoundaryEvenWholeMinute17, (long)evenWholeMinuteCeil17Exp.rangeLower(evenWholeMinute.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeMinute17, (long)evenWholeMinuteCeil17Exp.rangeUpper(evenWholeMinute.getTime()));
        Assert.assertEquals((Object)evenWholeMinuteCeil17, (Object)new Timestamp(evenWholeMinuteCeil17Exp.roundTime(lowerBoundaryEvenWholeMinute17)));
        Assert.assertNotEquals((Object)evenWholeMinuteCeil17, (Object)new Timestamp(evenWholeMinuteCeil17Exp.roundTime(lowerBoundaryEvenWholeMinute17 - 1L)));
        Assert.assertEquals((Object)evenWholeMinuteCeil17, (Object)new Timestamp(evenWholeMinuteCeil17Exp.roundTime(upperBoundaryEvenWholeMinute17)));
        Assert.assertNotEquals((Object)evenWholeMinuteCeil17, (Object)new Timestamp(evenWholeMinuteCeil17Exp.roundTime(upperBoundaryEvenWholeMinute17 + 1L)));
        CeilDateExpression oddWholeHourExp = this.getCeilMsExpression("2022-11-11 11:0:0", TimeUnit.HOUR, 1);
        Timestamp oddWholeHour = new Timestamp(DateUtil.parseDate((String)"2022-11-11 11:0:0").getTime());
        long lowerBoundaryOddWholeHour = oddWholeHour.getTime() - HOUR + 1L;
        long upperBoundaryOddWholeHour = oddWholeHour.getTime();
        Assert.assertEquals((long)lowerBoundaryOddWholeHour, (long)oddWholeHourExp.rangeLower(oddWholeHour.getTime() - 1L));
        Assert.assertEquals((long)upperBoundaryOddWholeHour, (long)oddWholeHourExp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(lowerBoundaryOddWholeHour)));
        Assert.assertNotEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(lowerBoundaryOddWholeHour - 1L)));
        Assert.assertEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(upperBoundaryOddWholeHour)));
        Assert.assertNotEquals((Object)oddWholeHour, (Object)new Timestamp(oddWholeHourExp.roundTime(upperBoundaryOddWholeHour + 1L)));
        CeilDateExpression oddWholeHour10Exp = this.getCeilMsExpression("2022-11-11 12:0:0", TimeUnit.HOUR, 10);
        Timestamp oddWholeHour10 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 12:0:0").getTime());
        long lowerBoundaryOddWholeHour10 = oddWholeHour10.getTime() - 10L * HOUR + 1L;
        long upperBoundaryOddWholeHour10 = oddWholeHour10.getTime();
        Assert.assertEquals((long)lowerBoundaryOddWholeHour10, (long)oddWholeHour10Exp.rangeLower(oddWholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeHour10, (long)oddWholeHour10Exp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(lowerBoundaryOddWholeHour10)));
        Assert.assertNotEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(lowerBoundaryOddWholeHour10 - 1L)));
        Assert.assertEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(upperBoundaryOddWholeHour10)));
        Assert.assertNotEquals((Object)oddWholeHour10, (Object)new Timestamp(oddWholeHour10Exp.roundTime(upperBoundaryOddWholeHour10 + 1L)));
        CeilDateExpression oddWholeHour11Exp = this.getCeilMsExpression("2022-11-11 12:0:0", TimeUnit.HOUR, 11);
        Timestamp oddWholeHour11 = new Timestamp(DateUtil.parseDate((String)"2022-11-11 18:0:0").getTime());
        long lowerBoundaryOddWholeHour11 = oddWholeHour11.getTime() - 11L * HOUR + 1L;
        long upperBoundaryOddWholeHour11 = oddWholeHour11.getTime();
        Assert.assertEquals((long)lowerBoundaryOddWholeHour11, (long)oddWholeHour11Exp.rangeLower(oddWholeHour.getTime()));
        Assert.assertEquals((long)upperBoundaryOddWholeHour11, (long)oddWholeHour11Exp.rangeUpper(oddWholeHour.getTime()));
        Assert.assertEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(lowerBoundaryOddWholeHour11)));
        Assert.assertNotEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(lowerBoundaryOddWholeHour11 - 1L)));
        Assert.assertEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(upperBoundaryOddWholeHour11)));
        Assert.assertNotEquals((Object)oddWholeHour11, (Object)new Timestamp(oddWholeHour11Exp.roundTime(upperBoundaryOddWholeHour11 + 1L)));
        CeilDateExpression evenWholeDayExp = this.getCeilMsExpression("2022-11-12 0:0:0", TimeUnit.DAY, 1);
        Timestamp evenWholeDay = new Timestamp(DateUtil.parseDate((String)"2022-11-12 0:0:0").getTime());
        long lowerBoundaryEvenWholeDay = evenWholeDay.getTime() - DAY + 1L;
        long upperBoundaryEvenWholeDay = evenWholeDay.getTime();
        Assert.assertEquals((long)lowerBoundaryEvenWholeDay, (long)evenWholeDayExp.rangeLower(evenWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeDay, (long)evenWholeDayExp.rangeUpper(evenWholeDay.getTime()));
        Assert.assertEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(lowerBoundaryEvenWholeDay)));
        Assert.assertNotEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(lowerBoundaryEvenWholeDay - 1L)));
        Assert.assertEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(upperBoundaryEvenWholeDay)));
        Assert.assertNotEquals((Object)evenWholeDay, (Object)new Timestamp(evenWholeDayExp.roundTime(upperBoundaryEvenWholeDay + 1L)));
        CeilDateExpression evenWholeDay2Exp = this.getCeilMsExpression("2022-11-12 0:0:0", TimeUnit.DAY, 2);
        Timestamp evenWholeDay2 = new Timestamp(DateUtil.parseDate((String)"2022-11-12 0:0:0").getTime());
        long lowerBoundaryEvenWholeDay2 = evenWholeDay2.getTime() - 2L * DAY + 1L;
        long upperBoundaryEvenWholeDay2 = evenWholeDay2.getTime();
        Assert.assertEquals((long)lowerBoundaryEvenWholeDay2, (long)evenWholeDay2Exp.rangeLower(evenWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeDay2, (long)evenWholeDay2Exp.rangeUpper(evenWholeDay.getTime()));
        Assert.assertEquals((Object)evenWholeDay2, (Object)new Timestamp(evenWholeDay2Exp.roundTime(lowerBoundaryEvenWholeDay2)));
        Assert.assertNotEquals((Object)evenWholeDay2, (Object)new Timestamp(evenWholeDay2Exp.roundTime(lowerBoundaryEvenWholeDay2 - 1L)));
        Assert.assertEquals((Object)evenWholeDay2, (Object)new Timestamp(evenWholeDay2Exp.roundTime(upperBoundaryEvenWholeDay2)));
        Assert.assertNotEquals((Object)evenWholeDay2, (Object)new Timestamp(evenWholeDay2Exp.roundTime(upperBoundaryEvenWholeDay2 + 1L)));
        CeilDateExpression evenWholeDay3Exp = this.getCeilMsExpression("2022-11-12 0:0:0", TimeUnit.DAY, 3);
        Timestamp evenWholeDay3 = new Timestamp(DateUtil.parseDate((String)"2022-11-12 0:0:0").getTime());
        long lowerBoundaryEvenWholeDay3 = evenWholeDay3.getTime() - 3L * DAY + 1L;
        long upperBoundaryEvenWholeDay3 = evenWholeDay3.getTime();
        Assert.assertEquals((long)lowerBoundaryEvenWholeDay3, (long)evenWholeDay3Exp.rangeLower(evenWholeDay.getTime()));
        Assert.assertEquals((long)upperBoundaryEvenWholeDay3, (long)evenWholeDay3Exp.rangeUpper(evenWholeDay.getTime()));
        Assert.assertEquals((Object)evenWholeDay3, (Object)new Timestamp(evenWholeDay3Exp.roundTime(lowerBoundaryEvenWholeDay3)));
        Assert.assertNotEquals((Object)evenWholeDay3, (Object)new Timestamp(evenWholeDay3Exp.roundTime(lowerBoundaryEvenWholeDay3 - 1L)));
        Assert.assertEquals((Object)evenWholeDay3, (Object)new Timestamp(evenWholeDay3Exp.roundTime(upperBoundaryEvenWholeDay3)));
        Assert.assertNotEquals((Object)evenWholeDay3, (Object)new Timestamp(evenWholeDay3Exp.roundTime(upperBoundaryEvenWholeDay3 + 1L)));
        CeilWeekExpression ceilWeekExp = new CeilWeekExpression();
        Timestamp wholeWeekOdd = new Timestamp(DateUtil.parseDate((String)"2022-10-10 0:0:0").getTime());
        long lowerBoundaryWholeWeekOdd = wholeWeekOdd.getTime() - WEEK + 1L;
        long upperBoundaryWholeWeekOdd = wholeWeekOdd.getTime();
        Assert.assertEquals((long)lowerBoundaryWholeWeekOdd, (long)ceilWeekExp.rangeLower(wholeWeekOdd.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeWeekOdd, (long)ceilWeekExp.rangeUpper(wholeWeekOdd.getTime()));
        Assert.assertEquals((Object)wholeWeekOdd, (Object)new Timestamp(ceilWeekExp.roundDateTime(new DateTime(lowerBoundaryWholeWeekOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeWeekOdd, (Object)new Timestamp(ceilWeekExp.roundDateTime(new DateTime(lowerBoundaryWholeWeekOdd - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeWeekOdd, (Object)new Timestamp(ceilWeekExp.roundDateTime(new DateTime(upperBoundaryWholeWeekOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeWeekOdd, (Object)new Timestamp(ceilWeekExp.roundDateTime(new DateTime(upperBoundaryWholeWeekOdd + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        CeilMonthExpression ceilMonthExp = new CeilMonthExpression();
        Timestamp wholeMonthOdd = new Timestamp(DateUtil.parseDate((String)"2022-08-1 0:0:0").getTime());
        long lowerBoundaryWholeMonthOdd = wholeMonthOdd.getTime() - 31L * DAY + 1L;
        long upperBoundaryWholeMonthOdd = wholeMonthOdd.getTime();
        Assert.assertEquals((long)lowerBoundaryWholeMonthOdd, (long)ceilMonthExp.rangeLower(wholeMonthOdd.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeMonthOdd, (long)ceilMonthExp.rangeUpper(wholeMonthOdd.getTime()));
        Assert.assertEquals((Object)wholeMonthOdd, (Object)new Timestamp(ceilMonthExp.roundDateTime(new DateTime(lowerBoundaryWholeMonthOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthOdd, (Object)new Timestamp(ceilMonthExp.roundDateTime(new DateTime(lowerBoundaryWholeMonthOdd - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeMonthOdd, (Object)new Timestamp(ceilMonthExp.roundDateTime(new DateTime(upperBoundaryWholeMonthOdd, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthOdd, (Object)new Timestamp(ceilMonthExp.roundDateTime(new DateTime(upperBoundaryWholeMonthOdd + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeMonthLeap = new Timestamp(DateUtil.parseDate((String)"2024-03-1 0:0:0").getTime());
        long lowerBoundaryWholeMonthLeap = wholeMonthLeap.getTime() - 29L * DAY + 1L;
        long upperBoundaryWholeMonthLeap = wholeMonthLeap.getTime();
        Assert.assertEquals((long)lowerBoundaryWholeMonthLeap, (long)ceilMonthExp.rangeLower(wholeMonthLeap.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeMonthLeap, (long)ceilMonthExp.rangeUpper(wholeMonthLeap.getTime()));
        Assert.assertEquals((Object)wholeMonthLeap, (Object)new Timestamp(ceilMonthExp.roundDateTime(new DateTime(lowerBoundaryWholeMonthLeap, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthLeap, (Object)new Timestamp(ceilMonthExp.roundDateTime(new DateTime(lowerBoundaryWholeMonthLeap - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeMonthLeap, (Object)new Timestamp(ceilMonthExp.roundDateTime(new DateTime(upperBoundaryWholeMonthLeap, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeMonthLeap, (Object)new Timestamp(ceilMonthExp.roundDateTime(new DateTime(upperBoundaryWholeMonthLeap + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        CeilYearExpression ceilYearExp = new CeilYearExpression();
        Timestamp wholeYearEven = new Timestamp(DateUtil.parseDate((String)"2022-1-1 0:0:0").getTime());
        long lowerBoundaryWholeYearEven = wholeYearEven.getTime() - YEAR + 1L;
        long upperBoundaryWholeYearEven = wholeYearEven.getTime();
        Assert.assertEquals((long)lowerBoundaryWholeYearEven, (long)ceilYearExp.rangeLower(wholeYearEven.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeYearEven, (long)ceilYearExp.rangeUpper(wholeYearEven.getTime()));
        Assert.assertEquals((Object)wholeYearEven, (Object)new Timestamp(ceilYearExp.roundDateTime(new DateTime(lowerBoundaryWholeYearEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearEven, (Object)new Timestamp(ceilYearExp.roundDateTime(new DateTime(lowerBoundaryWholeYearEven - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeYearEven, (Object)new Timestamp(ceilYearExp.roundDateTime(new DateTime(upperBoundaryWholeYearEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearEven, (Object)new Timestamp(ceilYearExp.roundDateTime(new DateTime(upperBoundaryWholeYearEven + 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Timestamp wholeYearLeapEven = new Timestamp(DateUtil.parseDate((String)"2025-1-1 0:0:0").getTime());
        long lowerBoundaryWholeYearLeapEven = wholeYearLeapEven.getTime() - (YEAR + DAY) + 1L;
        long upperBoundaryWholeYearLeapEven = wholeYearLeapEven.getTime();
        Assert.assertEquals((long)lowerBoundaryWholeYearLeapEven, (long)ceilYearExp.rangeLower(wholeYearLeapEven.getTime()));
        Assert.assertEquals((long)upperBoundaryWholeYearLeapEven, (long)ceilYearExp.rangeUpper(wholeYearLeapEven.getTime()));
        Assert.assertEquals((Object)wholeYearLeapEven, (Object)new Timestamp(ceilYearExp.roundDateTime(new DateTime(lowerBoundaryWholeYearLeapEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearLeapEven, (Object)new Timestamp(ceilYearExp.roundDateTime(new DateTime(lowerBoundaryWholeYearLeapEven - 1L, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertEquals((Object)wholeYearLeapEven, (Object)new Timestamp(ceilYearExp.roundDateTime(new DateTime(upperBoundaryWholeYearLeapEven, (Chronology)GJChronology.getInstanceUTC()))));
        Assert.assertNotEquals((Object)wholeYearLeapEven, (Object)new Timestamp(ceilYearExp.roundDateTime(new DateTime(upperBoundaryWholeYearLeapEven + 1L, (Chronology)GJChronology.getInstanceUTC()))));
    }

    private static enum Relation {
        EQUAL(CompareOperator.EQUAL, "="),
        GREATER(CompareOperator.GREATER, ">"),
        GREATER_OR_EQUAL(CompareOperator.GREATER_OR_EQUAL, ">="),
        LESS(CompareOperator.LESS, "<"),
        LESS_OR_EQUAL(CompareOperator.LESS_OR_EQUAL, "<=");

        public final CompareOperator compareOp;
        public final String symbol;

        private Relation(CompareOperator compareOp, String symbol) {
            this.compareOp = compareOp;
            this.symbol = symbol;
        }

        public <E extends Comparable<? super E>> boolean compare(E lhs, E rhs) {
            int comparison = lhs.compareTo(rhs);
            switch (this) {
                case EQUAL: {
                    return comparison == 0;
                }
                case GREATER_OR_EQUAL: {
                    return comparison >= 0;
                }
                case GREATER: {
                    return comparison > 0;
                }
                case LESS_OR_EQUAL: {
                    return comparison <= 0;
                }
                case LESS: {
                    return comparison < 0;
                }
            }
            throw new AssertionError((Object)"Unknown RelationType");
        }
    }

    private static enum RoundingType {
        ROUND("ROUND"),
        FLOOR("FLOOR"),
        CEIL("CEIL");

        public final String name;

        private RoundingType(String name) {
            this.name = name;
        }

        public Expression getExpression(byte[] key, int scale) throws SQLException {
            LiteralExpression decimalLiteral = LiteralExpression.newConstant((Object)PDecimal.INSTANCE.toObject(key), (PDataType)PDecimal.INSTANCE);
            switch (this) {
                case ROUND: {
                    return RoundDecimalExpression.create((Expression)decimalLiteral, (int)scale);
                }
                case FLOOR: {
                    return FloorDecimalExpression.create((Expression)decimalLiteral, (int)scale);
                }
                case CEIL: {
                    return CeilDecimalExpression.create((Expression)decimalLiteral, (int)scale);
                }
            }
            throw new AssertionError((Object)"Unknown RoundingType");
        }
    }
}

