/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ByteBasedRegexpSubstrFunction;
import org.apache.phoenix.expression.function.StringBasedRegexpSubstrFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class RegexpSubstrFunctionTest {
    private static final PVarchar TYPE = PVarchar.INSTANCE;

    private String evalExp(Expression exp) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        boolean eval = exp.evaluate(null, ptr);
        Assert.assertTrue((boolean)eval);
        String res = (String)exp.getDataType().toObject(ptr);
        return res;
    }

    private String testExpression(String srcStr, String patternStr, int offset, SortOrder sortOrder) throws SQLException {
        LiteralExpression srcExp = LiteralExpression.newConstant((Object)srcStr, (PDataType)TYPE, (SortOrder)sortOrder);
        LiteralExpression patternExp = LiteralExpression.newConstant((Object)patternStr, (PDataType)TYPE, (SortOrder)sortOrder);
        LiteralExpression offsetExp = LiteralExpression.newConstant((Object)offset, (PDataType)PInteger.INSTANCE, (SortOrder)sortOrder);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{srcExp, patternExp, offsetExp});
        String res1 = this.evalExp((Expression)new ByteBasedRegexpSubstrFunction((List)expressions));
        String res2 = this.evalExp((Expression)new StringBasedRegexpSubstrFunction((List)expressions));
        Assert.assertEquals((Object)res1, (Object)res2);
        return res1;
    }

    private String testExpression(String srcStr, String patternStr, int offset) throws SQLException {
        String result1 = this.testExpression(srcStr, patternStr, offset, SortOrder.ASC);
        String result2 = this.testExpression(srcStr, patternStr, offset, SortOrder.DESC);
        Assert.assertEquals((Object)result1, (Object)result2);
        return result1;
    }

    private void testExpression(String srcStr, String patternStr, int offset, String expectedStr) throws SQLException {
        String result = this.testExpression(srcStr, patternStr, offset);
        Assert.assertEquals((Object)expectedStr, (Object)result);
    }

    @Test
    public void test() throws Exception {
        this.testExpression("Report1?1", "[^\\\\?]+", 1, "Report1");
        this.testExpression("Report1?2", "[^\\\\?]+", 1, "Report1");
        this.testExpression("Report2?1", "[^\\\\?]+", 1, "Report2");
        this.testExpression("Report3?2", "[^\\\\?]+", 1, "Report3");
        this.testExpression("Report3?2", "[4-9]+", 0, (String)null);
        this.testExpression("Report3?2", "[^\\\\?]+", 2, "eport3");
        this.testExpression("Report3?2", "[^\\\\?]+", -5, "rt3");
    }
}

