/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class NullValueTest
extends BaseConnectionlessQueryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComparisonExpressionWithNullOperands() throws Exception {
        String[] query = new String[]{"SELECT 'a' >= ''", "SELECT '' < 'a'", "SELECT '' = ''"};
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(NullValueTest.getUrl(), props);){
            for (String q : query) {
                ResultSet rs = conn.createStatement().executeQuery(q);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertNull((Object)rs.getObject(1));
                Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAndExpressionWithNullOperands() throws Exception {
        String[] query = new String[]{"SELECT 'b' >= 'a' and '' < 'b'", "SELECT 'b' >= '' and 'a' < 'b'", "SELECT 'a' >= 'b' and 'a' < ''", "SELECT '' >= 'a' and 'b' < 'a'", "SELECT 'a' >= '' and '' < 'a'"};
        Boolean[] result = new Boolean[]{null, null, Boolean.FALSE, Boolean.FALSE, null};
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(NullValueTest.getUrl(), props);){
            for (int i = 0; i < query.length; ++i) {
                ResultSet rs = conn.createStatement().executeQuery(query[i]);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)result[i], (Object)rs.getObject(1));
                Assert.assertEquals((Object)false, (Object)rs.getBoolean(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrExpressionWithNullOperands() throws Exception {
        String[] query = new String[]{"SELECT 'b' >= 'a' or '' < 'b'", "SELECT 'b' >= '' or 'a' < 'b'", "SELECT 'a' >= 'b' or 'a' < ''", "SELECT '' >= 'a' or 'b' < 'a'", "SELECT 'a' >= '' or '' < 'a'"};
        Boolean[] result = new Boolean[]{Boolean.TRUE, Boolean.TRUE, null, null, null};
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(NullValueTest.getUrl(), props);){
            for (int i = 0; i < query.length; ++i) {
                ResultSet rs = conn.createStatement().executeQuery(query[i]);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)result[i], (Object)rs.getObject(1));
                Assert.assertEquals((Object)(Boolean.TRUE.equals(result[i]) ? 1 : 0), (Object)rs.getBoolean(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

