/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class InListExpressionTest {
    @Test
    public void testHashCode() throws Exception {
        int valuesNumber = 500000;
        ArrayList<ImmutableBytesPtr> values = new ArrayList<ImmutableBytesPtr>(valuesNumber);
        for (int i = 0; i < valuesNumber; ++i) {
            values.add(new ImmutableBytesPtr(Bytes.toBytes((int)i)));
        }
        InListExpression exp = new InListExpression(values);
        long startTs = System.currentTimeMillis();
        int firstHashCode = exp.hashCode();
        long firstTimeCost = System.currentTimeMillis() - startTs;
        int restAccessNumber = 3;
        startTs = System.currentTimeMillis();
        ArrayList hashCodes = Lists.newArrayListWithExpectedSize((int)restAccessNumber);
        for (int i = 0; i < restAccessNumber; ++i) {
            hashCodes.add(exp.hashCode());
        }
        long restTimeCost = System.currentTimeMillis() - startTs;
        Assert.assertTrue((String)("first time: " + firstTimeCost + " <= rest time: " + restTimeCost), (firstTimeCost > restTimeCost ? 1 : 0) != 0);
        Iterator iterator = hashCodes.iterator();
        while (iterator.hasNext()) {
            int hashCode = (Integer)iterator.next();
            Assert.assertEquals((String)("hash code not equal, firstHashCode: " + firstHashCode + ", restHashCode: " + hashCode), (long)firstHashCode, (long)hashCode);
        }
    }

    @Test
    public void testGetSortedInListColumnKeyValuePairWithNoPkOrder() {
        this.testGetSortedInListColumnKeyValuePair(false);
    }

    @Test
    public void testGetSortedInListColumnKeyValuePairWithPkOrder() {
        this.testGetSortedInListColumnKeyValuePair(true);
    }

    private void testGetSortedInListColumnKeyValuePair(boolean isPkOrder) {
        ArrayList<RowValueConstructorExpression> expressionList = new ArrayList<RowValueConstructorExpression>();
        LiteralExpression literalChild1 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        ArrayList<LiteralExpression> literalExpressions = new ArrayList<LiteralExpression>();
        Mockito.when((Object)literalChild1.getDataType()).thenReturn((Object)PInteger.INSTANCE);
        Mockito.when((Object)literalChild1.getBytes()).thenReturn(null);
        Mockito.when((Object)literalChild1.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        literalExpressions.add(literalChild1);
        literalExpressions.add(literalChild1);
        ArrayList<RowKeyColumnExpression> expressionChildren = new ArrayList<RowKeyColumnExpression>();
        RowKeyColumnExpression rowKeyColumnExpressionMock1 = (RowKeyColumnExpression)Mockito.mock(RowKeyColumnExpression.class);
        RowKeyColumnExpression rowKeyColumnExpressionMock2 = (RowKeyColumnExpression)Mockito.mock(RowKeyColumnExpression.class);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getPosition()).thenReturn((Object)1);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        Mockito.when((Object)rowKeyColumnExpressionMock2.getPosition()).thenReturn((Object)2);
        Mockito.when((Object)rowKeyColumnExpressionMock2.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getChildren()).thenReturn(expressionChildren);
        Mockito.when((Object)rowKeyColumnExpressionMock2.getChildren()).thenReturn(literalExpressions);
        if (isPkOrder) {
            expressionChildren.add(rowKeyColumnExpressionMock1);
            expressionChildren.add(rowKeyColumnExpressionMock2);
        } else {
            expressionChildren.add(rowKeyColumnExpressionMock2);
            expressionChildren.add(rowKeyColumnExpressionMock1);
        }
        RowValueConstructorExpression rvc1 = new RowValueConstructorExpression(expressionChildren, true);
        RowValueConstructorExpression rvc2 = new RowValueConstructorExpression(literalExpressions, true);
        expressionList.add(rvc1);
        expressionList.add(rvc2);
        if (isPkOrder) {
            Assert.assertEquals((long)1L, (long)((RowKeyColumnExpression)((Expression)expressionList.get(0)).getChildren().get(0)).getPosition());
            Assert.assertEquals((long)2L, (long)((RowKeyColumnExpression)((Expression)expressionList.get(0)).getChildren().get(1)).getPosition());
        } else {
            Assert.assertEquals((long)2L, (long)((RowKeyColumnExpression)((Expression)expressionList.get(0)).getChildren().get(0)).getPosition());
            Assert.assertEquals((long)1L, (long)((RowKeyColumnExpression)((Expression)expressionList.get(0)).getChildren().get(1)).getPosition());
        }
        List inListColumnKeyValuePairList = InListExpression.getSortedInListColumnKeyValuePair(expressionList);
        Assert.assertEquals((long)1L, (long)((InListExpression.InListColumnKeyValuePair)inListColumnKeyValuePairList.get(0)).getRowKeyColumnExpression().getPosition());
        Assert.assertEquals((long)2L, (long)((InListExpression.InListColumnKeyValuePair)inListColumnKeyValuePairList.get(1)).getRowKeyColumnExpression().getPosition());
    }

    @Test
    public void testGetSortedInListColumnKeyValuePairWithLessValueThanPkColumns() {
        ArrayList<RowValueConstructorExpression> expressionList = new ArrayList<RowValueConstructorExpression>();
        LiteralExpression literalChild1 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        ArrayList<LiteralExpression> literalExpressions = new ArrayList<LiteralExpression>();
        Mockito.when((Object)literalChild1.getDataType()).thenReturn((Object)PInteger.INSTANCE);
        Mockito.when((Object)literalChild1.getBytes()).thenReturn(null);
        Mockito.when((Object)literalChild1.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        literalExpressions.add(literalChild1);
        literalExpressions.add(literalChild1);
        ArrayList<RowKeyColumnExpression> expressionChildren = new ArrayList<RowKeyColumnExpression>();
        RowKeyColumnExpression rowKeyColumnExpressionMock1 = (RowKeyColumnExpression)Mockito.mock(RowKeyColumnExpression.class);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getPosition()).thenReturn((Object)1);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getChildren()).thenReturn(expressionChildren);
        expressionChildren.add(rowKeyColumnExpressionMock1);
        RowValueConstructorExpression rvc1 = new RowValueConstructorExpression(expressionChildren, true);
        RowValueConstructorExpression rvc2 = new RowValueConstructorExpression(literalExpressions, true);
        expressionList.add(rvc1);
        expressionList.add(rvc2);
        List inListColumnKeyValuePairList = InListExpression.getSortedInListColumnKeyValuePair(expressionList);
        Assert.assertEquals(null, (Object)inListColumnKeyValuePairList);
    }

    @Test
    public void testGetSortedInListColumnKeyValuePairWithMoreValueThanPkColumn() {
        ArrayList<RowValueConstructorExpression> expressionList = new ArrayList<RowValueConstructorExpression>();
        LiteralExpression literalChild1 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        ArrayList<LiteralExpression> literalExpressions = new ArrayList<LiteralExpression>();
        Mockito.when((Object)literalChild1.getDataType()).thenReturn((Object)PInteger.INSTANCE);
        Mockito.when((Object)literalChild1.getBytes()).thenReturn(null);
        Mockito.when((Object)literalChild1.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        literalExpressions.add(literalChild1);
        ArrayList<RowKeyColumnExpression> expressionChildren = new ArrayList<RowKeyColumnExpression>();
        RowKeyColumnExpression rowKeyColumnExpressionMock1 = (RowKeyColumnExpression)Mockito.mock(RowKeyColumnExpression.class);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getPosition()).thenReturn((Object)1);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getChildren()).thenReturn(expressionChildren);
        expressionChildren.add(rowKeyColumnExpressionMock1);
        expressionChildren.add(rowKeyColumnExpressionMock1);
        RowValueConstructorExpression rvc1 = new RowValueConstructorExpression(expressionChildren, true);
        RowValueConstructorExpression rvc2 = new RowValueConstructorExpression(literalExpressions, true);
        expressionList.add(rvc1);
        expressionList.add(rvc2);
        List inListColumnKeyValuePairList = InListExpression.getSortedInListColumnKeyValuePair(expressionList);
        Assert.assertEquals(null, (Object)inListColumnKeyValuePairList);
    }

    @Test
    public void testInListColumnKeyValuePairClass() {
        RowKeyColumnExpression rowKeyColumnExpression = (RowKeyColumnExpression)Mockito.mock(RowKeyColumnExpression.class);
        LiteralExpression literalChild = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        InListExpression.InListColumnKeyValuePair inListColumnKeyValuePair = new InListExpression.InListColumnKeyValuePair(rowKeyColumnExpression);
        inListColumnKeyValuePair.addToLiteralExpressionList(literalChild);
        Assert.assertEquals((Object)rowKeyColumnExpression, (Object)inListColumnKeyValuePair.getRowKeyColumnExpression());
        Assert.assertEquals((Object)literalChild, inListColumnKeyValuePair.getLiteralExpressionList().get(0));
    }

    @Test
    public void testGetSortedRowValueConstructorExpressionList() {
        byte[] bytesValueOne = ByteBuffer.allocate(4).putInt(1).array();
        byte[] bytesValueTwo = ByteBuffer.allocate(4).putInt(1).array();
        ArrayList<LiteralExpression> literalExpressions = new ArrayList<LiteralExpression>();
        LiteralExpression literalChild1 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        Mockito.when((Object)literalChild1.getDataType()).thenReturn((Object)PInteger.INSTANCE);
        Mockito.when((Object)literalChild1.getBytes()).thenReturn((Object)bytesValueOne);
        Mockito.when((Object)literalChild1.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        literalExpressions.add(literalChild1);
        LiteralExpression literalChild2 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        Mockito.when((Object)literalChild2.getDataType()).thenReturn((Object)PInteger.INSTANCE);
        Mockito.when((Object)literalChild2.getBytes()).thenReturn((Object)bytesValueTwo);
        Mockito.when((Object)literalChild2.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        literalExpressions.add(literalChild2);
        ArrayList<RowKeyColumnExpression> expressionChildren = new ArrayList<RowKeyColumnExpression>();
        RowKeyColumnExpression rowKeyColumnExpressionMock1 = (RowKeyColumnExpression)Mockito.mock(RowKeyColumnExpression.class);
        RowKeyColumnExpression rowKeyColumnExpressionMock2 = (RowKeyColumnExpression)Mockito.mock(RowKeyColumnExpression.class);
        expressionChildren.add(rowKeyColumnExpressionMock1);
        expressionChildren.add(rowKeyColumnExpressionMock2);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getPosition()).thenReturn((Object)1);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        Mockito.when((Object)rowKeyColumnExpressionMock2.getPosition()).thenReturn((Object)2);
        Mockito.when((Object)rowKeyColumnExpressionMock2.getDeterminism()).thenReturn((Object)Determinism.ALWAYS);
        Mockito.when((Object)rowKeyColumnExpressionMock1.getChildren()).thenReturn(expressionChildren);
        Mockito.when((Object)rowKeyColumnExpressionMock2.getChildren()).thenReturn(literalExpressions);
        ArrayList<InListExpression.InListColumnKeyValuePair> children = new ArrayList<InListExpression.InListColumnKeyValuePair>();
        InListExpression.InListColumnKeyValuePair rvc1 = new InListExpression.InListColumnKeyValuePair(rowKeyColumnExpressionMock1);
        rvc1.addToLiteralExpressionList(literalChild1);
        children.add(rvc1);
        InListExpression.InListColumnKeyValuePair rvc2 = new InListExpression.InListColumnKeyValuePair(rowKeyColumnExpressionMock2);
        rvc2.addToLiteralExpressionList(literalChild2);
        children.add(rvc2);
        List result = InListExpression.getSortedRowValueConstructorExpressionList(children, (boolean)true, (int)1);
        Assert.assertTrue((boolean)(((Expression)result.get(0)).getChildren().get(0) instanceof RowKeyColumnExpression));
        Assert.assertTrue((boolean)(((Expression)result.get(0)).getChildren().get(1) instanceof RowKeyColumnExpression));
        Assert.assertEquals((long)1L, (long)((RowKeyColumnExpression)((Expression)result.get(0)).getChildren().get(0)).getPosition());
        Assert.assertEquals((long)2L, (long)((RowKeyColumnExpression)((Expression)result.get(0)).getChildren().get(1)).getPosition());
        Assert.assertTrue((boolean)(((Expression)result.get(1)).getChildren().get(0) instanceof LiteralExpression));
        Assert.assertTrue((boolean)(((Expression)result.get(1)).getChildren().get(1) instanceof LiteralExpression));
        Assert.assertEquals((Object)bytesValueOne, (Object)((LiteralExpression)((Expression)result.get(1)).getChildren().get(0)).getBytes());
        Assert.assertEquals((Object)bytesValueTwo, (Object)((LiteralExpression)((Expression)result.get(1)).getChildren().get(1)).getBytes());
    }
}

