/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PVarchar;
import org.junit.Assert;
import org.junit.Test;

public class ColumnExpressionTest {
    @Test
    public void testSerialization() throws Exception {
        int maxLen = 30;
        int scale = 5;
        PName colName = PNameFactory.newName((String)"c1");
        PColumnImpl column = new PColumnImpl(colName, PNameFactory.newName((String)"f1"), (PDataType)PDecimal.INSTANCE, Integer.valueOf(maxLen), Integer.valueOf(scale), true, 20, SortOrder.getDefault(), Integer.valueOf(0), null, false, null, false, false, colName.getBytes(), Long.MAX_VALUE);
        KeyValueColumnExpression colExp = new KeyValueColumnExpression((PColumn)column);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dOut = new DataOutputStream(baos);
        colExp.write((DataOutput)dOut);
        dOut.flush();
        KeyValueColumnExpression colExp2 = new KeyValueColumnExpression();
        byte[] bytes = baos.toByteArray();
        DataInputStream dIn = new DataInputStream(new ByteArrayInputStream(bytes, 0, bytes.length));
        colExp2.readFields((DataInput)dIn);
        Assert.assertEquals((long)maxLen, (long)colExp2.getMaxLength().intValue());
        Assert.assertEquals((long)scale, (long)colExp2.getScale().intValue());
        Assert.assertEquals((Object)PDecimal.INSTANCE, (Object)colExp2.getDataType());
    }

    @Test
    public void testSerializationWithNullScale() throws Exception {
        int maxLen = 30;
        PName colName = PNameFactory.newName((String)"c1");
        PColumnImpl column = new PColumnImpl(colName, PNameFactory.newName((String)"f1"), (PDataType)PBinary.INSTANCE, Integer.valueOf(maxLen), null, true, 20, SortOrder.getDefault(), Integer.valueOf(0), null, false, null, false, false, colName.getBytes(), Long.MAX_VALUE);
        KeyValueColumnExpression colExp = new KeyValueColumnExpression((PColumn)column);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dOut = new DataOutputStream(baos);
        colExp.write((DataOutput)dOut);
        dOut.flush();
        KeyValueColumnExpression colExp2 = new KeyValueColumnExpression();
        byte[] bytes = baos.toByteArray();
        DataInputStream dIn = new DataInputStream(new ByteArrayInputStream(bytes, 0, bytes.length));
        colExp2.readFields((DataInput)dIn);
        Assert.assertEquals((long)maxLen, (long)colExp2.getMaxLength().intValue());
        Assert.assertNull((Object)colExp2.getScale());
        Assert.assertEquals((Object)PBinary.INSTANCE, (Object)colExp2.getDataType());
    }

    @Test
    public void testSerializationWithNullMaxLength() throws Exception {
        int scale = 5;
        PName colName = PNameFactory.newName((String)"c1");
        PColumnImpl column = new PColumnImpl(colName, PNameFactory.newName((String)"f1"), (PDataType)PVarchar.INSTANCE, null, Integer.valueOf(scale), true, 20, SortOrder.getDefault(), Integer.valueOf(0), null, false, null, false, false, colName.getBytes(), Long.MAX_VALUE);
        KeyValueColumnExpression colExp = new KeyValueColumnExpression((PColumn)column);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dOut = new DataOutputStream(baos);
        colExp.write((DataOutput)dOut);
        dOut.flush();
        KeyValueColumnExpression colExp2 = new KeyValueColumnExpression();
        byte[] bytes = baos.toByteArray();
        DataInputStream dIn = new DataInputStream(new ByteArrayInputStream(bytes, 0, bytes.length));
        colExp2.readFields((DataInput)dIn);
        Assert.assertNull((Object)colExp2.getMaxLength());
        Assert.assertEquals((long)scale, (long)colExp2.getScale().intValue());
        Assert.assertEquals((Object)PVarchar.INSTANCE, (Object)colExp2.getDataType());
    }

    @Test
    public void testSerializationWithNullScaleAndMaxLength() throws Exception {
        PName colName = PNameFactory.newName((String)"c1");
        PColumnImpl column = new PColumnImpl(colName, PNameFactory.newName((String)"f1"), (PDataType)PDecimal.INSTANCE, null, null, true, 20, SortOrder.getDefault(), Integer.valueOf(0), null, false, null, false, false, colName.getBytes(), Long.MAX_VALUE);
        KeyValueColumnExpression colExp = new KeyValueColumnExpression((PColumn)column);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dOut = new DataOutputStream(baos);
        colExp.write((DataOutput)dOut);
        dOut.flush();
        KeyValueColumnExpression colExp2 = new KeyValueColumnExpression();
        byte[] bytes = baos.toByteArray();
        DataInputStream dIn = new DataInputStream(new ByteArrayInputStream(bytes, 0, bytes.length));
        colExp2.readFields((DataInput)dIn);
        Assert.assertNull((Object)colExp2.getMaxLength());
        Assert.assertNull((Object)colExp2.getScale());
    }
}

