/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBson;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PJson;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.junit.Assert;
import org.junit.Test;

public class CoerceExpressionTest {
    private static final HashMap<Class, Object> map = new HashMap();

    @Test
    public void testCoerceExpressionSupportsCoercingIntToDecimal() throws Exception {
        LiteralExpression v = LiteralExpression.newConstant((Object)1, (PDataType)PInteger.INSTANCE);
        CoerceExpression e = new CoerceExpression((Expression)v, (PDataType)PDecimal.INSTANCE);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        e.evaluate(null, ptr);
        Object obj = e.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(obj instanceof BigDecimal));
        BigDecimal value = (BigDecimal)obj;
        Assert.assertTrue((boolean)value.equals(BigDecimal.valueOf(1L)));
    }

    @Test
    public void testCoerceExpressionSupportsCoercingCharToVarchar() throws Exception {
        LiteralExpression v = LiteralExpression.newConstant((Object)"a", (PDataType)PChar.INSTANCE);
        CoerceExpression e = new CoerceExpression((Expression)v, (PDataType)PVarchar.INSTANCE);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        e.evaluate(null, ptr);
        Object obj = e.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(obj instanceof String));
        String value = (String)obj;
        Assert.assertTrue((boolean)value.equals("a"));
    }

    @Test
    public void testCoerceExpressionSupportsCoercingIntToLong() throws Exception {
        LiteralExpression v = LiteralExpression.newConstant((Object)1, (PDataType)PInteger.INSTANCE);
        CoerceExpression e = new CoerceExpression((Expression)v, (PDataType)PLong.INSTANCE);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        e.evaluate(null, ptr);
        Object obj = e.getDataType().toObject(ptr);
        Assert.assertTrue((boolean)(obj instanceof Long));
        Long value = (Long)obj;
        Assert.assertTrue((boolean)value.equals(1L));
    }

    @Test
    public void testCoerceExpressionSupportsCoercingAllPDataTypesToVarBinary() throws Exception {
        for (PDataType p : PDataType.values()) {
            if (p.isArrayType() || p.equals((Object)PJson.INSTANCE) || p.equals((Object)PBson.INSTANCE)) continue;
            LiteralExpression v = LiteralExpression.newConstant((Object)map.get(p.getJavaClass()), (PDataType)p);
            CoerceExpression e = new CoerceExpression((Expression)v, (PDataType)PVarbinary.INSTANCE);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            e.evaluate(null, ptr);
            Object obj = e.getDataType().toObject(ptr);
            Assert.assertTrue((String)("Coercing to VARBINARY failed for PDataType " + p), (boolean)(obj instanceof byte[]));
        }
    }

    @Test
    public void testCoerceExpressionSupportsCoercingAllPDataTypesToBinary() throws Exception {
        for (PDataType p : PDataType.values()) {
            if (p.isArrayType() || p.equals((Object)PJson.INSTANCE) || p.equals((Object)PBson.INSTANCE)) continue;
            LiteralExpression v = LiteralExpression.newConstant((Object)map.get(p.getJavaClass()), (PDataType)p);
            CoerceExpression e = new CoerceExpression((Expression)v, (PDataType)PBinary.INSTANCE);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            e.evaluate(null, ptr);
            Object obj = e.getDataType().toObject(ptr);
            Assert.assertTrue((String)("Coercing to BINARY failed for PDataType " + p), (boolean)(obj instanceof byte[]));
        }
    }

    static {
        map.put(String.class, "a");
        map.put(Long.class, 1L);
        map.put(Integer.class, 1);
        map.put(Short.class, 1);
        map.put(Byte.class, 1);
        map.put(Float.class, Float.valueOf(1.0f));
        map.put(Double.class, 1.0);
        map.put(BigDecimal.class, BigDecimal.ONE);
        map.put(Timestamp.class, new Timestamp(0L));
        map.put(Time.class, new Time(0L));
        map.put(Date.class, new Date(0L));
        map.put(Boolean.class, Boolean.TRUE);
        map.put(byte[].class, new byte[]{-128, 0, 0, 1});
    }
}

