/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ArrayToStringFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PBooleanArray;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDateArray;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDecimalArray;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PDoubleArray;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PFloatArray;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PIntegerArray;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PLongArray;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PSmallintArray;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimeArray;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTimestampArray;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PTinyintArray;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PVarcharArray;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class ArrayToStringFunctionTest {
    private static void testExpression(LiteralExpression array, LiteralExpression delimiter, LiteralExpression nullString, String expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{array});
        expressions.add(delimiter);
        expressions.add(nullString);
        ArrayToStringFunction arrayToStringFunction = new ArrayToStringFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayToStringFunction.evaluate(null, ptr);
        String result = (String)arrayToStringFunction.getDataType().toObject(ptr, arrayToStringFunction.getSortOrder(), arrayToStringFunction.getMaxLength(), arrayToStringFunction.getScale());
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private static void test(PhoenixArray array, PDataType arrayDataType, Integer arrMaxLen, Integer arrScale, String delimiter, String nullString, String expected, SortOrder arraySortOrder, SortOrder delimiterSortOrder, SortOrder nullStringSortOrder) throws SQLException {
        LiteralExpression arrayLiteral = LiteralExpression.newConstant((Object)array, (PDataType)arrayDataType, (Integer)arrMaxLen, (Integer)arrScale, (SortOrder)arraySortOrder, (Determinism)Determinism.ALWAYS);
        LiteralExpression delimiterLiteral = LiteralExpression.newConstant((Object)delimiter, (PDataType)PVarchar.INSTANCE, null, null, (SortOrder)delimiterSortOrder, (Determinism)Determinism.ALWAYS);
        LiteralExpression nullStringLiteral = LiteralExpression.newConstant((Object)nullString, (PDataType)PVarchar.INSTANCE, null, null, (SortOrder)nullStringSortOrder, (Determinism)Determinism.ALWAYS);
        ArrayToStringFunctionTest.testExpression(arrayLiteral, delimiterLiteral, nullStringLiteral, expected);
    }

    @Test
    public void testInt1() throws SQLException {
        PIntegerArray type = PIntegerArray.INSTANCE;
        PInteger base = PInteger.INSTANCE;
        Object[] o1 = new Object[]{1, 2, 3, 4, 5};
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "1,2,3,4,5";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testInt2() throws SQLException {
        PIntegerArray type = PIntegerArray.INSTANCE;
        PInteger base = PInteger.INSTANCE;
        Object[] o1 = new Object[]{1, 2, 3, 4, 5};
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "";
        String expected = "1,2,3,4,5";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testInt3() throws SQLException {
        PIntegerArray type = PIntegerArray.INSTANCE;
        PInteger base = PInteger.INSTANCE;
        Object[] o1 = new Object[]{1, 2, 3, 4, 5};
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)base, o1);
        String delimiter = "";
        String nullString = "";
        String expected = null;
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testInt4() throws SQLException {
        PIntegerArray type = PIntegerArray.INSTANCE;
        PInteger base = PInteger.INSTANCE;
        Object[] o1 = new Object[]{1};
        PhoenixArray.PrimitiveIntPhoenixArray arr = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "";
        String expected = "1";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testFloat1() throws SQLException {
        PFloatArray type = PFloatArray.INSTANCE;
        PFloat base = PFloat.INSTANCE;
        Object[] o1 = new Object[]{Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f), Float.valueOf(4.4f), Float.valueOf(5.5f)};
        PhoenixArray.PrimitiveFloatPhoenixArray arr = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "1.1,2.2,3.3,4.4,5.5";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testFloat2() throws SQLException {
        PFloatArray type = PFloatArray.INSTANCE;
        PFloat base = PFloat.INSTANCE;
        Object[] o1 = new Object[]{Float.valueOf(1.1f), Float.valueOf(2.2f), Float.valueOf(3.3f), Float.valueOf(4.4f), Float.valueOf(5.5f)};
        PhoenixArray.PrimitiveFloatPhoenixArray arr = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "*";
        String expected = "1.1, 2.2, 3.3, 4.4, 5.5";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testDate() throws SQLException {
        PDateArray type = PDateArray.INSTANCE;
        PDate base = PDate.INSTANCE;
        Object[] o1 = new Object[]{new Date(0L), new Date(0L), new Date(0L)};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "*";
        String expected = "";
        for (int i = 0; i < o1.length - 1; ++i) {
            expected = expected + o1[i].toString() + ", ";
        }
        expected = expected + o1[o1.length - 1];
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testTime() throws SQLException {
        PTimeArray type = PTimeArray.INSTANCE;
        PTime base = PTime.INSTANCE;
        Object[] o1 = new Object[]{new Time(0L), new Time(0L), new Time(0L)};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "*";
        String expected = "";
        for (int i = 0; i < o1.length - 1; ++i) {
            expected = expected + o1[i].toString() + ", ";
        }
        expected = expected + o1[o1.length - 1];
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testTimestamp() throws SQLException {
        PTimestampArray type = PTimestampArray.INSTANCE;
        PTimestamp base = PTimestamp.INSTANCE;
        Object[] o1 = new Object[]{new Timestamp(0L), new Timestamp(0L), new Timestamp(0L)};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "*";
        String expected = "";
        for (int i = 0; i < o1.length - 1; ++i) {
            expected = expected + o1[i].toString() + ", ";
        }
        expected = expected + o1[o1.length - 1];
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testVarchar1() throws SQLException {
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        Object[] o1 = new Object[]{"hello", null, "hello", null};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "*";
        String expected = "hello, *, hello, *";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testVarchar2() throws SQLException {
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        Object[] o1 = new Object[]{"hello", null, "hello", null, null};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "*";
        String expected = "hello, *, hello, *, *";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testVarchar3() throws SQLException {
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        Object[] o1 = new Object[]{"hello", null, "hello", null, null};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "";
        String expected = "hello, hello";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testVarchar4() throws SQLException {
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        Object[] o1 = new Object[]{null, "hello", "hello", null, null};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "";
        String expected = "hello, hello";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testVarchar5() throws SQLException {
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        Object[] o1 = new Object[]{"hello"};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "";
        String expected = "hello";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testVarchar6() throws SQLException {
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        Object[] o1 = new Object[]{null, null, null, null, "hello"};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "";
        String expected = "hello";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testVarchar7() throws SQLException {
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        Object[] o1 = new Object[]{null, null, null, null, "hello"};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ", ";
        String nullString = "*";
        String expected = "*, *, *, *, hello";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testDouble() throws SQLException {
        PDoubleArray type = PDoubleArray.INSTANCE;
        PDouble base = PDouble.INSTANCE;
        Object[] o1 = new Object[]{23.4, 56.8, 2.4};
        PhoenixArray.PrimitiveDoublePhoenixArray arr = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "23.4,56.8,2.4";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testTinyint() throws SQLException {
        PTinyintArray type = PTinyintArray.INSTANCE;
        PTinyint base = PTinyint.INSTANCE;
        Object[] o1 = new Object[]{(byte)2, (byte)4, (byte)5};
        PhoenixArray.PrimitiveBytePhoenixArray arr = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "2,4,5";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testSmallint() throws SQLException {
        PSmallintArray type = PSmallintArray.INSTANCE;
        PSmallint base = PSmallint.INSTANCE;
        Object[] o1 = new Object[]{(short)6, (short)7, (short)8};
        PhoenixArray.PrimitiveShortPhoenixArray arr = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "6,7,8";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testBoolean() throws SQLException {
        PBooleanArray type = PBooleanArray.INSTANCE;
        PBoolean base = PBoolean.INSTANCE;
        Object[] o1 = new Object[]{true, false, true};
        PhoenixArray.PrimitiveBooleanPhoenixArray arr = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "true,false,true";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testLong() throws SQLException {
        PLongArray type = PLongArray.INSTANCE;
        PLong base = PLong.INSTANCE;
        Object[] o1 = new Object[]{23L, 34L, 45L};
        PhoenixArray.PrimitiveLongPhoenixArray arr = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "23,34,45";
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test((PhoenixArray)arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testDecimal1() throws SQLException {
        PDecimalArray type = PDecimalArray.INSTANCE;
        PDecimal base = PDecimal.INSTANCE;
        Object[] o1 = new Object[]{BigDecimal.valueOf(23.45), BigDecimal.valueOf(2.345), BigDecimal.valueOf(234.5)};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "23.45,2.345,234.5";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testDecimal2() throws SQLException {
        PDecimalArray type = PDecimalArray.INSTANCE;
        PDecimal base = PDecimal.INSTANCE;
        Object[] o1 = new Object[]{BigDecimal.valueOf(23.45), BigDecimal.valueOf(2.345), BigDecimal.valueOf(234.5), null};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "23.45,2.345,234.5,*";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testDecimal3() throws SQLException {
        PDecimalArray type = PDecimalArray.INSTANCE;
        PDecimal base = PDecimal.INSTANCE;
        Object[] o1 = new Object[]{BigDecimal.valueOf(23.45), BigDecimal.valueOf(2.345), null, BigDecimal.valueOf(234.5)};
        PhoenixArray arr = new PhoenixArray((PDataType)base, o1);
        String delimiter = ",";
        String nullString = "*";
        String expected = "23.45,2.345,*,234.5";
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC);
        ArrayToStringFunctionTest.test(arr, (PDataType)type, null, null, delimiter, nullString, expected, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC);
    }
}

