/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ArrayFillFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class ArrayFillFunctionTest {
    private static void testExpression(LiteralExpression element, LiteralExpression length, PhoenixArray expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{element});
        expressions.add(length);
        ArrayFillFunction arrayFillFunction = new ArrayFillFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayFillFunction.evaluate(null, ptr);
        PhoenixArray result = (PhoenixArray)arrayFillFunction.getDataType().toObject(ptr, arrayFillFunction.getSortOrder(), arrayFillFunction.getMaxLength(), arrayFillFunction.getScale());
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private static void test(Object element, Object length, PDataType elementDataType, Integer elementMaxLen, Integer elementScale, PDataType lengthDataType, Integer lengthMaxlen, Integer lengthScale, PhoenixArray expected, SortOrder elementSortOrder, SortOrder lengthSortOrder) throws SQLException {
        LiteralExpression elementLiteral = LiteralExpression.newConstant((Object)element, (PDataType)elementDataType, (Integer)elementMaxLen, (Integer)elementScale, (SortOrder)elementSortOrder, (Determinism)Determinism.ALWAYS);
        LiteralExpression lengthLiteral = LiteralExpression.newConstant((Object)length, (PDataType)lengthDataType, (Integer)lengthMaxlen, (Integer)lengthScale, (SortOrder)lengthSortOrder, (Determinism)Determinism.ALWAYS);
        ArrayFillFunctionTest.testExpression(elementLiteral, lengthLiteral, expected);
    }

    @Test
    public void testForInt() throws SQLException {
        Integer element = 5;
        Integer length = 3;
        PInteger baseType = PInteger.INSTANCE;
        PhoenixArray.PrimitiveIntPhoenixArray e = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, new Object[]{5, 5, 5});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForBoolean() throws SQLException {
        Boolean element = false;
        Integer length = 3;
        PBoolean baseType = PBoolean.INSTANCE;
        PhoenixArray.PrimitiveBooleanPhoenixArray e = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)baseType, new Object[]{false, false, false});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForVarchar() throws SQLException {
        String element = "foo";
        Integer length = 3;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray e = new PhoenixArray((PDataType)baseType, new Object[]{"foo", "foo", "foo"});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForChar() throws SQLException {
        String element = "foo";
        Integer length = 3;
        PChar baseType = PChar.INSTANCE;
        PhoenixArray e = new PhoenixArray((PDataType)baseType, new Object[]{"foo", "foo", "foo"});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForDouble() throws SQLException {
        Double element = 34.67;
        Integer length = 3;
        PDouble baseType = PDouble.INSTANCE;
        PhoenixArray.PrimitiveDoublePhoenixArray e = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)baseType, new Object[]{34.67, 34.67, 34.67});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForFloat() throws SQLException {
        Double element = 5.6;
        Integer length = 3;
        PFloat baseType = PFloat.INSTANCE;
        PhoenixArray.PrimitiveFloatPhoenixArray e = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)baseType, new Object[]{Float.valueOf(5.6f), Float.valueOf(5.6f), Float.valueOf(5.6f)});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.DESC);
    }

    @Test
    public void testForSmallint() throws SQLException {
        Integer element = 5;
        Integer length = 3;
        PSmallint baseType = PSmallint.INSTANCE;
        PhoenixArray.PrimitiveShortPhoenixArray e = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)baseType, new Object[]{(short)5, (short)5, (short)5});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForTinyint() throws SQLException {
        Integer element = 6;
        Integer length = 3;
        PTinyint baseType = PTinyint.INSTANCE;
        PhoenixArray.PrimitiveBytePhoenixArray e = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)baseType, new Object[]{(byte)6, (byte)6, (byte)6});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForLong() throws SQLException {
        Long element = 34567L;
        Integer length = 3;
        PLong baseType = PLong.INSTANCE;
        PhoenixArray.PrimitiveLongPhoenixArray e = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)baseType, new Object[]{34567L, 34567L, 34567L});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForDecimal() throws SQLException {
        BigDecimal element = BigDecimal.valueOf(345.67);
        Integer length = 3;
        PDecimal baseType = PDecimal.INSTANCE;
        PhoenixArray e = new PhoenixArray((PDataType)baseType, new Object[]{BigDecimal.valueOf(345.67), BigDecimal.valueOf(345.67), BigDecimal.valueOf(345.67)});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForDate() throws SQLException {
        Date element = new Date(23L);
        Integer length = 3;
        PDate baseType = PDate.INSTANCE;
        PhoenixArray e = new PhoenixArray((PDataType)baseType, new Object[]{new Date(23L), new Date(23L), new Date(23L)});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForTime() throws SQLException {
        Time element = new Time(23L);
        Integer length = 3;
        PTime baseType = PTime.INSTANCE;
        PhoenixArray e = new PhoenixArray((PDataType)baseType, new Object[]{new Time(23L), new Time(23L), new Time(23L)});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForNulls1() throws SQLException {
        Object element = null;
        Integer length = 3;
        PInteger baseType = PInteger.INSTANCE;
        PhoenixArray.PrimitiveIntPhoenixArray e = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)baseType, new Object[]{0, 0, 0});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, (PhoenixArray)e, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForNulls2() throws SQLException {
        Object element = null;
        Integer length = 3;
        PVarchar baseType = PVarchar.INSTANCE;
        PhoenixArray e = new PhoenixArray((PDataType)baseType, new Object[]{null, null, null});
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.ASC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.ASC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.DESC);
        ArrayFillFunctionTest.test(element, length, (PDataType)baseType, null, null, (PDataType)PInteger.INSTANCE, null, null, e, SortOrder.DESC, SortOrder.ASC);
    }
}

