/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ArrayConstructorExpression;
import org.apache.phoenix.expression.DelegateExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ArrayElemRefExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Assert;
import org.junit.Test;

public class ArrayConstructorExpressionTest {
    protected static final LiteralExpression CONSTANT_EXPRESSION = LiteralExpression.newConstant((Object)QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
    protected static final byte[] BYTE_ARRAY1 = new byte[]{1, 2, 3, 4, 5};
    protected static final byte[] BYTE_ARRAY2 = new byte[]{6, 7, 8};
    protected Expression FALSE_EVAL_EXPRESSION = new DelegateExpression((Expression)LiteralExpression.newConstant(null)){

        public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
            return false;
        }
    };

    @Test
    public void testLeadingNulls() throws Exception {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)4);
        LiteralExpression nullExpression = LiteralExpression.newConstant(null);
        children.add(nullExpression);
        children.add(nullExpression);
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY1, (PDataType)PVarbinary.INSTANCE));
        children.add(LiteralExpression.newConstant((Object)BYTE_ARRAY2, (PDataType)PVarbinary.INSTANCE));
        ArrayConstructorExpression arrayConstructorExpression = new ArrayConstructorExpression((List)children, (PDataType)PVarbinary.INSTANCE, false);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        ArrayElemRefExpression arrayElemRefExpression = new ArrayElemRefExpression((List)Lists.newArrayList((Object[])new Expression[]{arrayConstructorExpression}));
        arrayElemRefExpression.setIndex(1);
        arrayElemRefExpression.evaluate(null, (ImmutableBytesWritable)ptr);
        Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ptr.copyBytesIfNecessary());
        arrayElemRefExpression.setIndex(2);
        arrayElemRefExpression.evaluate(null, (ImmutableBytesWritable)ptr);
        Assert.assertArrayEquals((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])ptr.copyBytesIfNecessary());
        arrayElemRefExpression.setIndex(3);
        arrayElemRefExpression.evaluate(null, (ImmutableBytesWritable)ptr);
        Assert.assertArrayEquals((byte[])BYTE_ARRAY1, (byte[])ptr.copyBytesIfNecessary());
        arrayElemRefExpression.setIndex(4);
        arrayElemRefExpression.evaluate(null, (ImmutableBytesWritable)ptr);
        Assert.assertArrayEquals((byte[])BYTE_ARRAY2, (byte[])ptr.copyBytesIfNecessary());
    }
}

