/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ArrayConcatFunction;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PBooleanArray;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PCharArray;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDateArray;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDecimalArray;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PDoubleArray;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PFloatArray;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PIntegerArray;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PLongArray;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PSmallintArray;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PTinyintArray;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PVarcharArray;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class ArrayConcatFunctionTest {
    private static void testExpression(LiteralExpression array1, LiteralExpression array2, PhoenixArray expected) throws SQLException {
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{array1});
        expressions.add(array2);
        ArrayConcatFunction arrayConcatFunction = new ArrayConcatFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayConcatFunction.evaluate(null, ptr);
        PhoenixArray result = (PhoenixArray)arrayConcatFunction.getDataType().toObject(ptr, ((Expression)expressions.get(0)).getSortOrder(), array1.getMaxLength(), array1.getScale());
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private static void test(PhoenixArray array1, PhoenixArray array2, PDataType array1DataType, Integer arr1MaxLen, Integer arr1Scale, PDataType array2DataType, Integer arr2MaxLen, Integer arr2Scale, PhoenixArray expected, SortOrder array1SortOrder, SortOrder array2SortOrder) throws SQLException {
        LiteralExpression array1Literal = LiteralExpression.newConstant((Object)array1, (PDataType)array1DataType, (Integer)arr1MaxLen, (Integer)arr1Scale, (SortOrder)array1SortOrder, (Determinism)Determinism.ALWAYS);
        LiteralExpression array2Literal = LiteralExpression.newConstant((Object)array2, (PDataType)array2DataType, (Integer)arr2MaxLen, (Integer)arr2Scale, (SortOrder)array2SortOrder, (Determinism)Determinism.ALWAYS);
        ArrayConcatFunctionTest.testExpression(array1Literal, array2Literal, expected);
    }

    @Test
    public void testChar1() throws SQLException {
        Object[] o1 = new Object[]{"aa", "bb"};
        Object[] o2 = new Object[]{"c", "d"};
        Object[] e = new Object[]{"aa", "bb", "c", "d"};
        PCharArray type = PCharArray.INSTANCE;
        PChar base = PChar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 1, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 1, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 1, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testChar2() throws SQLException {
        Object[] o1 = new Object[]{"aa", "bb"};
        Object[] o2 = new Object[]{"cc", "dc", "ee"};
        Object[] e = new Object[]{"aa", "bb", "cc", "dc", "ee"};
        PCharArray type = PCharArray.INSTANCE;
        PChar base = PChar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 2, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 2, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 2, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 2, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test(expected=DataExceedsCapacityException.class)
    public void testChar3() throws SQLException {
        Object[] o1 = new Object[]{"c", "d"};
        Object[] o2 = new Object[]{"aa", "bb"};
        Object[] e = new Object[]{"aa", "bb", "c", "d"};
        PCharArray type = PCharArray.INSTANCE;
        PChar base = PChar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 1, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 1, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 1, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, 2, null, (PDataType)type, 1, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testInt1() throws SQLException {
        Object[] o1 = new Object[]{1, 2};
        Object[] o2 = new Object[]{5, 6, 7};
        Object[] e = new Object[]{1, 2, 5, 6, 7};
        PIntegerArray type = PIntegerArray.INSTANCE;
        PInteger base = PInteger.INSTANCE;
        PhoenixArray.PrimitiveIntPhoenixArray arr1 = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)base, o1);
        PhoenixArray.PrimitiveIntPhoenixArray arr2 = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)base, o2);
        PhoenixArray.PrimitiveIntPhoenixArray expected = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testFloat1() throws SQLException {
        Object[] o1 = new Object[]{Float.valueOf(1.2f), Float.valueOf(2.0f)};
        Object[] o2 = new Object[]{Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)};
        Object[] e = new Object[]{Float.valueOf(1.2f), Float.valueOf(2.0f), Float.valueOf(5.0f), Float.valueOf(6.0f), Float.valueOf(7.0f)};
        PFloatArray type = PFloatArray.INSTANCE;
        PFloat base = PFloat.INSTANCE;
        PhoenixArray.PrimitiveFloatPhoenixArray arr1 = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)base, o1);
        PhoenixArray.PrimitiveFloatPhoenixArray arr2 = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)base, o2);
        PhoenixArray.PrimitiveFloatPhoenixArray expected = new PhoenixArray.PrimitiveFloatPhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testDouble1() throws SQLException {
        Object[] o1 = new Object[]{1.2, 2.0};
        Object[] o2 = new Object[]{5.2, 6.0, 7.0};
        Object[] e = new Object[]{1.2, 2.0, 5.2, 6.0, 7.0};
        PDoubleArray type = PDoubleArray.INSTANCE;
        PDouble base = PDouble.INSTANCE;
        PhoenixArray.PrimitiveDoublePhoenixArray arr1 = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)base, o1);
        PhoenixArray.PrimitiveDoublePhoenixArray arr2 = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)base, o2);
        PhoenixArray.PrimitiveDoublePhoenixArray expected = new PhoenixArray.PrimitiveDoublePhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testLong1() throws SQLException {
        Object[] o1 = new Object[]{1L, 2L};
        Object[] o2 = new Object[]{5L, 6L, 7L};
        Object[] e = new Object[]{1L, 2L, 5L, 6L, 7L};
        PLongArray type = PLongArray.INSTANCE;
        PLong base = PLong.INSTANCE;
        PhoenixArray.PrimitiveLongPhoenixArray arr1 = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)base, o1);
        PhoenixArray.PrimitiveLongPhoenixArray arr2 = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)base, o2);
        PhoenixArray.PrimitiveLongPhoenixArray expected = new PhoenixArray.PrimitiveLongPhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testShort1() throws SQLException {
        Object[] o1 = new Object[]{(short)1, (short)2};
        Object[] o2 = new Object[]{(short)5, (short)6, (short)7};
        Object[] e = new Object[]{(short)1, (short)2, (short)5, (short)6, (short)7};
        PSmallintArray type = PSmallintArray.INSTANCE;
        PSmallint base = PSmallint.INSTANCE;
        PhoenixArray.PrimitiveShortPhoenixArray arr1 = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)base, o1);
        PhoenixArray.PrimitiveShortPhoenixArray arr2 = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)base, o2);
        PhoenixArray.PrimitiveShortPhoenixArray expected = new PhoenixArray.PrimitiveShortPhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testBoolean1() throws SQLException {
        Object[] o1 = new Object[]{true, true};
        Object[] o2 = new Object[]{false, false, false};
        Object[] e = new Object[]{true, true, false, false, false};
        PBooleanArray type = PBooleanArray.INSTANCE;
        PBoolean base = PBoolean.INSTANCE;
        PhoenixArray.PrimitiveBooleanPhoenixArray arr1 = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)base, o1);
        PhoenixArray.PrimitiveBooleanPhoenixArray arr2 = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)base, o2);
        PhoenixArray.PrimitiveBooleanPhoenixArray expected = new PhoenixArray.PrimitiveBooleanPhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
    }

    @Test
    public void testTinyInt1() throws SQLException {
        Object[] o1 = new Object[]{(byte)2, (byte)2};
        Object[] o2 = new Object[]{(byte)5, (byte)6, (byte)7};
        Object[] e = new Object[]{(byte)2, (byte)2, (byte)5, (byte)6, (byte)7};
        PTinyintArray type = PTinyintArray.INSTANCE;
        PTinyint base = PTinyint.INSTANCE;
        PhoenixArray.PrimitiveBytePhoenixArray arr1 = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)base, o1);
        PhoenixArray.PrimitiveBytePhoenixArray arr2 = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)base, o2);
        PhoenixArray.PrimitiveBytePhoenixArray expected = new PhoenixArray.PrimitiveBytePhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test((PhoenixArray)arr1, (PhoenixArray)arr2, (PDataType)type, null, null, (PDataType)type, null, null, (PhoenixArray)expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testDate1() throws SQLException {
        Object[] o1 = new Object[]{new Date(0L), new Date(0L)};
        Object[] o2 = new Object[]{new Date(0L), new Date(0L), new Date(0L)};
        Object[] e = new Object[]{new Date(0L), new Date(0L), new Date(0L), new Date(0L), new Date(0L)};
        PDateArray type = PDateArray.INSTANCE;
        PDate base = PDate.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testDecimal1() throws SQLException {
        Object[] o1 = new Object[]{BigDecimal.valueOf(32.4), BigDecimal.valueOf(34L)};
        Object[] o2 = new Object[]{BigDecimal.valueOf(32.4), BigDecimal.valueOf(34L)};
        Object[] e = new Object[]{BigDecimal.valueOf(32.4), BigDecimal.valueOf(34L), BigDecimal.valueOf(32.4), BigDecimal.valueOf(34L)};
        PDecimalArray type = PDecimalArray.INSTANCE;
        PDecimal base = PDecimal.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testVarchar1() throws SQLException {
        Object[] o1 = new Object[]{"a", "b"};
        Object[] o2 = new Object[]{"c", "d"};
        Object[] e = new Object[]{"a", "b", "c", "d"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testVarchar2() throws SQLException {
        Object[] o1 = new Object[]{"a"};
        Object[] o2 = new Object[]{"c", "d"};
        Object[] e = new Object[]{"a", "c", "d"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testVarchar3() throws SQLException {
        Object[] o1 = new Object[]{"a", "b"};
        Object[] o2 = new Object[]{"c"};
        Object[] e = new Object[]{"a", "b", "c"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testVarchar4() throws SQLException {
        Object[] o1 = new Object[]{"a"};
        Object[] o2 = new Object[]{null, "c"};
        Object[] e = new Object[]{"a", null, "c"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testVarchar5() throws SQLException {
        Object[] o1 = new Object[]{"a", null, null};
        Object[] o2 = new Object[]{null, null, "c"};
        Object[] e = new Object[]{"a", null, null, null, null, "c"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testVarchar6() throws SQLException {
        Object[] o1 = new Object[]{"a", "b"};
        Object[] e = new Object[]{"a", "b"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = null;
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testVarchar7() throws SQLException {
        PhoenixArray arr2;
        Object[] o2 = new Object[]{"a", "b"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = null;
        PhoenixArray expected = arr2 = new PhoenixArray((PDataType)base, o2);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testVarchar8() throws SQLException {
        Object[] o1 = new Object[]{"a", null, null, "b"};
        Object[] o2 = new Object[]{"c", null, "d", null, "e"};
        Object[] e = new Object[]{"a", null, null, "b", "c", null, "d", null, "e"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test(expected=TypeMismatchException.class)
    public void testVarchar9() throws SQLException {
        Object[] o1 = new Object[]{"a", "b"};
        Object[] o2 = new Object[]{1, 2};
        PhoenixArray arr1 = new PhoenixArray((PDataType)PVarchar.INSTANCE, o1);
        PhoenixArray.PrimitiveIntPhoenixArray arr2 = new PhoenixArray.PrimitiveIntPhoenixArray((PDataType)PInteger.INSTANCE, o2);
        ArrayConcatFunctionTest.test(arr1, (PhoenixArray)arr2, (PDataType)PVarcharArray.INSTANCE, null, null, (PDataType)PIntegerArray.INSTANCE, null, null, null, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, (PhoenixArray)arr2, (PDataType)PVarcharArray.INSTANCE, null, null, (PDataType)PIntegerArray.INSTANCE, null, null, null, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, (PhoenixArray)arr2, (PDataType)PVarcharArray.INSTANCE, null, null, (PDataType)PIntegerArray.INSTANCE, null, null, null, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, (PhoenixArray)arr2, (PDataType)PVarcharArray.INSTANCE, null, null, (PDataType)PIntegerArray.INSTANCE, null, null, null, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWithIntOffsetArray() throws SQLException {
        Object[] o1 = new Object[32774];
        Object[] o2 = new Object[]{"b", "b"};
        Object[] e = new Object[32776];
        for (int i = 0; i < o1.length; ++i) {
            o1[i] = "a";
            e[i] = "a";
        }
        e[32774] = "b";
        e[32775] = "b";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWithShortToIntOffsetArray() throws SQLException {
        Object[] o1 = new Object[32768];
        Object[] o2 = new Object[]{"b", "b"};
        Object[] e = new Object[32770];
        for (int i = 0; i < o1.length; ++i) {
            o1[i] = "a";
            e[i] = "a";
        }
        e[32769] = "b";
        e[32768] = "b";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWithShortToIntOffsetArray2() throws SQLException {
        Object[] o1 = new Object[32768];
        Object[] o2 = new Object[]{null, "b"};
        Object[] e = new Object[32770];
        for (int i = 0; i < o1.length; ++i) {
            o1[i] = "a";
            e[i] = "a";
        }
        e[32768] = null;
        e[32769] = "b";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWith10NullsAnd246Nulls() throws SQLException {
        Object[] o1 = new Object[11];
        Object[] o2 = new Object[247];
        Object[] e = new Object[258];
        o1[0] = "a";
        o2[o2.length - 1] = "a";
        e[e.length - 1] = "a";
        e[0] = "a";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWith0NullsAnd256Nulls() throws SQLException {
        Object[] o1 = new Object[1];
        Object[] o2 = new Object[257];
        Object[] e = new Object[258];
        o1[0] = "a";
        o2[o2.length - 1] = "a";
        e[e.length - 1] = "a";
        e[0] = "a";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWith256NullsAnd0Nulls() throws SQLException {
        Object[] o1 = new Object[257];
        Object[] o2 = new Object[1];
        Object[] e = new Object[258];
        o1[0] = "a";
        o2[o2.length - 1] = "a";
        e[e.length - 1] = "a";
        e[0] = "a";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWith255NullsAnd0Nulls() throws SQLException {
        Object[] o1 = new Object[256];
        Object[] o2 = new Object[1];
        Object[] e = new Object[257];
        o1[0] = "a";
        o2[o2.length - 1] = "a";
        e[e.length - 1] = "a";
        e[0] = "a";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWith0NullsAnd255Nulls() throws SQLException {
        Object[] o1 = new Object[1];
        Object[] o2 = new Object[256];
        Object[] e = new Object[257];
        o1[0] = "a";
        o2[o2.length - 1] = "a";
        e[e.length - 1] = "a";
        e[0] = "a";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testWith10NullsAnd245Nulls() throws SQLException {
        Object[] o1 = new Object[11];
        Object[] o2 = new Object[246];
        Object[] e = new Object[257];
        o1[0] = "a";
        o2[o2.length - 1] = "a";
        e[e.length - 1] = "a";
        e[0] = "a";
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        PhoenixArray expected = new PhoenixArray((PDataType)base, e);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.ASC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.ASC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.DESC);
        ArrayConcatFunctionTest.test(arr1, arr2, (PDataType)type, null, null, (PDataType)type, null, null, expected, SortOrder.DESC, SortOrder.ASC);
    }

    @Test
    public void testForCorrectSeparatorBytes1() throws Exception {
        Object[] o1 = new Object[]{"a", "b"};
        Object[] o2 = new Object[]{"c", "d", "e"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        LiteralExpression array1Literal = LiteralExpression.newConstant((Object)arr1, (PDataType)type, null, null, (SortOrder)SortOrder.ASC, (Determinism)Determinism.ALWAYS);
        LiteralExpression array2Literal = LiteralExpression.newConstant((Object)arr2, (PDataType)type, null, null, (SortOrder)SortOrder.ASC, (Determinism)Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{array1Literal});
        expressions.add(array2Literal);
        ArrayConcatFunction arrayConcatFunction = new ArrayConcatFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayConcatFunction.evaluate(null, ptr);
        byte[] expected = new byte[]{97, 0, 98, 0, 99, 0, 100, 0, 101, 0, 0, 0, -128, 1, -128, 3, -128, 5, -128, 7, -128, 9, 0, 0, 0, 12, 0, 0, 0, 5, 1};
        Assert.assertArrayEquals((byte[])expected, (byte[])ptr.get());
    }

    @Test
    public void testForCorrectSeparatorBytes2() throws Exception {
        Object[] o1 = new Object[]{"a", "b"};
        Object[] o2 = new Object[]{"c", "d", "e"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        LiteralExpression array1Literal = LiteralExpression.newConstant((Object)arr1, (PDataType)type, null, null, (SortOrder)SortOrder.ASC, (Determinism)Determinism.ALWAYS);
        LiteralExpression array2Literal = LiteralExpression.newConstant((Object)arr2, (PDataType)type, null, null, (SortOrder)SortOrder.DESC, (Determinism)Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{array1Literal});
        expressions.add(array2Literal);
        ArrayConcatFunction arrayConcatFunction = new ArrayConcatFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayConcatFunction.evaluate(null, ptr);
        byte[] expected = new byte[]{97, 0, 98, 0, 99, 0, 100, 0, 101, 0, 0, 0, -128, 1, -128, 3, -128, 5, -128, 7, -128, 9, 0, 0, 0, 12, 0, 0, 0, 5, 1};
        Assert.assertArrayEquals((byte[])expected, (byte[])ptr.get());
    }

    @Test
    public void testForCorrectSeparatorBytes3() throws Exception {
        Object[] o1 = new Object[]{"a", "b"};
        Object[] o2 = new Object[]{"c", "d", "e"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        LiteralExpression array1Literal = LiteralExpression.newConstant((Object)arr1, (PDataType)type, null, null, (SortOrder)SortOrder.DESC, (Determinism)Determinism.ALWAYS);
        LiteralExpression array2Literal = LiteralExpression.newConstant((Object)arr2, (PDataType)type, null, null, (SortOrder)SortOrder.DESC, (Determinism)Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{array1Literal});
        expressions.add(array2Literal);
        ArrayConcatFunction arrayConcatFunction = new ArrayConcatFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayConcatFunction.evaluate(null, ptr);
        byte[] expected = new byte[]{-98, -1, -99, -1, -100, -1, -101, -1, -102, -1, -1, -1, -128, 1, -128, 3, -128, 5, -128, 7, -128, 9, 0, 0, 0, 12, 0, 0, 0, 5, 1};
        Assert.assertArrayEquals((byte[])expected, (byte[])ptr.get());
    }

    @Test
    public void testForCorrectSeparatorBytes4() throws Exception {
        Object[] o1 = new Object[]{"a", "b", null};
        Object[] o2 = new Object[]{null, "c", "d", "e"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        LiteralExpression array1Literal = LiteralExpression.newConstant((Object)arr1, (PDataType)type, null, null, (SortOrder)SortOrder.ASC, (Determinism)Determinism.ALWAYS);
        LiteralExpression array2Literal = LiteralExpression.newConstant((Object)arr2, (PDataType)type, null, null, (SortOrder)SortOrder.DESC, (Determinism)Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{array1Literal});
        expressions.add(array2Literal);
        ArrayConcatFunction arrayConcatFunction = new ArrayConcatFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayConcatFunction.evaluate(null, ptr);
        byte[] expected = new byte[]{97, 0, 98, 0, 0, -2, 99, 0, 100, 0, 101, 0, 0, 0, -128, 1, -128, 3, -128, 5, -128, 5, -128, 7, -128, 9, -128, 11, 0, 0, 0, 14, 0, 0, 0, 7, 1};
        Assert.assertArrayEquals((byte[])expected, (byte[])ptr.get());
    }

    @Test
    public void testForCorrectSeparatorBytes5() throws Exception {
        Object[] o1 = new Object[]{"a", "b", null, null};
        Object[] o2 = new Object[]{null, "c", "d", "e"};
        PVarcharArray type = PVarcharArray.INSTANCE;
        PVarchar base = PVarchar.INSTANCE;
        PhoenixArray arr1 = new PhoenixArray((PDataType)base, o1);
        PhoenixArray arr2 = new PhoenixArray((PDataType)base, o2);
        LiteralExpression array1Literal = LiteralExpression.newConstant((Object)arr1, (PDataType)type, null, null, (SortOrder)SortOrder.DESC, (Determinism)Determinism.ALWAYS);
        LiteralExpression array2Literal = LiteralExpression.newConstant((Object)arr2, (PDataType)type, null, null, (SortOrder)SortOrder.DESC, (Determinism)Determinism.ALWAYS);
        ArrayList expressions = Lists.newArrayList((Object[])new Expression[]{array1Literal});
        expressions.add(array2Literal);
        ArrayConcatFunction arrayConcatFunction = new ArrayConcatFunction((List)expressions);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        arrayConcatFunction.evaluate(null, ptr);
        byte[] expected = new byte[]{-98, -1, -99, -1, 0, -3, -100, -1, -101, -1, -102, -1, -1, -1, -128, 1, -128, 3, -128, 5, -128, 5, -128, 5, -128, 7, -128, 9, -128, 11, 0, 0, 0, 14, 0, 0, 0, 8, 1};
        Assert.assertArrayEquals((byte[])expected, (byte[])ptr.get());
    }
}

