/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.LiteralResultIterationPlan;
import org.apache.phoenix.execute.UnnestArrayPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PIntegerArray;
import org.apache.phoenix.schema.types.PVarcharArray;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.junit.Assert;
import org.junit.Test;

public class UnnestArrayPlanTest {
    private static final StatementContext CONTEXT;

    @Test
    public void testUnnestIntegerArrays() throws Exception {
        this.testUnnestArrays((PArrayDataType)PIntegerArray.INSTANCE, Arrays.asList({1, 10}, {2, 20}), false);
    }

    @Test
    public void testUnnestIntegerArraysWithOrdinality() throws Exception {
        this.testUnnestArrays((PArrayDataType)PIntegerArray.INSTANCE, Arrays.asList({1, 10}, {2, 20}), true);
    }

    @Test
    public void testUnnestVarcharArrays() throws Exception {
        this.testUnnestArrays((PArrayDataType)PVarcharArray.INSTANCE, Arrays.asList({"1", "10"}, {"2", "20"}), false);
    }

    @Test
    public void testUnnestVarcharArraysWithOrdinality() throws Exception {
        this.testUnnestArrays((PArrayDataType)PVarcharArray.INSTANCE, Arrays.asList({"1", "10"}, {"2", "20"}), true);
    }

    @Test
    public void testUnnestEmptyArrays() throws Exception {
        this.testUnnestArrays((PArrayDataType)PIntegerArray.INSTANCE, Arrays.asList({1, 10}, new Object[0], {2, 20}), false);
    }

    @Test
    public void testUnnestEmptyArraysWithOrdinality() throws Exception {
        this.testUnnestArrays((PArrayDataType)PIntegerArray.INSTANCE, Arrays.asList({1, 10}, new Object[0], {2, 20}), true);
    }

    private void testUnnestArrays(PArrayDataType arrayType, List<Object[]> arrays, boolean withOrdinality) throws Exception {
        PDataType baseType = PDataType.fromTypeId((int)(arrayType.getSqlType() - 3000));
        List<Tuple> tuples = this.toTuples(arrayType, arrays);
        LiteralResultIterationPlan subPlan = new LiteralResultIterationPlan(tuples, CONTEXT, (FilterableStatement)SelectStatement.SELECT_ONE, TableRef.EMPTY_TABLE_REF, RowProjector.EMPTY_PROJECTOR, null, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null);
        LiteralExpression dummy = LiteralExpression.newConstant(null, (PDataType)arrayType);
        RowKeyValueAccessor accessor = new RowKeyValueAccessor(Arrays.asList(dummy), 0);
        UnnestArrayPlan plan = new UnnestArrayPlan((QueryPlan)subPlan, (Expression)new RowKeyColumnExpression((PDatum)dummy, accessor), withOrdinality);
        PName colName = PNameFactory.newName((String)"ELEM");
        PColumnImpl elemColumn = new PColumnImpl(PNameFactory.newName((String)"ELEM"), PNameFactory.newName((byte[])QueryConstants.VALUE_COLUMN_FAMILY), baseType, null, null, true, 0, SortOrder.getDefault(), null, null, false, "", false, false, colName.getBytes(), Long.MAX_VALUE);
        colName = PNameFactory.newName((String)"IDX");
        PColumnImpl indexColumn = withOrdinality ? new PColumnImpl(colName, PNameFactory.newName((byte[])QueryConstants.VALUE_COLUMN_FAMILY), (PDataType)PInteger.INSTANCE, null, null, true, 0, SortOrder.getDefault(), null, null, false, "", false, false, colName.getBytes(), Long.MAX_VALUE) : null;
        List<PColumn> columns = withOrdinality ? Arrays.asList(elemColumn, indexColumn) : Arrays.asList(elemColumn);
        ProjectedColumnExpression elemExpr = new ProjectedColumnExpression((PColumn)elemColumn, columns, 0, elemColumn.getName().getString());
        ProjectedColumnExpression indexExpr = withOrdinality ? new ProjectedColumnExpression((PColumn)indexColumn, columns, 1, indexColumn.getName().getString()) : null;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        ResultIterator iterator = plan.iterator();
        for (Object[] o : this.flatten(arrays)) {
            Tuple tuple = iterator.next();
            Assert.assertNotNull((Object)tuple);
            Assert.assertTrue((boolean)elemExpr.evaluate(tuple, ptr));
            Object elem = baseType.toObject(ptr);
            Assert.assertEquals((Object)o[0], (Object)elem);
            if (!withOrdinality) continue;
            Assert.assertTrue((boolean)indexExpr.evaluate(tuple, ptr));
            Object index = PInteger.INSTANCE.toObject(ptr);
            Assert.assertEquals((Object)o[1], (Object)index);
        }
        Assert.assertNull((Object)iterator.next());
    }

    private List<Object[]> flatten(List<Object[]> arrays) {
        ArrayList ret = Lists.newArrayList();
        for (Object[] array : arrays) {
            for (int i = 0; i < array.length; ++i) {
                ret.add(new Object[]{array[i], i + 1});
            }
        }
        return ret;
    }

    private List<Tuple> toTuples(PArrayDataType arrayType, List<Object[]> arrays) {
        ArrayList tuples = Lists.newArrayListWithExpectedSize((int)arrays.size());
        PDataType baseType = PDataType.fromTypeId((int)(arrayType.getSqlType() - 3000));
        for (Object[] array : arrays) {
            PhoenixArray pArray = new PhoenixArray(baseType, array);
            byte[] bytes = arrayType.toBytes((Object)pArray);
            tuples.add(new SingleKeyValueTuple(PhoenixKeyValueUtil.newKeyValue((byte[])bytes, (int)0, (int)bytes.length, (byte[])bytes, (int)0, (int)0, (byte[])bytes, (int)0, (int)0, (long)0L, (byte[])bytes, (int)0, (int)0, (Cell.Type)Cell.Type.Put)));
        }
        return tuples;
    }

    static {
        try {
            PhoenixConnection connection = DriverManager.getConnection("jdbc:phoenix:none").unwrap(PhoenixConnection.class);
            PhoenixStatement stmt = new PhoenixStatement(connection);
            ColumnResolver resolver = FromCompiler.getResolverForQuery((SelectStatement)SelectStatement.SELECT_ONE, (PhoenixConnection)connection);
            CONTEXT = new StatementContext(stmt, resolver, new Scan(), new SequenceManager(stmt));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

