/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class PartialCommitIT
extends BaseTest {
    private final String aSuccessTable;
    private final String bFailureTable;
    private final String cSuccessTable;
    private final String upsertToFail;
    private final String upsertSelectToFail;
    private final String deleteToFail;
    private static final String TABLE_NAME_TO_FAIL = "B_FAILURE_TABLE";
    private static final byte[] ROW_TO_FAIL_UPSERT_BYTES = Bytes.toBytes((String)"fail me upsert");
    private static final byte[] ROW_TO_FAIL_DELETE_BYTES = Bytes.toBytes((String)"fail me delete");
    private final boolean transactional;
    private final String transactionProvider;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)3);
        serverProps.put("hbase.coprocessor.region.classes", FailingRegionObserver.class.getName());
        serverProps.put("hbase.coprocessor.abortonerror", "false");
        serverProps.put("com.saleforce.hbase.index.checkversion", "false");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.transactions.enabled", "true");
        clientProps.put("phoenix.query.request.metrics.enabled", String.valueOf(true));
        PartialCommitIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Parameterized.Parameters(name="PartialCommitIT_transactionProvider={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{"OMID"}});
    }

    public PartialCommitIT(String transactionProvider) {
        this.transactionProvider = transactionProvider;
        this.transactional = transactionProvider != null;
        this.aSuccessTable = PartialCommitIT.generateUniqueName();
        this.bFailureTable = TABLE_NAME_TO_FAIL + PartialCommitIT.generateUniqueName();
        this.cSuccessTable = PartialCommitIT.generateUniqueName();
        this.upsertToFail = "upsert into " + this.bFailureTable + " values ('" + Bytes.toString((byte[])ROW_TO_FAIL_UPSERT_BYTES) + "', 'boom!')";
        this.upsertSelectToFail = "upsert into " + this.bFailureTable + " select k, c from " + this.aSuccessTable;
        this.deleteToFail = "delete from " + this.bFailureTable + "  where k='" + Bytes.toString((byte[])ROW_TO_FAIL_DELETE_BYTES) + "'";
    }

    private void createTables() throws Exception {
        try (Connection con = DriverManager.getConnection(PartialCommitIT.getUrl());){
            Statement sta = con.createStatement();
            sta.execute("create table " + this.aSuccessTable + " (k varchar primary key, c varchar)" + (this.transactional ? " TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.transactionProvider + "'" : ""));
            sta.execute("create table " + this.bFailureTable + " (k varchar primary key, c varchar)" + (this.transactional ? " TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.transactionProvider + "'" : ""));
            sta.execute("create table " + this.cSuccessTable + " (k varchar primary key, c varchar)" + (this.transactional ? " TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.transactionProvider + "'" : ""));
        }
    }

    private void populateTables() throws Exception {
        try (Connection con = DriverManager.getConnection(PartialCommitIT.getUrl());){
            con.setAutoCommit(false);
            Statement sta = con.createStatement();
            ArrayList tableNames = Lists.newArrayList((Object[])new String[]{this.aSuccessTable, this.bFailureTable, this.cSuccessTable});
            for (String tableName : tableNames) {
                sta.execute("upsert into " + tableName + " values ('z', 'z')");
                sta.execute("upsert into " + tableName + " values ('zz', 'zz')");
                sta.execute("upsert into " + tableName + " values ('zzz', 'zzz')");
            }
            con.commit();
        }
    }

    @Before
    public void resetGlobalMetrics() throws Exception {
        this.createTables();
        this.populateTables();
        for (GlobalMetric m : PhoenixRuntime.getGlobalPhoenixClientMetrics()) {
            m.reset();
        }
    }

    @Test
    public void testNoFailure() throws SQLException {
        int[] expectedUncommittedStatementIndexes = new int[]{};
        this.testPartialCommit(Collections.singletonList("upsert into " + this.aSuccessTable + " values ('testNoFailure', 'a')"), expectedUncommittedStatementIndexes, false, Collections.singletonList("select count(*) from " + this.aSuccessTable + " where k='testNoFailure'"), Collections.singletonList(new Integer(1)), expectedUncommittedStatementIndexes.length);
    }

    @Test
    public void testUpsertFailure() throws SQLException {
        int[] nArray;
        if (this.transactional) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        int[] expectedUncommittedStatementIndexes = nArray;
        this.testPartialCommit(Lists.newArrayList((Object[])new String[]{"upsert into " + this.aSuccessTable + " values ('testUpsertFailure1', 'a')", this.upsertToFail, "upsert into " + this.aSuccessTable + " values ('testUpsertFailure2', 'b')"}), expectedUncommittedStatementIndexes, true, Lists.newArrayList((Object[])new String[]{"select count(*) from " + this.aSuccessTable + " where k like 'testUpsertFailure_'", "select count(*) from " + this.bFailureTable + " where k = '" + Bytes.toString((byte[])ROW_TO_FAIL_UPSERT_BYTES) + "'"}), this.transactional ? Lists.newArrayList((Object[])new Integer[]{new Integer(0), new Integer(0)}) : Lists.newArrayList((Object[])new Integer[]{new Integer(2), new Integer(0)}), expectedUncommittedStatementIndexes.length);
    }

    @Test
    public void testUpsertSelectFailure() throws SQLException {
        int[] nArray;
        if (this.transactional) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        int[] expectedUncommittedStatementIndexes = nArray;
        try (Connection con = DriverManager.getConnection(PartialCommitIT.getUrl());){
            con.createStatement().execute("upsert into " + this.aSuccessTable + " values ('" + Bytes.toString((byte[])ROW_TO_FAIL_UPSERT_BYTES) + "', 'boom!')");
            con.commit();
        }
        this.testPartialCommit(Lists.newArrayList((Object[])new String[]{"upsert into " + this.aSuccessTable + " values ('testUpsertSelectFailure', 'a')", this.upsertSelectToFail}), expectedUncommittedStatementIndexes, true, Lists.newArrayList((Object[])new String[]{"select count(*) from " + this.aSuccessTable + " where k in ('testUpsertSelectFailure', '" + Bytes.toString((byte[])ROW_TO_FAIL_UPSERT_BYTES) + "')", "select count(*) from " + this.bFailureTable + " where k = '" + Bytes.toString((byte[])ROW_TO_FAIL_UPSERT_BYTES) + "'"}), this.transactional ? Lists.newArrayList((Object[])new Integer[]{new Integer(1), new Integer(0)}) : Lists.newArrayList((Object[])new Integer[]{new Integer(2), new Integer(0)}), 5);
    }

    @Test
    public void testDeleteFailure() throws SQLException {
        int[] nArray;
        if (this.transactional) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        int[] expectedUncommittedStatementIndexes = nArray;
        this.testPartialCommit(Lists.newArrayList((Object[])new String[]{"upsert into " + this.aSuccessTable + " values ('testDeleteFailure1', 'a')", this.deleteToFail, "upsert into " + this.aSuccessTable + " values ('testDeleteFailure2', 'b')"}), expectedUncommittedStatementIndexes, true, Lists.newArrayList((Object[])new String[]{"select count(*) from " + this.aSuccessTable + " where k like 'testDeleteFailure_'", "select count(*) from " + this.bFailureTable + " where k = 'z'"}), this.transactional ? Lists.newArrayList((Object[])new Integer[]{new Integer(0), new Integer(1)}) : Lists.newArrayList((Object[])new Integer[]{new Integer(2), new Integer(1)}), expectedUncommittedStatementIndexes.length);
    }

    @Test
    public void testOrderOfMutationsIsPredicatable() throws SQLException {
        int[] nArray;
        if (this.transactional) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        int[] expectedUncommittedStatementIndexes = nArray;
        this.testPartialCommit(Lists.newArrayList((Object[])new String[]{"upsert into " + this.cSuccessTable + " values ('testOrderOfMutationsIsPredicatable', 'c')", this.upsertToFail, "upsert into " + this.aSuccessTable + " values ('testOrderOfMutationsIsPredicatable', 'a')"}), expectedUncommittedStatementIndexes, true, Lists.newArrayList((Object[])new String[]{"select count(*) from " + this.cSuccessTable + " where k='testOrderOfMutationsIsPredicatable'", "select count(*) from " + this.aSuccessTable + " where k='testOrderOfMutationsIsPredicatable'", "select count(*) from " + this.bFailureTable + " where k = '" + Bytes.toString((byte[])ROW_TO_FAIL_UPSERT_BYTES) + "'"}), this.transactional ? Lists.newArrayList((Object[])new Integer[]{new Integer(0), new Integer(0), new Integer(0)}) : Lists.newArrayList((Object[])new Integer[]{new Integer(0), new Integer(1), new Integer(0)}), expectedUncommittedStatementIndexes.length);
    }

    @Test
    public void testStatementOrderMaintainedInConnection() throws SQLException {
        int[] nArray;
        if (this.transactional) {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray = nArray2;
            nArray2[3] = 4;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 2;
            nArray = nArray3;
            nArray3[1] = 4;
        }
        int[] expectedUncommittedStatementIndexes = nArray;
        this.testPartialCommit(Lists.newArrayList((Object[])new String[]{"upsert into " + this.aSuccessTable + " values ('testStatementOrderMaintainedInConnection', 'a')", "upsert into " + this.aSuccessTable + " select k, c from " + this.cSuccessTable, this.deleteToFail, "select * from " + this.aSuccessTable + "", this.upsertToFail}), expectedUncommittedStatementIndexes, true, Lists.newArrayList((Object[])new String[]{"select count(*) from " + this.aSuccessTable + " where k='testStatementOrderMaintainedInConnection' or k like 'z%'", "select count(*) from " + this.bFailureTable + " where k = '" + Bytes.toString((byte[])ROW_TO_FAIL_UPSERT_BYTES) + "'", "select count(*) from " + this.bFailureTable + " where k = 'z'"}), this.transactional ? Lists.newArrayList((Object[])new Integer[]{new Integer(3), new Integer(0), new Integer(1)}) : Lists.newArrayList((Object[])new Integer[]{new Integer(4), new Integer(0), new Integer(1)}), expectedUncommittedStatementIndexes.length);
    }

    private void testPartialCommit(List<String> statements, int[] expectedUncommittedStatementIndexes, boolean willFail, List<String> countStatementsForVerification, List<Integer> expectedCountsForVerification, int numFailureInTransactons) throws SQLException {
        Preconditions.checkArgument((countStatementsForVerification.size() == expectedCountsForVerification.size() ? 1 : 0) != 0);
        try (PhoenixConnection con = this.getConnectionWithTableOrderPreservingMutationState();){
            con.setAutoCommit(false);
            Statement sta = con.createStatement();
            for (String statement : statements) {
                sta.execute(statement);
            }
            try {
                con.commit();
                if (willFail) {
                    Assert.fail((String)"Expected at least one statement in the list to fail");
                } else {
                    Assert.assertEquals((long)0L, (long)con.unwrap(PhoenixConnection.class).getStatementExecutionCounter());
                }
            }
            catch (SQLException sqle) {
                if (!willFail) {
                    Assert.fail((String)"Expected no statements to fail");
                }
                Assert.assertEquals(CommitException.class, sqle.getClass());
                int[] uncommittedStatementIndexes = ((CommitException)((Object)sqle)).getUncommittedStatementIndexes();
                Assert.assertArrayEquals((int[])expectedUncommittedStatementIndexes, (int[])uncommittedStatementIndexes);
                Map mutationWriteMetrics = PhoenixRuntime.getWriteMetricInfoForMutationsSinceLastReset((Connection)con);
                Assert.assertEquals((long)numFailureInTransactons, (long)((Long)((Map)mutationWriteMetrics.get(this.bFailureTable)).get(MetricType.MUTATION_BATCH_FAILED_SIZE)).intValue());
                Assert.assertEquals((long)numFailureInTransactons, (long)GlobalClientMetrics.GLOBAL_MUTATION_BATCH_FAILED_COUNT.getMetric().getValue());
            }
            for (int i = 0; i < countStatementsForVerification.size(); ++i) {
                String countStatement = countStatementsForVerification.get(i);
                ResultSet rs = sta.executeQuery(countStatement);
                if (!rs.next()) {
                    Assert.fail((String)"Expected a single row from count query");
                }
                Assert.assertEquals((long)expectedCountsForVerification.get(i).intValue(), (long)rs.getInt(1));
            }
        }
    }

    private PhoenixConnection getConnectionWithTableOrderPreservingMutationState() throws SQLException {
        try (PhoenixConnection con = DriverManager.getConnection(PartialCommitIT.getUrl()).unwrap(PhoenixConnection.class);){
            final TreeMap mutations = Maps.newTreeMap((Comparator)new TableRefComparator());
            PhoenixConnection phoenixConnection = new PhoenixConnection(con, null){

                protected MutationState newMutationState(int maxSize, long maxSizeBytes) {
                    return new MutationState(maxSize, maxSizeBytes, (PhoenixConnection)this, mutations, false, null);
                }
            };
            return phoenixConnection;
        }
    }

    private static class TableRefComparator
    implements Comparator<TableRef> {
        private TableRefComparator() {
        }

        @Override
        public int compare(TableRef tr1, TableRef tr2) {
            return tr1.getTable().getPhysicalName().getString().compareTo(tr2.getTable().getPhysicalName().getString());
        }
    }

    public static class FailingRegionObserver
    extends SimpleRegionObserver {
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws HBaseIOException {
            if (this.shouldFail(c, (Mutation)put)) {
                throw new DoNotRetryIOException();
            }
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
            if (this.shouldFail(c, (Mutation)delete)) {
                throw new DoNotRetryIOException();
            }
        }

        private boolean shouldFail(ObserverContext<RegionCoprocessorEnvironment> c, Mutation m) {
            String tableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString();
            return tableName.contains(PartialCommitIT.TABLE_NAME_TO_FAIL) && (Bytes.equals((byte[])ROW_TO_FAIL_UPSERT_BYTES, (byte[])m.getRow()) || Bytes.equals((byte[])ROW_TO_FAIL_DELETE_BYTES, (byte[])m.getRow()));
        }
    }
}

