/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PUnsignedInt;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class MutationStateTest {
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Test
    public void testJoinIntArrays() {
        int[] a = new int[]{1};
        int[] b = new int[]{2};
        int[] result = MutationState.joinSortedIntArrays((int[])a, (int[])b);
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])result);
        a = new int[]{};
        b = new int[]{};
        result = MutationState.joinSortedIntArrays((int[])a, (int[])b);
        Assert.assertEquals((long)0L, (long)result.length);
        Assert.assertArrayEquals((int[])new int[0], (int[])result);
        a = new int[]{1, 2, 3};
        b = new int[]{1, 2, 4};
        result = MutationState.joinSortedIntArrays((int[])a, (int[])b);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])result);
        a = new int[]{1, 2, 2, 3};
        b = new int[]{1, 2, 4};
        result = MutationState.joinSortedIntArrays((int[])a, (int[])b);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])result);
    }

    private static String getUrl() {
        return "jdbc:phoenix:none";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToMutationsOverMultipleTables() throws Exception {
        try (Connection conn = null;){
            conn = DriverManager.getConnection(MutationStateTest.getUrl());
            conn.createStatement().execute("create table MUTATION_TEST1( id1 UNSIGNED_INT not null primary key,appId1 VARCHAR)");
            conn.createStatement().execute("create table MUTATION_TEST2( id2 UNSIGNED_INT not null primary key,appId2 VARCHAR)");
            conn.createStatement().execute("upsert into MUTATION_TEST1(id1,appId1) values(111,'app1')");
            conn.createStatement().execute("upsert into MUTATION_TEST2(id2,appId2) values(222,'app2')");
            Iterator dataTableNameAndMutationKeyValuesIter = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
            Assert.assertTrue((boolean)dataTableNameAndMutationKeyValuesIter.hasNext());
            Pair pair = (Pair)dataTableNameAndMutationKeyValuesIter.next();
            String tableName1 = Bytes.toString((byte[])((byte[])pair.getFirst()));
            List keyValues1 = (List)pair.getSecond();
            Assert.assertTrue((boolean)dataTableNameAndMutationKeyValuesIter.hasNext());
            pair = (Pair)dataTableNameAndMutationKeyValuesIter.next();
            String tableName2 = Bytes.toString((byte[])((byte[])pair.getFirst()));
            List keyValues2 = (List)pair.getSecond();
            if ("MUTATION_TEST1".equals(tableName1)) {
                this.assertTable(tableName1, keyValues1, tableName2, keyValues2);
            } else {
                this.assertTable(tableName2, keyValues2, tableName1, keyValues1);
            }
            Assert.assertTrue((!dataTableNameAndMutationKeyValuesIter.hasNext() ? 1 : 0) != 0);
        }
    }

    private void assertTable(String tableName1, List<Cell> keyValues1, String tableName2, List<Cell> keyValues2) {
        Assert.assertTrue((boolean)"MUTATION_TEST1".equals(tableName1));
        Assert.assertTrue((boolean)Bytes.equals((byte[])PUnsignedInt.INSTANCE.toBytes((Object)111), (byte[])CellUtil.cloneRow((Cell)keyValues1.get(0))));
        Assert.assertTrue((boolean)"app1".equals(PVarchar.INSTANCE.toObject(CellUtil.cloneValue((Cell)keyValues1.get(1)))));
        Assert.assertTrue((boolean)"MUTATION_TEST2".equals(tableName2));
        Assert.assertTrue((boolean)Bytes.equals((byte[])PUnsignedInt.INSTANCE.toBytes((Object)222), (byte[])CellUtil.cloneRow((Cell)keyValues2.get(0))));
        Assert.assertTrue((boolean)"app2".equals(PVarchar.INSTANCE.toObject(CellUtil.cloneValue((Cell)keyValues2.get(1)))));
    }

    @Test
    public void testGetMutationBatchList() {
        byte[] r1 = Bytes.toBytes((int)1);
        byte[] r2 = Bytes.toBytes((int)2);
        byte[] r3 = Bytes.toBytes((int)3);
        byte[] r4 = Bytes.toBytes((int)4);
        ImmutableList list = ImmutableList.of((Object)new Put(r1), (Object)new Put(r2), (Object)new Delete(r2));
        List batchLists = MutationState.getMutationBatchList((long)2L, (long)10L, (List)list);
        Assert.assertTrue((batchLists.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)((List)batchLists.get(0)).size(), (long)1L);
        Assert.assertEquals((long)((List)batchLists.get(1)).size(), (long)2L);
        list = ImmutableList.of((Object)new Put(r1), (Object)new Delete(r1), (Object)new Put(r2));
        batchLists = MutationState.getMutationBatchList((long)2L, (long)10L, (List)list);
        Assert.assertTrue((batchLists.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((long)((List)batchLists.get(0)).size(), (long)2L);
        Assert.assertEquals((long)((List)batchLists.get(1)).size(), (long)1L);
        list = ImmutableList.of((Object)new Put(r3), (Object)new Put(r1), (Object)new Delete(r1), (Object)new Put(r2), (Object)new Put(r4), (Object)new Delete(r4));
        batchLists = MutationState.getMutationBatchList((long)2L, (long)10L, (List)list);
        Assert.assertTrue((batchLists.size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((long)((List)batchLists.get(0)).size(), (long)1L);
        Assert.assertEquals((long)((List)batchLists.get(1)).size(), (long)2L);
        Assert.assertEquals((long)((List)batchLists.get(2)).size(), (long)1L);
        Assert.assertEquals((long)((List)batchLists.get(3)).size(), (long)2L);
    }

    @Test
    public void testPendingMutationsOnDDL() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.pending.mutations.before.ddl.throw", "true");
        try (Connection conn = DriverManager.getConnection(MutationStateTest.getUrl(), props);
             PhoenixConnection pConnSpy = (PhoenixConnection)Mockito.spy((Object)((PhoenixConnection)conn));){
            MutationState mutationState = (MutationState)Mockito.mock(MutationState.class);
            Mockito.when((Object)mutationState.getNumRows()).thenReturn((Object)1);
            ((PhoenixConnection)Mockito.doReturn((Object)mutationState).when((Object)pConnSpy)).getMutationState();
            this.exceptionRule.expect(SQLException.class);
            this.exceptionRule.expectMessage(SQLExceptionCode.CANNOT_PERFORM_DDL_WITH_PENDING_MUTATIONS.getMessage());
            pConnSpy.createStatement().execute("create table MUTATION_TEST1( id1 UNSIGNED_INT not null primary key,appId1 VARCHAR)");
        }
    }

    @Test
    public void testOnDupAndUpsertInSameCommitBatch() throws Exception {
        String dataTable1 = BaseTest.generateUniqueName();
        String dataTable2 = BaseTest.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(MutationStateTest.getUrl());){
            conn.createStatement().execute(String.format("create table %s (id1 UNSIGNED_INT not null primary key, appId1 VARCHAR)", dataTable1));
            conn.createStatement().execute(String.format("create table %s (id2 UNSIGNED_INT not null primary key, appId2 VARCHAR)", dataTable2));
            conn.createStatement().execute(String.format("upsert into %s(id1,appId1) values(111,'app1')", dataTable1));
            conn.createStatement().execute(String.format("upsert into %s(id1,appId1) values(111, 'app1') ON DUPLICATE KEY UPDATE appId1 = null", dataTable1));
            conn.createStatement().execute(String.format("upsert into %s(id2,appId2) values(222,'app2')", dataTable2));
            conn.createStatement().execute(String.format("upsert into %s(id2,appId2) values(222,'app2') ON DUPLICATE KEY UPDATE appId2 = null", dataTable2));
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            MutationState state = pconn.getMutationState();
            Assert.assertEquals((long)2L, (long)state.getNumRows());
            int actualPairs = 0;
            Iterator mutations = state.toMutations();
            while (mutations.hasNext()) {
                Pair nextTable = (Pair)mutations.next();
                ++actualPairs;
                Assert.assertEquals((long)1L, (long)((List)nextTable.getSecond()).size());
            }
            Assert.assertEquals((long)4L, (long)actualPairs);
            List commitBatches = state.createCommitBatches();
            Assert.assertEquals((long)2L, (long)commitBatches.size());
            this.verifyCommitBatch((Map)commitBatches.get(0), false, 2, 1);
            this.verifyCommitBatch((Map)commitBatches.get(1), true, 2, 1);
        }
    }

    private void verifyCommitBatch(Map<TableRef, MutationState.MultiRowMutationState> commitBatch, boolean conditional, int numberOfBatches, int rowsPerBatch) {
        Assert.assertEquals((long)numberOfBatches, (long)commitBatch.size());
        for (Map.Entry<TableRef, MutationState.MultiRowMutationState> entry : commitBatch.entrySet()) {
            TableRef tableRef = entry.getKey();
            MutationState.MultiRowMutationState batch = entry.getValue();
            Assert.assertEquals((long)rowsPerBatch, (long)batch.size());
            for (Map.Entry row : batch.entrySet()) {
                ImmutableBytesPtr key = (ImmutableBytesPtr)row.getKey();
                MutationState.RowMutationState rowMutationState = (MutationState.RowMutationState)row.getValue();
                if (conditional) {
                    Assert.assertNotNull((Object)rowMutationState.getOnDupKeyBytes());
                    continue;
                }
                Assert.assertNull((Object)rowMutationState.getOnDupKeyBytes());
            }
        }
    }
}

