/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.TupleProjectionCompiler;
import org.apache.phoenix.execute.LiteralResultIterationPlan;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class LiteralResultIteratorPlanTest {
    private static final StatementContext CONTEXT;
    private static final Object[][] RELATION;
    PTable table = this.createProjectedTableFromLiterals(RELATION[0]).getTable();

    @Test
    public void testLiteralResultIteratorPlanWithOffset() throws SQLException {
        Object[][] expected = new Object[][]{{"2", 40}, {"5", 50}, {"6", 60}, {"5", 100}, {"1", 10}, {"3", 30}};
        this.testLiteralResultIteratorPlan(expected, 1, null);
    }

    @Test
    public void testLiteralResultIteratorPlanWithLimit() throws SQLException {
        Object[][] expected = new Object[][]{{"2", 20}, {"2", 40}, {"5", 50}, {"6", 60}};
        this.testLiteralResultIteratorPlan(expected, null, 4);
    }

    @Test
    public void testLiteralResultIteratorPlanWithLimitAndOffset() throws SQLException {
        Object[][] expected = new Object[][]{{"5", 50}, {"6", 60}, {"5", 100}, {"1", 10}};
        this.testLiteralResultIteratorPlan(expected, 2, 4);
    }

    private void testLiteralResultIteratorPlan(Object[][] expectedResult, Integer offset, Integer limit) throws SQLException {
        QueryPlan plan = this.newLiteralResultIterationPlan(offset, limit);
        ResultIterator iter = plan.iterator();
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        for (Object[] row : expectedResult) {
            Tuple next = iter.next();
            Assert.assertNotNull((Object)next);
            for (int i = 0; i < row.length; ++i) {
                PColumn column = (PColumn)this.table.getColumns().get(i);
                boolean eval = new ProjectedColumnExpression(column, this.table, column.getName().getString()).evaluate(next, ptr);
                Object o = eval ? column.getDataType().toObject(ptr) : null;
                Assert.assertEquals((Object)row[i], (Object)o);
            }
        }
        Assert.assertNull((Object)iter.next());
    }

    private QueryPlan newLiteralResultIterationPlan(Integer offset, Integer limit) throws SQLException {
        ArrayList tuples = Lists.newArrayList();
        SingleKeyValueTuple baseTuple = new SingleKeyValueTuple((Cell)KeyValue.LOWESTKEY);
        for (Object[] row : RELATION) {
            Expression[] exprs = new Expression[row.length];
            for (int i = 0; i < row.length; ++i) {
                exprs[i] = LiteralExpression.newConstant((Object)row[i]);
            }
            TupleProjector projector = new TupleProjector(exprs);
            tuples.add(projector.projectResults((Tuple)baseTuple));
        }
        return new LiteralResultIterationPlan((Iterable)tuples, CONTEXT, (FilterableStatement)SelectStatement.SELECT_ONE, TableRef.EMPTY_TABLE_REF, RowProjector.EMPTY_PROJECTOR, limit, offset, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null);
    }

    private TableRef createProjectedTableFromLiterals(Object[] row) {
        ArrayList columns = Lists.newArrayList();
        for (int i = 0; i < row.length; ++i) {
            String name = ParseNodeFactory.createTempAlias();
            LiteralExpression expr = LiteralExpression.newConstant((Object)row[i]);
            PName colName = PNameFactory.newName((String)name);
            columns.add(new PColumnImpl(PNameFactory.newName((String)name), PNameFactory.newName((byte[])QueryConstants.VALUE_COLUMN_FAMILY), expr.getDataType(), expr.getMaxLength(), expr.getScale(), expr.isNullable(), i, expr.getSortOrder(), null, null, false, name, false, false, colName.getBytes(), Long.MAX_VALUE));
        }
        try {
            PTableImpl pTable = new PTableImpl.Builder().setType(PTableType.SUBQUERY).setTimeStamp(0L).setIndexDisableTimestamp(0L).setSequenceNumber(0L).setImmutableRows(false).setDisableWAL(false).setMultiTenant(false).setStoreNulls(false).setUpdateCacheFrequency(0L).setNamespaceMapped(false).setAppendOnlySchema(false).setImmutableStorageScheme(PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN).setQualifierEncodingScheme(PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS).setBaseColumnCount(-1).setEncodedCQCounter(PTable.EncodedCQCounter.NULL_COUNTER).setUseStatsForParallelization(Boolean.valueOf(true)).setExcludedColumns((List)ImmutableList.of()).setSchemaName(PName.EMPTY_NAME).setTableName(PName.EMPTY_NAME).setRowKeyOrderOptimizable(true).setIndexes(Collections.emptyList()).setPhysicalNames((List)ImmutableList.of()).setColumns((Collection)columns).build();
            TableRef sourceTable = new TableRef((PTable)pTable);
            ArrayList sourceColumnRefs = Lists.newArrayList();
            for (PColumn column : sourceTable.getTable().getColumns()) {
                sourceColumnRefs.add(new ColumnRef(sourceTable, column.getPosition()));
            }
            return new TableRef(TupleProjectionCompiler.createProjectedTable((TableRef)sourceTable, (List)sourceColumnRefs, (boolean)false));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            PhoenixConnection connection = DriverManager.getConnection("jdbc:phoenix:none").unwrap(PhoenixConnection.class);
            PhoenixStatement stmt = new PhoenixStatement(connection);
            ColumnResolver resolver = FromCompiler.getResolverForQuery((SelectStatement)SelectStatement.SELECT_ONE, (PhoenixConnection)connection);
            CONTEXT = new StatementContext(stmt, resolver, new Scan(), new SequenceManager(stmt));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        RELATION = new Object[][]{{"2", 20}, {"2", 40}, {"5", 50}, {"6", 60}, {"5", 100}, {"1", 10}, {"3", 30}};
    }
}

