/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.transform;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.coprocessor.tasks.TransformMonitorTask;
import org.apache.phoenix.end2end.IndexRebuildTaskIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.index.SingleCellIndexIT;
import org.apache.phoenix.end2end.transform.TransformToolIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.ConnectionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.ServerTask;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.Transform;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransformMonitorIT
extends ParallelStatsDisabledIT {
    private static RegionCoprocessorEnvironment TaskRegionEnvironment;
    private Properties testProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);

    public TransformMonitorIT() throws IOException, InterruptedException {
        this.testProps.put("phoenix.default.immutable.storage.scheme", "ONE_CELL_PER_COLUMN");
        this.testProps.put("phoenix.default.column.encoded.bytes.attrib", "0");
        this.testProps.put("phoenix.acls.enabled", "true");
        TaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)TransformMonitorIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(TaskRegionObserver.class.getName());
    }

    @Before
    public void setupTest() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME);
            conn.createStatement().execute("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME);
        }
    }

    private void testTransformTable(boolean createIndex, boolean createView, boolean isImmutable) throws Exception {
        String schemaName = TransformMonitorIT.generateUniqueName();
        String dataTableName = "TBL_" + TransformMonitorIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String newTableName = dataTableName + "_1";
        String newTableFullName = SchemaUtil.getTableName((String)schemaName, (String)newTableName);
        String indexName = "IDX_" + TransformMonitorIT.generateUniqueName();
        String indexName2 = "IDX_" + TransformMonitorIT.generateUniqueName();
        String viewName = "VW_" + TransformMonitorIT.generateUniqueName();
        String viewName2 = "VW2_" + TransformMonitorIT.generateUniqueName();
        String viewIdxName = "VW_IDX_" + TransformMonitorIT.generateUniqueName();
        String viewIdxName2 = "VW_IDX_" + TransformMonitorIT.generateUniqueName();
        String view2IdxName1 = "VW2_IDX_" + TransformMonitorIT.generateUniqueName();
        String indexFullName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        String createIndexStmt = "CREATE INDEX %s ON " + dataTableFullName + " (NAME) INCLUDE (ZIP) ";
        String createViewStmt = "CREATE VIEW %s ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + dataTableFullName;
        String createViewIdxSql = "CREATE INDEX  %s ON " + viewName + " (VIEW_COL1) include (VIEW_COL2) ";
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            int numOfRows = 10;
            TransformToolIT.createTableAndUpsertRows((Connection)conn, dataTableFullName, numOfRows, isImmutable ? " IMMUTABLE_ROWS=true" : "");
            if (createIndex) {
                conn.createStatement().execute(String.format(createIndexStmt, indexName));
            }
            if (createView) {
                conn.createStatement().execute(String.format(createViewStmt, viewName));
                conn.createStatement().execute(String.format(createViewIdxSql, viewIdxName));
                conn.createStatement().execute("UPSERT INTO " + viewName + "(ID, NAME, VIEW_COL1, VIEW_COL2) VALUES (1, 'uname11', 100, 'viewCol2')");
            }
            TransformMonitorIT.assertMetadata((Connection)conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)((PhoenixConnection)conn.unwrap(PhoenixConnection.class)));
            Assert.assertNotNull((Object)record);
            List taskRecordList = Task.queryTaskTable((Connection)conn, null);
            Assert.assertEquals((long)1L, (long)taskRecordList.size());
            Assert.assertEquals((Object)PTable.TaskType.TRANSFORM_MONITOR, (Object)((Task.TaskRecord)taskRecordList.get(0)).getTaskType());
            Assert.assertEquals((Object)schemaName, (Object)((Task.TaskRecord)taskRecordList.get(0)).getSchemaName());
            Assert.assertEquals((Object)dataTableName, (Object)((Task.TaskRecord)taskRecordList.get(0)).getTableName());
            TransformMonitorIT.waitForTransformToGetToState((PhoenixConnection)conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            PTable oldTable = conn.getTableNoCache(dataTableFullName);
            Assert.assertEquals((Object)newTableName, (Object)oldTable.getPhysicalName(true).getString());
            TransformMonitorIT.assertMetadata((Connection)conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            TransformMonitorIT.assertMetadata((Connection)conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, dataTableFullName);
            ConnectionQueryServices cqs = ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices();
            long newRowCount = TransformMonitorIT.countRows((Connection)conn, newTableFullName);
            Assert.assertEquals((long)TestUtil.getRawRowCount(cqs.getTable(Bytes.toBytes((String)dataTableFullName))), (long)newRowCount);
            if (createIndex) {
                Assert.assertEquals((long)newRowCount, (long)TransformMonitorIT.countRows((Connection)conn, indexFullName));
                int additionalRows = 2;
                TransformToolIT.upsertRows((Connection)conn, dataTableFullName, (int)newRowCount + 1, additionalRows);
                Assert.assertEquals((long)(newRowCount + (long)additionalRows), (long)TransformMonitorIT.countRows((Connection)conn, indexFullName));
                Assert.assertEquals((long)newRowCount, (long)TestUtil.getRawRowCount(cqs.getTable(Bytes.toBytes((String)dataTableFullName))));
                Admin admin = ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices().getAdmin();
                TableName hTableName = TableName.valueOf((String)dataTableFullName);
                admin.disableTable(hTableName);
                admin.deleteTable(hTableName);
                conn.createStatement().execute(String.format(createIndexStmt, indexName2));
                Assert.assertEquals((long)(newRowCount + (long)additionalRows), (long)TransformMonitorIT.countRows((Connection)conn, dataTableFullName));
                Assert.assertEquals((long)(newRowCount + (long)additionalRows), (long)TransformMonitorIT.countRows((Connection)conn, SchemaUtil.getTableName((String)schemaName, (String)indexName2)));
            } else if (createView) {
                Assert.assertEquals((long)numOfRows, (long)TransformMonitorIT.countRows((Connection)conn, viewName));
                Assert.assertEquals((long)numOfRows, (long)this.countRowsForViewIndex((Connection)conn, dataTableFullName));
                TransformMonitorIT.assertMetadata((Connection)conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, viewName);
                ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices().clearCache();
                ResultSet rs = conn.createStatement().executeQuery("SELECT VIEW_COL2 FROM " + viewName + " WHERE VIEW_COL1=100");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"viewCol2", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
                int additionalRows = 2;
                TransformToolIT.upsertRows((Connection)conn, viewName, (int)newRowCount + 1, additionalRows);
                Assert.assertEquals((long)(newRowCount + (long)additionalRows), (long)TestUtil.getRowCount((Connection)conn, viewName));
                Assert.assertEquals((long)(newRowCount + (long)additionalRows), (long)this.countRowsForViewIndex((Connection)conn, dataTableFullName));
                conn.createStatement().execute("DROP INDEX " + viewIdxName + " ON " + viewName);
                Admin admin = ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices().getAdmin();
                TableName hTableName = TableName.valueOf((String)dataTableFullName);
                admin.disableTable(hTableName);
                admin.deleteTable(hTableName);
                conn.createStatement().execute(String.format(createViewIdxSql, viewIdxName2));
                Assert.assertEquals((long)(newRowCount + (long)additionalRows), (long)this.countRowsForViewIndex((Connection)conn, dataTableFullName));
                conn.createStatement().execute(String.format(createViewStmt, viewName2));
                conn.createStatement().execute(String.format(createViewIdxSql, view2IdxName1));
                Assert.assertEquals((long)((newRowCount + (long)additionalRows) * 2L), (long)this.countRowsForViewIndex((Connection)conn, dataTableFullName));
                conn.createStatement().execute("UPSERT INTO " + viewName2 + "(ID, NAME, VIEW_COL1, VIEW_COL2) VALUES (100, 'uname100', 1000, 'viewCol100')");
                rs = conn.createStatement().executeQuery("SELECT VIEW_COL2, NAME FROM " + viewName2 + " WHERE VIEW_COL1=1000");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"viewCol100", (Object)rs.getString(1));
                Assert.assertEquals((Object)"uname100", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    public static int countRows(Connection conn, String tableFullName) throws SQLException {
        ResultSet count = conn.createStatement().executeQuery("select  /*+ NO_INDEX*/ count(*) from " + tableFullName);
        count.next();
        int numRows = count.getInt(1);
        return numRows;
    }

    protected int countRowsForViewIndex(Connection conn, String baseTable) throws IOException, SQLException {
        String viewIndexTableName = MetaDataUtil.getViewIndexPhysicalName((String)baseTable);
        ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
        Table indexHTable = queryServices.getTable(Bytes.toBytes((String)viewIndexTableName));
        return TransformMonitorIT.getUtility().countRows(indexHTable);
    }

    @Test
    public void testTransformMonitor_mutableTableWithoutIndex() throws Exception {
        this.testTransformTable(false, false, false);
    }

    @Test
    public void testTransformMonitor_immutableTableWithoutIndex() throws Exception {
        this.testTransformTable(false, false, true);
    }

    @Test
    public void testTransformMonitor_immutableTableWithIndex() throws Exception {
        this.testTransformTable(true, false, true);
    }

    @Test
    public void testTransformMonitor_pausedTransform() throws Exception {
        this.testTransformMonitor_checkStates(PTable.TransformStatus.PAUSED, PTable.TaskStatus.COMPLETED);
    }

    @Test
    public void testTransformMonitor_completedTransform() throws Exception {
        this.testTransformMonitor_checkStates(PTable.TransformStatus.COMPLETED, PTable.TaskStatus.COMPLETED);
    }

    @Test
    public void testTransformMonitor_failedTransform() throws Exception {
        this.testTransformMonitor_checkStates(PTable.TransformStatus.FAILED, PTable.TaskStatus.FAILED);
    }

    private void testTransformMonitor_checkStates(PTable.TransformStatus transformStatus, PTable.TaskStatus taskStatus) throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            SystemTransformRecord.SystemTransformBuilder transformBuilder = new SystemTransformRecord.SystemTransformBuilder();
            String logicalTableName = TransformMonitorIT.generateUniqueName();
            transformBuilder.setLogicalTableName(logicalTableName);
            transformBuilder.setTransformStatus(transformStatus.name());
            transformBuilder.setNewPhysicalTableName(logicalTableName + "_1");
            Transform.upsertTransform((SystemTransformRecord)transformBuilder.build(), (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            TaskRegionObserver.SelfHealingTask task = new TaskRegionObserver.SelfHealingTask(TaskRegionEnvironment, 1800000L);
            Timestamp startTs = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            ServerTask.addTask((SystemTaskParams)new SystemTaskParams.SystemTaskParamsBuilder().setConn(conn.unwrap(PhoenixConnection.class)).setTaskType(PTable.TaskType.TRANSFORM_MONITOR).setTenantId(null).setSchemaName(null).setTableName(logicalTableName).setTaskStatus(PTable.TaskStatus.CREATED.toString()).setData(null).setPriority(null).setStartTs(startTs).setEndTs(null).build());
            task.run();
            IndexRebuildTaskIT.waitForTaskState(conn, PTable.TaskType.TRANSFORM_MONITOR, logicalTableName, taskStatus);
        }
    }

    @Test
    public void testTransformMonitor_pauseAndResumeTransform() throws Exception {
        String schemaName = TransformMonitorIT.generateUniqueName();
        String dataTableName = TransformMonitorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            TransformToolIT.pauseTableTransform(schemaName, dataTableName, conn, "");
            List<String> args = TransformToolIT.getArgList(schemaName, dataTableName, null, null, null, null, false, false, true, false, false);
            TransformToolIT.runTransformTool(args.toArray(new String[0]), 0);
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            List taskRecordList = Task.queryTaskTable((Connection)conn, null);
            Assert.assertEquals((long)1L, (long)taskRecordList.size());
            Assert.assertEquals((Object)PTable.TaskType.TRANSFORM_MONITOR, (Object)((Task.TaskRecord)taskRecordList.get(0)).getTaskType());
            Assert.assertEquals((Object)schemaName, (Object)((Task.TaskRecord)taskRecordList.get(0)).getSchemaName());
            Assert.assertEquals((Object)dataTableName, (Object)((Task.TaskRecord)taskRecordList.get(0)).getTableName());
            IndexRebuildTaskIT.waitForTaskState(conn, PTable.TaskType.TRANSFORM_MONITOR, dataTableName, PTable.TaskStatus.COMPLETED);
        }
    }

    @Test
    public void testTransformMonitor_mutableTableWithIndex() throws Exception {
        this.testTransformTable(true, false, false);
    }

    @Test
    public void testTransformMonitor_tableWithViews() throws Exception {
        this.testTransformTable(false, true, false);
    }

    @Test
    public void testTransformMonitor_index() throws Exception {
        String schemaName = TransformMonitorIT.generateUniqueName();
        String dataTableName = "TBL_" + TransformMonitorIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexName = "IDX_" + TransformMonitorIT.generateUniqueName();
        String indexFullName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        String newTableFullName = indexFullName + "_1";
        String createIndexStmt = "CREATE INDEX " + indexName + " ON " + dataTableFullName + " (ZIP) INCLUDE (NAME) ";
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            int numOfRows = 10;
            TransformToolIT.createTableAndUpsertRows((Connection)conn, dataTableFullName, numOfRows, "");
            conn.createStatement().execute(createIndexStmt);
            TransformMonitorIT.assertMetadata((Connection)conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, indexFullName);
            conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + dataTableFullName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)indexName, (String)dataTableFullName, null, (PhoenixConnection)((PhoenixConnection)conn.unwrap(PhoenixConnection.class)));
            Assert.assertNotNull((Object)record);
            List taskRecordList = Task.queryTaskTable((Connection)conn, null);
            Assert.assertEquals((long)1L, (long)taskRecordList.size());
            Assert.assertEquals((Object)PTable.TaskType.TRANSFORM_MONITOR, (Object)((Task.TaskRecord)taskRecordList.get(0)).getTaskType());
            Assert.assertEquals((Object)schemaName, (Object)((Task.TaskRecord)taskRecordList.get(0)).getSchemaName());
            Assert.assertEquals((Object)indexName, (Object)((Task.TaskRecord)taskRecordList.get(0)).getTableName());
            TransformMonitorIT.waitForTransformToGetToState((PhoenixConnection)conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            PTable oldTable = conn.getTableNoCache(indexFullName);
            Assert.assertEquals((Object)(indexName + "_1"), (Object)oldTable.getPhysicalName(true).getString());
            TransformMonitorIT.assertMetadata((Connection)conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, newTableFullName);
            ConnectionQueryServices cqs = ((PhoenixConnection)conn.unwrap(PhoenixConnection.class)).getQueryServices();
            long newRowCount = TransformMonitorIT.countRows((Connection)conn, newTableFullName);
            Assert.assertEquals((long)TestUtil.getRawRowCount(cqs.getTable(Bytes.toBytes((String)indexFullName))), (long)newRowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformTableWithTenantViews() throws Exception {
        String tenantId = TransformMonitorIT.generateUniqueName();
        String dataTableName = TransformMonitorIT.generateUniqueName();
        String viewTenantName = "TENANTVW_" + TransformMonitorIT.generateUniqueName();
        String createTblStr = "CREATE TABLE %s (TENANT_ID VARCHAR(15) NOT NULL,ID INTEGER NOT NULL, NAME VARCHAR, CONSTRAINT PK_1 PRIMARY KEY (TENANT_ID, ID)) MULTI_TENANT=true";
        String createViewStr = "CREATE VIEW %s  (VIEW_COL1 VARCHAR) AS SELECT * FROM %s";
        String upsertQueryStr = "UPSERT INTO %s (TENANT_ID, ID, NAME, VIEW_COL1) VALUES('%s' , %d, '%s', '%s')";
        Properties props = PropertiesUtil.deepCopy((Properties)this.testProps);
        Connection connGlobal = null;
        Connection connTenant = null;
        try {
            connGlobal = DriverManager.getConnection(TransformMonitorIT.getUrl(), props);
            props.setProperty("TenantId", tenantId);
            connTenant = DriverManager.getConnection(TransformMonitorIT.getUrl(), props);
            connTenant.setAutoCommit(true);
            String tableStmtGlobal = String.format(createTblStr, dataTableName);
            connGlobal.createStatement().execute(tableStmtGlobal);
            TransformMonitorIT.assertMetadata(connGlobal, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableName);
            String viewStmtTenant = String.format(createViewStr, viewTenantName, dataTableName);
            connTenant.createStatement().execute(viewStmtTenant);
            try {
                connTenant.createStatement().execute("ALTER TABLE " + dataTableName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
                Assert.fail((String)"Tenant connection cannot do alter");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_TENANT_SPECIFIC_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            connGlobal.createStatement().execute("ALTER TABLE " + dataTableName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord tableRecord = Transform.getTransformRecord(null, (String)dataTableName, null, null, (PhoenixConnection)connGlobal.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)tableRecord);
            TransformMonitorIT.waitForTransformToGetToState(connGlobal.unwrap(PhoenixConnection.class), tableRecord, PTable.TransformStatus.COMPLETED);
            connTenant.createStatement().execute(String.format(upsertQueryStr, viewTenantName, tenantId, 2, "y", "yy"));
            ResultSet rs = connTenant.createStatement().executeQuery("SELECT /*+ NO_INDEX */ VIEW_COL1 FROM " + viewTenantName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"yy", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            if (connGlobal != null) {
                connGlobal.close();
            }
            if (connTenant != null) {
                connTenant.close();
            }
        }
    }

    @Test
    public void testTransformAlreadyTransformedIndex() throws Exception {
        String dataTableName = "TBL_" + TransformMonitorIT.generateUniqueName();
        String indexName = "IDX_" + TransformMonitorIT.generateUniqueName();
        String createIndexStmt = "CREATE INDEX %s ON " + dataTableName + " (NAME) INCLUDE (ZIP) ";
        try (Connection conn = DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableName, numOfRows, "");
            conn.createStatement().execute(String.format(createIndexStmt, indexName));
            Assert.assertEquals((long)numOfRows, (long)TransformMonitorIT.countRows(conn, indexName));
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, indexName);
            conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + dataTableName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord(null, (String)indexName, (String)dataTableName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            TransformToolIT.upsertRows(conn, dataTableName, 2, 1);
            Transform.removeTransformRecord((SystemTransformRecord)record, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + dataTableName + " ACTIVE SET IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES=0");
            record = Transform.getTransformRecord(null, (String)indexName, (String)dataTableName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            TransformToolIT.upsertRows(conn, dataTableName, 3, 1);
            Assert.assertEquals((long)(numOfRows + 2), (long)TransformMonitorIT.countRows(conn, indexName));
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, record.getNewPhysicalTableName());
            ResultSet rs = conn.createStatement().executeQuery("SELECT \":ID\", \"0:ZIP\" FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((long)95051L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2", (Object)rs.getString(1));
            Assert.assertEquals((long)95052L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"3", (Object)rs.getString(1));
            Assert.assertEquals((long)95053L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testTransformAlreadyTransformedTable() throws Exception {
        String dataTableName = "TBL_" + TransformMonitorIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            String stmString1 = "CREATE TABLE IF NOT EXISTS " + dataTableName + " (ID INTEGER NOT NULL, CITY_PK VARCHAR NOT NULL, NAME_PK VARCHAR NOT NULL,NAME VARCHAR, ZIP INTEGER CONSTRAINT PK PRIMARY KEY(ID, CITY_PK, NAME_PK)) ";
            conn.createStatement().execute(stmString1);
            String upsertQuery = "UPSERT INTO %s VALUES(%d, '%s', '%s', '%s', %d)";
            conn.createStatement().execute(String.format(upsertQuery, dataTableName, 1, "city1", "name1", "uname1", 95051));
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableName);
            conn.createStatement().execute("ALTER TABLE " + dataTableName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord(null, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            conn.createStatement().execute(String.format(upsertQuery, dataTableName, 2, "city2", "name2", "uname2", 95052));
            Assert.assertEquals((long)(numOfRows + 1), (long)TransformMonitorIT.countRows(conn, dataTableName));
            Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            TableName hTableName = TableName.valueOf((String)dataTableName);
            admin.disableTable(hTableName);
            admin.deleteTable(hTableName);
            Transform.removeTransformRecord((SystemTransformRecord)record, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            conn.createStatement().execute("ALTER TABLE " + dataTableName + " SET IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES=0");
            record = Transform.getTransformRecord(null, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, record.getNewPhysicalTableName());
            conn.createStatement().execute(String.format(upsertQuery, dataTableName, 3, "city3", "name3", "uname3", 95053));
            Assert.assertEquals((long)(numOfRows + 2), (long)TransformMonitorIT.countRows(conn, dataTableName));
            ResultSet rs = conn.createStatement().executeQuery("SELECT ID, ZIP, NAME, NAME_PK, CITY_PK FROM " + dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((long)95051L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"uname1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"name1", (Object)rs.getString(4));
            Assert.assertEquals((Object)"city1", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2", (Object)rs.getString(1));
            Assert.assertEquals((long)95052L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"uname2", (Object)rs.getString(3));
            Assert.assertEquals((Object)"name2", (Object)rs.getString(4));
            Assert.assertEquals((Object)"city2", (Object)rs.getString(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"3", (Object)rs.getString(1));
            Assert.assertEquals((long)95053L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"uname3", (Object)rs.getString(3));
            Assert.assertEquals((Object)"name3", (Object)rs.getString(4));
            Assert.assertEquals((Object)"city3", (Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    public void testDifferentClientAccessTransformedTable(boolean isImmutable) throws Exception {
        String dataTableName = "TBL_" + TransformMonitorIT.generateUniqueName();
        try (Connection conn1 = DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn1.setAutoCommit(true);
            int numOfRows = 1;
            TransformToolIT.createTableAndUpsertRows(conn1, dataTableName, numOfRows, isImmutable ? " IMMUTABLE_ROWS=true" : "");
            String url2 = ConnectionInfo.create((String)url, null, null).withPrincipal("LongRunningQueries").toUrl();
            try (Connection conn2 = DriverManager.getConnection(url2, PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));){
                conn2.setAutoCommit(true);
                TransformToolIT.upsertRows(conn2, dataTableName, 2, 1);
                conn1.createStatement().execute("ALTER TABLE " + dataTableName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
                SystemTransformRecord record = Transform.getTransformRecord(null, (String)dataTableName, null, null, (PhoenixConnection)conn1.unwrap(PhoenixConnection.class));
                Assert.assertNotNull((Object)record);
                TransformMonitorIT.waitForTransformToGetToState(conn1.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
                TransformMonitorIT.assertMetadata(conn1, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
                TransformToolIT.upsertRows(conn2, dataTableName, 3, 1);
                ResultSet rs = conn2.createStatement().executeQuery("SELECT ID, NAME, ZIP FROM " + dataTableName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"uname1", (Object)rs.getString(2));
                Assert.assertEquals((long)95051L, (long)rs.getInt(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"2", (Object)rs.getString(1));
                Assert.assertEquals((Object)"uname2", (Object)rs.getString(2));
                Assert.assertEquals((long)95052L, (long)rs.getInt(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"3", (Object)rs.getString(1));
                Assert.assertEquals((Object)"uname3", (Object)rs.getString(2));
                Assert.assertEquals((long)95053L, (long)rs.getInt(3));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testDifferentClientAccessTransformedTable_mutable() throws Exception {
        this.testDifferentClientAccessTransformedTable(false);
    }

    @Test
    public void testDifferentClientAccessTransformedTable_immutable() throws Exception {
        this.testDifferentClientAccessTransformedTable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransformTable_cutoverNotAuto() throws Exception {
        String schemaName = TransformMonitorIT.generateUniqueName();
        String dataTableName = "TBL_" + TransformMonitorIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        try (Connection conn = DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            TransformMonitorTask.disableTransformMonitorTask((boolean)true);
            conn.setAutoCommit(true);
            int numOfRows = 1;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName, numOfRows, "");
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            IndexRebuildTaskIT.waitForTaskState(conn, PTable.TaskType.TRANSFORM_MONITOR, dataTableName, PTable.TaskStatus.FAILED);
        }
        finally {
            TransformMonitorTask.disableTransformMonitorTask((boolean)false);
        }
    }

    @Test
    public void testTransformMonitor_tableWithViews_OnOldAndNew() throws Exception {
        String schemaName = "S_" + TransformMonitorIT.generateUniqueName();
        String dataTableName = "TBL_" + TransformMonitorIT.generateUniqueName();
        String fullDataTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String view1 = "VW1_" + TransformMonitorIT.generateUniqueName();
        String view2 = "VW2_" + TransformMonitorIT.generateUniqueName();
        String createTblStr = "CREATE TABLE %s (ID INTEGER NOT NULL, PK1 VARCHAR NOT NULL, NAME VARCHAR CONSTRAINT PK_1 PRIMARY KEY (ID, PK1)) ";
        String createViewStr = "CREATE VIEW %s  (VIEW_COL1 VARCHAR) AS SELECT * FROM %s WHERE NAME='%s'";
        try (Connection conn = DriverManager.getConnection(TransformMonitorIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            conn.createStatement().execute(String.format(createTblStr, fullDataTableName));
            int numOfRows = 2;
            String upsertQuery = String.format("UPSERT INTO %s VALUES(?, ?, ?)", fullDataTableName);
            PreparedStatement stmt1 = conn.prepareStatement(upsertQuery);
            for (int i = 1; i <= numOfRows; ++i) {
                stmt1.setInt(1, i);
                stmt1.setString(2, "pk" + i);
                stmt1.setString(3, "name" + i);
                stmt1.execute();
            }
            conn.createStatement().execute(String.format(createViewStr, view1, fullDataTableName, "name1"));
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullDataTableName);
            conn.createStatement().execute("ALTER TABLE " + fullDataTableName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            TransformMonitorIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            conn.createStatement().execute(String.format(createViewStr, view2, fullDataTableName, "name2"));
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + view2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"pk2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT * FROM " + view1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"pk1", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    public static void waitForTransformToGetToState(PhoenixConnection conn, SystemTransformRecord record, PTable.TransformStatus status) throws InterruptedException, SQLException {
        int maxTries = 250;
        int nTries = 0;
        String lastStatus = "";
        do {
            if (status.name().equals(record.getTransformStatus())) {
                return;
            }
            Thread.sleep(500L);
            record = Transform.getTransformRecord((String)record.getSchemaName(), (String)record.getLogicalTableName(), (String)record.getLogicalParentName(), (String)record.getTenantId(), (PhoenixConnection)conn);
            lastStatus = record.getTransformStatus();
        } while (++nTries < maxTries);
        try {
            SingleCellIndexIT.dumpTable("SYSTEM.TASK");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.fail((String)("Ran out of time waiting for transform state to become " + status + " but it was " + lastStatus));
    }
}

